/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PlanSplitMappingEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"detailkey", "plankey", "btn_save"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map custParams = parameter.getCustomParams();
        Object pk = custParams.get("pk");
        if (pk == null) {
            return;
        }
        DynamicObject mapping = BusinessDataServiceHelper.loadSingle(pk, (String)this.getModel().getDataEntityType().getName());
        DynamicObjectCollection entries = mapping.getDynamicObjectCollection("entry");
        if (entries.size() > 0) {
            int i;
            IDataModel model = this.getModel();
            int count = model.getEntryRowCount("entry");
            for (i = 0; i < count; ++i) {
                model.deleteEntryRow("entry", i);
            }
            model.batchCreateNewEntryRow("entry", entries.size());
            for (i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                model.setValue("detailkey", (Object)entry.getString("detailkey"), i);
                model.setValue("detailname", (Object)entry.getString("detailname"), i);
                model.setValue("plankey", (Object)entry.getString("plankey"), i);
                model.setValue("planname", (Object)entry.getString("planname"), i);
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
    }

    public void click(EventObject evt) {
        OperateOption option;
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.getFinEntityName());
        if ("detailkey".equals(key)) {
            PropTreeBuildOption option2 = new PropTreeBuildOption();
            option2.setCurrentEntity(this.getDetailEntryName());
            option2.setIncludeParentEntity(false);
            option2.setIncludeChildEntity(false);
            TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option2);
            this.showSelectFieldForm(srcBillNode, key);
        }
        if ("plankey".equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            String value = (String)this.getModel().getValue("detailkey", rowIndex);
            if (StringUtils.isBlank((CharSequence)value)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5bf9\u5e94\u884c\u7684\u7269\u6599\u884c\u5b57\u6bb5\u6807\u8bc6", (String)"PlanSplitMappingEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                return;
            }
            IDataEntityProperty matchProperty = mainType.findProperty(value);
            option = new PropTreeBuildOption();
            option.setCurrentEntity(this.getPlanEntryName());
            option.setIncludeParentEntity(false);
            option.setIncludeChildEntity(false);
            option.setMatchedProperty(matchProperty);
            TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
            this.showSelectFieldForm(srcBillNode, key);
        }
        if ("btn_save".equals(key)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Map custParams = parameter.getCustomParams();
            Object pk = custParams.get("pk");
            if (pk == null) {
                this.getView().invokeOperation("save");
            } else {
                option = OperateOption.create();
                option.setVariableValue("pk", pk.toString());
                this.getView().invokeOperation("save", option);
            }
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if ("detailkey".equals(actionId)) {
            this.receiveBillName(returnData, "detailkey", "detailname");
        } else if ("plankey".equals(actionId)) {
            this.receiveBillName(returnData, "plankey", "planname");
        }
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveBillName(String returnData, String key, String keyName) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.getFinEntityName());
        int row = this.getModel().getEntryCurrentRowIndex("entry");
        if (!StringUtils.isBlank((CharSequence)returnData)) {
            this.getModel().setValue(key, (Object)returnData, row);
            this.getModel().setValue(keyName, (Object)EntityParseHelper.buildPropFullCaption((EntityType)mainType, (String)returnData), row);
        }
    }

    private String getFinEntityName() {
        return this.isAr() ? "ar_finarbill" : "ap_finapbill";
    }

    private String getDetailEntryName() {
        return this.isAr() ? "entry" : "detailentry";
    }

    private String getPlanEntryName() {
        return "planentity";
    }

    private boolean isAr() {
        return "ar_plansplit_mapping".equals(this.getModel().getDataEntityType().getName());
    }
}

