/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.ext.data.idi.formplugin.SmartPanelPlugin;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.StringUtils;

public class RelationInfoPlugin
extends SmartPanelPlugin
implements TabSelectListener,
HyperLinkClickListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(RelationInfoPlugin.class);
    private static final int pageSize = 5;
    public static final String TABAP = "tabap";
    public static final String RELATION_ENTRY = "relationentry";
    public static final String FLOD = "flod";
    public static final String RELATIONTAB = "relationtab";
    public static final String TABPAGEAP = "tabpageap";
    public static final String PAGEINDEX = "pageindex";
    public static final String RELATION_USER = "relationuser";
    public static final String RELATION_BILL_NAME = "relationbillname";
    public static final String RELATION_NAME = "relationname";
    public static final String RELATION_BILLNO = "relationbillno";
    public static final String BILL_TAG = "billtag";
    public static final String BILL_ID = "billid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
        TextEdit textEdit = (TextEdit)this.getView().getControl(RELATION_BILLNO);
        textEdit.addClickListener((ClickListener)this);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(RELATION_ENTRY);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        cardEntry.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{FLOD});
    }

    public void tabSelected(TabSelectEvent arg0) {
        String key;
        switch (key = arg0.getTabKey()) {
            case "relationtab": {
                this.createRelationEntity("DEFAULT");
                break;
            }
            case "tabpageap": {
                this.getView().setVisible(Boolean.TRUE, new String[]{this.getSmartPanelKey()});
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "flod": {
                this.createRelationEntity("ALLINFO");
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long billId = this.getModel().getDataEntity().getLong("id");
        if (billId == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{RELATIONTAB});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{RELATIONTAB});
        }
        if (!this.isVisCustomControl()) {
            Tab tab = (Tab)this.getView().getControl(TABAP);
            tab.activeTab(RELATIONTAB);
        }
    }

    public void createRelationEntity(String showType) {
        AbstractFormDataModel formModel = (AbstractFormDataModel)this.getModel();
        int pageIndex = 4;
        boolean isChanged = formModel.getDataChanged();
        if (showType.equals("ALLINFO")) {
            pageIndex = 40;
        }
        int showSize = 5 * pageIndex;
        formModel.deleteEntryData(RELATION_ENTRY);
        List<Map<String, Object>> list = this.getOtherInfo(showSize);
        if (list.size() > 0) {
            formModel.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(RELATION_USER, new Object[0]);
            vs.addField(RELATION_BILL_NAME, new Object[0]);
            vs.addField(RELATION_NAME, new Object[0]);
            vs.addField(RELATION_BILLNO, new Object[0]);
            vs.addField(BILL_TAG, new Object[0]);
            vs.addField(BILL_ID, new Object[0]);
            for (int i = 0; i < list.size(); ++i) {
                vs.addRow(list.get(i).values().toArray());
            }
            formModel.batchCreateNewEntryRow(RELATION_ENTRY, vs);
            formModel.endInit();
            this.getView().updateView(RELATION_ENTRY);
        }
        boolean isFlod = showSize > list.size() ? Boolean.FALSE : Boolean.TRUE;
        this.getView().setVisible(Boolean.valueOf(isFlod), new String[]{FLOD});
        if (!isChanged) {
            formModel.setDataChanged(isChanged);
        }
    }

    private List<Map<String, Object>> getOtherInfo(int pageSize) {
        int currentShowSize = 1;
        IDataModel model = this.getModel();
        long billId = (Long)model.getValue("id");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> map = null;
        String dataEntityType = model.getDataEntityType().getName();
        logger.info(String.format("find source and target bill, dataEntityType[%s], billId[%s]", dataEntityType, billId));
        if (StringUtils.isNull(dataEntityType) || billId == 0L) {
            return list;
        }
        Map<String, HashSet<Long>> sourceBills = BOTPHelper.findSourceBills(dataEntityType, new Long[]{billId});
        logger.info(String.format("find source bill, dataEntityType[%s], billId[%s], result[%s]", dataEntityType, billId, sourceBills));
        for (Map.Entry<String, HashSet<Long>> entry : sourceBills.entrySet()) {
            String mapKey = entry.getKey();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)mapKey);
            HashSet<Long> mapValue = entry.getValue();
            List<String> selector = this.getSelector(type);
            Map<Long, DynamicObject> bills = this.batchGetBillInfo(type.getName(), mapValue, selector);
            for (Long billno : mapValue) {
                DynamicObject creator;
                DynamicObject bill = bills.get(billno);
                map = new LinkedHashMap<String, Object>();
                long creatorId = 0L;
                if (EntityMetadataUtils.isExistProperty(bill, "creator") && (creator = bill.getDynamicObject("creator")) != null) {
                    creatorId = creator.getLong("id");
                }
                map.put(RELATION_USER, creatorId);
                map.put(RELATION_BILL_NAME, type.getDisplayName().getLocaleValue_zh_CN());
                map.put(RELATION_NAME, ResManager.loadKDString((String)"\u4e0a\u6e38\u5355\u636e", (String)"RelationInfoPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                String numPrpo = "";
                if (EntityMetadataUtils.isExistProperty(bill, "billno")) {
                    numPrpo = "billno";
                } else if (EntityMetadataUtils.isExistProperty(bill, "number")) {
                    numPrpo = "number";
                } else {
                    return list;
                }
                map.put(RELATION_BILLNO, bill.get(numPrpo));
                map.put(BILL_TAG, mapKey);
                map.put(BILL_ID, billno);
                list.add(map);
                if (currentShowSize == pageSize) {
                    return list;
                }
                ++currentShowSize;
            }
        }
        Map<String, HashSet<Long>> targetBills = BOTPHelper.findTargetBills(dataEntityType, new Long[]{billId});
        logger.info(String.format("find target bill, dataEntityType[%s], billId[%s], result[%s]", dataEntityType, billId, targetBills));
        for (Map.Entry<String, HashSet<Long>> entry : targetBills.entrySet()) {
            String mapKey = entry.getKey();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)mapKey);
            HashSet<Long> mapValue = entry.getValue();
            List<String> selector = this.getSelector(type);
            Map<Long, DynamicObject> bills = this.batchGetBillInfo(type.getName(), mapValue, selector);
            for (Long billno : mapValue) {
                DynamicObject bill = bills.get(billno);
                map = new LinkedHashMap();
                DynamicObject creator = bill.getDynamicObject("creator");
                long creatorId = 0L;
                if (creator != null) {
                    creatorId = creator.getLong("id");
                }
                map.put(RELATION_USER, creatorId);
                map.put(RELATION_BILL_NAME, type.getDisplayName().getLocaleValue_zh_CN());
                map.put(RELATION_NAME, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e", (String)"RelationInfoPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                map.put(RELATION_BILLNO, bill.get("billno"));
                map.put(BILL_TAG, mapKey);
                map.put(BILL_ID, billno);
                list.add(map);
                if (currentShowSize == pageSize) {
                    return list;
                }
                ++currentShowSize;
            }
        }
        return list;
    }

    private DynamicObject getBillInfo(String dataEntityType, long billId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billId, (String)dataEntityType);
        return dynamicObject;
    }

    private Map<Long, DynamicObject> batchGetBillInfo(String dataEntityType, Set<Long> billIds, List<String> selector) {
        DynamicObject[] datas;
        HashMap<Long, DynamicObject> bills = new HashMap<Long, DynamicObject>(2);
        for (DynamicObject data : datas = BusinessDataServiceHelper.load((String)dataEntityType, (String)String.join((CharSequence)",", selector), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)})) {
            bills.put(data.getLong("id"), data);
        }
        return bills;
    }

    private List<String> getSelector(MainEntityType type) {
        ArrayList<String> selector = new ArrayList<String>(2);
        if (type.findProperty("creator") != null) {
            selector.add("creator");
        }
        if (type.findProperty("billno") != null) {
            selector.add("billno");
        }
        if (type.findProperty("number") != null) {
            selector.add("number");
        }
        return selector;
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String key = arg0.getFieldName();
        if (RELATION_BILLNO.equals(key)) {
            this.dealRelation(arg0);
        }
    }

    private boolean isVisCustomControl() {
        Tab tab = (Tab)this.getView().getControl(TABAP);
        List controls = tab.getItems();
        for (Control control : controls) {
            if (!TABPAGEAP.equals(control.getKey())) continue;
            return true;
        }
        return false;
    }

    public void dealRelation(HyperLinkClickEvent evt) {
        int n;
        Control con = (Control)evt.getSource();
        if (RELATION_ENTRY.equals(con.getKey()) && (n = evt.getRowIndex()) > -1) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(RELATION_ENTRY, n);
            String[] str = new String[2];
            if (entryRowEntity != null) {
                if (RELATION_BILLNO.equals(evt.getFieldName())) {
                    str[0] = entryRowEntity.getString(BILL_TAG);
                    str[1] = entryRowEntity.getString(BILL_ID);
                }
                this.showBillForm(str[0], str[1]);
            }
        }
    }

    private void showBillForm(String billtag, String billid) {
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)billid)) {
            return;
        }
        BillShowParameter formshowParameter = new BillShowParameter();
        formshowParameter.setBillStatus(BillOperationStatus.VIEW);
        formshowParameter.setStatus(OperationStatus.VIEW);
        formshowParameter.setFormId(billtag);
        formshowParameter.setPkId((Object)billid);
        formshowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)formshowParameter);
    }
}

