/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.fi.arapcommon.enums.SettleRelationEnum;

public class SettleSchemeRulePlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok", "mainfilterdesc", "asstfilterdesc"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Map customParams = showParam.getCustomParams();
        String oper = (String)customParams.get("oper");
        if ("modify".equals(oper)) {
            IDataModel model = this.getModel();
            model.setValue("description", customParams.get("description"));
            model.setValue("settlerelation", customParams.get("settlerelation"));
            model.setValue("timeorder", customParams.get("timeorder"));
            model.setValue("asstbill", customParams.get("asstbill"));
            String matchFieldInfo = (String)customParams.get("matchfieldinfo");
            if (matchFieldInfo != null && !"".equals(matchFieldInfo.trim())) {
                List fieldEntrys = (List)SerializationUtils.fromJsonString((String)matchFieldInfo, List.class);
                for (Map map : fieldEntrys) {
                    int index = model.createNewEntryRow("entryentity");
                    for (Map.Entry entry : map.entrySet()) {
                        model.setValue((String)entry.getKey(), entry.getValue(), index);
                    }
                }
            }
            String mainFilterJson = (String)customParams.get("mainfilter_tag");
            model.setValue("mainfilter_tag", (Object)mainFilterJson);
            if (StringUtils.isNotBlank((CharSequence)mainFilterJson)) {
                CRCondition mainCondition = (CRCondition)SerializationUtils.fromJsonString((String)mainFilterJson, CRCondition.class);
                model.setValue("mainfilterdesc", (Object)(mainCondition.getExprDesc().length() > 255 ? mainCondition.getExprDesc().substring(0, 255) : mainCondition.getExprDesc()));
            }
            String asstFilterJson = (String)customParams.get("asstfilter_tag");
            model.setValue("asstfilter_tag", (Object)asstFilterJson);
            if (StringUtils.isNotBlank((CharSequence)asstFilterJson)) {
                CRCondition asstCondition = (CRCondition)SerializationUtils.fromJsonString((String)asstFilterJson, CRCondition.class);
                model.setValue("asstfilterdesc", (Object)(asstCondition.getExprDesc().length() > 255 ? asstCondition.getExprDesc().substring(0, 255) : asstCondition.getExprDesc()));
            }
            model.setValue("maindatesrc", customParams.get("maindatesrc"));
            model.setValue("asstdatesrc", customParams.get("asstdatesrc"));
        }
        String settleRelation = (String)this.getModel().getValue("settlerelation");
        List<String> entitys = SettleRelationEnum.getEntityByRelation(settleRelation);
        this.initFieldColumn(entitys.get(0), "mainfield");
        this.initDateSrc(entitys.get(0), "maindatesrc");
        if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation)) {
            this.initFieldColumn((String)this.getModel().getValue("asstbill"), "asstfield");
            this.initDateSrc((String)this.getModel().getValue("asstbill"), "asstdatesrc");
        } else {
            this.initFieldColumn(entitys.get(1), "asstfield");
            this.initDateSrc(entitys.get(1), "asstdatesrc");
        }
    }

    private void initDateSrc(String entityName, String dateSrc) {
        ComboEdit fields = (ComboEdit)this.getControl(dateSrc);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(64);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
        for (FilterField field : filterFields) {
            IDataEntityProperty fieldProp = field.getFieldProp();
            if (!(fieldProp instanceof DateProp) && !(fieldProp instanceof DateTimeProp)) continue;
            LocaleString caption = field.getCaption();
            String fullFieldName = field.getFullFieldName();
            ComboItem item = new ComboItem(caption, fullFieldName);
            items.add(item);
        }
        fields.setComboItems(items);
        String dateSrcValue = (String)this.getModel().getValue(dateSrc);
        if (StringUtils.isEmpty((CharSequence)dateSrcValue) || !this.isExistForComboItems(dateSrcValue, items)) {
            this.getModel().setValue(dateSrc, (Object)"bizdate");
        }
    }

    private boolean isExistForComboItems(String srcValue, List<ComboItem> items) {
        int length = items.size();
        for (int i = 0; i < length; ++i) {
            String value = items.get(i).getValue();
            if (!value.equals(srcValue)) continue;
            return true;
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData;
        Object newValue;
        super.propertyChanged(e);
        if ("settlerelation".equals(e.getProperty().getName()) || "asstbill".equals(e.getProperty().getName())) {
            this.getModel().deleteEntryData("entryentity");
            String settleRelation = (String)this.getModel().getValue("settlerelation");
            String asstBill = (String)this.getModel().getValue("asstbill");
            if (!ObjectUtils.isEmpty((Object)settleRelation)) {
                List<String> entitys = SettleRelationEnum.getEntityByRelation(settleRelation);
                this.initFieldColumn(entitys.get(0), "mainfield");
                this.initDateSrc(entitys.get(0), "maindatesrc");
                if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation)) {
                    if (ObjectUtils.isEmpty((Object)asstBill)) {
                        switch (this.getModel().getDataEntityType().getName()) {
                            case "ar_settleschemerule": {
                                asstBill = "cas_recbill";
                                this.getModel().setValue("asstbill", (Object)"cas_recbill");
                                break;
                            }
                            case "ap_settleschemerule": {
                                asstBill = "cas_paybill";
                                this.getModel().setValue("asstbill", (Object)"cas_paybill");
                            }
                        }
                    }
                    this.initFieldColumn(asstBill, "asstfield");
                    this.initDateSrc(asstBill, "asstdatesrc");
                } else {
                    this.initFieldColumn(entitys.get(1), "asstfield");
                    this.initDateSrc(entitys.get(1), "asstdatesrc");
                }
            }
            this.getModel().setValue("mainfilterdesc", null);
            this.getModel().setValue("mainfilter", null);
            this.getModel().setValue("mainfilter_tag", null);
            this.getModel().setValue("asstfilterdesc", null);
            this.getModel().setValue("asstfilter", null);
            this.getModel().setValue("asstfilter_tag", null);
        }
        if (StringUtils.isBlank((Object)(newValue = (changeData = e.getChangeSet())[0].getNewValue()))) {
            if ("mainfilterdesc".equals(e.getProperty().getName())) {
                this.getModel().setValue("mainfilter", null);
                this.getModel().setValue("mainfilter_tag", null);
            }
            if ("asstfilterdesc".equals(e.getProperty().getName())) {
                this.getModel().setValue("asstfilter", null);
                this.getModel().setValue("asstfilter_tag", null);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            if (this.verify()) {
                this.returnDataToParentAndClose();
            }
        } else if ("btncancel".equals(key)) {
            this.getView().close();
        } else if ("mainfilterdesc".equals(key)) {
            String settleRelation = (String)this.getModel().getValue("settlerelation");
            List<String> entityTypes = SettleRelationEnum.getEntityByRelation(settleRelation);
            String mainNumber = entityTypes.get(0);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)mainNumber);
            TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, null);
            String fldNodes = SerializationUtils.toJsonString((Object)srcBillNode);
            LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl("mainfilter");
            String conditionJson = (String)this.getModel().getValue(largeTextEdit.getTagFieldKey());
            this.showConditionForm(conditionJson, mainType.getName(), false, fldNodes, key);
        } else if ("asstfilterdesc".equals(key)) {
            String asstNumber = "";
            String settleRelation = (String)this.getModel().getValue("settlerelation");
            if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation)) {
                asstNumber = (String)this.getModel().getValue("asstbill");
            } else {
                List<String> entityTypes = SettleRelationEnum.getEntityByRelation(settleRelation);
                asstNumber = entityTypes.get(1);
            }
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)asstNumber);
            TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, null);
            String fldNodes = SerializationUtils.toJsonString((Object)srcBillNode);
            LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl("asstfilter");
            String conditionJson = (String)this.getModel().getValue(largeTextEdit.getTagFieldKey());
            this.showConditionForm(conditionJson, mainType.getName(), false, fldNodes, key);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if ("mainfilterdesc".equals(actionId)) {
            this.setFilterValueByReturnData(returnData, actionId, "mainfilter");
        }
        if ("asstfilterdesc".equals(actionId)) {
            this.setFilterValueByReturnData(returnData, actionId, "asstfilter");
        }
    }

    private void setFilterValueByReturnData(String returnData, String actionId, String largeTextNumber) {
        LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl(largeTextNumber);
        this.receiveCondition(returnData, "", largeTextNumber, largeTextEdit.getTagFieldKey(), actionId);
    }

    private void receiveCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String tagFidKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(tagFidKey, (Object)conditionJson);
                if (condition.getExprDesc().length() > 255) {
                    this.getModel().setValue(descFldKey, (Object)condition.getExprDesc().substring(0, 255));
                } else {
                    this.getModel().setValue(descFldKey, (Object)condition.getExprDesc());
                }
            }
        }
    }

    private boolean verify() {
        String settleRelation = (String)this.getModel().getValue("settlerelation");
        if (settleRelation == null || settleRelation.trim().equals("")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ed3\u7b97\u5173\u7cfb\u3002", (String)"SettleSchemeRulePlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        List<String> entityTypes = SettleRelationEnum.getEntityByRelation(settleRelation);
        String mainNumber = entityTypes.get(0);
        String asstNumber = entityTypes.get(1);
        if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation)) {
            asstNumber = (String)this.getModel().getValue("asstbill");
        }
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("entryentity");
        ArrayList<String> detailFields = new ArrayList<String>(8);
        ArrayList<String> planFields = new ArrayList<String>(8);
        for (DynamicObject entry : entryEntitys) {
            String mainField = entry.getString("mainfield");
            String asstField = entry.getString("asstfield");
            if (mainField == null || asstField == null || "".equals(mainField) || "".equals(asstField)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u65b9\u5339\u914d\u5b57\u6bb5\u548c\u8f85\u65b9\u5339\u914d\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SettleSchemeRulePlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                return false;
            }
            if ("ar_finarbill".equals(mainNumber) && mainField.contains("entry") || "ap_finapbill".equals(mainNumber) && mainField.contains("detailentry")) {
                detailFields.add(mainField);
            }
            if ("ar_finarbill".equals(mainNumber) && mainField.contains("planentity") || "ap_finapbill".equals(mainNumber) && mainField.contains("planentity")) {
                planFields.add(mainField);
            }
            if ("ar_finarbill".equals(asstNumber) && asstField.contains("entry") || "ap_finapbill".equals(asstNumber) && asstField.contains("detailentry")) {
                detailFields.add(asstField);
            }
            if ((!"ar_finarbill".equals(asstNumber) || !asstField.contains("planentity")) && (!"ap_finapbill".equals(asstNumber) || !asstField.contains("planentity"))) continue;
            planFields.add(asstField);
        }
        if (detailFields.size() > 0 && planFields.size() > 0) {
            if (SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation)) {
                return true;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u65b9\u548c\u8f85\u65b9\u5339\u914d\u5b57\u6bb5\u4e2d\u540c\u65f6\u5b58\u5728\u7269\u6599\u5206\u5f55\u548c\u8ba1\u5212\u5206\u5f55\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SettleSchemeRulePlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void returnDataToParentAndClose() {
        DynamicObjectCollection entryEntitys;
        HashMap<String, Object> data = new HashMap<String, Object>();
        IDataModel model = this.getModel();
        String relation = (String)model.getValue("settlerelation");
        data.put("timeorder", model.getValue("timeorder"));
        data.put("settlerelation", relation);
        data.put("description", model.getValue("description"));
        if (SettleRelationEnum.APPAYSETTLE.getValue().equals(relation) || SettleRelationEnum.RECSETTLE.getValue().equals(relation)) {
            data.put("asstbill", model.getValue("asstbill"));
        }
        if ((entryEntitys = model.getEntryEntity("entryentity")) != null && entryEntitys.size() > 0) {
            ArrayList ruleEntryList = new ArrayList();
            for (DynamicObject entry : entryEntitys) {
                HashMap<String, Object> entryMap = new HashMap<String, Object>();
                entryMap.put("mainfield", entry.get("mainfield"));
                entryMap.put("asstfield", entry.get("asstfield"));
                entryMap.put("matchrelation", entry.get("matchrelation"));
                entryMap.put("isnullmatch", entry.get("isnullmatch"));
                ruleEntryList.add(entryMap);
            }
            String matchfieldinfo = SerializationUtils.toJsonString(ruleEntryList);
            data.put("matchfieldinfo", matchfieldinfo);
        } else {
            data.put("matchfieldinfo", null);
        }
        LargeTextEdit mainLargeTextEdit = (LargeTextEdit)this.getView().getControl("mainfilter");
        String mainfilterJson = (String)model.getValue(mainLargeTextEdit.getTagFieldKey());
        data.put("mainfilter_tag", mainfilterJson);
        LargeTextEdit asstLargeTextEdit = (LargeTextEdit)this.getView().getControl("asstfilter");
        String asstfilterJson = (String)model.getValue(asstLargeTextEdit.getTagFieldKey());
        data.put("asstfilter_tag", asstfilterJson);
        data.put("maindatesrc", model.getValue("maindatesrc"));
        data.put("asstdatesrc", model.getValue("asstdatesrc"));
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    private void initFieldColumn(String entityName, String controlName) {
        ComboEdit fields = (ComboEdit)this.getControl(controlName);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(64);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
        for (FilterField field : filterFields) {
            LocaleString caption = field.getCaption();
            String fullFieldName = field.getFullFieldName();
            ComboItem item = new ComboItem(caption, fullFieldName);
            items.add(item);
        }
        fields.setComboItems(items);
    }

    private void showConditionForm(String conditionJson, String entityNumber, boolean onlyHeadFields, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", String.valueOf(onlyHeadFields));
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

