/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.arapcommon.helper.PeriodHelper;
import kd.fi.arapcommon.service.AdjExchService;
import kd.fi.arapcommon.util.EmptyUtils;

public class TerminalAdjustExchList
extends AbstractListPlugin {
    private static final String AP_ADJUSTEXCH = "ap_adjustexch";
    private static final String AR_ADJUSTEXCH = "ar_adjustexch";
    private static final String AP_ADJEXCHBILL = "ap_adjexchbill";
    private static final String AR_ADJUSTEXCHBILL = "ar_adjustexchbill";
    private static final String bizSystem = "bizSystem";

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("tblviewrate".equals(key)) {
            String whpjUrl = "http://www.boc.cn/sourcedb/whpj/";
            this.getView().openUrl(whpjUrl);
        }
    }

    private void showForm() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] pks = selectedRows.getPrimaryKeyValues();
        if (pks.length < 1) {
            return;
        }
        String entityName = this.isAr() ? AR_ADJUSTEXCH : AP_ADJUSTEXCH;
        DynamicObject[] schemeArr = BusinessDataServiceHelper.load((String)entityName, (String)"org,basecurrency,period,isadjexch,exratetable,isperiod,adjexchdate", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        ArrayList<Object> orgList = new ArrayList<Object>(8);
        for (DynamicObject scheme : schemeArr) {
            DynamicObject org = scheme.getDynamicObject("org");
            if (org == null) continue;
            orgList.add(org.getPkValue());
        }
        this.adjexchValidator(schemeArr, orgList);
        FormShowParameter fsp = new FormShowParameter();
        Boolean isPeriod = schemeArr[0].getBoolean("isperiod");
        fsp.setFormId(entityName);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setStatus(OperationStatus.EDIT);
        fsp.setCustomParam("multyorg", orgList);
        if (!isPeriod.booleanValue()) {
            fsp.setCustomParam("period", schemeArr[0].getDynamicObject("period").getPkValue());
            fsp.setCustomParam("periodname", (Object)schemeArr[0].getDynamicObject("period").getString("name"));
        }
        fsp.setCustomParam("exratetable", schemeArr[0].getDynamicObject("exratetable").getPkValue());
        fsp.setCustomParam("basecurrency", schemeArr[0].getDynamicObject("basecurrency").getPkValue());
        fsp.setCustomParam("isperiod", (Object)isPeriod);
        if (isPeriod.booleanValue()) {
            fsp.setCustomParam("adjexchdate", (Object)schemeArr[0].getDate("adjexchdate"));
        }
        fsp.setCustomParam(bizSystem, (Object)this.getParam());
        fsp.setCaption(ResManager.loadKDString((String)"\u8c03\u6c47\u65b9\u6848", (String)"TerminalAdjustExchList_11", (String)"fi-arapcommon", (Object[])new Object[0]));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "adjexch"));
        this.getView().showForm(fsp);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object pkId = billList.getFocusRowPkId();
        if ("adjexchmode".equals(fieldName)) {
            args.setCancel(true);
            BillShowParameter param = new BillShowParameter();
            param.setPkId(pkId);
            param.setStatus(OperationStatus.VIEW);
            param.setCaption(ResManager.loadKDString((String)"\u8c03\u6c47\u65b9\u6848", (String)"TerminalAdjustExchList_11", (String)"fi-arapcommon", (Object[])new Object[0]));
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId(this.isAr() ? AR_ADJUSTEXCH : AP_ADJUSTEXCH);
            this.getView().showForm((FormShowParameter)param);
        } else if ("gainloss".equals(fieldName)) {
            args.setCancel(true);
            DynamicObject selectData = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)(this.isAr() ? AR_ADJUSTEXCH : AP_ADJUSTEXCH));
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId(this.isAr() ? AR_ADJUSTEXCHBILL : AP_ADJEXCHBILL);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setLookUp(true);
            parameter.setCustomParam("isadjexchrecordjump", (Object)Boolean.FALSE);
            parameter.setCustomParam(bizSystem, (Object)this.getParam());
            ListFilterParameter param = new ListFilterParameter();
            param.setFilter(new QFilter("org", "=", selectData.getDynamicObject("org").getPkValue()));
            DynamicObject period = selectData.getDynamicObject("period");
            param.setFilter(new QFilter("period", "=", EmptyUtils.isEmpty(period) ? Integer.valueOf(0) : period.getPkValue()));
            param.setFilter(new QFilter("bizsystem", "=", (Object)this.getParam()));
            parameter.setListFilterParameter(param);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("adjexch".equals(closedCallBackEvent.getActionId())) {
            this.getView().invokeOperation("refresh");
            Map jumpData = (Map)closedCallBackEvent.getReturnData();
            if (EmptyUtils.isEmpty(jumpData)) {
                return;
            }
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId(this.isAr() ? AR_ADJUSTEXCHBILL : AP_ADJEXCHBILL);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setLookUp(true);
            parameter.setCustomParam("isadjexchrecordjump", (Object)Boolean.TRUE);
            parameter.setCustomParam("orgFilter", jumpData.get("org"));
            parameter.setCustomParam("periodFilter", jumpData.get("period"));
            parameter.setCustomParam(bizSystem, (Object)this.getParam());
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        OperationResult operationResult = e.getOperationResult();
        switch (e.getOperateKey()) {
            case "canceladj": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "adjustexch": {
                this.showForm();
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String isPeriod = (String)listShowParameter.getCustomParam("isPeriod");
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("bizsystem", "=", (Object)this.getParam()));
        if ("true".equals(isPeriod)) {
            Long orgId = (Long)listShowParameter.getCustomParam("initOrg");
            qFilters.add(new QFilter("org", "=", (Object)orgId));
            qFilters.add(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
        }
        if (!"botp_trackerlist".equals(this.getView().getFormShowParameter().getFormId())) {
            qFilters = e.getQFilters();
            String param = this.getParam();
            if (param != null) {
                qFilters.add(new QFilter("bizsystem", "=", (Object)param));
            }
        }
    }

    protected String getInitEntityKey() {
        return this.isAr() ? "ar_init" : "ap_init";
    }

    protected boolean isAr() {
        return "AR".equalsIgnoreCase(this.getParam());
    }

    private String getParam() {
        String param = (String)this.getView().getFormShowParameter().getCustomParam(bizSystem);
        if (EmptyUtils.isEmpty(param)) {
            String serviceAppID = this.getView().getFormShowParameter().getServiceAppId();
            if (EmptyUtils.isEmpty(serviceAppID)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf\u5f02\u5e38", (String)"TerminalAdjustExchList_1", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
            }
            param = serviceAppID.toUpperCase();
        }
        return param;
    }

    private void adjexchValidator(DynamicObject[] schemeArr, List<Object> orgList) {
        DynamicObject[] initArr;
        if (EmptyUtils.isEmpty(schemeArr)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"TerminalAdjustExchList_0", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
        }
        AdjExchService adjExchService = new AdjExchService(this.isAr() ? "ar" : "ap");
        List<Long> orgIds = adjExchService.getOrgIds((DynamicObject[])schemeArr);
        Map<Long, Boolean> orgAndParamMap = adjExchService.getIsParticipateInAdjExchMap(orgIds);
        StringBuffer errorMessage = new StringBuffer();
        for (DynamicObject scheme : schemeArr) {
            if (scheme.getBoolean("isadjexch")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u8c03\u6c47\u7684\u7ec4\u7ec7\u624d\u53ef\u4ee5\u8fdb\u884c\u8c03\u6c47\uff0c\u8bf7\u53d6\u6d88\u8c03\u6c47\u540e\u91cd\u8bd5\u3002", (String)"TerminalAdjustExchList_9", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
            }
            DynamicObject[] org = scheme.getDynamicObject("org");
            Long orgId = (Long)org.getPkValue();
            if (orgAndParamMap.get(orgId) != null && orgAndParamMap.get(orgId).booleanValue()) continue;
            errorMessage.append(org.getString("name"));
            errorMessage.append('\n');
        }
        if (EmptyUtils.isNotEmpty(errorMessage) && errorMessage.length() > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\uff1a\n%s\u4e0d\u53c2\u4e0e\u8c03\u6c47\uff0c\u8bf7\u53d6\u6d88\u540e\u91cd\u8bd5\u3002", (String)"TerminalAdjustExchList_8", (String)"fi-arapcommon", (Object[])new Object[0]), errorMessage));
        }
        Long baseCurrencyStandard = (Long)schemeArr[0].getDynamicObject("basecurrency").getPkValue();
        DynamicObject periodStandard = schemeArr[0].getDynamicObject("period");
        Boolean isPeriod = schemeArr[0].getBoolean("isperiod");
        for (DynamicObject init : initArr = BusinessDataServiceHelper.load((String)this.getInitEntityKey(), (String)"id,org,startperiod,curperiod,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "in", orgList)})) {
            if (!EmptyUtils.isEmpty(init.getDynamicObject("curperiod"))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d \u672a\u7ed3\u675f\u521d\u59cb\u5316\u4e0d\u5141\u8bb8\u8c03\u6c47\u3002", (String)"TerminalAdjustExchList_7", (String)"fi-arapcommon", (Object[])new Object[]{init.getDynamicObject("org").getString("name")}), new Object[0]));
        }
        if (isPeriod.booleanValue()) {
            for (DynamicObject scheme : schemeArr) {
                if (!scheme.getDynamicObject("basecurrency").getPkValue().equals(baseCurrencyStandard)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672c\u4f4d\u5e01\u4e0d\u76f8\u540c\u7684\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u540c\u65f6\u8c03\u6c47\u3002", (String)"TerminalAdjustExchList_2", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
                }
                if (scheme.getBoolean("isperiod")) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8c03\u6c47\u671f\u95f4\u4e0d\u76f8\u540c\u7684\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u540c\u65f6\u8c03\u6c47\u3002", (String)"TerminalAdjustExchList_3", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
            }
            return;
        }
        if (EmptyUtils.isEmpty(periodStandard)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9009\u4e2d\u6570\u636e\u7684\u5f53\u524d\u671f\u95f4\u3002", (String)"TerminalAdjustExchList_6", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
        }
        Long periodStandardId = (Long)periodStandard.getPkValue();
        DynamicObject lastPeriod = PeriodHelper.getPrevPeriod(periodStandardId);
        HashMap<Long, Date> adjExchPeriodDateMap = new HashMap<Long, Date>(16);
        if (EmptyUtils.isNotEmpty(lastPeriod)) {
            QFilter isAdjExchFilter = new QFilter("org.id", "in", orgList);
            isAdjExchFilter.and(new QFilter("isadjexch", "=", (Object)Boolean.FALSE));
            QFilter periodFilter = new QFilter("period.id", "=", lastPeriod.getPkValue());
            QFilter isArFilter = new QFilter("bizsystem", "=", (Object)this.getParam());
            boolean isAdjExchFlag = QueryServiceHelper.exists((String)(this.isAr() ? AR_ADJUSTEXCH : AP_ADJUSTEXCH), (QFilter[])new QFilter[]{isAdjExchFilter, periodFilter, isArFilter});
            if (isAdjExchFlag) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7ec4\u7ec7\u8c03\u6c47\u671f\u95f4\u7684\u4e0a\u4e00\u671f\u72b6\u6001\u4e3a\u5df2\u8c03\u6c47\u65f6\uff0c\u624d\u5141\u8bb8\u5bf9\u5f53\u524d\u671f\u95f4\u8c03\u6c47\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TerminalAdjustExchList_4", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
            }
        }
        for (QFilter scheme : schemeArr) {
            if (!scheme.getDynamicObject("basecurrency").getPkValue().equals(baseCurrencyStandard)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672c\u4f4d\u5e01\u4e0d\u76f8\u540c\u7684\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u540c\u65f6\u8c03\u6c47\u3002", (String)"TerminalAdjustExchList_2", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
            }
            DynamicObject period = scheme.getDynamicObject("period");
            if (EmptyUtils.isEmpty(period) || !periodStandardId.equals(period.getPkValue())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8c03\u6c47\u671f\u95f4\u4e0d\u76f8\u540c\u7684\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u540c\u65f6\u8c03\u6c47\u3002", (String)"TerminalAdjustExchList_3", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
            }
            adjExchPeriodDateMap.put((Long)scheme.getDynamicObject("org").getPkValue(), period.getDate("enddate"));
        }
        ArrayList<Long> stratPeriodOrgIds = new ArrayList<Long>(orgIds.size());
        for (DynamicObject init : initArr) {
            Long currentOrg = (Long)init.getDynamicObject("org").getPkValue();
            Date validatorDate = (Date)adjExchPeriodDateMap.get(currentOrg);
            Date curperiodEndDate = init.getDynamicObject("curperiod").getDate("enddate");
            Date currentDate = init.getDate("currentdate");
            Long startPeriodId = (Long)init.getDynamicObject("startperiod").getPkValue();
            if (validatorDate.compareTo(curperiodEndDate) < 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u6c47\u671f\u95f4\u65e9\u4e8e\u7ed3\u7b97\u7ec4\u7ec7\u7684\u5f53\u524d\u671f\u95f4\uff0c\u65e0\u6cd5\u8c03\u6c47\u3002", (String)"TerminalAdjustExchList_5", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
            }
            if (validatorDate.compareTo(currentDate) >= 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u6c47\u671f\u95f4\u672a\u5173\u8d26\uff0c\u65e0\u6cd5\u8c03\u6c47\u3002", (String)"TerminalAdjustExchList_10", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
            }
            if (!periodStandardId.equals(startPeriodId)) continue;
            stratPeriodOrgIds.add(currentOrg);
        }
        QFilter isAdjExchFilter = new QFilter("org.id", "in", stratPeriodOrgIds);
        isAdjExchFilter.and(new QFilter("isadjexch", "=", (Object)Boolean.FALSE));
        QFilter periodFilter = new QFilter("period.id", "=", (Object)0);
        QFilter isArFilter = new QFilter("bizsystem", "=", (Object)this.getParam());
        boolean periodIsAdjExchFlag = QueryServiceHelper.exists((String)(this.isAr() ? AR_ADJUSTEXCH : AP_ADJUSTEXCH), (QFilter[])new QFilter[]{isAdjExchFilter, periodFilter, isArFilter});
        if (periodIsAdjExchFlag) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7ec4\u7ec7\u8c03\u6c47\u671f\u95f4\u7684\u4e0a\u4e00\u671f\u72b6\u6001\u4e3a\u5df2\u8c03\u6c47\u65f6\uff0c\u624d\u5141\u8bb8\u5bf9\u5f53\u524d\u671f\u95f4\u8c03\u6c47\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"TerminalAdjustExchList_4", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List<ComboItem> orgFilterItems = this.getOrgFilterItems(this.getFinishedSettingOrgs());
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Object initOrg = this.getView().getFormShowParameter().getCustomParam("initOrg");
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if ("gl_periodclosedetails".equals(parentFormId)) {
            for (CommonFilterColumn filterColumn : commonFilterColumns) {
                String fieldName = filterColumn.getFieldName();
                if (!fieldName.startsWith("org")) continue;
                filterColumn.setComboItems(orgFilterItems);
                filterColumn.setDefaultValue("");
                break;
            }
        } else {
            for (CommonFilterColumn filterColumn : commonFilterColumns) {
                String fieldName = filterColumn.getFieldName();
                if (!fieldName.startsWith("org")) continue;
                filterColumn.setComboItems(orgFilterItems);
                if (!ObjectUtils.isEmpty((Object)initOrg)) {
                    filterColumn.setDefaultValue(initOrg.toString());
                    break;
                }
                Long orgId = RequestContext.get().getOrgId();
                ComboItem curOrgId = new ComboItem(new LocaleString("curOrg"), orgId.toString());
                if (EmptyUtils.isNotEmpty(orgId) && orgFilterItems.contains(curOrgId)) {
                    filterColumn.setDefaultValue(orgId.toString());
                    if (!EmptyUtils.isEmpty(this.getPageCache().get("orgForPeriod"))) break;
                    this.getPageCache().put("orgForPeriod", orgId.toString());
                    break;
                }
                String value = orgFilterItems.get(0).getValue();
                filterColumn.setDefaultValue(value);
                if (!EmptyUtils.isEmpty(this.getPageCache().get("orgForPeriod"))) break;
                this.getPageCache().put("orgForPeriod", value);
                break;
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customFilterValues = (List)filterValues.get("customfilter");
        if (customFilterValues != null) {
            for (Map map : customFilterValues) {
                String orgValue;
                Object value;
                if (!((List)map.get("FieldName")).get(0).equals("org.id")) continue;
                this.getPageCache().put("orgForPeriod", "0");
                List values = (List)map.get("Value");
                if (values == null || values.size() <= 0 || (value = values.get(0)) == null || (orgValue = value.toString()) == null || orgValue.equals("")) continue;
                this.getPageCache().put("orgForPeriod", orgValue);
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        DynamicObject startPeriod;
        QFilter[] filters;
        String entityInit;
        DynamicObject finishSettingInitInfo;
        String orgForPeriod;
        super.filterContainerBeforeF7Select(args);
        if ("period.id".equals(args.getFieldName()) && (orgForPeriod = this.getPageCache().get("orgForPeriod")) != null && !orgForPeriod.equals("") && (finishSettingInitInfo = BusinessDataServiceHelper.loadSingle((String)(entityInit = "AP".equalsIgnoreCase(this.getParam()) ? "ap_init" : "ar_init"), (String)"startperiod", (QFilter[])(filters = new QFilter[]{new QFilter("org", "in", (Object)Long.parseLong(orgForPeriod))}))) != null && (startPeriod = finishSettingInitInfo.getDynamicObject("startperiod")) != null) {
            args.getQfilters().add(new QFilter("periodtype", "=", (Object)startPeriod.getLong("periodtype.id")));
        }
    }

    private List<ComboItem> getOrgFilterItems(List<DynamicObject> orgs) {
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        if (orgs != null && orgs.size() > 0) {
            for (DynamicObject org : orgs) {
                orgItems.add(new ComboItem(new LocaleString(org.getString("name")), org.getString("id")));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4e0d\u5b58\u5728\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\u7684\u7ec4\u7ec7\u3002", (String)"AdjustExchangeList_7", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        return orgItems;
    }

    private List<DynamicObject> getFinishedSettingOrgs() {
        DynamicObject[] finishSettingInitInfos;
        LinkedList<DynamicObject> finishedSettingOrgs = new LinkedList<DynamicObject>();
        Long userId = RequestContext.get().getCurrUserId();
        String param = ObjectUtils.isEmpty((Object)this.getParam()) ? "AP" : this.getParam();
        DynamicObjectCollection orgs = TerminalAdjustExchList.getAuthorizedBankOrg(userId, this.isAr() ? AR_ADJUSTEXCH : AP_ADJUSTEXCH, "47150e89000000ac", "fisaccounting", param);
        String entityInit = "AP".equalsIgnoreCase(param) ? "ap_init" : "ar_init";
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", TerminalAdjustExchList.getIdList((List<DynamicObject>)orgs))};
        for (DynamicObject info : finishSettingInitInfos = BusinessDataServiceHelper.load((String)entityInit, (String)"org", (QFilter[])filters)) {
            finishedSettingOrgs.add(info.getDynamicObject("org"));
        }
        return finishedSettingOrgs;
    }

    public static DynamicObjectCollection getAuthorizedBankOrg(Long userID, String entityID, String permissionItem, String attributes, String appID) {
        Map orgMap;
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appID.toLowerCase(), (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter functionFilter = new QFilter(attributes, "=", (Object)Boolean.TRUE);
        if (result.hasAllOrgPerm()) {
            orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter});
        } else {
            List orgIdList = result.getHasPermOrgs();
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
            orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter});
        }
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)orgType, null);
        for (DynamicObject org : orgMap.values()) {
            orgColl.add((Object)org);
        }
        return orgColl;
    }

    public static List<Long> getIdList(List<DynamicObject> orgList) {
        ArrayList<Long> idList = new ArrayList<Long>(orgList.size());
        for (DynamicObject org : orgList) {
            idList.add(org.getLong("id"));
        }
        return idList;
    }
}

