/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.DateUtils;

public class UpdateSettleDatePlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long orgId = Long.parseLong(customParams.get("org").toString());
        String entity = (String)customParams.get("initentity");
        InitHelper init = new InitHelper(orgId, entity);
        this.getModel().setValue("currentdate", (Object)init.getCurrentDate());
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnok": {
                Date currentDate;
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                long orgId = Long.parseLong(customParams.get("org").toString());
                String entity = (String)customParams.get("initentity");
                if (!this.orgIsfinishinit(orgId, entity)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u672a\u8fdb\u884c\u201c\u7ed3\u675f\u521d\u59cb\u5316\u201d\u3002", (String)"UpdateSettleDatePlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                    return;
                }
                Date newDate = (Date)this.getModel().getValue("newdate");
                if (DateUtils.getDiffDays(newDate, currentDate = (Date)this.getModel().getValue("currentdate")) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u7ed3\u7b97\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u7ec4\u7ec7\u6708\u672b\u5173\u8d26\u7684\u201c\u5f53\u524d\u65e5\u671f\u201d\u3002", (String)"UpdateSettleDatePlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                    break;
                }
                Long maxDateTime = (Long)customParams.get("maxDate");
                int diffDays = DateUtils.getDiffDaysIgnoreTime(new Date(maxDateTime), newDate);
                if (diffDays < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u7ed3\u7b97\u53cc\u65b9\u5355\u636e\u8bb0\u8d26\u6216\u4e1a\u52a1\u65e5\u671f\u3002", (String)"UpdateSettleDatePlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                    break;
                }
                HashMap<String, Date> returnData = new HashMap<String, Date>();
                returnData.put("newdate", newDate);
                returnData.put("currentdate", currentDate);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    private boolean orgIsfinishinit(long orgId, String entity) {
        String entityName = entity.contains("ar") ? "ar_init" : "ap_init";
        DynamicObject initOrg = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,org", (QFilter[])new QFilter[]{new QFilter("isfinishinit", "=", (Object)Boolean.TRUE), new QFilter("org", "=", (Object)orgId)});
        return initOrg != null;
    }
}

