/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.enums.SettleRelationEnum;

public class ViewSettleBaseListProvider
extends ListDataProvider {
    protected static final Log logger = LogFactory.getLog(ViewSettleBaseListProvider.class);
    private IFormView view;

    public ViewSettleBaseListProvider(IFormView view) {
        this.view = view;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        ListShowParameter parameter = (ListShowParameter)this.view.getFormShowParameter();
        long billId = Long.parseLong(parameter.getCustomParam("billId").toString());
        this.getQFilters().clear();
        QFilter notArTrans = new QFilter("settlerelation", "<>", (Object)SettleRelationEnum.ARTRANSFER.getValue());
        QFilter notApTrans = new QFilter("settlerelation", "<>", (Object)SettleRelationEnum.PAYTRANS.getValue());
        this.getQFilters().add(new QFilter("mainbillid", "=", (Object)billId).or(new QFilter("entry.billid", "=", (Object)billId).and(notApTrans).and(notArTrans)));
        DynamicObjectCollection dataColl = super.getData(0, 1000);
        if (dataColl.size() > 0) {
            DynamicObjectCollection newColl = new DynamicObjectCollection(dataColl.getDynamicObjectType(), null);
            HashMap<Long, BigDecimal> entryMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> localEntryMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> swapEntryMap = new HashMap<Long, BigDecimal>();
            for (DynamicObject data : dataColl) {
                long eBillId = data.getLong("entry.billid");
                if (billId == eBillId) {
                    Map<String, Object> valueMap = this.convertObjToMap(data);
                    DynamicObject newObj = data;
                    newObj.set("id", valueMap.get("entry.id"));
                    newObj.set("billno", valueMap.get("entry.billnum"));
                    newObj.set("maincurrency", valueMap.get("entry.currency"));
                    newObj.set("mainbizdate", valueMap.get("entry.billdate"));
                    newObj.set("mainasstact", valueMap.get("entry.asstact"));
                    newObj.set("mainpayableamt", valueMap.get("entry.payableamt"));
                    newObj.set("totalsettleamt", valueMap.get("entry.settleamt"));
                    newObj.set("material", valueMap.get("entry.material"));
                    newObj.set("expenseitem", valueMap.get("entry.expenseitem"));
                    newObj.set("mainbillid", valueMap.get("entry.billid"));
                    newObj.set("mainbillentryid", valueMap.get("entry.billentryid"));
                    newObj.set("swappl", valueMap.get("entry.e_swappl"));
                    newObj.set("planduedate", valueMap.get("entry.e_planduedate"));
                    newObj.set("localtotalsettleamt", valueMap.get("entry.localsettleamt"));
                    newObj.set("entry.id", valueMap.get("id"));
                    newObj.set("entry.currency", valueMap.get("maincurrency"));
                    newObj.set("entry.billnum", valueMap.get("billno"));
                    newObj.set("entry.billdate", valueMap.get("mainbizdate"));
                    newObj.set("entry.e_material", valueMap.get("material"));
                    newObj.set("entry.e_expenseitem", valueMap.get("expenseitem"));
                    newObj.set("entry.asstact", valueMap.get("mainasstact"));
                    newObj.set("entry.billtype", valueMap.get("mainbilltype"));
                    newObj.set("entry.payableamt", valueMap.get("mainpayableamt"));
                    newObj.set("entry.settleamt", valueMap.get("totalsettleamt"));
                    newObj.set("entry.billid", valueMap.get("mainbillid"));
                    newObj.set("entry.billentryid", valueMap.get("mainbillentryid"));
                    newObj.set("entry.e_swappl", valueMap.get("swappl"));
                    newObj.set("entry.e_planduedate", valueMap.get("planduedate"));
                    newObj.set("entry.localsettleamt", valueMap.get("localtotalsettleamt"));
                    newColl.add((Object)newObj);
                    continue;
                }
                newColl.add((Object)data);
            }
            if (newColl.size() > 0) {
                newColl.sort((Comparator)new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        if (o1.getLong("mainbillentryid") < o2.getLong("mainbillentryid")) {
                            return -1;
                        }
                        if (o1.getLong("mainbillentryid") == o2.getLong("mainbillentryid")) {
                            return 0;
                        }
                        return 1;
                    }
                });
                long tempEntryId = 0L;
                long tempSettleId = 0L;
                long tempSameId = 0L;
                for (int i = 0; i < newColl.size(); ++i) {
                    DynamicObject obj = (DynamicObject)newColl.get(i);
                    long entryId = obj.getLong("mainbillentryid");
                    long id = obj.getLong("id");
                    if (i == 0) {
                        tempSameId = id;
                    }
                    BigDecimal settledAmt = obj.getBigDecimal("totalsettleamt");
                    BigDecimal localSettledAmt = obj.getBigDecimal("localtotalsettleamt");
                    BigDecimal swapPL = obj.getBigDecimal("swappl");
                    if (tempSettleId != id) {
                        if (entryMap.get(entryId) != null) {
                            entryMap.put(entryId, ((BigDecimal)entryMap.get(entryId)).add(settledAmt));
                            localEntryMap.put(entryId, ((BigDecimal)localEntryMap.get(entryId)).add(localSettledAmt));
                            swapEntryMap.put(entryId, ((BigDecimal)swapEntryMap.get(entryId)).add(swapPL));
                        } else {
                            entryMap.put(entryId, settledAmt);
                            localEntryMap.put(entryId, localSettledAmt);
                            swapEntryMap.put(entryId, swapPL);
                        }
                        if (tempEntryId == entryId) {
                            obj.set("id", (Object)tempSameId);
                        } else {
                            tempSameId = id;
                        }
                    }
                    tempEntryId = entryId;
                    tempSettleId = id;
                }
                for (DynamicObject obj : newColl) {
                    BigDecimal totalsettleamt = (BigDecimal)entryMap.get(obj.getLong("mainbillentryid"));
                    BigDecimal localTotalsettleamt = (BigDecimal)localEntryMap.get(obj.getLong("mainbillentryid"));
                    BigDecimal swapPL = (BigDecimal)swapEntryMap.get(obj.getLong("mainbillentryid"));
                    obj.set("totalsettleamt", (Object)totalsettleamt);
                    obj.set("localtotalsettleamt", (Object)localTotalsettleamt);
                    obj.set("swappl", (Object)swapPL);
                }
            }
            return newColl;
        }
        return dataColl;
    }

    private Map<String, Object> convertObjToMap(DynamicObject obj) {
        HashMap<String, Object> map = new HashMap<String, Object>(64);
        map.put("id", obj.getPkValue());
        map.put("maincurrency", obj.get("maincurrency"));
        map.put("mainbilltype", obj.get("mainbilltype"));
        map.put("mainbizdate", obj.get("mainbizdate"));
        map.put("billno", obj.get("billno"));
        map.put("mainasstact", obj.get("mainasstact"));
        map.put("mainpayableamt", obj.get("mainpayableamt"));
        map.put("totalsettleamt", obj.get("totalsettleamt"));
        map.put("mainbillid", obj.get("mainbillid"));
        map.put("mainbillentryid", obj.get("mainbillentryid"));
        map.put("swappl", obj.get("swappl"));
        map.put("localtotalsettleamt", obj.get("localtotalsettleamt"));
        map.put("material", obj.get("material"));
        map.put("expenseitem", obj.get("expenseitem"));
        map.put("planduedate", obj.get("planduedate"));
        map.put("entry.id", obj.get("entry.id"));
        map.put("entry.currency", obj.get("entry.currency"));
        map.put("entry.billtype", obj.get("entry.billtype"));
        map.put("entry.billnum", obj.get("entry.billnum"));
        map.put("entry.billdate", obj.get("entry.billdate"));
        map.put("entry.asstact", obj.get("entry.asstact"));
        map.put("entry.payableamt", obj.get("entry.payableamt"));
        map.put("entry.settleamt", obj.get("entry.settleamt"));
        map.put("entry.material", obj.get("entry.e_material"));
        map.put("entry.expenseitem", obj.get("entry.e_expenseitem"));
        map.put("entry.billid", obj.get("entry.billid"));
        map.put("entry.billentryid", obj.get("entry.billentryid"));
        map.put("entry.localsettleamt", obj.get("entry.localsettleamt"));
        map.put("entry.e_swappl", obj.get("entry.e_swappl"));
        map.put("entry.e_planduedate", obj.get("entry.e_planduedate"));
        return map;
    }
}

