/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.form.ArApBaseAllocationPlugin;
import kd.fi.arapcommon.util.DateUtils;

public class WoffBillBookEdit
extends ArApBaseAllocationPlugin {
    private static final Log logger = LogFactory.getLog(WoffBillBookEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            List ids = (List)this.getView().getFormShowParameter().getCustomParam("ids");
            ArrayList<Map<String, Object>> woffBillBizeDates = (ArrayList<Map<String, Object>>)this.getView().getFormShowParameter().getCustomParam("woffBillBookDates");
            Map needSelect1 = (Map)this.getView().getFormShowParameter().getCustomParam("needSettle1");
            Map needSelect2 = (Map)this.getView().getFormShowParameter().getCustomParam("needSettle2");
            Map billOrgDate = (Map)this.getView().getFormShowParameter().getCustomParam("billorgdate");
            String operation = (String)this.getView().getFormShowParameter().getCustomParam("operation");
            String dateType = (String)this.getModel().getValue("offsetbillbizdate");
            String entityFlag = (String)this.getView().getFormShowParameter().getCustomParam("entityflag");
            Map orgDateMap = (Map)this.getView().getFormShowParameter().getCustomParam("orgcurdate");
            Set orgIds = orgDateMap.keySet().stream().map(v -> Long.valueOf((String)v)).collect(Collectors.toSet());
            String entityName = "ar".equals(entityFlag) ? "ar_closeaccount" : "ap_closeaccount";
            DynamicObject[] closeAccounts = BusinessDataServiceHelper.load((String)entityName, (String)"id,org.id,org.number,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
            List<String> hadCloseAccountOrg = this.getCloseAccountOrg(orgDateMap, closeAccounts, entityFlag);
            if (hadCloseAccountOrg.size() > 0) {
                String orgNumbers = String.join((CharSequence)",", hadCloseAccountOrg);
                String message = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230%s\u7ec4\u7ec7\u7684\u5173\u8d26\u65e5\u671f\u53d1\u751f\u53d8\u5316\uff0c\u70b9\u51fb\u786e\u5b9a\u540e\u5c06\u6309\u7167\u6700\u65b0\u7684\u5173\u8d26\u65e5\u671f\u8ba1\u7b97\u51b2\u56de\u5355\u7684\u5355\u636e\u65e5\u671f\u3002", (String)"WoffBillBookEdit_0", (String)"fi-arapcommon", (Object[])new Object[]{orgNumbers});
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
            } else {
                try {
                    String time;
                    SimpleDateFormat sdf;
                    Long busId;
                    String busIdStr;
                    HashMap<String, Comparable<Long>> dateMap;
                    if (woffBillBizeDates == null) {
                        woffBillBizeDates = new ArrayList<Map<String, Object>>(2);
                    }
                    if (needSelect1 != null && needSelect1.size() > 0) {
                        for (Map.Entry entrySet : needSelect1.entrySet()) {
                            dateMap = new HashMap<String, Comparable<Long>>(2);
                            busIdStr = String.valueOf(entrySet.getKey());
                            busId = Long.valueOf(busIdStr);
                            if ("previous".equals(dateType)) {
                                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                time = (String)billOrgDate.get(busId);
                                Date orgCurDate = sdf.parse(time);
                                if (orgCurDate == null) continue;
                                Date bookDate = DateUtils.getMaxMonthDate(orgCurDate);
                                dateMap.put("id", busId);
                                dateMap.put("bizdate", bookDate);
                                dateMap.put("bookdate", bookDate);
                                woffBillBizeDates.add(dateMap);
                                continue;
                            }
                            dateMap.put("id", busId);
                            dateMap.put("bizdate", new Date());
                            dateMap.put("bookdate", new Date());
                            woffBillBizeDates.add(dateMap);
                        }
                    }
                    if (needSelect2 != null && needSelect2.size() > 0) {
                        for (Map.Entry entrySet : needSelect2.entrySet()) {
                            dateMap = new HashMap(2);
                            busIdStr = String.valueOf(entrySet.getKey());
                            busId = Long.valueOf(busIdStr);
                            if ("previous".equals(dateType)) {
                                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                time = (String)entrySet.getValue();
                                Date bookDate = sdf.parse(time);
                                if (bookDate == null) continue;
                                bookDate = DateUtils.getMaxMonthDate(bookDate);
                                dateMap.put("id", busId);
                                dateMap.put("bizdate", bookDate);
                                dateMap.put("bookdate", bookDate);
                                woffBillBizeDates.add(dateMap);
                                continue;
                            }
                            dateMap.put("id", busId);
                            dateMap.put("bizdate", new Date());
                            dateMap.put("bookdate", new Date());
                            woffBillBizeDates.add(dateMap);
                        }
                    }
                }
                catch (ParseException e) {
                    logger.error("context", (Object)e.getMessage());
                }
                IFormView parentView = this.getView().getParentView();
                this.invokeWoff(ids, woffBillBizeDates, entityFlag, operation);
            }
        }
    }

    private List<String> getCloseAccountOrg(Map<Object, Object> orgDateMap, DynamicObject[] closeAccounts, String entityFlag) {
        ArrayList<String> orgNumbers = new ArrayList<String>(2);
        String busEntity = "ar".equals(entityFlag) ? "ar_busbill" : "ap_busbill";
        try {
            for (DynamicObject account : closeAccounts) {
                Long id = account.getLong("org.id");
                String number = account.getString("org.number");
                Date currentDate = account.getDate("currentdate");
                String time = (String)orgDateMap.get(id);
                Date oldCurdate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time);
                if (oldCurdate.equals(currentDate)) continue;
                orgNumbers.add(number);
            }
        }
        catch (ParseException e) {
            logger.error("context", (Object)e.getMessage());
        }
        return orgNumbers;
    }

    private Map<String, Object> getWoffBillBizDate(Long id, Date bookDate, Date orgCurDate) {
        HashMap<String, Object> woffBillBizDateMap = new HashMap<String, Object>(2);
        woffBillBizDateMap.put("id", id);
        String dateType = (String)this.getModel().getValue("offsetbillbizdate");
        Date currentDate = new Date();
        if (!bookDate.before(currentDate) && !bookDate.before(orgCurDate)) {
            woffBillBizDateMap.put("bizdate", bookDate);
        } else if (!orgCurDate.before(bookDate) && !orgCurDate.before(currentDate)) {
            woffBillBizDateMap.put("bizdate", orgCurDate);
        } else if (!currentDate.before(orgCurDate) && !orgCurDate.before(bookDate)) {
            if (DateUtils.isSameMonth(currentDate, orgCurDate)) {
                woffBillBizDateMap.put("bizdate", currentDate);
            } else if ("previous".equals(dateType)) {
                Date bizDate = DateUtils.getMaxMonthDate(orgCurDate);
                woffBillBizDateMap.put("bizdate", bizDate);
            } else {
                woffBillBizDateMap.put("bizdate", currentDate);
            }
        } else if (!currentDate.before(bookDate) && !bookDate.before(orgCurDate)) {
            if (DateUtils.isSameMonth(currentDate, orgCurDate)) {
                woffBillBizDateMap.put("bizdate", currentDate);
            } else if (!DateUtils.isSameMonth(currentDate, orgCurDate) && DateUtils.isSameMonth(currentDate, bookDate)) {
                woffBillBizDateMap.put("bizdate", currentDate);
            } else if (!DateUtils.isSameMonth(currentDate, orgCurDate) && !DateUtils.isSameMonth(currentDate, bookDate)) {
                if ("previous".equals(dateType)) {
                    Date bizDate = DateUtils.getMaxMonthDate(bookDate);
                    woffBillBizDateMap.put("bizdate", bizDate);
                } else {
                    woffBillBizDateMap.put("bizdate", currentDate);
                }
            }
        }
        return woffBillBizDateMap;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (isOK && "btnok".equals(callBackID)) {
            ArrayList<Map<String, Object>> woffBillBizeDates = new ArrayList<Map<String, Object>>(2);
            List ids = (List)this.getView().getFormShowParameter().getCustomParam("ids");
            String entityFlag = (String)this.getView().getFormShowParameter().getCustomParam("entityflag");
            String busEntity = "ar".equals(entityFlag) ? "ar_busbill" : "ap_busbill";
            String operation = (String)this.getView().getFormShowParameter().getCustomParam("operation");
            DynamicObject[] busBills = BusinessDataServiceHelper.load((String)busEntity, (String)"id,bookdate,org.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
            String entityName = "ar".equals(entityFlag) ? "ar_closeaccount" : "ap_closeaccount";
            Map orgDateMap = (Map)this.getView().getFormShowParameter().getCustomParam("orgcurdate");
            Set orgIds = orgDateMap.keySet().stream().map(v -> Long.valueOf((String)v)).collect(Collectors.toSet());
            DynamicObject[] closeAccounts = BusinessDataServiceHelper.load((String)entityName, (String)"id,org.id,org.number,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
            Map<Long, Date> orgCurDateMap = Arrays.stream(closeAccounts).collect(Collectors.toMap(v -> v.getLong("org.id"), v -> v.getDate("currentdate")));
            for (DynamicObject busBill : busBills) {
                Long id = busBill.getLong("id");
                Long orgId = busBill.getLong("org.id");
                Date bookDate = busBill.getDate("bookdate");
                Date orgCurDate = orgCurDateMap.get(orgId);
                if (orgCurDate == null) continue;
                Map<String, Object> woffBillBizDateMap = this.getWoffBillBizDate(id, bookDate, orgCurDate);
                woffBillBizeDates.add(woffBillBizDateMap);
            }
            this.invokeWoff(ids, woffBillBizeDates, entityFlag, operation);
        }
    }

    private void invokeWoff(List<Object> busIds, List<Map<String, Object>> woffBillBizDates, String entityFlag, String operation) {
        String bizDate = SerializationUtils.toJsonString(woffBillBizDates);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("ids", busIds);
        returnMap.put("bizdate", bizDate);
        returnMap.put("opreation", operation);
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }
}

