/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.InvoiceBizTypeEnum;
import kd.fi.arapcommon.util.StringUtils;

public class ApFarmTaxAmtHelper {
    public static Map setDecuAmt(Map<String, Object> interCostAmtParamMap, boolean isBus) {
        HashMap<String, BigDecimal> costAmtMap = new HashMap<String, BigDecimal>(8);
        boolean isFarm = (Boolean)interCostAmtParamMap.get("e_farmproducts");
        String taxPayerType = (String)interCostAmtParamMap.get("taxpayertype");
        long invoiceBizTypeId = (Long)interCostAmtParamMap.get("invoicebiztype");
        if (!isFarm && (StringUtils.isEmpty(taxPayerType) && invoiceBizTypeId == 0L || "1".equals(taxPayerType) && invoiceBizTypeId == 0L || StringUtils.isEmpty(taxPayerType) && invoiceBizTypeId == 1533341968170710016L)) {
            costAmtMap.put("deductiblerate", BigDecimal.ZERO);
            costAmtMap.put("curdeductibleamt", BigDecimal.ZERO);
            costAmtMap.put("intercostamt", BigDecimal.ZERO);
            return costAmtMap;
        }
        BigDecimal priceTaxotalBase = (BigDecimal)interCostAmtParamMap.get("pricetaxtotalbase");
        BigDecimal locAmt = (BigDecimal)interCostAmtParamMap.get("amtbase");
        BigDecimal deducRate = (BigDecimal)interCostAmtParamMap.get("deductiblerate");
        if (isFarm) {
            int localPrecision = (Integer)interCostAmtParamMap.get("baseamtprecision");
            BigDecimal deducAmt = deducRate.multiply(locAmt).divide(BigDecimal.valueOf(100L), localPrecision, RoundingMode.HALF_UP);
            costAmtMap.put("deductiblerate", deducRate);
            costAmtMap.put("curdeductibleamt", deducAmt);
            costAmtMap.put("intercostamt", priceTaxotalBase.subtract(deducAmt));
            return costAmtMap;
        }
        if (isBus) {
            ApFarmTaxAmtHelper.getBusFarmMap(interCostAmtParamMap, costAmtMap);
        } else {
            ApFarmTaxAmtHelper.getFinFarmMap(interCostAmtParamMap, costAmtMap);
        }
        return costAmtMap;
    }

    private static void getBusFarmMap(Map<String, Object> interCostAmtParamMap, Map<String, BigDecimal> costAmtMap) {
        String taxPayerType = (String)interCostAmtParamMap.get("taxpayertype");
        long invoiceBizTypeId = (Long)interCostAmtParamMap.get("invoicebiztype");
        BigDecimal priceTaxotalBase = (BigDecimal)interCostAmtParamMap.get("pricetaxtotalbase");
        BigDecimal locAmt = (BigDecimal)interCostAmtParamMap.get("amtbase");
        BigDecimal taxRate = (BigDecimal)interCostAmtParamMap.get("taxrate");
        if ("1".equals(taxPayerType) && (InvoiceBizTypeEnum.SP00002_S.getValue() == invoiceBizTypeId || InvoiceBizTypeEnum.SP00004_S.getValue() == invoiceBizTypeId)) {
            costAmtMap.put("deductiblerate", taxRate);
            costAmtMap.put("curdeductibleamt", priceTaxotalBase.subtract(locAmt));
            costAmtMap.put("intercostamt", locAmt);
        } else if (InvoiceBizTypeEnum.SP00001_S.getValue() == invoiceBizTypeId || "2".equals(taxPayerType) || InvoiceBizTypeEnum.SP00003_S.getValue() == invoiceBizTypeId && StringUtils.isEmpty(taxPayerType)) {
            costAmtMap.put("deductiblerate", BigDecimal.ZERO);
            costAmtMap.put("curdeductibleamt", BigDecimal.ZERO);
            costAmtMap.put("intercostamt", priceTaxotalBase);
        } else if ("1".equals(taxPayerType) && invoiceBizTypeId == 0L || InvoiceBizTypeEnum.SP00002_S.getValue() == invoiceBizTypeId && StringUtils.isEmpty(taxPayerType)) {
            costAmtMap.put("deductiblerate", BigDecimal.ZERO);
            costAmtMap.put("curdeductibleamt", BigDecimal.ZERO);
            costAmtMap.put("intercostamt", BigDecimal.ZERO);
        } else {
            costAmtMap.put("deductiblerate", BigDecimal.ZERO);
            costAmtMap.put("curdeductibleamt", BigDecimal.ZERO);
            costAmtMap.put("intercostamt", priceTaxotalBase);
        }
    }

    private static void getFinFarmMap(Map<String, Object> interCostAmtParamMap, Map<String, BigDecimal> costAmtMap) {
        boolean isTaxDeduction = (Boolean)interCostAmtParamMap.get("istaxdeduction");
        String taxPayerType = (String)interCostAmtParamMap.get("taxpayertype");
        BigDecimal priceTaxotalBase = (BigDecimal)interCostAmtParamMap.get("pricetaxtotalbase");
        BigDecimal locAmt = (BigDecimal)interCostAmtParamMap.get("amtbase");
        BigDecimal taxRate = (BigDecimal)interCostAmtParamMap.get("taxrate");
        if (isTaxDeduction && "1".equals(taxPayerType)) {
            costAmtMap.put("deductiblerate", taxRate);
            costAmtMap.put("curdeductibleamt", priceTaxotalBase.subtract(locAmt));
            costAmtMap.put("intercostamt", locAmt);
        } else {
            costAmtMap.put("deductiblerate", BigDecimal.ZERO);
            costAmtMap.put("curdeductibleamt", BigDecimal.ZERO);
            costAmtMap.put("intercostamt", priceTaxotalBase);
        }
    }

    public static void setFinDecuAmt(DynamicObject[] datas) {
        ArrayList<DynamicObject> farmTaxBill = new ArrayList<DynamicObject>(datas.length);
        for (DynamicObject data : datas) {
            if (data.getBoolean("iswrittenoff") || data.getBoolean("ispremium") || data.getBoolean("istanspay")) continue;
            farmTaxBill.add(data);
        }
        if (farmTaxBill.size() > 0) {
            for (DynamicObject bill : farmTaxBill) {
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : entrys) {
                    ApFarmTaxAmtHelper.setEntryFarmFileds(bill, entry, false);
                }
            }
        }
    }

    public static void setBusDecuAmt(DynamicObject[] datas) {
        if (datas.length > 0) {
            for (DynamicObject bill : datas) {
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entrys) {
                    ApFarmTaxAmtHelper.setEntryFarmFileds(bill, entry, true);
                }
            }
        }
    }

    private static void setEntryFarmFileds(DynamicObject bill, DynamicObject entry, boolean isBus) {
        String locAmtName = isBus ? "e_localamt" : "e_amountbase";
        String taxRateName = isBus ? "e_taxrate" : "taxrate";
        HashMap<String, Object> interCostAmtParamMap = new HashMap<String, Object>(1);
        interCostAmtParamMap.put("e_farmproducts", entry.getBoolean("e_farmproducts"));
        interCostAmtParamMap.put("pricetaxtotalbase", entry.getBigDecimal("e_pricetaxtotalbase"));
        interCostAmtParamMap.put("amtbase", entry.getBigDecimal(locAmtName));
        interCostAmtParamMap.put("deductiblerate", entry.getBigDecimal("deductiblerate"));
        interCostAmtParamMap.put("baseamtprecision", bill.getInt("basecurrency.amtprecision"));
        interCostAmtParamMap.put("taxrate", entry.getBigDecimal(taxRateName));
        if (!isBus) {
            interCostAmtParamMap.put("istaxdeduction", bill.getBoolean("istaxdeduction"));
        }
        interCostAmtParamMap.put("taxpayertype", bill.getString("org.taxpayertype"));
        interCostAmtParamMap.put("invoicebiztype", bill.getLong("invoicebiztype.id"));
        Map costAmtMap = ApFarmTaxAmtHelper.setDecuAmt(interCostAmtParamMap, isBus);
        entry.set("deductiblerate", costAmtMap.get("deductiblerate"));
        entry.set("curdeductibleamt", costAmtMap.get("curdeductibleamt"));
        entry.set("intercostamt", costAmtMap.get("intercostamt"));
    }

    public static void setWoffLastDeduAmt(DynamicObject[] busBills) {
        HashMap<Long, Long> srcBillsMap = new HashMap<Long, Long>(8);
        ArrayList<DynamicObject> woffBills = new ArrayList<DynamicObject>(10);
        for (DynamicObject busBill : busBills) {
            boolean isAdjust = busBill.getBoolean("isadjust");
            if (!isAdjust) continue;
            woffBills.add(busBill);
            DynamicObjectCollection entrys = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                srcBillsMap.put(entry.getLong("id"), entry.getLong("e_srcentryid"));
            }
        }
        if (woffBills.size() == 0) {
            return;
        }
        HashSet<Long> woffIds = new HashSet<Long>(10);
        HashMap<Long, BigDecimal> srcRowDecAmtMap = new HashMap<Long, BigDecimal>(8);
        DynamicObjectCollection srcBusBills = QueryServiceHelper.query((String)"ap_busbill", (String)"entry.id,entry.intercostamt,entry.curdeductibleamt,entry.e_unwoffqty,entry.e_iswriteoff", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", srcBillsMap.values())});
        for (DynamicObject srcBusBill : srcBusBills) {
            boolean isWoff = srcBusBill.getBoolean("entry.e_iswriteoff");
            if (!isWoff) continue;
            woffIds.add(srcBusBill.getLong("entry.id"));
            srcRowDecAmtMap.put(srcBusBill.getLong("entry.id"), srcBusBill.getBigDecimal("entry.curdeductibleamt"));
        }
        DynamicObjectCollection tarBusBills = QueryServiceHelper.query((String)"ap_busbill", (String)"entry.e_srcentryid,entry.intercostamt,entry.curdeductibleamt,entry.e_unwoffqty,entry.e_iswriteoff", (QFilter[])new QFilter[]{new QFilter("entry.e_srcentryid", "in", woffIds)});
        HashMap<Long, BigDecimal> tarRowTotalDecAmtMap = new HashMap<Long, BigDecimal>(8);
        for (DynamicObject tarBusBiLL : tarBusBills) {
            BigDecimal tarDeDucAmt = tarBusBiLL.getBigDecimal("entry.curdeductibleamt");
            Long srcEntryId = tarBusBiLL.getLong("entry.e_srcentryid");
            if (tarRowTotalDecAmtMap.get(srcEntryId) != null) {
                BigDecimal totalDeAmt = ((BigDecimal)tarRowTotalDecAmtMap.get(srcEntryId)).add(tarDeDucAmt);
                tarRowTotalDecAmtMap.put(srcEntryId, totalDeAmt);
                continue;
            }
            tarRowTotalDecAmtMap.put(srcEntryId, tarDeDucAmt);
        }
        HashMap<Long, BigDecimal> balanceAmtMap = new HashMap<Long, BigDecimal>(8);
        for (DynamicObject woffBill : woffBills) {
            DynamicObjectCollection entrys = woffBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entrys) {
                BigDecimal tarDeDucTotalAmt;
                BigDecimal srcDeDucAmt;
                BigDecimal balanceAmt;
                Long entrSrcId = entry.getLong("e_srcentryid");
                if (srcRowDecAmtMap.get(entrSrcId) == null || balanceAmtMap.get(entrSrcId) != null || (balanceAmt = (srcDeDucAmt = (BigDecimal)srcRowDecAmtMap.get(entrSrcId)).add(tarDeDucTotalAmt = (BigDecimal)tarRowTotalDecAmtMap.get(entrSrcId))).compareTo(BigDecimal.ZERO) == 0) continue;
                balanceAmtMap.put(entrSrcId, balanceAmt);
                BigDecimal deducAmt = entry.getBigDecimal("curdeductibleamt");
                BigDecimal intercostAmt = entry.getBigDecimal("intercostamt");
                entry.set("curdeductibleamt", (Object)deducAmt.subtract(balanceAmt));
                entry.set("intercostAmt", (Object)intercostAmt.add(balanceAmt));
            }
        }
    }
}

