/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class ArApBudgetCommonHelper {
    private static Log logger = LogFactory.getLog(ArApBudgetCommonHelper.class);
    public static final String budgetAmountField = "budgetbalance";

    private static String queryBudgetAmount(DynamicObject billObj) {
        logger.info("\u5f00\u59cb\u8c03\u7528\u9884\u7b97\u83b7\u53d6\u4f59\u989d\u63a5\u53e3, \u5355\u636e\u5b9e\u4f53id:" + billObj.getLong("id"));
        String budgetData = null;
        try {
            budgetData = (String)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"queryBalance", (Object[])new Object[]{billObj});
        }
        catch (UndeclaredThrowableException e) {
            if (e.getUndeclaredThrowable() instanceof InvocationTargetException) {
                budgetData = ArApBudgetCommonHelper.getErrorMessage(((InvocationTargetException)e.getUndeclaredThrowable()).getTargetException().getMessage());
                logger.info("\u8c03\u7528\u9884\u7b97\u83b7\u53d6\u4f59\u989d\u63a5\u53e3queryBudgetAmount \u5931\u8d25:" + e.getUndeclaredThrowable());
            }
        }
        catch (Exception e) {
            budgetData = ArApBudgetCommonHelper.getErrorMessage(e.getMessage());
            logger.info("\u8c03\u7528\u9884\u7b97\u83b7\u53d6\u4f59\u989d\u63a5\u53e3queryBudgetAmount \u5931\u8d25:" + e.getMessage());
        }
        logger.info("\u7ed3\u675f\u8c03\u7528\u9884\u7b97\u83b7\u53d6\u4f59\u989d\u63a5\u53e3, \u9884\u7b97\u4f59\u989d\u6570\u636e:" + budgetData);
        return budgetData;
    }

    private static String getErrorMessage(String message) {
        JSONArray errorArray = new JSONArray();
        JSONObject errorData = new JSONObject();
        errorData.put("success", (Object)Boolean.FALSE);
        errorData.put("message", (Object)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u9884\u7b97\u4f59\u989d\u5931\u8d25: %s", (String)"ArApBudgetCommonHelper_0", (String)"fi-arapcommon", (Object[])new Object[]{message}), new Object[0]));
        errorArray.add((Object)errorData);
        return JSONObject.toJSONString((Object)errorArray);
    }

    public static String buildBudgetBalance(DynamicObject billObj) {
        DynamicObject newBillObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)billObj, (boolean)false, (boolean)true);
        return ArApBudgetCommonHelper.queryBudgetAmount(newBillObj);
    }

    private static Map queryBudgetAmountMap(DynamicObject billObj) {
        String budgetData = ArApBudgetCommonHelper.queryBudgetAmount(billObj);
        List budgetDataArray = JSONObject.parseArray((String)budgetData, JSONObject.class);
        HashMap<String, Object> budgetMap = new HashMap<String, Object>();
        if (budgetDataArray != null && budgetDataArray.size() > 0) {
            for (int i = 0; i < budgetDataArray.size(); ++i) {
                JSONObject budgetDataJson = (JSONObject)budgetDataArray.get(i);
                if (budgetDataJson.get((Object)"success") != null && !((Boolean)budgetDataJson.get((Object)"success")).booleanValue()) {
                    budgetMap.put("success", "false");
                    budgetMap.put("message", budgetDataJson.getString("message"));
                    return budgetMap;
                }
                BigDecimal budgetAmount = budgetDataJson.getBigDecimal("balance");
                budgetMap.put("budgetAmount", budgetAmount);
            }
        } else {
            budgetMap.put(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u67e5\u5230\u9884\u7b97\u4fe1\u606f\uff0c \u8bf7\u68c0\u67e5\u9884\u7b97\u7f16\u5236\u3002", (String)"ArApBudgetCommonHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]), null);
        }
        return budgetMap;
    }

    public static Map getBudgetBalanceByIndex(DynamicObject billObj, Integer rowIndex) {
        DynamicObject newBillObj = ArApBudgetCommonHelper.genBgDynamicObject(billObj, rowIndex);
        return ArApBudgetCommonHelper.queryBudgetAmountMap(newBillObj);
    }

    public static DynamicObject genBgDynamicObject(DynamicObject billObj, Integer rowIndex) {
        DynamicObject newBillObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)billObj, (boolean)false, (boolean)true);
        DynamicObjectCollection rows = newBillObj.getDynamicObjectCollection("detailentry");
        if (rows == null) {
            return null;
        }
        if (rows.size() > 0) {
            rows.clear();
        }
        DynamicObjectCollection detailentry = billObj.getDynamicObjectCollection("detailentry");
        DynamicObject row = new DynamicObject(rows.getDynamicObjectType());
        DataEntityPropertyCollection entryProps = rows.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : entryProps) {
            String propertyName = property.getName();
            row.set(propertyName, ((DynamicObject)detailentry.get(rowIndex.intValue())).get(propertyName));
        }
        rows.add((Object)row);
        return newBillObj;
    }
}

