/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.util.QueryUtil;
import kd.fi.arapcommon.util.StdConfig;

public class ArApDataRepairHelper {
    public static boolean isExecuteRepairData() {
        return !"true".equals(StdConfig.get("isNotExecuteRepairData"));
    }

    public static boolean isInBaseData(DynamicObject[] datas) {
        if (ObjectUtils.isEmpty((Object[])datas)) {
            return false;
        }
        String entityName = datas[0].getDataEntityType().getName();
        return QueryServiceHelper.exists((String)entityName, (Object)datas[0].getPkValue());
    }

    public static void repairFinApBillDatas(DynamicObject[] dataEntities) {
        if (ObjectUtils.isEmpty((Object[])dataEntities) || !ArApDataRepairHelper.isExecuteRepairData() || ArApDataRepairHelper.isInBaseData(dataEntities)) {
            return;
        }
        ArApDataRepairHelper.repairAmtPrecision(dataEntities);
        Set<Long> orgIds = Arrays.stream(dataEntities).map(bill -> bill.getLong("org.id")).collect(Collectors.toSet());
        Map<Long, Long> orgCurrencyMap = ArApDataRepairHelper.getOrgBaseCurrency(orgIds, false);
        QueryUtil queryUtil = new QueryUtil();
        for (DynamicObject bill2 : dataEntities) {
            long baseCurrencyId;
            Object detail2;
            if (bill2.getBoolean("istanspay") || bill2.getBoolean("iswrittenoff") || bill2.getBoolean("isadjust")) continue;
            BigDecimal priceTaxTotal = bill2.getBigDecimal("pricetaxtotal");
            bill2.set("unsettleamount", (Object)priceTaxTotal);
            bill2.set("settleamount", (Object)BigDecimal.ZERO);
            bill2.set("unverifyamount", (Object)bill2.getBigDecimal("amount"));
            DynamicObjectCollection detailEntry = bill2.getDynamicObjectCollection("detailentry");
            for (Object detail2 : detailEntry) {
                long materialId = detail2.getLong("material.id");
                long unitId = detail2.getLong("measureunit.id");
                DynamicObject baseUnit = detail2.getDynamicObject("e_baseunit");
                BigDecimal eQuantity = detail2.getBigDecimal("quantity");
                ArApDataRepairHelper.processBaseQty((DynamicObject)detail2, materialId, unitId, baseUnit, eQuantity, "e_unitconvertrate", "e_baseunitqty", queryUtil);
                BigDecimal ePriceTaxTotal = detail2.getBigDecimal("e_pricetaxtotal");
                BigDecimal eAmount = detail2.getBigDecimal("e_amount");
                detail2.set("lockedamt", (Object)BigDecimal.ZERO);
                detail2.set("e_fixlockedamt", (Object)BigDecimal.ZERO);
                detail2.set("unlockamt", (Object)ePriceTaxTotal);
                detail2.set("settledamt", (Object)BigDecimal.ZERO);
                detail2.set("e_fixsettleedamt", (Object)BigDecimal.ZERO);
                detail2.set("unsettleamt", (Object)ePriceTaxTotal);
                detail2.set("verifyquantity", (Object)BigDecimal.ZERO);
                detail2.set("unverifyquantity", (Object)detail2.getBigDecimal("quantity"));
                detail2.set("e_verifybaseqty", (Object)BigDecimal.ZERO);
                detail2.set("e_unverifybaseqty", (Object)detail2.getBigDecimal("e_baseunitqty"));
                detail2.set("verifyamount", (Object)BigDecimal.ZERO);
                detail2.set("e_unverifyamount", (Object)eAmount);
            }
            DynamicObjectCollection planEntity = bill2.getDynamicObjectCollection("planentity");
            detail2 = planEntity.iterator();
            while (detail2.hasNext()) {
                DynamicObject plan = (DynamicObject)detail2.next();
                BigDecimal planPriceTax = plan.getBigDecimal("planpricetax");
                plan.set("planlockedamt", (Object)BigDecimal.ZERO);
                plan.set("unplanlockamt", (Object)planPriceTax);
                plan.set("plansettledamt", (Object)BigDecimal.ZERO);
                plan.set("unplansettleamt", (Object)planPriceTax);
            }
            long initBaseCurrencyId = orgCurrencyMap.getOrDefault(bill2.getLong("org.id"), 0L);
            if (initBaseCurrencyId == (baseCurrencyId = bill2.getLong("basecurrency.id"))) continue;
            bill2.set("basecurrency_id", (Object)initBaseCurrencyId);
        }
    }

    private static void repairAmtPrecision(DynamicObject[] dataEntities) {
        String isRepairAmtPrecision = StdConfig.get("isRepairAmtPrecision");
        if (!"true".equals(isRepairAmtPrecision)) {
            return;
        }
        for (DynamicObject bill : dataEntities) {
            String billEntityKey = dataEntities[0].getDataEntityType().getExtendName();
            BillModel billModel = BillModelFactory.getModel(billEntityKey);
            DynamicObject currency = bill.getDynamicObject(billModel.HEAD_CURRENCY);
            int precision = currency.getInt("amtprecision");
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal tax = BigDecimal.ZERO;
            BigDecimal pricetaxtotal = BigDecimal.ZERO;
            boolean needRepair = false;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(billModel.ENTRY);
            for (DynamicObject entry : entrys) {
                if (entry.getBigDecimal(billModel.E_AMOUNT).scale() == precision && entry.getBigDecimal(billModel.E_TAX).scale() == precision && entry.getBigDecimal(billModel.E_PRICETAXTOTAL).scale() == precision) continue;
                needRepair = true;
                break;
            }
            if (!needRepair) {
                return;
            }
            for (DynamicObject entry : entrys) {
                BigDecimal e_amount = entry.getBigDecimal(billModel.E_AMOUNT).setScale(precision, RoundingMode.HALF_UP);
                BigDecimal e_pricetaxtotal = entry.getBigDecimal(billModel.E_PRICETAXTOTAL).setScale(precision, RoundingMode.HALF_UP);
                BigDecimal e_tax = e_pricetaxtotal.subtract(e_amount);
                entry.set(billModel.E_AMOUNT, (Object)e_amount);
                entry.set(billModel.E_TAX, (Object)e_tax);
                entry.set(billModel.E_PRICETAXTOTAL, (Object)e_pricetaxtotal);
                amount = amount.add(e_amount);
                tax = tax.add(e_tax);
                pricetaxtotal = pricetaxtotal.add(e_pricetaxtotal);
            }
            bill.set(billModel.HEAD_AMOUNT, (Object)amount);
            bill.set(billModel.HEAD_TAX, (Object)tax);
            bill.set(billModel.HEAD_PRICETAXTOTAL, (Object)pricetaxtotal);
            if (!"ap_finapbill".equals(billEntityKey) && !"ar_finarbill".equals(billEntityKey)) continue;
            DynamicObjectCollection planEntrys = bill.getDynamicObjectCollection(billModel.P_ENTRY);
            int planEntrySize = planEntrys.size();
            BigDecimal p_planpricetaxTatol = BigDecimal.ZERO;
            for (int i = 0; i < planEntrySize; ++i) {
                DynamicObject planEntry = (DynamicObject)planEntrys.get(i);
                if (planEntrySize == 1) {
                    planEntry.set(billModel.P_PLANPRICETAX, (Object)pricetaxtotal);
                    continue;
                }
                if (i == planEntrySize - 1) {
                    planEntry.set(billModel.P_PLANPRICETAX, (Object)pricetaxtotal.subtract(p_planpricetaxTatol));
                    continue;
                }
                BigDecimal p_planpricetax = planEntry.getBigDecimal(billModel.P_PLANPRICETAX).setScale(precision, RoundingMode.HALF_UP);
                planEntry.set(billModel.P_PLANPRICETAX, (Object)p_planpricetax);
                p_planpricetaxTatol = p_planpricetaxTatol.add(p_planpricetax);
            }
        }
    }

    public static void repairBusApDatas(DynamicObject[] dataEntities) {
        if (ObjectUtils.isEmpty((Object[])dataEntities) || !ArApDataRepairHelper.isExecuteRepairData() || ArApDataRepairHelper.isInBaseData(dataEntities)) {
            return;
        }
        ArApDataRepairHelper.repairAmtPrecision(dataEntities);
        Set<Long> orgIds = Arrays.stream(dataEntities).map(bill -> bill.getLong("org.id")).collect(Collectors.toSet());
        Map<Long, Long> orgCurrencyMap = ArApDataRepairHelper.getOrgBaseCurrency(orgIds, false);
        for (DynamicObject busAp : dataEntities) {
            long baseCurrencyId;
            long initBaseCurrencyId = orgCurrencyMap.getOrDefault(busAp.getLong("org.id"), 0L);
            if (initBaseCurrencyId == (baseCurrencyId = busAp.getLong("basecurrency.id"))) continue;
            busAp.set("basecurrency_id", (Object)initBaseCurrencyId);
        }
    }

    public static void repairApInvoiceDatas(DynamicObject[] dataEntities) {
        if (ObjectUtils.isEmpty((Object[])dataEntities) || !ArApDataRepairHelper.isExecuteRepairData() || ArApDataRepairHelper.isInBaseData(dataEntities)) {
            return;
        }
        ArApDataRepairHelper.repairAmtPrecision(dataEntities);
        Set<Long> orgIds = Arrays.stream(dataEntities).map(bill -> bill.getLong("org.id")).collect(Collectors.toSet());
        Map<Long, Long> orgCurrencyMap = ArApDataRepairHelper.getOrgBaseCurrency(orgIds, false);
        for (DynamicObject inv : dataEntities) {
            long baseCurrencyId;
            BigDecimal exchangeRate = inv.getBigDecimal("exchangerate");
            boolean isNeedRepairLocalAmt = exchangeRate.compareTo(BigDecimal.ONE) == 0;
            BigDecimal priceTaxTotal = inv.getBigDecimal("pricetaxtotal");
            if (isNeedRepairLocalAmt) {
                inv.set("pricetaxtotalbase", (Object)priceTaxTotal);
                inv.set("amountbase", (Object)inv.getBigDecimal("amount"));
            }
            inv.set("unrelatedamt", (Object)priceTaxTotal);
            DynamicObjectCollection entry = inv.getDynamicObjectCollection("entry");
            for (DynamicObject detailRow : entry) {
                BigDecimal ePriceTaxTotal = detailRow.getBigDecimal("e_pricetaxtotal");
                detailRow.set("e_relatedamt", (Object)BigDecimal.ZERO);
                detailRow.set("e_unrelatedamt", (Object)ePriceTaxTotal);
                if (!isNeedRepairLocalAmt) continue;
                detailRow.set("e_amountbase", (Object)detailRow.getBigDecimal("e_amount"));
                detailRow.set("discountlocalamt", (Object)detailRow.getBigDecimal("discountamt"));
                detailRow.set("e_pricetaxtotalbase", (Object)ePriceTaxTotal);
            }
            long initBaseCurrencyId = orgCurrencyMap.getOrDefault(inv.getLong("org.id"), 0L);
            if (initBaseCurrencyId == (baseCurrencyId = inv.getLong("basecurrency.id"))) continue;
            inv.set("basecurrency_id", (Object)initBaseCurrencyId);
        }
    }

    public static void repairPayApplyDatas(DynamicObject[] dataEntities) {
        if (ObjectUtils.isEmpty((Object[])dataEntities) || !ArApDataRepairHelper.isExecuteRepairData() || ArApDataRepairHelper.isInBaseData(dataEntities)) {
            return;
        }
        for (DynamicObject bill : dataEntities) {
            BigDecimal rate = bill.getBigDecimal("exchangerate");
            if (rate.compareTo(BigDecimal.ONE) != 0) continue;
            bill.set("appseleamount", (Object)bill.getBigDecimal("applyamount"));
            bill.set("aprseleamount", (Object)bill.getBigDecimal("approvalamount"));
            for (DynamicObject entry : bill.getDynamicObjectCollection("entry")) {
                entry.set("e_appseleamount", (Object)entry.getBigDecimal("e_applyamount"));
                entry.set("e_approvedseleamt", (Object)entry.getBigDecimal("e_approvedamt"));
            }
        }
    }

    public static void repaireFinArAmtField(DynamicObject[] dataEntities) {
        if (ObjectUtils.isEmpty((Object[])dataEntities) || !ArApDataRepairHelper.isExecuteRepairData() || ArApDataRepairHelper.isInBaseData(dataEntities)) {
            return;
        }
        ArApDataRepairHelper.repairAmtPrecision(dataEntities);
        Set<Long> orgIds = Arrays.stream(dataEntities).map(bill -> bill.getLong("org.id")).collect(Collectors.toSet());
        Map<Long, Long> orgCurrencyMap = ArApDataRepairHelper.getOrgBaseCurrency(orgIds, true);
        QueryUtil queryUtil = new QueryUtil();
        for (DynamicObject bill2 : dataEntities) {
            long baseCurrencyId;
            Object entryInfo2;
            boolean istransfer = bill2.getBoolean("istransfer");
            boolean iswrittenoff = bill2.getBoolean("iswrittenoff");
            boolean isPeriod = bill2.getBoolean("isperiod");
            DynamicObject billType = bill2.getDynamicObject("billtype");
            boolean isadjust = false;
            if (!ObjectUtils.isEmpty((Object)billType)) {
                boolean bl = isadjust = "arfin_borrowar_BT_S".equals(billType.getString("number"));
            }
            if (istransfer || iswrittenoff || isadjust) continue;
            bill2.set("settleamount", (Object)BigDecimal.ZERO);
            bill2.set("settlelocalamt", (Object)BigDecimal.ZERO);
            BigDecimal recamount = bill2.getBigDecimal("recamount");
            BigDecimal amount = bill2.getBigDecimal("amount");
            bill2.set("unsettleamount", (Object)recamount);
            bill2.set("unverifyamount", (Object)amount);
            if (bill2.getBigDecimal("invoicedamt").compareTo(BigDecimal.ZERO) == 0) {
                bill2.set("uninvoicedamt", (Object)recamount);
            }
            DynamicObjectCollection entryCol = bill2.getDynamicObjectCollection("entry");
            for (Object entryInfo2 : entryCol) {
                long materialId = entryInfo2.getLong("e_material.id");
                long unitId = entryInfo2.getLong("e_measureunit.id");
                DynamicObject baseUnit = entryInfo2.getDynamicObject("e_baseunit");
                BigDecimal eQuantity = entryInfo2.getBigDecimal("e_quantity");
                ArApDataRepairHelper.processBaseQty((DynamicObject)entryInfo2, materialId, unitId, baseUnit, eQuantity, "e_unitcoefficient", "e_baseunitqty", queryUtil);
                entryInfo2.set("e_lockedamt", (Object)BigDecimal.ZERO);
                entryInfo2.set("e_fixlockedamt", (Object)BigDecimal.ZERO);
                entryInfo2.set("e_fixsettleedamt", (Object)BigDecimal.ZERO);
                entryInfo2.set("e_settledamt", (Object)BigDecimal.ZERO);
                entryInfo2.set("e_verifiedqty", (Object)BigDecimal.ZERO);
                entryInfo2.set("e_verifybaseqty", (Object)BigDecimal.ZERO);
                entryInfo2.set("e_verifiedamt", (Object)BigDecimal.ZERO);
                entryInfo2.set("e_settledlocalamt", (Object)BigDecimal.ZERO);
                BigDecimal eBaseUnitQty = entryInfo2.getBigDecimal("e_baseunitqty");
                BigDecimal eAmount = entryInfo2.getBigDecimal("e_amount");
                BigDecimal e_recAmount = entryInfo2.getBigDecimal("e_recamount");
                entryInfo2.set("e_unlockamt", (Object)e_recAmount);
                entryInfo2.set("e_unsettleamt", (Object)e_recAmount);
                entryInfo2.set("e_unverifyqty", (Object)eQuantity);
                entryInfo2.set("e_unverifybaseqty", (Object)eBaseUnitQty);
                entryInfo2.set("e_unverifyamt", (Object)eAmount);
                if (isPeriod) {
                    BigDecimal confirmedAmt = entryInfo2.getBigDecimal("e_confirmedamt");
                    BigDecimal confirmedQty = entryInfo2.getBigDecimal("e_confirmedqty");
                    BigDecimal confirmedBaseQty = entryInfo2.getBigDecimal("e_confirmedbaseqty");
                    entryInfo2.set("e_unconfirmamt", (Object)eAmount.subtract(confirmedAmt));
                    entryInfo2.set("e_unconfirmqty", (Object)eQuantity.subtract(confirmedQty));
                    entryInfo2.set("e_unconfirmbaseqty", (Object)eBaseUnitQty.subtract(confirmedBaseQty));
                } else {
                    entryInfo2.set("e_confirmedqty", (Object)BigDecimal.ZERO);
                    entryInfo2.set("e_confirmedbaseqty", (Object)BigDecimal.ZERO);
                    entryInfo2.set("e_confirmedamt", (Object)BigDecimal.ZERO);
                    entryInfo2.set("e_unconfirmqty", (Object)eQuantity);
                    entryInfo2.set("e_unconfirmbaseqty", (Object)eBaseUnitQty);
                    entryInfo2.set("e_unconfirmamt", (Object)eAmount);
                }
                if (entryInfo2.getBigDecimal("e_invoicedamt").compareTo(BigDecimal.ZERO) != 0) continue;
                entryInfo2.set("e_uninvoicedamt", (Object)e_recAmount);
            }
            DynamicObjectCollection planEntry = bill2.getDynamicObjectCollection("planentity");
            entryInfo2 = planEntry.iterator();
            while (entryInfo2.hasNext()) {
                DynamicObject plan = (DynamicObject)entryInfo2.next();
                plan.set("planlockedamt", (Object)BigDecimal.ZERO);
                plan.set("plansettledamt", (Object)BigDecimal.ZERO);
                plan.set("plansettledlocamt", (Object)BigDecimal.ZERO);
                BigDecimal planPriceTax = plan.getBigDecimal("planpricetax");
                plan.set("unplanlockamt", (Object)planPriceTax);
                plan.set("unplansettleamt", (Object)planPriceTax);
            }
            long initBaseCurrencyId = orgCurrencyMap.getOrDefault(bill2.getLong("org.id"), 0L);
            if (initBaseCurrencyId == (baseCurrencyId = bill2.getLong("basecurrency.id"))) continue;
            bill2.set("basecurrency_id", (Object)initBaseCurrencyId);
        }
        ArApDataRepairHelper.FinArlocAmountFieldCorrection(dataEntities);
    }

    private static void FinArlocAmountFieldCorrection(DynamicObject[] entities) {
        for (DynamicObject bill : entities) {
            BigDecimal rate = bill.getBigDecimal("exchangerate");
            if (rate.compareTo(BigDecimal.ONE) != 0) continue;
            bill.set("localamt", (Object)bill.getBigDecimal("amount"));
            bill.set("taxlocamt", (Object)bill.getBigDecimal("tax"));
            bill.set("reclocalamt", (Object)bill.getBigDecimal("recamount"));
            bill.set("settlelocalamt", (Object)bill.getBigDecimal("settleamount"));
            bill.set("unsettlelocalamt", (Object)bill.getBigDecimal("unsettleamount"));
            bill.set("adjustlocalamt", (Object)bill.getBigDecimal("adjustamount"));
            bill.set("invoicedlocalamt", (Object)bill.getBigDecimal("invoicedamt"));
            bill.set("uninvoicedlocalamt", (Object)bill.getBigDecimal("uninvoicedamt"));
            for (DynamicObject entry : bill.getDynamicObjectCollection("entry")) {
                entry.set("e_taxlocalamt", (Object)entry.getBigDecimal("e_tax"));
                entry.set("e_discountlocalamt", (Object)entry.getBigDecimal("e_discountamount"));
                entry.set("e_localamt", (Object)entry.getBigDecimal("e_amount"));
                entry.set("e_reclocalamt", (Object)entry.getBigDecimal("e_recamount"));
                entry.set("e_settledlocalamt", (Object)entry.getBigDecimal("e_settledamt"));
                entry.set("e_unsettlelocalamt", (Object)entry.getBigDecimal("e_unsettleamt"));
                entry.set("e_invoicedlocalamt", (Object)entry.getBigDecimal("e_invoicedamt"));
                entry.set("e_uninvoicedlocalamt", (Object)entry.getBigDecimal("e_uninvoicedamt"));
                entry.set("e_adjustlocalamt", (Object)entry.getBigDecimal("e_adjustamount"));
            }
            for (DynamicObject entry : bill.getDynamicObjectCollection("planentity")) {
                entry.set("planpricetaxloc", (Object)entry.getBigDecimal("planpricetax"));
                entry.set("plansettledlocamt", (Object)entry.getBigDecimal("plansettledamt"));
                entry.set("unplansettlelocamt", (Object)entry.getBigDecimal("unplansettleamt"));
            }
        }
    }

    public static void repairBusArAmtField(DynamicObject[] dataEntities) {
        if (ObjectUtils.isEmpty((Object[])dataEntities) || !ArApDataRepairHelper.isExecuteRepairData() || ArApDataRepairHelper.isInBaseData(dataEntities)) {
            return;
        }
        ArApDataRepairHelper.repairAmtPrecision(dataEntities);
        Set<Long> orgIds = Arrays.stream(dataEntities).map(bill -> bill.getLong("org.id")).collect(Collectors.toSet());
        Map<Long, Long> orgCurrencyMap = ArApDataRepairHelper.getOrgBaseCurrency(orgIds, true);
        for (DynamicObject bill2 : dataEntities) {
            long baseCurrencyId;
            bill2.set("invoicedamt", (Object)BigDecimal.ZERO);
            bill2.set("relateinvamt", (Object)BigDecimal.ZERO);
            bill2.set("invamt", (Object)BigDecimal.ZERO);
            BigDecimal recamount = bill2.getBigDecimal("recamount");
            bill2.set("uninvoicedamt", (Object)recamount);
            bill2.set("unrelateinvamt", (Object)recamount);
            DynamicObjectCollection entryCol = bill2.getDynamicObjectCollection("entry");
            for (DynamicObject entryInfo : entryCol) {
                entryInfo.set("e_invoicedqty", (Object)BigDecimal.ZERO);
                entryInfo.set("e_invoicedamt", (Object)BigDecimal.ZERO);
                entryInfo.set("e_invoicednotaxamt", (Object)BigDecimal.ZERO);
                entryInfo.set("e_confirmedamt", (Object)BigDecimal.ZERO);
                entryInfo.set("e_confirmedqty", (Object)BigDecimal.ZERO);
                entryInfo.set("e_relateinvqty", (Object)BigDecimal.ZERO);
                entryInfo.set("e_relateinvamt", (Object)BigDecimal.ZERO);
                entryInfo.set("e_invqty", (Object)BigDecimal.ZERO);
                entryInfo.set("e_invnotaxamt", (Object)BigDecimal.ZERO);
                entryInfo.set("e_invamt", (Object)BigDecimal.ZERO);
                BigDecimal eQuantity = entryInfo.getBigDecimal("e_quantity");
                BigDecimal eAmount = entryInfo.getBigDecimal("e_amount");
                BigDecimal eRecamount = entryInfo.getBigDecimal("e_recamount");
                entryInfo.set("e_uninvoicedqty", (Object)eQuantity);
                entryInfo.set("e_uninvoicedamt", (Object)eRecamount);
                entryInfo.set("e_uninvnotaxamt", (Object)eAmount);
                entryInfo.set("e_unconfirmamt", (Object)eAmount);
                entryInfo.set("e_unconfirmqty", (Object)eQuantity);
                entryInfo.set("e_unrelateinvqty", (Object)eQuantity);
                entryInfo.set("e_unrelateinvamt", (Object)eRecamount);
            }
            long initBaseCurrencyId = orgCurrencyMap.getOrDefault(bill2.getLong("org.id"), 0L);
            if (initBaseCurrencyId == (baseCurrencyId = bill2.getLong("basecurrency.id"))) continue;
            bill2.set("basecurrency_id", (Object)initBaseCurrencyId);
        }
        ArApDataRepairHelper.BusArlocAmountFieldCorrection(dataEntities);
    }

    private static void BusArlocAmountFieldCorrection(DynamicObject[] entities) {
        for (DynamicObject bill : entities) {
            BigDecimal rate = bill.getBigDecimal("exchangerate");
            if (rate.compareTo(BigDecimal.ONE) != 0) continue;
            bill.set("localamt", (Object)bill.getBigDecimal("amount"));
            bill.set("taxlocamt", (Object)bill.getBigDecimal("tax"));
            bill.set("reclocalamt", (Object)bill.getBigDecimal("recamount"));
            bill.set("unwofflocamt", (Object)bill.getBigDecimal("unwoffamt"));
            bill.set("invoicedlocamt", (Object)bill.getBigDecimal("invoicedamt"));
            bill.set("uninvoicedlocamt", (Object)bill.getBigDecimal("uninvoicedamt"));
            bill.set("relateinvlocamt", (Object)bill.getBigDecimal("relateinvamt"));
            bill.set("unrelateinvlocamt", (Object)bill.getBigDecimal("unrelateinvamt"));
            bill.set("invlocamt", (Object)bill.getBigDecimal("invamt"));
            for (DynamicObject entry : bill.getDynamicObjectCollection("entry")) {
                entry.set("e_taxlocalamt", (Object)entry.getBigDecimal("e_tax"));
                entry.set("e_discountlocalamt", (Object)entry.getBigDecimal("e_discountamount"));
                entry.set("e_localamt", (Object)entry.getBigDecimal("e_amount"));
                entry.set("e_reclocalamt", (Object)entry.getBigDecimal("e_recamount"));
                entry.set("e_unwofflocamt", (Object)entry.getBigDecimal("e_unwoffamt"));
                entry.set("e_invoicedlocamt", (Object)entry.getBigDecimal("e_invoicedamt"));
                entry.set("e_invnotaxlocalamt", (Object)entry.getBigDecimal("e_invoicednotaxamt"));
                entry.set("e_uninvoicedlocamt", (Object)entry.getBigDecimal("e_uninvoicedamt"));
                entry.set("e_uninvnotaxlocalamt", (Object)entry.getBigDecimal("e_uninvnotaxamt"));
                entry.set("e_unrelateinvlocamt", (Object)entry.getBigDecimal("e_unrelateinvamt"));
                entry.set("e_relateinvlocamt", (Object)entry.getBigDecimal("e_relateinvamt"));
                entry.set("e_invnotaxlocamt", (Object)entry.getBigDecimal("e_invnotaxamt"));
                entry.set("e_invlocamt", (Object)entry.getBigDecimal("e_invamt"));
            }
        }
    }

    public static void repairRevCfmBillAmtField(DynamicObject[] dataEntities) {
        if (ObjectUtils.isEmpty((Object[])dataEntities) || !ArApDataRepairHelper.isExecuteRepairData() || ArApDataRepairHelper.isInBaseData(dataEntities)) {
            return;
        }
        Set<Long> orgIds = Arrays.stream(dataEntities).map(bill -> bill.getLong("org.id")).collect(Collectors.toSet());
        Map<Long, Long> orgCurrencyMap = ArApDataRepairHelper.getOrgBaseCurrency(orgIds, true);
        for (DynamicObject bill2 : dataEntities) {
            long baseCurrencyId;
            String sourceBillType = bill2.getString("sourcebilltype");
            bill2.set("unverifyamt", (Object)bill2.getBigDecimal("confirmamt"));
            DynamicObjectCollection entryCol = bill2.getDynamicObjectCollection("entry");
            for (DynamicObject entryInfo : entryCol) {
                BigDecimal eConfirmQty = entryInfo.getBigDecimal("e_confirmqty");
                BigDecimal eConfirmBaseQty = entryInfo.getBigDecimal("e_confirmbaseqty");
                BigDecimal eConfirmAmt = entryInfo.getBigDecimal("e_confirmamt");
                entryInfo.set("e_verifiedqty", (Object)BigDecimal.ZERO);
                entryInfo.set("e_unverifyqty", (Object)eConfirmQty);
                entryInfo.set("e_verifybaseqty", (Object)BigDecimal.ZERO);
                entryInfo.set("e_unverifybaseqty", (Object)eConfirmBaseQty);
                entryInfo.set("e_verifiedamt", (Object)BigDecimal.ZERO);
                entryInfo.set("e_unverifyamt", (Object)eConfirmAmt);
                if ("ar_finarbill".equals(sourceBillType)) {
                    entryInfo.set("e_unrecqty", (Object)BigDecimal.ZERO);
                    entryInfo.set("e_unrecbaseqty", (Object)BigDecimal.ZERO);
                    entryInfo.set("e_recqty", (Object)eConfirmQty);
                    entryInfo.set("e_recbaseqty", (Object)eConfirmBaseQty);
                    entryInfo.set("e_unrecamt", (Object)BigDecimal.ZERO);
                    entryInfo.set("e_recamt", (Object)eConfirmAmt);
                    continue;
                }
                entryInfo.set("e_unrecqty", (Object)eConfirmQty);
                entryInfo.set("e_unrecbaseqty", (Object)eConfirmBaseQty);
                entryInfo.set("e_recqty", (Object)BigDecimal.ZERO);
                entryInfo.set("e_recbaseqty", (Object)BigDecimal.ZERO);
                entryInfo.set("e_unrecamt", (Object)eConfirmAmt);
                entryInfo.set("e_recamt", (Object)BigDecimal.ZERO);
            }
            long initBaseCurrencyId = orgCurrencyMap.getOrDefault(bill2.getLong("org.id"), 0L);
            if (initBaseCurrencyId == (baseCurrencyId = bill2.getLong("basecurrency.id"))) continue;
            bill2.set("basecurrency_id", (Object)initBaseCurrencyId);
        }
        ArApDataRepairHelper.RevcfmlocAmountFieldCorrection(dataEntities);
    }

    private static void RevcfmlocAmountFieldCorrection(DynamicObject[] entities) {
        for (DynamicObject bill : entities) {
            BigDecimal rate = bill.getBigDecimal("exchangerate");
            if (rate.compareTo(BigDecimal.ONE) != 0) continue;
            bill.set("localamt", (Object)bill.getBigDecimal("amount"));
            bill.set("confirmlocamt", (Object)bill.getBigDecimal("confirmamt"));
            for (DynamicObject entry : bill.getDynamicObjectCollection("entry")) {
                entry.set("e_localamt", (Object)entry.getBigDecimal("e_amount"));
            }
        }
    }

    public static void repairArInvoiceAmtField(DynamicObject[] dataEntities) {
        if (ObjectUtils.isEmpty((Object[])dataEntities) || !ArApDataRepairHelper.isExecuteRepairData() || ArApDataRepairHelper.isInBaseData(dataEntities)) {
            return;
        }
        ArApDataRepairHelper.repairAmtPrecision(dataEntities);
        Set<Long> orgIds = Arrays.stream(dataEntities).map(bill -> bill.getLong("org.id")).collect(Collectors.toSet());
        Map<Long, Long> orgCurrencyMap = ArApDataRepairHelper.getOrgBaseCurrency(orgIds, true);
        for (DynamicObject bill2 : dataEntities) {
            long baseCurrencyId;
            long initBaseCurrencyId = orgCurrencyMap.getOrDefault(bill2.getLong("org.id"), 0L);
            if (initBaseCurrencyId == (baseCurrencyId = bill2.getLong("basecurrency.id"))) continue;
            bill2.set("basecurrency_id", (Object)initBaseCurrencyId);
        }
    }

    public static Map<Long, Long> getOrgBaseCurrency(Set<Long> orgIds, boolean isAr) {
        if (ObjectUtils.isEmpty(orgIds)) {
            return new HashMap<Long, Long>(2);
        }
        DynamicObjectCollection inits = QueryServiceHelper.query((String)(isAr ? "ar_init" : "ap_init"), (String)"org,standardcurrency", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        if (inits.isEmpty()) {
            return new HashMap<Long, Long>(2);
        }
        HashMap<Long, Long> result = new HashMap<Long, Long>(8);
        for (DynamicObject init : inits) {
            result.put(init.getLong("org"), init.getLong("standardcurrency"));
        }
        return result;
    }

    private static void processBaseQty(DynamicObject entryInfo, long materialId, long unitId, DynamicObject baseUnit, BigDecimal qty, String convertUnitKey, String baseUnitQtyKey, QueryUtil queryUtil) {
        if (materialId != 0L && unitId != 0L && baseUnit != null) {
            long baseUnitId = baseUnit.getLong("id");
            if (unitId == baseUnitId) {
                entryInfo.set(convertUnitKey, (Object)1);
                entryInfo.set(baseUnitQtyKey, (Object)qty);
            } else {
                BigDecimal baseunitqty = entryInfo.getBigDecimal(baseUnitQtyKey);
                if (baseunitqty.compareTo(BigDecimal.ZERO) == 0) {
                    BigDecimal unitRateConv = queryUtil.getConvertRate(materialId, unitId, baseUnitId);
                    entryInfo.set(convertUnitKey, (Object)unitRateConv);
                    baseunitqty = UnitConvertHelper.getBaseunitqty(qty, unitRateConv, baseUnit);
                    entryInfo.set(baseUnitQtyKey, (Object)baseunitqty);
                }
            }
        }
    }
}

