/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.writeback.bill.DisposerInfo;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public class ArApHelper {
    public static final String AP_APPID = "+HKZHSKFXOX";
    public static final String AR_APPID = "/BBRH+122=39";

    public static boolean isExistNumberRule(DynamicObject obj, String orgID) {
        return CodeRuleServiceHelper.isExist((String)obj.getDataEntityType().getName(), (DynamicObject)obj, (String)orgID);
    }

    public static boolean isExistNumberRule(String entityId, Long billId, String orgID) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityId);
        return CodeRuleServiceHelper.isExist((String)entityId, (DynamicObject)bill, (String)orgID);
    }

    public static String getNumberRule(DynamicObject obj, String orgID) {
        return CodeRuleServiceHelper.getNumber((String)obj.getDataEntityType().getName(), (DynamicObject)obj, (String)orgID);
    }

    public static void setValue(IDataModel model, String fieldKey, Object fieldValue) {
        if (fieldValue instanceof DynamicObject) {
            model.setValue(fieldKey, ((DynamicObject)fieldValue).getPkValue());
        } else {
            model.setValue(fieldKey, fieldValue);
        }
    }

    public static void setValue(IDataModel model, String fieldKey, Object fieldValue, int index) {
        if (fieldValue instanceof DynamicObject) {
            model.setValue(fieldKey, ((DynamicObject)fieldValue).getPkValue(), index);
        } else {
            model.setValue(fieldKey, fieldValue, index);
        }
    }

    @Deprecated
    public static void setFieldValue(DynamicObject obj, String fieldKey, Object fieldValue) {
        if (fieldValue instanceof DynamicObject) {
            obj.set(fieldKey, ((DynamicObject)fieldValue).getPkValue());
        } else {
            obj.set(fieldKey, fieldValue);
        }
    }

    public static List<Object> getIdList4MultiBase(DynamicObjectCollection objs) {
        ArrayList<Object> pks = new ArrayList<Object>();
        if (objs != null && objs.size() > 0) {
            for (DynamicObject obj : objs) {
                pks.add(obj.getDynamicObject("fbasedataid").getPkValue());
            }
        }
        return pks;
    }

    public static Map<Long, Integer> batchGetApSettleParam(Set<Long> orgIds) {
        return ArApHelper.batchGetSettleParam(false, orgIds);
    }

    public static Map<Long, Integer> batchGetArSettleParam(Set<Long> orgIds) {
        return ArApHelper.batchGetSettleParam(true, orgIds);
    }

    public static Map<Long, Integer> batchGetSettleParam(boolean isAr, Set<Long> orgIds) {
        String paramKey = isAr ? "ar_003" : "ap_003";
        Map<Long, Object> settleParamMap = SystemParameterHelper.batchGetAppParameter(isAr, new ArrayList<Long>(orgIds), paramKey);
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>(settleParamMap.size());
        for (Map.Entry<Long, Object> entry : settleParamMap.entrySet()) {
            Object value = entry.getValue();
            int result = 1;
            if (value != null) {
                result = Integer.parseInt(value.toString());
            }
            resultMap.put(entry.getKey(), result);
        }
        return resultMap;
    }

    public static int getApSettleParam(Object orgPk) {
        return ArApHelper.getApParam(orgPk, "ap_003");
    }

    public static int getApParam(Object orgPk, String param) {
        int result = 1;
        Object settleParam = ArApHelper.getParameter(orgPk, param, false);
        if (settleParam != null) {
            result = Integer.parseInt(settleParam.toString());
        }
        return result;
    }

    public static int getArSettleParam(Object orgPk) {
        return ArApHelper.getArParam(orgPk, "ar_003");
    }

    public static int getArParam(Object orgPk, String param) {
        int result = 1;
        Object settleParam = ArApHelper.getParameter(orgPk, param, true);
        if (settleParam != null) {
            result = Integer.parseInt(settleParam.toString());
        }
        return result;
    }

    public static Object getParameter(Object orgPk, String param, boolean isAr) {
        AppParam appParam = new AppParam(isAr ? AR_APPID : AP_APPID, Long.valueOf(Long.parseLong(orgPk.toString())));
        appParam.setViewType(OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)param);
    }

    public static List<Long> getPks(Object bills) {
        ArrayList<Long> pks;
        block3: {
            block2: {
                pks = new ArrayList<Long>();
                if (!(bills instanceof DynamicObject[])) break block2;
                for (DynamicObject bill : (DynamicObject[])bills) {
                    pks.add(bill.getLong("id"));
                }
                break block3;
            }
            if (!(bills instanceof DynamicObjectCollection)) break block3;
            for (DynamicObject bill : (DynamicObjectCollection)bills) {
                pks.add(bill.getLong("id"));
            }
        }
        return pks;
    }

    public static void sortPlanDueDate(DynamicObject[] datas) {
        String isSortPlanEntry = StdConfig.get("isSortPlanEntry");
        if ("false".equals(isSortPlanEntry)) {
            return;
        }
        for (DynamicObject bill : datas) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("planentity");
            boolean isSort = true;
            for (DynamicObject entry2 : entrys) {
                Date dueDate = entry2.getDate("planduedate");
                if (!ObjectUtils.isEmpty((Object)dueDate)) continue;
                isSort = false;
                break;
            }
            if (entrys.size() <= 1 || !isSort) continue;
            entrys.sort(Comparator.comparing(entry -> ((DynamicObject)entry).getDate("planduedate")).thenComparing(entry -> ((DynamicObject)entry).getInt("p_splitdimensionid")));
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry2;
                entry2 = (DynamicObject)entrys.get(i);
                entry2.set("seq", (Object)(i + 1));
            }
        }
    }

    public static boolean verifyByCoreBill(String settleType, long asstBillId, String entity, String ... possibleSources) {
        if (ObjectUtils.isEmpty((Object)entity) || ObjectUtils.isEmpty((Object[])possibleSources)) {
            return false;
        }
        return SettleTypeEnum.AUTO.getValue().equals(settleType) && !BOTPHelper.isPushedBy(asstBillId, entity, possibleSources);
    }

    public static String getStackTraceMessage(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(':');
        sb.append(e.getMessage()).append('\n');
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }

    public static Map<String, Object> getQueryDateByInit(List<Object> ids, boolean isAr) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        String entityNumber = isAr ? "ar_init" : "ap_init";
        QFilter filter = new QFilter("org", "in", (Object)ids.toArray());
        filter.and(new QFilter("startdate", "is not null", null));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entityNumber, (String)"id,startdate", (QFilter[])new QFilter[]{filter});
        if (dynamicObjects.length > 0) {
            DynamicObject dynamicObject = dynamicObjects[0];
            Date initDate = dynamicObject.getDate("startdate");
            Date lastDay = DateUtils.getLastDay(initDate, 180);
            map.put("startDate", DateUtils.formatString(lastDay, "yyyy-MM-dd"));
            map.put("stopDate", DateUtils.formatString(initDate, "yyyy-MM-dd"));
        }
        return map;
    }

    public static void baseUnitQtyCorrection(DynamicObject[] entities, String entityKey) {
        BillModel m = BillModelFactory.getModel(entityKey);
        for (DynamicObject bill : entities) {
            for (DynamicObject entry : bill.getDynamicObjectCollection(m.ENTRY)) {
                long baseUnitId;
                long measureUnitId;
                DynamicObject material = entry.getDynamicObject(m.E_MATERIAL);
                if (!EmptyUtils.isNotEmpty(material) || (measureUnitId = entry.getLong(m.E_MEASUREUNIT + ".id")) != (baseUnitId = material.getLong("baseunit.id"))) continue;
                entry.set(m.E_UNITCOEFFICIENT, (Object)BigDecimal.ONE);
                entry.set(m.E_BASEUNITQTY, (Object)entry.getBigDecimal(m.E_QUANTITY));
            }
        }
    }

    public static String getMaxPushRows() {
        String maxRows = StdConfig.get("bos_max_push_rows");
        return EmptyUtils.isEmpty(maxRows) ? "20000" : maxRows;
    }

    public static boolean queryArIsNotInit() {
        boolean isNotInit = false;
        String sql = "select count(1) as count from t_ar_init";
        Integer count = (Integer)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, e -> {
            if (e.next()) {
                return e.getInt("count");
            }
            return 0;
        });
        if (count < 1) {
            isNotInit = true;
        }
        return isNotInit;
    }

    public static boolean queryApIsNotInit() {
        boolean isNotInit = false;
        String sql = "select count(1) as count from t_ap_init";
        Integer count = (Integer)DB.query((DBRoute)DBRoute.of((String)"fi"), (String)sql, e -> {
            if (e.next()) {
                return e.getInt("count");
            }
            return 0;
        });
        if (count < 1) {
            isNotInit = true;
        }
        return isNotInit;
    }

    public static BigDecimal getBigDecimal(Object value) {
        BigDecimal ret = null;
        if (value != null) {
            if (value instanceof BigDecimal) {
                ret = (BigDecimal)value;
            } else if (value instanceof String) {
                ret = new BigDecimal(((String)value).trim());
            } else if (value instanceof BigInteger) {
                ret = new BigDecimal((BigInteger)value);
            } else if (value instanceof Number) {
                ret = BigDecimal.valueOf(((Number)value).doubleValue());
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5c06[%1$s]\u4ece\u7c7b\u578b%2$s\u8f6c\u4e3aBigDecimal\u3002", (String)"ArApHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]), value, value.getClass()));
            }
        }
        return ret;
    }

    public static Map<Long, Boolean> isHasSameTarBill(String srcEntityName, Long[] srcIds, String tarEntityName) {
        HashMap<Long, Boolean> isSameBillMap = new HashMap<Long, Boolean>(8);
        Map<Long, Set<String>> targetBills = BOTPHelper.findAllTargetBillEntityNum(srcEntityName, srcIds);
        if (targetBills.size() > 0) {
            for (Long srcId : srcIds) {
                Set<String> entityNumberSet = targetBills.get(srcId);
                if (entityNumberSet != null && entityNumberSet.size() > 0) {
                    if (entityNumberSet.contains(tarEntityName)) {
                        isSameBillMap.put(srcId, Boolean.TRUE);
                        continue;
                    }
                    isSameBillMap.put(srcId, Boolean.FALSE);
                    continue;
                }
                isSameBillMap.put(srcId, Boolean.FALSE);
            }
        }
        return isSameBillMap;
    }

    public static Map<Long, DisposerInfo> processWriteBackMap(Map<Long, List<DisposerInfo>> notMergeWriteBackMap) {
        HashMap<Long, DisposerInfo> disposerInfoMap = new HashMap<Long, DisposerInfo>(64);
        if (ObjectUtils.isEmpty(notMergeWriteBackMap)) {
            return disposerInfoMap;
        }
        for (Map.Entry<Long, List<DisposerInfo>> entrySet : notMergeWriteBackMap.entrySet()) {
            List<DisposerInfo> disposerInfos = entrySet.getValue();
            Long tarRowId = entrySet.getKey();
            Long sourceId = disposerInfos.get(0).getSourceId();
            Long sourceEntryId = disposerInfos.get(0).getSourceEntryId();
            if (disposerInfos.size() == 1) {
                disposerInfoMap.put(tarRowId, disposerInfos.get(0));
                continue;
            }
            BigDecimal disposeAmt = BigDecimal.ZERO;
            for (DisposerInfo disposerInfo : disposerInfos) {
                disposeAmt = disposeAmt.add(disposerInfo.getDisposeAmt());
            }
            if (BigDecimal.ZERO.compareTo(disposeAmt) == 0) continue;
            disposerInfoMap.put(tarRowId, new DisposerInfo(sourceId, sourceEntryId, disposeAmt));
        }
        return disposerInfoMap;
    }
}

