/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.FinPlanRowService;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanRow;

@Deprecated
public class ArApPlanAmtHelp {
    public static void finArBillPlanAmtHelp(DynamicObject finArBill) {
        if (finArBill == null) {
            return;
        }
        DynamicObject bascur = finArBill.getDynamicObject("basecurrency");
        int baseprecision = bascur.getInt("amtprecision");
        int precision = finArBill.getInt("currency.amtprecision");
        List planList = new FinPlanRowService().calculatePlanRows(finArBill);
        ArApPlanAmtHelp.updateFinBillPlanEntity(planList, finArBill, baseprecision, precision);
    }

    public static void finApBillPlanAmtHelp(DynamicObject finApBill) {
        if (finApBill == null) {
            return;
        }
        DynamicObject bascur = finApBill.getDynamicObject("basecurrency");
        int baseprecision = bascur.getInt("amtprecision");
        int precision = finApBill.getInt("currency.amtprecision");
        FinPlanRowService planRowService = new FinPlanRowService();
        Date termsDate = finApBill.getDate("termsdate");
        if (termsDate == null) {
            termsDate = planRowService.getTermsDate(finApBill);
            finApBill.set("termsdate", (Object)termsDate);
        }
        List planList = planRowService.calculatePlanRows(finApBill, termsDate);
        ArApPlanAmtHelp.updateFin(planList, finApBill, baseprecision, precision);
    }

    private static void updateFin(List<PlanRow> planRows, DynamicObject finAPBill, int baseprecision, int amtprecision) {
        Date planMaxDuedate = null;
        DynamicObject settlementType = finAPBill.getDynamicObject("settlementtype");
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal amtLoc = BigDecimal.ZERO;
        BigDecimal rate = finAPBill.getBigDecimal("exchangerate");
        String quotation = finAPBill.getString("quotation");
        DynamicObjectCollection planEntryDatas = finAPBill.getDynamicObjectCollection("planentity");
        planEntryDatas.clear();
        for (int i = 0; i < planRows.size(); ++i) {
            EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)"ap_finapbill").findProperty("planentity");
            DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
            DynamicObject planEntry = new DynamicObject(dt);
            PlanRow planRow = planRows.get(i);
            Date palnDuedate = planRow.getDueDate();
            BigDecimal planAmtLoc = BigDecimal.ZERO;
            BigDecimal planAmt = planRow.getPlanAmt().setScale(amtprecision, RoundingMode.HALF_UP);
            planAmtLoc = "0".equals(quotation) ? planAmt.multiply(rate).setScale(baseprecision, RoundingMode.HALF_UP) : planAmt.divide(rate, baseprecision, RoundingMode.HALF_UP);
            amt = amt.add(planAmt.setScale(amtprecision, 4));
            amtLoc = amtLoc.add(planAmtLoc.setScale(baseprecision, 4));
            if (i == planRows.size() - 1) {
                BigDecimal priceLoc;
                BigDecimal price;
                BigDecimal pricetaxtotal = finAPBill.getBigDecimal("pricetaxtotal");
                BigDecimal pricetaxtotalbase = finAPBill.getBigDecimal("pricetaxtotalbase");
                if (amt.compareTo(pricetaxtotal) > 0) {
                    price = amt.subtract(pricetaxtotal);
                    planAmt = planAmt.subtract(price);
                } else if (amt.compareTo(pricetaxtotal) < 0) {
                    price = pricetaxtotal.subtract(amt);
                    planAmt = planAmt.add(price);
                }
                if (amtLoc.compareTo(pricetaxtotalbase) > 0) {
                    priceLoc = amtLoc.subtract(pricetaxtotalbase);
                    planAmtLoc = planAmtLoc.subtract(priceLoc);
                } else if (amtLoc.compareTo(pricetaxtotalbase) < 0) {
                    priceLoc = pricetaxtotalbase.subtract(amtLoc);
                    planAmtLoc = planAmtLoc.add(priceLoc);
                }
            }
            planEntry.set("seq", (Object)(i + 1));
            planEntry.set("planpricetax", (Object)planAmt);
            planEntry.set("unplanlockamt", (Object)planAmt);
            planEntry.set("unplansettleamt", (Object)planAmt);
            planEntry.set("planpricetaxloc", (Object)planAmtLoc);
            planEntry.set("unplansettlelocamt", (Object)planAmtLoc);
            planEntry.set("planduedate", (Object)palnDuedate);
            planEntry.set("plansettletype", (Object)settlementType);
            planEntry.set("e_freezestate", (Object)"unfreeze");
            if (planMaxDuedate == null) {
                planMaxDuedate = palnDuedate;
            } else if (palnDuedate != null) {
                planMaxDuedate = palnDuedate.after(planMaxDuedate) ? palnDuedate : planMaxDuedate;
            }
            planEntryDatas.add((Object)planEntry);
        }
        if (planMaxDuedate != null && finAPBill.getDate("duedate") == null) {
            finAPBill.set("duedate", planMaxDuedate);
        }
    }

    private static void updateFinBillPlanEntity(List<PlanRow> planRows, DynamicObject finAPBill, int baseprecision, int amtprecision) {
        Date planMaxDuedate = null;
        DynamicObject settlementType = finAPBill.getDynamicObject("settlementtype");
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal amtLoc = BigDecimal.ZERO;
        BigDecimal rate = finAPBill.getBigDecimal("exchangerate");
        String quotation = finAPBill.getString("quotation");
        DynamicObjectCollection planEntries = finAPBill.getDynamicObjectCollection("planentity");
        planEntries.clear();
        for (int i = 0; i < planRows.size(); ++i) {
            EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)"ar_finarbill").findProperty("planentity");
            DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
            DynamicObject planEntry = new DynamicObject(dt);
            PlanRow planRow = planRows.get(i);
            Date palnDuedate = planRow.getDueDate();
            BigDecimal planAmtLoc = BigDecimal.ZERO;
            BigDecimal planAmt = planRow.getPlanAmt().setScale(amtprecision, RoundingMode.HALF_UP);
            planAmtLoc = "0".equals(quotation) ? planAmt.multiply(rate).setScale(baseprecision, RoundingMode.HALF_UP) : planAmt.divide(rate, baseprecision, RoundingMode.HALF_UP);
            amt = amt.add(planAmt.setScale(amtprecision, 4));
            amtLoc = amtLoc.add(planAmtLoc.setScale(baseprecision, 4));
            if (i == planRows.size() - 1) {
                BigDecimal priceLoc;
                BigDecimal price;
                BigDecimal pricetaxtotal = finAPBill.getBigDecimal("recamount");
                BigDecimal planpricetaxloc = finAPBill.getBigDecimal("reclocalamt");
                if (amt.compareTo(pricetaxtotal) > 0) {
                    price = amt.subtract(pricetaxtotal);
                    planAmt = planAmt.subtract(price);
                } else if (amt.compareTo(pricetaxtotal) < 0) {
                    price = pricetaxtotal.subtract(amt);
                    planAmt = planAmt.add(price);
                }
                if (amtLoc.compareTo(planpricetaxloc) > 0) {
                    priceLoc = amtLoc.subtract(planpricetaxloc);
                    planAmtLoc = planAmtLoc.subtract(priceLoc);
                } else if (amtLoc.compareTo(planpricetaxloc) < 0) {
                    priceLoc = planpricetaxloc.subtract(amtLoc);
                    planAmtLoc = planAmtLoc.add(priceLoc);
                }
            }
            planEntry.set("seq", (Object)(i + 1));
            planEntry.set("planpricetax", (Object)planAmt);
            planEntry.set("unplanlockamt", (Object)planAmt);
            planEntry.set("unplansettleamt", (Object)planAmt);
            planEntry.set("planpricetaxloc", (Object)planAmtLoc);
            planEntry.set("unplansettlelocamt", (Object)planAmtLoc);
            planEntry.set("planduedate", (Object)palnDuedate);
            planEntry.set("plansettletype", (Object)settlementType);
            planEntry.getDataEntityState().setPushChanged(true);
            if (planMaxDuedate == null) {
                planMaxDuedate = palnDuedate;
            } else if (palnDuedate != null) {
                planMaxDuedate = palnDuedate.after(planMaxDuedate) ? palnDuedate : planMaxDuedate;
            }
            planEntries.add((Object)planEntry);
        }
        if (planMaxDuedate != null && finAPBill.getDate("duedate") == null) {
            finAPBill.set("duedate", planMaxDuedate);
        }
    }
}

