/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.helper.AsstactHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArApProcessParamsHelper {
    private static final Log logger = LogFactory.getLog(ArApProcessParamsHelper.class);

    public static void processArToSm(List<Map<String, Object>> params, DynamicObject[] entities, boolean isAudit) {
        Map<Long, Boolean> assactInterMap = AsstactHelper.isExistInternalBusinessUnit(entities);
        HashSet<Long> billIdSet = new HashSet<Long>(8);
        HashSet<Long> billEntryIdSet = new HashSet<Long>(8);
        for (DynamicObject entity : entities) {
            billIdSet.add(entity.getLong("id"));
            DynamicObjectCollection entryColl = entity.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                billEntryIdSet.add(entry.getLong("id"));
            }
        }
        Map<Long, List<Long>> upBillMaps = BOTPHelper.loadNearUpBillIds("ar_finarbill", "entry", billIdSet.toArray(new Long[0]), billEntryIdSet.toArray(new Long[0]), "im_saloutbill");
        for (DynamicObject bill : entities) {
            boolean isAdjust = BillTypeConsts.ARFIN_BORROW.equals(bill.getLong("billtype.id"));
            boolean isPremimum = bill.getBoolean("ispremium");
            Long billId = bill.getLong("id");
            if (!isAdjust && (isAdjust || ObjectUtils.isEmpty(upBillMaps.get(billId))) || isPremimum) continue;
            DynamicObject currency = bill.getDynamicObject("currency");
            Long settleOrgId = bill.getLong("org.id");
            Long asstactId = bill.getLong("asstact.id");
            Boolean isExistInternal = assactInterMap.getOrDefault(asstactId, Boolean.FALSE);
            DynamicObjectCollection entryCol = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entryInfo : entryCol) {
                String coreBillType = entryInfo.getString("e_corebilltype");
                Long coreBillId = entryInfo.getLong("corebillid");
                Long coreBillEntryId = entryInfo.getLong("corebillentryid");
                BigDecimal baseQty = isAudit ? entryInfo.getBigDecimal("e_baseunitqty") : entryInfo.getBigDecimal("e_baseunitqty").negate();
                BigDecimal recAmount = isAudit ? entryInfo.getBigDecimal("e_recamount") : entryInfo.getBigDecimal("e_recamount").negate();
                Long conbillid = entryInfo.getLong("e_conbillid");
                Long conbillentryid = entryInfo.getLong("e_conbillentryid");
                String conbillentity = entryInfo.getString("e_conbillentity.number");
                if (coreBillId == 0L || coreBillEntryId == 0L || !"sm_salorder".equals(coreBillType) && !"conm_salcontract".equals(coreBillType)) continue;
                String wbType = "sm_salorder".equals(coreBillType) ? "salorder" : "salcontract";
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("arinternalasst", isExistInternal);
                map.put("arasstactid", asstactId);
                map.put("arsettleorgid", settleOrgId);
                map.put("arMainBillEntity", coreBillType);
                map.put("soid", coreBillId);
                map.put("soentryid", coreBillEntryId);
                map.put("baseqty", baseQty);
                map.put("amount", recAmount.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP));
                map.put("conbillentity", conbillentity);
                map.put("conbillid", conbillid);
                map.put("conbillentryid", conbillentryid);
                map.put("wbtype", wbType);
                map.put("ArApBillId", bill.getLong("id"));
                params.add(map);
            }
        }
    }

    public static void processRevcfmToSmParams(List<Map<String, Object>> params, DynamicObject[] entities, boolean isAudit) {
        HashMap billTypeMap = new HashMap(8);
        ArrayList<Long> orderIds = new ArrayList<Long>(8);
        ArrayList<Long> orderEntryIds = new ArrayList<Long>(8);
        HashMap<Long, Long> revcfmEntryIdAndOrderEntryId = new HashMap<Long, Long>(8);
        for (DynamicObject entity2 : entities) {
            DynamicObjectCollection entries = entity2.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long entryId = entry.getLong("id");
                long coreBillId = entry.getLong("e_corebillid");
                long coreBillEntryId = entry.getLong("e_corebillentryid");
                String coreBillType = entry.getString("e_corebilltype");
                if (coreBillId == 0L || coreBillEntryId == 0L || !"sm_salorder".equals(coreBillType)) continue;
                orderIds.add(coreBillId);
                orderEntryIds.add(coreBillEntryId);
                revcfmEntryIdAndOrderEntryId.put(entryId, coreBillEntryId);
            }
        }
        HashMap<Long, Object> revcfmEntryIdAndOrderEntryLineType = new HashMap<Long, Object>(8);
        if (orderIds.size() > 0 && orderEntryIds.size() > 0) {
            DynamicObjectCollection orders = QueryServiceHelper.query((String)"sm_salorder", (String)"id,billentry.id,billentry.linetype.serviceattribute.number", (QFilter[])new QFilter[]{new QFilter("id", "in", orderIds), new QFilter("billentry.id", "in", orderEntryIds)});
            for (Iterator order : orders) {
                long orderEntryId = order.getLong("billentry.id");
                String lineType = order.getString("billentry.linetype.serviceattribute.number");
                for (Map.Entry mapEntry : revcfmEntryIdAndOrderEntryId.entrySet()) {
                    Long key = (Long)mapEntry.getKey();
                    Long value = (Long)mapEntry.getValue();
                    if (orderEntryId != value) continue;
                    revcfmEntryIdAndOrderEntryLineType.put(key, lineType);
                }
            }
        }
        Set srcFinArIds = Arrays.stream(entities).filter(entity -> "ar_finarbill".equals(entity.getString("sourcebilltype"))).map(entity -> entity.getLong("sourcebillid")).collect(Collectors.toSet());
        DynamicObjectCollection finArBillCol = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,billtype", (QFilter[])new QFilter[]{new QFilter("id", "in", srcFinArIds)});
        for (DynamicObject finArBillInfo : finArBillCol) {
            billTypeMap.put(finArBillInfo.getLong("id"), finArBillInfo.getLong("billtype"));
        }
        Set srcArRevcfmIds = Arrays.stream(entities).filter(entity -> "ar_revcfmbill".equals(entity.getString("sourcebilltype"))).map(entity -> entity.getLong("sourcebillid")).collect(Collectors.toSet());
        DynamicObjectCollection arRevcfmBillCol = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", srcArRevcfmIds)});
        HashMap<Long, Long> idSrcIdMap = new HashMap<Long, Long>(8);
        for (DynamicObject arRevcfmBillInfo : arRevcfmBillCol) {
            idSrcIdMap.put(arRevcfmBillInfo.getLong("sourcebillid"), arRevcfmBillInfo.getLong("id"));
        }
        DynamicObjectCollection finalFinArBillCol = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,billtype", (QFilter[])new QFilter[]{new QFilter("id", "in", idSrcIdMap.keySet())});
        for (DynamicObject billInfo : finalFinArBillCol) {
            Long billId = billInfo.getLong("id");
            Long billTypeId = billInfo.getLong("billtype");
            billTypeMap.put(idSrcIdMap.get(billId), billTypeId);
        }
        Map<Long, Boolean> assactInterMap = AsstactHelper.isExistInternalBusinessUnit(entities);
        for (DynamicObject bill : entities) {
            Long sourceBillId = bill.getLong("sourcebillid");
            Long billTypeId = billTypeMap.getOrDefault(sourceBillId, 0L);
            boolean isAdjust = BillTypeConsts.ARFIN_BORROW.equals(billTypeId);
            DynamicObject currency = bill.getDynamicObject("currency");
            Long settleOrgId = bill.getLong("org.id");
            Long asstactId = bill.getLong("asstact.id");
            Boolean isExistInternal = assactInterMap.getOrDefault(asstactId, Boolean.FALSE);
            DynamicObjectCollection entryCol = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entryInfo : entryCol) {
                BigDecimal confirmAmt;
                long entryId = entryInfo.getLong("id");
                DynamicObject lineTypeInfo = entryInfo.getDynamicObject("linetype");
                if (!BillSrcTypeEnum.VERIFY.getValue().equals(bill.getString("billsrctype"))) {
                    if (lineTypeInfo != null) {
                        DynamicObject serviceaTtributeInfo = lineTypeInfo.getDynamicObject("serviceattribute");
                        if (serviceaTtributeInfo == null) continue;
                        String serviceNumber = serviceaTtributeInfo.getString("number");
                        if (!isAdjust && "1001".equals(serviceNumber)) {
                            continue;
                        }
                    } else {
                        String lineTypeServiceNum = (String)revcfmEntryIdAndOrderEntryLineType.get(entryId);
                        if (EmptyUtils.isEmpty(lineTypeServiceNum) || !isAdjust && "1001".equals(lineTypeServiceNum)) continue;
                    }
                }
                String coreBillType = entryInfo.getString("e_corebilltype");
                Long coreBillId = entryInfo.getLong("e_corebillid");
                Long coreBillEntryId = entryInfo.getLong("e_corebillentryid");
                BigDecimal confirmQty = entryInfo.getBigDecimal("e_confirmqty");
                BigDecimal unitcoefficient = entryInfo.getBigDecimal("e_unitcoefficient");
                BigDecimal baseQty = isAudit ? confirmQty.multiply(unitcoefficient) : confirmQty.multiply(unitcoefficient).negate();
                BigDecimal bigDecimal = confirmAmt = isAudit ? entryInfo.getBigDecimal("e_confirmamt") : entryInfo.getBigDecimal("e_confirmamt").negate();
                if (coreBillId == 0L || coreBillEntryId == 0L || !"sm_salorder".equals(coreBillType)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("arinternalasst", isExistInternal);
                map.put("arasstactid", asstactId);
                map.put("arsettleorgid", settleOrgId);
                map.put("arMainBillEntity", coreBillType);
                map.put("soid", coreBillId);
                map.put("soentryid", coreBillEntryId);
                map.put("baseqty", baseQty);
                map.put("amount", confirmAmt.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP));
                map.put("ArApBillId", bill.getLong("id"));
                params.add(map);
            }
        }
    }

    @Deprecated
    public static void processRevcfmToSmParam(List<Map<String, Object>> params, DynamicObject[] entities, boolean isAudit) {
        Object[] ids = Arrays.stream(entities).map(entity -> entity.get("id")).toArray();
        Set<Long> salOutVerifyBillIds = ArApProcessParamsHelper.getSalOutVerifyBillIds(ids);
        Object[] srcIds = Arrays.stream(entities).filter(entity -> entity.getBoolean("iswrittenoff")).map(entity -> entity.get("sourcebillid")).toArray();
        salOutVerifyBillIds.addAll(ArApProcessParamsHelper.getSalOutVerifyBillIds(srcIds));
        Map<Long, Boolean> assactInterMap = AsstactHelper.isExistInternalBusinessUnit(entities);
        for (DynamicObject bill : entities) {
            Long billId = bill.getLong("id");
            Long sourceBillId = bill.getLong("sourcebillid");
            if (salOutVerifyBillIds.contains(billId) || salOutVerifyBillIds.contains(sourceBillId)) continue;
            DynamicObject currency = bill.getDynamicObject("currency");
            Long settleOrgId = bill.getLong("org.id");
            Long asstactId = bill.getLong("asstact.id");
            Boolean isExistInternal = assactInterMap.getOrDefault(asstactId, Boolean.FALSE);
            DynamicObjectCollection entryCol = bill.getDynamicObjectCollection("entry");
            for (DynamicObject entryInfo : entryCol) {
                BigDecimal confirmAmt;
                String coreBillType = entryInfo.getString("e_corebilltype");
                Long coreBillId = entryInfo.getLong("e_corebillid");
                Long coreBillEntryId = entryInfo.getLong("e_corebillentryid");
                BigDecimal confirmQty = entryInfo.getBigDecimal("e_confirmqty");
                BigDecimal unitcoefficient = entryInfo.getBigDecimal("e_unitcoefficient");
                BigDecimal baseQty = isAudit ? confirmQty.multiply(unitcoefficient) : confirmQty.multiply(unitcoefficient).negate();
                BigDecimal bigDecimal = confirmAmt = isAudit ? entryInfo.getBigDecimal("e_confirmamt") : entryInfo.getBigDecimal("e_confirmamt").negate();
                if (coreBillId == 0L || coreBillEntryId == 0L || !"sm_salorder".equals(coreBillType)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("arinternalasst", isExistInternal);
                map.put("arasstactid", asstactId);
                map.put("arsettleorgid", settleOrgId);
                map.put("arMainBillEntity", coreBillType);
                map.put("soid", coreBillId);
                map.put("soentryid", coreBillEntryId);
                map.put("baseqty", baseQty);
                map.put("amount", confirmAmt.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP));
                map.put("ArApBillId", bill.getLong("id"));
                params.add(map);
            }
        }
    }

    @Deprecated
    public static Set<Long> getSalOutVerifyBillIds(Object[] billIds) {
        HashSet<Long> salOutIds = new HashSet<Long>(8);
        if (billIds == null || billIds.length == 0) {
            return salOutIds;
        }
        QFilter asstFilter = new QFilter("entry.e_billid", "in", (Object)billIds);
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter("ar_revcfmbill", billIds, true);
        asstFilter.and(commonFilter);
        List<String> relationList = Arrays.asList("arsalout", "arsalreturn");
        QFilter relationFilter = new QFilter("verifyrelation", "in", relationList);
        DataSet vr4Assts = QueryServiceHelper.queryDataSet((String)"queryVR4Asst", (String)"ar_verifyrecord", (String)"id,entry.e_billid", (QFilter[])new QFilter[]{asstFilter.and(relationFilter)}, null);
        for (Row vr4Asst : vr4Assts) {
            salOutIds.add(vr4Asst.getLong("entry.e_billid"));
        }
        return salOutIds;
    }

    public static void writeBackScmcBill(DynamicObject[] entities, boolean isSettle) {
        DynamicObject[] adjustBills = (DynamicObject[])Arrays.stream(entities).filter(entity -> "ApFin_borr_BT_S".equals(entity.getString("billtypeid.number"))).toArray(DynamicObject[]::new);
        if (EmptyUtils.isEmpty(adjustBills)) {
            return;
        }
        logger.info("writeBackScmcBill - begin to structure write back param ");
        ArrayList<Map<String, Object>> writePurOrderParam = new ArrayList<Map<String, Object>>(64);
        ArrayList<Map<String, Object>> writeScpoOrderParam = new ArrayList<Map<String, Object>>(64);
        ArrayList<Map<String, Object>> writeContractParam = new ArrayList<Map<String, Object>>(64);
        Map<Long, Boolean> assactInterMap = AsstactHelper.isExistInternalBusinessUnit(adjustBills);
        for (DynamicObject adjustBill : adjustBills) {
            long asstactId = adjustBill.getLong("asstact.id");
            Boolean isExistInternal = assactInterMap.getOrDefault(asstactId, Boolean.FALSE);
            DynamicObjectCollection detailEntry = adjustBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject detail : detailEntry) {
                HashMap<String, Object> param;
                long coreBillId = detail.getLong("corebillid");
                long coreBillEntryId = detail.getLong("corebillentryid");
                String coreBillType = detail.getString("corebilltype");
                long orgId = adjustBill.getLong("org.id");
                long conBillId = detail.getLong("e_conbillid");
                long conBillEntryId = detail.getLong("e_conbillentryid");
                BigDecimal baseUnitQty = detail.getBigDecimal("e_baseunitqty");
                BigDecimal amount = BigDecimal.ZERO;
                amount = isSettle ? detail.getBigDecimal("e_pricetaxtotal") : detail.getBigDecimal("e_pricetaxtotal").negate();
                if ("conm_purcontract".equals(coreBillType) || "pm_purorderbill".equals(coreBillType)) {
                    param = new HashMap<String, Object>(8);
                    param.put("apinternalasst", isExistInternal);
                    param.put("apasstactid", asstactId);
                    param.put("apsettleorgid", orgId);
                    param.put("apMainBillEntity", coreBillType);
                    param.put("poid", coreBillId);
                    param.put("poentryid", coreBillEntryId);
                    param.put("baseqty", baseUnitQty);
                    param.put("amount", amount);
                    param.put("conbillentity", detail.getString("e_conbillentity.number"));
                    param.put("conbillid", conBillId);
                    param.put("conbillentryid", conBillEntryId);
                    writeContractParam.add(param);
                }
                if (!"pm_purorderbill".equals(coreBillType) && !"sctm_scpo".equals(coreBillType) || 0L == coreBillId || 0L == coreBillEntryId) continue;
                param = new HashMap(8);
                param.put("mainbillid", coreBillId);
                param.put("mainbillentryid", coreBillEntryId);
                param.put("mainbillentity", coreBillType);
                param.put("internal_company", isExistInternal);
                param.put("settleorgid", orgId);
                param.put("supplierid", asstactId);
                param.put("amount", amount);
                param.put("baseqty", baseUnitQty);
                param.put("qty", detail.getBigDecimal("quantity"));
                if ("sctm_scpo".equals(coreBillType)) {
                    writeScpoOrderParam.add(param);
                    continue;
                }
                writePurOrderParam.add(param);
            }
        }
        if (!writePurOrderParam.isEmpty()) {
            Settle4ScmcHelper.writeBackPmOrderBillEntry(writePurOrderParam, isSettle);
        }
        if (!writeContractParam.isEmpty()) {
            Settle4ScmcHelper.writeBackContractBillEntry(writeContractParam, isSettle);
        }
        if (!writeScpoOrderParam.isEmpty()) {
            Settle4ScmcHelper.writeBackScpoOrderBillEntry(writeScpoOrderParam, isSettle);
        }
    }
}

