/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ArApRecOrPayBillHelper {
    public static void showRecOrPayBillF7(String billType, IFormView view, String pluginName, QFilter filter) {
        ArApRecOrPayBillHelper.showRecOrPayBillF7(billType, view, pluginName, filter, false);
    }

    public static void showRecOrPayBillF7(String billType, IFormView view, String pluginName, QFilter filter, boolean isMergeRows) {
        if (StringUtils.isEmpty((CharSequence)billType)) {
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)billType, (boolean)true, (int)2);
        ListFilterParameter lfp = new ListFilterParameter();
        lfp.setFilter(filter);
        lsp.setCustomParam("ismergerows", (Object)isMergeRows);
        lsp.setListFilterParameter(lfp);
        CloseCallBack closeCallBack = new CloseCallBack(pluginName, "recOrPayBill");
        lsp.setCloseCallBack(closeCallBack);
        view.showForm((FormShowParameter)lsp);
    }

    public static void closeRecOrPayBillF7(IDataModel model, String entryKey, Object returnData) {
        ListSelectedRowCollection collection = (ListSelectedRowCollection)returnData;
        if (ObjectUtils.isEmpty((Object)collection)) {
            return;
        }
        boolean isPreEntry = (Boolean)model.getValue("ispreentry");
        if (isPreEntry) {
            if (collection.get(0).getEntryPrimaryKeyValue() == null) {
                int currentRowIndex = model.getEntryCurrentRowIndex(entryKey);
                String billType = (String)model.getValue("y_billtype", currentRowIndex);
                ArrayList<Long> billIds = new ArrayList<Long>(2);
                for (ListSelectedRow listSelectedRow : collection) {
                    billIds.add((Long)listSelectedRow.getPrimaryKeyValue());
                }
                QFilter filter = new QFilter("id", "in", billIds);
                if ("cas_paybill".equals(billType) || "cas_recbill".equals(billType)) {
                    DynamicObject org = (DynamicObject)model.getValue("org");
                    BigDecimal unSettleAmount = (BigDecimal)model.getValue("unsettleamount");
                    if ("cas_paybill".equals(billType)) {
                        filter.and(new QFilter("entry.settleorg", "=", (Object)org.getLong("id")));
                        filter.and(new QFilter("entry.e_paymenttype.ispartpayment", "=", (Object)Boolean.TRUE));
                        filter.and(new QFilter("entry.e_paymenttype.biztype", "=", (Object)"202"));
                    } else {
                        filter.and(new QFilter("entry.e_settleorg", "=", (Object)org.getLong("id")));
                        filter.and(new QFilter("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE));
                        filter.and(new QFilter("entry.e_receivingtype.biztype", "=", (Object)"101"));
                    }
                    if (unSettleAmount.compareTo(BigDecimal.ZERO) > 0) {
                        filter.and(new QFilter("entry.e_unsettledamt", ">", (Object)BigDecimal.ZERO));
                    } else if (unSettleAmount.compareTo(BigDecimal.ZERO) < 0) {
                        filter.and(new QFilter("entry.e_unsettledamt", "<", (Object)BigDecimal.ZERO));
                    }
                } else if ("ap_paidbill".equals(billType) || "ar_receivedbill".equals(billType)) {
                    Object actAmtField;
                    BigDecimal priceTaxTotal;
                    String entityType = model.getDataEntity().getDataEntityType().getName();
                    if ("ar_finarbill".equals(entityType)) {
                        priceTaxTotal = (BigDecimal)model.getValue("recamount");
                        actAmtField = "entry.e_amount";
                    } else {
                        priceTaxTotal = (BigDecimal)model.getValue("pricetaxtotal");
                        actAmtField = "entry.e_actamt";
                    }
                    filter.and("entry.e_unsettledamt", "<>", (Object)BigDecimal.ZERO);
                    if (priceTaxTotal.compareTo(BigDecimal.ZERO) > 0) {
                        filter.and((String)actAmtField, ">", (Object)BigDecimal.ZERO);
                    } else if (priceTaxTotal.compareTo(BigDecimal.ZERO) < 0) {
                        filter.and((String)actAmtField, "<", (Object)BigDecimal.ZERO);
                    }
                }
                DynamicObjectCollection preEntry = model.getEntryEntity("preentry");
                ArrayList<Long> selectedEntryId = new ArrayList<Long>();
                for (DynamicObject row : preEntry) {
                    Long billEntryId;
                    String rowBillType = row.getString("y_billtype");
                    if (!billType.equals(rowBillType) || ObjectUtils.isEmpty((Object)(billEntryId = Long.valueOf(row.getLong("y_billentryid"))))) continue;
                    selectedEntryId.add(billEntryId);
                }
                if (selectedEntryId.size() > 0 && selectedEntryId != null) {
                    filter.and("entry.id", "not in", selectedEntryId);
                }
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"preentryquery", (String)billType, (String)"id,entry.id,billno", (QFilter[])filter.toArray(), (String)"billno");
                int size = coll.size();
                int entryRowCount = model.getEntryRowCount(entryKey);
                if (size > 1) {
                    model.appendEntryRow(entryKey, entryRowCount - 1, size - 1);
                }
                model.setValue("y_billtype", (Object)billType, currentRowIndex);
                model.setValue("y_billno", (Object)((DynamicObject)coll.get(0)).getString("billno"), currentRowIndex);
                model.setValue("y_billid", (Object)((DynamicObject)coll.get(0)).getLong("id"), currentRowIndex);
                model.setValue("y_billentryid", (Object)((DynamicObject)coll.get(0)).getLong("entry.id"), currentRowIndex);
                int index = entryRowCount;
                for (int i = 1; i < size; ++i) {
                    DynamicObject col = (DynamicObject)coll.get(i);
                    String billNo = col.getString("billno");
                    Long billId = col.getLong("id");
                    Long billEntryId = col.getLong("entry.id");
                    model.setValue("y_billtype", (Object)billType, index);
                    model.setValue("y_billno", (Object)billNo, index);
                    model.setValue("y_billid", (Object)billId, index);
                    model.setValue("y_billentryid", (Object)billEntryId, index);
                    ++index;
                }
            } else {
                int size = collection.size();
                int entryRowCount = model.getEntryRowCount(entryKey);
                int currentRowIndex = model.getEntryCurrentRowIndex(entryKey);
                if (size > 1) {
                    model.appendEntryRow(entryKey, entryRowCount - 1, size - 1);
                }
                String billType = (String)model.getValue("y_billtype", currentRowIndex);
                model.setValue("y_billtype", (Object)billType, currentRowIndex);
                model.setValue("y_billno", (Object)collection.get(0).getBillNo(), currentRowIndex);
                model.setValue("y_billid", collection.get(0).getPrimaryKeyValue(), currentRowIndex);
                model.setValue("y_billentryid", collection.get(0).getEntryPrimaryKeyValue(), currentRowIndex);
                int index = entryRowCount;
                for (int i = 1; i < size; ++i) {
                    ListSelectedRow listSelectedRow = collection.get(i);
                    String billNo = listSelectedRow.getBillNo();
                    Long billId = (Long)listSelectedRow.getPrimaryKeyValue();
                    Long billEntryId = (Long)listSelectedRow.getEntryPrimaryKeyValue();
                    model.setValue("y_billtype", (Object)billType, index);
                    model.setValue("y_billno", (Object)billNo, index);
                    model.setValue("y_billid", (Object)billId, index);
                    model.setValue("y_billentryid", (Object)billEntryId, index);
                    ++index;
                }
            }
        } else {
            int size = collection.size();
            int entryRowCount = model.getEntryRowCount(entryKey);
            int currentRowIndex = model.getEntryCurrentRowIndex(entryKey);
            if (size > 1) {
                model.appendEntryRow(entryKey, entryRowCount - 1, size - 1);
            }
            String billType = (String)model.getValue("y_billtype", currentRowIndex);
            model.setValue("y_billtype", (Object)billType, currentRowIndex);
            model.setValue("y_billno", (Object)collection.get(0).getBillNo(), currentRowIndex);
            model.setValue("y_billid", collection.get(0).getPrimaryKeyValue(), currentRowIndex);
            int index = entryRowCount;
            for (int i = 1; i < size; ++i) {
                ListSelectedRow listSelectedRow = collection.get(i);
                String billNo = listSelectedRow.getBillNo();
                Long billId = (Long)listSelectedRow.getPrimaryKeyValue();
                model.setValue("y_billtype", (Object)billType, index);
                model.setValue("y_billno", (Object)billNo, index);
                model.setValue("y_billid", (Object)billId, index);
                ++index;
            }
        }
    }

    public static void sortPreEntryByDate(DynamicObject[] datas) {
        for (DynamicObject bill : datas) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("preentry");
            if (entrys.size() <= 1) continue;
            entrys.sort((o1, o2) -> {
                if (o1.getDate("y_date") == null || o2.getDate("y_date") == null) {
                    return -1;
                }
                return o1.getDate("y_date").compareTo(o2.getDate("y_date"));
            });
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                entry.set("seq", (Object)(i + 1));
            }
        }
    }

    public static void removeEmptyPreEntry(DynamicObject[] datas) {
        for (DynamicObject data : datas) {
            DynamicObjectCollection preEntryCol = data.getDynamicObjectCollection("preentry");
            preEntryCol.removeIf(row -> row.getLong("y_billid") == 0L);
        }
    }

    public static boolean isHistoryPreEntryBill(DynamicObject bill) {
        DynamicObjectCollection preEntry = bill.getDynamicObjectCollection("preentry");
        if (ObjectUtils.isEmpty((Object)preEntry)) {
            return false;
        }
        boolean isHistory = true;
        for (DynamicObject row : preEntry) {
            if ("ap_paidbill".equals(row.getString("y_billtype"))) {
                return false;
            }
            BigDecimal settleAmt = row.getBigDecimal("y_settleamt");
            if (settleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            isHistory = false;
            break;
        }
        return isHistory;
    }

    public static void updateHistoryPreEntrySettleAmt(DynamicObject[] dataEntities) {
        LinkedList<DynamicObject> historyBills = new LinkedList<DynamicObject>();
        HashMap<Long, List> orgPayBillMap = new HashMap<Long, List>(8);
        for (DynamicObject dataEntity : dataEntities) {
            boolean isHistory = ArApRecOrPayBillHelper.isHistoryPreEntryBill(dataEntity);
            if (!isHistory) continue;
            LinkedList<Long> payBillIds = new LinkedList<Long>();
            historyBills.add(dataEntity);
            long orgId = dataEntity.getDynamicObject("org").getLong("id");
            DynamicObjectCollection preEntry = dataEntity.getDynamicObjectCollection("preentry");
            for (DynamicObject row : preEntry) {
                long payBillId = row.getLong("y_billid");
                payBillIds.add(payBillId);
            }
            List value = (List)orgPayBillMap.get(orgId);
            if (value == null) {
                orgPayBillMap.put(orgId, payBillIds);
                continue;
            }
            value.addAll(payBillIds);
            orgPayBillMap.put(orgId, value);
        }
        if (ObjectUtils.isEmpty(orgPayBillMap) || ObjectUtils.isEmpty(historyBills)) {
            return;
        }
        HashMap unsettleAmtMap = new HashMap(8);
        Set entries = orgPayBillMap.entrySet();
        for (Map.Entry entry : entries) {
            Long orgId = (Long)entry.getKey();
            List ids = (List)entry.getValue();
            DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,entry.id,entry.e_paymenttype,entry.e_unsettledamt,entry.settleorg", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
            for (DynamicObject payBill : payBills) {
                HashMap<Long, BigDecimal> entryUnsettleAmtMap = new HashMap<Long, BigDecimal>(2);
                DynamicObjectCollection payEntry = payBill.getDynamicObjectCollection("entry");
                for (DynamicObject row : payEntry) {
                    if (orgId.longValue() != row.getLong("settleorg.id") || ObjectUtils.isEmpty((Object)row.getDynamicObject("e_paymenttype")) || !row.getDynamicObject("e_paymenttype").getBoolean("ispartpayment") || !"202".equals(row.getString("e_paymenttype.biztype"))) continue;
                    BigDecimal unsettleAmt = row.getBigDecimal("e_unsettledamt");
                    entryUnsettleAmtMap.put(row.getLong("id"), unsettleAmt);
                }
                unsettleAmtMap.put(payBill.getLong("id"), entryUnsettleAmtMap);
            }
            for (DynamicObject historyBill : historyBills) {
                BigDecimal priceTaxTotal = historyBill.getBigDecimal("pricetaxtotal");
                BigDecimal premiumAmt = historyBill.getBigDecimal("premiumamt");
                if (premiumAmt != null && premiumAmt.compareTo(BigDecimal.ZERO) != 0) {
                    priceTaxTotal = priceTaxTotal.subtract(premiumAmt);
                }
                DynamicObjectCollection preEntry = historyBill.getDynamicObjectCollection("preentry");
                for (DynamicObject row : preEntry) {
                    Map entryAmtMap;
                    long payBillId = row.getLong("y_billid");
                    long payBillEntryId = row.getLong("y_billentryid");
                    BigDecimal unsettleAmt = BigDecimal.ZERO;
                    if (payBillEntryId == 0L) {
                        entryAmtMap = (Map)unsettleAmtMap.get(payBillId);
                        for (BigDecimal value : entryAmtMap.values()) {
                            unsettleAmt = unsettleAmt.add(value);
                        }
                    } else {
                        entryAmtMap = (Map)unsettleAmtMap.get(payBillId);
                        if (!ObjectUtils.isEmpty((Object)entryAmtMap)) {
                            unsettleAmt = (BigDecimal)entryAmtMap.get(payBillEntryId);
                        }
                    }
                    if (unsettleAmt == null || unsettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    unsettleAmt = priceTaxTotal.abs().compareTo(unsettleAmt.abs()) >= 0 ? unsettleAmt : priceTaxTotal;
                    row.set("y_settleamt", (Object)unsettleAmt);
                    priceTaxTotal = priceTaxTotal.subtract(unsettleAmt);
                }
            }
        }
    }
}

