/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StringUtils;

public abstract class ArapAbstractImport
implements IImportPlugin {
    protected Map<String, Object> data = null;
    protected String importtype = null;
    protected Map<String, Map<String, DynamicObject>> cachedF7 = new HashMap<String, Map<String, DynamicObject>>();
    protected long orgId = 0L;
    protected InitHelper init;
    protected DynamicObject currency = null;
    protected DynamicObject baseCurrency = null;
    protected long baseCurrencyId = 0L;
    protected int baseCurrencyPrecision = 2;
    protected Map<Long, Date> cachedDate = new HashMap<Long, Date>();

    public void init(Map<String, Object> arg0) {
    }

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        this.data = data;
        this.importtype = (String)option.get("importtype");
        return super.beforeImportData(data, option, importlogs);
    }

    protected void checkOrg() throws Exception {
        JSONObject value = (JSONObject)this.data.get("org");
        if (value == null) {
            throw new Exception(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u5e94\u4ed8\u7ec4\u7ec7\u3002", (String)"ArapAbstractImport_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        String number = (String)value.get((Object)"number");
        if (!this.checkExist("bos_org", number)) {
            throw new Exception(ResManager.loadKDString((String)"\u5e94\u4ed8\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ArapAbstractImport_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        this.orgId = this.cachedF7.get("bos_org").get(number).getLong("id");
        this.init = new InitHelper(this.orgId, "ap_init");
        if (this.init == null || this.init.getStartDate() == null) {
            throw new Exception(ResManager.loadKDString((String)"\u5e94\u4ed8\u7ec4\u7ec7\u5c1a\u672a\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"ArapAbstractImport_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (this.init.isFinishInit()) {
            throw new Exception(ResManager.loadKDString((String)"\u5e94\u4ed8\u7ec4\u7ec7\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"ArapAbstractImport_3", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        DynamicObject baseCurrency = this.init.getStandardCurrency();
        this.baseCurrencyId = baseCurrency.getLong("id");
        this.baseCurrencyPrecision = baseCurrency.getInt("amtprecision");
        JSONObject jsonBaseCurrency = new JSONObject();
        jsonBaseCurrency.put("number", baseCurrency.get("number"));
        this.data.put("basecurrency", jsonBaseCurrency);
    }

    protected void checkOrgNew() throws Exception {
        JSONObject value = (JSONObject)this.data.get("org");
        if (value == null) {
            throw new Exception(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u5e94\u4ed8\u7ec4\u7ec7\u3002", (String)"ArapAbstractImport_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        String number = (String)value.get((Object)"number");
        if (!this.checkExist("bos_org", number)) {
            throw new Exception(ResManager.loadKDString((String)"\u5e94\u4ed8\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ArapAbstractImport_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        this.orgId = this.cachedF7.get("bos_org").get(number).getLong("id");
        this.init = new InitHelper(this.orgId, "ap_init");
        if (this.init == null || this.init.getStartDate() == null) {
            throw new Exception(ResManager.loadKDString((String)"\u5e94\u4ed8\u7ec4\u7ec7\u5c1a\u672a\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"ArapAbstractImport_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        DynamicObject baseCurrency = this.init.getStandardCurrency();
        this.baseCurrencyId = baseCurrency.getLong("id");
        this.baseCurrencyPrecision = baseCurrency.getInt("amtprecision");
        JSONObject jsonBaseCurrency = new JSONObject();
        jsonBaseCurrency.put("number", baseCurrency.get("number"));
        this.data.put("basecurrency", jsonBaseCurrency);
    }

    protected BigDecimal parseBigDecimal(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    protected boolean checkLength(String value, int length) {
        return value.length() > length;
    }

    protected boolean checkExist(String entityName, String number) {
        if (this.cachedF7.get(entityName) != null && this.cachedF7.get(entityName).containsKey(number)) {
            return this.cachedF7.get(entityName).get(number) != null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number)};
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,number,name", (QFilter[])filters);
        boolean exist = obj != null;
        Map<String, DynamicObject> entityCache = this.cachedF7.get(entityName);
        if (entityCache == null) {
            entityCache = new HashMap<String, DynamicObject>();
            this.cachedF7.put(entityName, entityCache);
        }
        entityCache.put(number, obj);
        return exist;
    }

    protected void checkNull(String key, String title) throws Exception {
        Object value = this.data.get(key);
        if (value == null) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c%s\u201d\u3002", (String)"ArapAbstractImport_4", (String)"fi-arapcommon", (Object[])new Object[0]), title));
        }
    }

    protected void checkDate(String key, String title, boolean required, Date min, Date max, Date defaultValue) throws Exception {
        String strValue = (String)this.data.get("bizdate");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date value = df.parse(strValue);
        if (required && value == null) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c%s\u201d\u3002", (String)"ArapAbstractImport_4", (String)"fi-arapcommon", (Object[])new Object[0]), title));
        }
        if (min != null && value.compareTo(min) < 0) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\u201c%2$s\u201d\u3002", (String)"ArapAbstractImport_5", (String)"fi-arapcommon", (Object[])new Object[0]), title, df.format(min)));
        }
        if (max != null && value.compareTo(max) >= 0) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u9700\u65e9\u4e8e\u542f\u7528\u65e5\u671f\u201c%2$s\u201d\u3002", (String)"ArapAbstractImport_6", (String)"fi-arapcommon", (Object[])new Object[0]), title, df.format(max)));
        }
        if (value == null && defaultValue != null) {
            this.data.put(key, defaultValue);
        }
    }

    protected void checkDateCompare(String key, String title) throws Exception {
        String bizdateValue = (String)this.data.get("bizdate");
        String strValue = (String)this.data.get("duedate");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (strValue != null) {
            Date duedate = df.parse(strValue);
            Date bizdate = df.parse(bizdateValue);
            if (bizdate != null && DateUtils.compareTo(duedate, bizdate) < 0) {
                throw new Exception(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u80fd\u5c0f\u4e8e\u5355\u636e\u65e5\u671f\u201c%2$s\u201d\u3002", (String)"ArapAbstractImport_7", (String)"fi-arapcommon", (Object[])new Object[0]), title, df.format(bizdate)));
            }
        }
    }

    protected void checkEnum(String key, String title, boolean required, String[] enums, String defaultValue) throws Exception {
        String value = (String)this.data.get(key);
        if (required && value == null) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c%s\u201d\u3002", (String)"ArapAbstractImport_4", (String)"fi-arapcommon", (Object[])new Object[0]), title));
        }
        if (value != null) {
            boolean hit = false;
            for (int i = 0; i < enums.length; ++i) {
                if (!value.equals(enums[i])) continue;
                hit = true;
                break;
            }
            if (!hit) {
                throw new Exception(String.format(ResManager.loadKDString((String)"%1$s\u7684\u8f93\u5165\u503c\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ArapAbstractImport_8", (String)"fi-arapcommon", (Object[])new Object[0]), title, value));
            }
        }
        if (value == null && defaultValue != null) {
            this.data.put(key, defaultValue);
        }
    }

    protected void checkF7(String key, String title, boolean required, String defaultValue) throws Exception {
        JSONObject value = (JSONObject)this.data.get(key);
        if (required && value == null) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c%s\u201d\u3002", (String)"ArapAbstractImport_4", (String)"fi-arapcommon", (Object[])new Object[0]), title));
        }
        if (value == null && defaultValue != null) {
            value = new JSONObject();
            value.put("number", (Object)defaultValue);
            this.data.put(key, value);
        }
    }

    protected void checkText(String key, String title, boolean required, int length, String defaultValue) throws Exception {
        String value = (String)this.data.get(key);
        if (required && value == null && defaultValue == null) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c%s\u201d\u3002", (String)"ArapAbstractImport_4", (String)"fi-arapcommon", (Object[])new Object[0]), title));
        }
        if (value == null && defaultValue != null) {
            this.data.put(key, defaultValue);
            return;
        }
        if (value != null && value.length() > length) {
            throw new Exception(String.format(ResManager.loadKDString((String)"%1$s\u5927\u4e8e\u6700\u5927\u957f\u5ea6%2$s\u3002", (String)"ArapAbstractImport_10", (String)"fi-arapcommon", (Object[])new Object[0]), title, length));
        }
    }

    protected void checkEntryNull(String key, String title, JSONObject entry, int seq) throws Exception {
        Object value = entry.get((Object)key);
        if (value == null) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\uff1a%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArapAbstractImport_11", (String)"fi-arapcommon", (Object[])new Object[0]), seq + 1, title));
        }
    }

    protected void checkEntryDate(String key, String title, JSONObject entry, int seq, boolean required, Date min, Date max, Date defaultValue) throws Exception {
        String strValue = (String)entry.get((Object)"bizdate");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date value = df.parse(strValue);
        if (required && value == null) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\uff1a%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArapAbstractImport_11", (String)"fi-arapcommon", (Object[])new Object[0]), seq + 1, title));
        }
        if (min != null && value.compareTo(min) < 0) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\uff1a%2$s\u4e0d\u80fd\u5c0f\u4e8e\u65e5\u671f%3$s\u3002", (String)"ArapAbstractImport_12", (String)"fi-arapcommon", (Object[])new Object[0]), seq + 1, title, df.format(min)));
        }
        if (max != null && value.compareTo(max) > 0) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\uff1a%2$s\u4e0d\u80fd\u5927\u4e8e\u65e5\u671f%3$s\u3002", (String)"ArapAbstractImport_13", (String)"fi-arapcommon", (Object[])new Object[0]), seq + 1, title, df.format(min)));
        }
        if (value == null && defaultValue != null) {
            entry.put(key, (Object)defaultValue);
        }
    }

    protected void checkEntryEnum(String key, String title, JSONObject entry, int seq, boolean required, String[] enums, String defaultValue) throws Exception {
        String value = (String)entry.get((Object)key);
        if (required && value == null) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\uff1a%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArapAbstractImport_11", (String)"fi-arapcommon", (Object[])new Object[0]), seq + 1, title));
        }
        if (value != null) {
            boolean hit = false;
            for (int i = 0; i < enums.length; ++i) {
                if (!value.equals(enums[i])) continue;
                hit = true;
                break;
            }
            if (!hit) {
                throw new Exception(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\uff1a%2$s\u8f93\u5165\u503c%3$s\u4e0d\u5b58\u5728\u3002", (String)"ArapAbstractImport_14", (String)"fi-arapcommon", (Object[])new Object[0]), seq + 1, title, value));
            }
        }
        if (value == null && defaultValue != null) {
            entry.put(key, (Object)defaultValue);
        }
    }

    protected void checkEntryF7(String key, String title, JSONObject entry, int seq, boolean required, String defaultValue) throws Exception {
        JSONObject value = (JSONObject)entry.get((Object)key);
        if (required && value == null) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c%s\u201d\u3002", (String)"ArapAbstractImport_4", (String)"fi-arapcommon", (Object[])new Object[0]), title));
        }
        if (value == null && defaultValue != null) {
            value = new JSONObject();
            value.put("number", (Object)defaultValue);
            entry.put(key, (Object)value);
        }
    }

    protected BigDecimal getEntryBigDecimal(JSONObject row, String key) {
        Object value = row.get((Object)key);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    protected BigDecimal getBigDecimal(String key) {
        Object value = this.data.get(key);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    protected void checkF7(String entityName, String key, String title, boolean required, String defaultValue) throws Exception {
        String number;
        JSONObject value = (JSONObject)this.data.get(key);
        if (required && value == null && defaultValue == null) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c%s\u201d\u3002", (String)"ArapAbstractImport_4", (String)"fi-arapcommon", (Object[])new Object[0]), title));
        }
        if (value == null && defaultValue != null) {
            value = new JSONObject();
            value.put("number", (Object)defaultValue);
            this.data.put(key, value);
        } else if (value != null && !this.checkExist(entityName, number = value.getString("number"), key)) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ArapAbstractImport_15", (String)"fi-arapcommon", (Object[])new Object[0]), title));
        }
    }

    protected boolean checkExist(String entityName, String number, String key) {
        Map<String, DynamicObject> objMap = this.cachedF7.get(key);
        if (objMap.get(number) != null) {
            return objMap.get(number) != null;
        }
        DynamicObject obj = null;
        if ("bd_operator".equals(entityName)) {
            QFilter[] filters = new QFilter[]{new QFilter("operatornumber", "=", (Object)number)};
            obj = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,operatornumber,name", (QFilter[])filters);
        } else {
            QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number)};
            obj = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,number,name", (QFilter[])filters);
        }
        if (obj == null) {
            return false;
        }
        if ("currency".equals(key)) {
            this.currency = obj;
        }
        objMap.put(number, obj);
        this.cachedF7.put(key, objMap);
        return true;
    }

    protected String checkOrgF7(String functional, String key, String title, boolean required, String defaultValue) throws Exception {
        JSONObject value = (JSONObject)this.data.get(key);
        if (required && value == null && defaultValue == null) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c%s\u201d\u3002", (String)"ArapAbstractImport_4", (String)"fi-arapcommon", (Object[])new Object[0]), title));
        }
        if (value == null && defaultValue != null) {
            value = new JSONObject();
            value.put("number", (Object)defaultValue);
            this.data.put(key, value);
        } else if (value != null) {
            String number = value.getString("number");
            if (!this.checkExistOrg(functional, number, key)) {
                throw new Exception(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ArapAbstractImport_15", (String)"fi-arapcommon", (Object[])new Object[0]), title));
            }
            return number;
        }
        return null;
    }

    protected void checkOrgNew(String functional) throws Exception {
        DynamicObject baseCurrency;
        JSONObject value = (JSONObject)this.data.get("org");
        if (value == null) {
            throw new Exception(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"ArapAbstractImport_17", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        String number = (String)value.get((Object)"number");
        if (!this.checkExistOrg(functional, number, "org")) {
            throw new Exception(ResManager.loadKDString((String)"\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ArapAbstractImport_18", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        this.orgId = this.cachedF7.get("org").get(number).getLong("id");
        this.init = new InitHelper(this.orgId, "ar_init");
        if (this.init == null || this.init.getStartDate() == null) {
            throw new Exception(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u201c\u5e94\u6536\u7ec4\u7ec7\u201d\u7684\u521d\u59cb\u8bbe\u7f6e\uff0c\u5426\u5219\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"ArapAbstractImport_19", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        this.currency = baseCurrency = this.init.getStandardCurrency();
        this.baseCurrency = baseCurrency;
        this.baseCurrencyId = baseCurrency.getLong("id");
        this.baseCurrencyPrecision = baseCurrency.getInt("amtprecision");
        JSONObject jsonBaseCurrency = new JSONObject();
        jsonBaseCurrency.put("number", baseCurrency.get("number"));
        this.data.put("basecurrency", jsonBaseCurrency);
    }

    protected boolean checkExistOrg(String functional, String number, String key) throws Exception {
        Map<String, DynamicObject> objMap = this.cachedF7.get(key);
        if (objMap.get(number) != null) {
            this.orgId = objMap.get(number).getLong("id");
            if ("org".equals(key)) {
                this.cachedMainOrg();
            }
            return objMap.get(number) != null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number)};
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id,number,name,fisaccounting,fisbankroll,fissale,fissettlement", (QFilter[])filters);
        if (obj == null) {
            return false;
        }
        this.orgId = obj.getLong("id");
        if ("org".equals(key)) {
            this.cachedMainOrg();
        }
        objMap.put(number, obj);
        this.cachedF7.put(key, objMap);
        return StringUtils.isEmpty(functional) ? true : obj.getBoolean(functional);
    }

    protected void cachedMainOrg() throws Exception {
        this.init = new InitHelper(this.orgId, "ar_init");
        if (ObjectUtils.isEmpty((Object)this.init.getInitId())) {
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)this.orgId, (String)"bos_org");
            throw new Exception(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u7ec4\u7ec7\u201c%1$s\u201d\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"ArapAbstractImport_20", (String)"fi-arapcommon", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue()));
        }
        Date startDate = this.init.getStartDate();
        this.cachedDate.put(this.orgId, startDate);
        this.baseCurrency = this.init.getStandardCurrency();
        JSONObject jsonBaseCurrency = new JSONObject();
        jsonBaseCurrency.put("number", this.baseCurrency.get("number"));
        this.data.put("basecurrency", jsonBaseCurrency);
    }

    protected void checkEntryF7(String entityName, String key, String title, JSONObject row, int seq, boolean required, String defaultValue) throws Exception {
        String number;
        JSONObject value = (JSONObject)row.get((Object)key);
        if (required && value == null && defaultValue == null) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\uff1a%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArapAbstractImport_11", (String)"fi-arapcommon", (Object[])new Object[0]), seq + 1, title));
        }
        if (defaultValue != null) {
            value = new JSONObject();
            value.put("number", (Object)defaultValue);
            row.put(key, (Object)value);
            return;
        }
        if (value != null && !this.checkExist(entityName, number = value.getString("number"), key)) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\uff1a%2$s\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ArapAbstractImport_21", (String)"fi-arapcommon", (Object[])new Object[0]), seq + 1, title));
        }
    }

    protected void checkEntryText(String key, String title, JSONObject row, int seq, boolean required, int length, String defaultValue) throws Exception {
        String value = (String)row.get((Object)key);
        if (required && value == null && defaultValue == null) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\uff1a%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArapAbstractImport_11", (String)"fi-arapcommon", (Object[])new Object[0]), seq + 1, title));
        }
        if (value == null && defaultValue != null) {
            row.put(key, (Object)defaultValue);
            return;
        }
        if (value != null && value.length() > length) {
            throw new Exception(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c%2$s\u5927\u4e8e\u6700\u5927\u957f\u5ea6%3$s\u3002", (String)"ArapAbstractImport_9", (String)"fi-arapcommon", (Object[])new Object[0]), seq + 1, title, length));
        }
    }
}

