/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ArapAmountPropHelper {
    public static void batchSetPrecision(DynamicObject[] bills) {
        if (ObjectUtils.isEmpty((Object[])bills)) {
            return;
        }
        String entityName = bills[0].getDynamicObjectType().getName();
        List billIds = Arrays.stream(bills).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection hasExistBills = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        HashSet<Long> hasExistBillIds = new HashSet<Long>(32);
        for (DynamicObject hasExistBill : hasExistBills) {
            hasExistBillIds.add(hasExistBill.getLong("id"));
        }
        for (DynamicObject bill2 : bills) {
            DynamicObject bascurrency;
            if (hasExistBillIds.contains(bill2.getLong("id"))) continue;
            HashMap<String, String[]> mapList = new HashMap(8);
            DynamicObject currency = bill2.getDynamicObject("currency");
            if (!ObjectUtils.isEmpty((Object)currency)) {
                mapList = ArapAmountPropHelper.getCurAmountStructure(entityName);
                int precision = currency.getInt("amtprecision");
                ArapAmountPropHelper.setPersion(mapList, precision, bill2);
            }
            if (ObjectUtils.isEmpty((Object)(bascurrency = bill2.getDynamicObject("basecurrency")))) continue;
            mapList = ArapAmountPropHelper.getBasAmountStructure(entityName);
            int precision = bascurrency.getInt("amtprecision");
            ArapAmountPropHelper.setPersion(mapList, precision, bill2);
        }
    }

    @Deprecated
    public static void setPrecision(DynamicObject entityObject) {
        DynamicObject bascurrency;
        DynamicObject BillCache = BusinessDataServiceHelper.loadSingleFromCache((Object)entityObject.getPkValue(), (String)entityObject.getDynamicObjectType().getName());
        if (!ObjectUtils.isEmpty((Object)BillCache)) {
            return;
        }
        HashMap<String, String[]> mapList = new HashMap();
        DynamicObject currency = entityObject.getDynamicObject("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            mapList = ArapAmountPropHelper.getCurAmountStructure(entityObject.getDataEntityType().getName());
            int precision = currency.getInt("amtprecision");
            ArapAmountPropHelper.setPersion(mapList, precision, entityObject);
        }
        if (!ObjectUtils.isEmpty((Object)(bascurrency = entityObject.getDynamicObject("basecurrency")))) {
            mapList = ArapAmountPropHelper.getBasAmountStructure(entityObject.getDataEntityType().getName());
            int precision = bascurrency.getInt("amtprecision");
            ArapAmountPropHelper.setPersion(mapList, precision, entityObject);
        }
    }

    private static Map<String, String[]> getBasAmountStructure(String entityKey) {
        HashMap<String, String[]> mapList = new HashMap<String, String[]>();
        switch (entityKey) {
            case "ap_finapbill": {
                mapList.put("head", new String[]{"pricetaxtotalbase", "amountbase", "unsettleamountbase"});
                mapList.put("detailentry", new String[]{"discountlocalamt", "e_pricetaxtotalbase", "settledamtbase", "unsettleamtbase"});
                mapList.put("planentity", new String[]{"planpricetaxloc", "unplansettlelocamt", "plansettledlocamt"});
                break;
            }
            case "ap_busbill": {
                mapList.put("head", new String[]{"pricetaxtotalbase", "localamt", "taxlocamt", "invoicedlocamt", "uninvoicedlocamt"});
                mapList.put("entry", new String[]{"e_taxlocalamt", "e_discountlocalamt", "e_localamt", "e_pricetaxtotalbase", "e_invoicedlocamt", "e_uninvoicedlocamt"});
                mapList.put("planentity", new String[]{"planpricetaxloc", "p_invoicedlocamt", "p_uninvoicedlocamt"});
                break;
            }
            case "ap_invoice": {
                mapList.put("head", new String[]{"amountbase", "pricetaxtotalbase"});
                mapList.put("entry", new String[]{"discountlocalamt", "e_pricetaxtotalbase", "e_amountbase"});
                break;
            }
            case "ar_finarbill": {
                mapList.put("head", new String[]{"reclocalamt", "localamt", "unsettlelocalamt"});
                mapList.put("entry", new String[]{"e_discountlocalamt", "e_reclocalamt", "e_settledlocalamt", "e_unsettlelocalamt"});
                mapList.put("planentity", new String[]{"planpricetaxloc", "unplansettlelocamt", "plansettledlocamt"});
                break;
            }
            case "ar_busbill": {
                mapList.put("head", new String[]{"localamt", "reclocalamt", "invoicedlocamt", "uninvoicedlocamt"});
                mapList.put("entry", new String[]{"e_reclocalamt", "e_localamt", "e_uninvoicedlocamt", "e_invoicedlocamt", "e_invoicedlocamt", "e_uninvoicedlocamt"});
                mapList.put("planentity", new String[]{"planpricetaxloc", "p_invoicedlocamt", "p_uninvoicedlocamt"});
            }
        }
        return mapList;
    }

    private static void setPersion(Map<String, String[]> mapList, int precision, DynamicObject entityObject) {
        for (Map.Entry<String, String[]> mapentry : mapList.entrySet()) {
            String key = mapentry.getKey();
            String[] fileds = mapList.get(key);
            if ("head".equals(key)) {
                for (int i = 0; i < fileds.length; ++i) {
                    entityObject.set(fileds[i], (Object)entityObject.getBigDecimal(fileds[i]).setScale(precision, RoundingMode.HALF_UP));
                }
                continue;
            }
            DynamicObjectCollection entryColl = entityObject.getDynamicObjectCollection(key);
            for (DynamicObject entry : entryColl) {
                for (int i = 0; i < fileds.length; ++i) {
                    entry.set(fileds[i], (Object)entry.getBigDecimal(fileds[i]).setScale(precision, RoundingMode.HALF_UP));
                }
            }
        }
    }

    private static Map<String, String[]> getCurAmountStructure(String entityKey) {
        HashMap<String, String[]> mapList = new HashMap<String, String[]>();
        switch (entityKey) {
            case "ap_finapbill": {
                mapList.put("head", new String[]{"pricetaxtotal", "unverifyamount", "unsettleamount", "amount", "tax"});
                mapList.put("detailentry", new String[]{"e_pricetaxtotal", "e_amount", "e_tax", "verifyamount", "e_unverifyamount", "lockedamt", "unlockamt", "settledamt", "unsettleamt"});
                mapList.put("planentity", new String[]{"planpricetax", "unplansettleamt", "plansettledamt", "unplanlockamt", "planlockedamt"});
                break;
            }
            case "ap_busbill": {
                mapList.put("head", new String[]{"pricetaxtotal", "amount", "uninvoicedamt", "invoicedamt", "tax"});
                mapList.put("entry", new String[]{"e_tax", "e_discountamount", "e_amount", "e_pricetaxtotal", "e_invoicedamt", "e_uninvoicedamt"});
                mapList.put("planentity", new String[]{"planpricetaxloc", "p_invoicedamt", "p_uninvoicedamt"});
                break;
            }
            case "ap_invoice": {
                mapList.put("head", new String[]{"pricetaxtotal", "amount", "tax"});
                mapList.put("entry", new String[]{"e_pricetaxtotal", "e_amount", "e_tax", "discountamt"});
                break;
            }
            case "ar_finarbill": {
                mapList.put("head", new String[]{"recamount", "amount", "localamt", "unverifyamount", "tax", "unsettleamount", "baddebtamt"});
                mapList.put("entry", new String[]{"e_amount", "e_tax", "e_discountamount", "e_recamount", "e_verifiedamt", "e_unverifyamt", "e_lockedamt", "e_unlockamt", "e_settledamt", "e_unsettleamt", "e_confirmedamt", "e_unconfirmamt"});
                mapList.put("planentity", new String[]{"planpricetax", "unplansettleamt", "plansettledamt", "unplanlockamt", "planlockedamt"});
                break;
            }
            case "ar_busbill": {
                mapList.put("head", new String[]{"recamount", "amount", "invoicedamt", "uninvoicedamt", "tax"});
                mapList.put("entry", new String[]{"e_tax", "e_discountamount", "e_amount", "e_recamount", "e_invoicedamt", "e_uninvoicedamt"});
                mapList.put("planentity", new String[]{"planpricetax", "p_invoicedamt", "p_uninvoicedamt"});
            }
        }
        return mapList;
    }
}

