/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.helper.DynamicListHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class AsstactHelper {
    public static void assacctShowF7(DynamicObject basedata, IFormView view, String pluginName) {
        if (ObjectUtils.isEmpty((Object)basedata)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f80\u6765\u6237\u3002", (String)"AsstactHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        String asstactType = basedata.getDataEntityType().getName();
        if ("bos_user".equals(asstactType)) {
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"er_payeer", (boolean)false, (int)2);
            ListFilterParameter lfp = new ListFilterParameter();
            lfp.setFilter(new QFilter("payer", "=", basedata.getPkValue()));
            lfp.setFilter(new QFilter("enable", "=", (Object)Boolean.TRUE));
            lsp.setListFilterParameter(lfp);
            CloseCallBack closeCallBack = new CloseCallBack(pluginName, "assaccount");
            lsp.setCloseCallBack(closeCallBack);
            view.showForm((FormShowParameter)lsp);
        } else if (!"bos_org".equals(asstactType)) {
            DynamicObjectCollection coll = DynamicListHelper.getBankCollInfo(basedata.getPkValue(), asstactType);
            if (coll == null || coll.isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"AsstactHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                return;
            }
            ListShowParameter lsp = null;
            lsp = "bd_supplier".equals(asstactType) ? DynamicListHelper.getSupplierBankInfoShowParameter(basedata.getPkValue()) : DynamicListHelper.getCustomerBankInfoShowParameter(basedata.getPkValue());
            CloseCallBack closeCallBack = new CloseCallBack(pluginName, "assaccount");
            lsp.setCloseCallBack(closeCallBack);
            BizExtendHelper.payeeBankInfoFilter(lsp.getListFilterParameter(), view);
            view.showForm((FormShowParameter)lsp);
        } else {
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bd_accountbanks", (boolean)false, (int)2);
            ListFilterParameter lfp = new ListFilterParameter();
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
            filterList.add(new QFilter("company", "=", basedata.getPkValue()));
            filterList.add(new QFilter("acctstatus", "=", (Object)"normal"));
            lfp.setQFilters(filterList);
            lsp.setListFilterParameter(lfp);
            CloseCallBack closeCallBack = new CloseCallBack(pluginName, "assaccount");
            lsp.setCloseCallBack(closeCallBack);
            view.showForm((FormShowParameter)lsp);
        }
    }

    public static void setAccountBankField(ExtendedDataEntity[] entities, String entryField, String asstacttypeField, String asstactField, String accountField, String bebankField) {
        HashMap<String, Set> asstactMap = new HashMap<String, Set>(2);
        String asstactIdField = asstactField + ".id";
        for (ExtendedDataEntity entity : entities) {
            DynamicObject bill = entity.getDataEntity();
            if (ObjectUtils.isEmpty((Object)entryField)) {
                if (!ObjectUtils.isEmpty((Object)bill.get(accountField)) && !ObjectUtils.isEmpty((Object)bill.get(bebankField))) continue;
                Set asstactIds = asstactMap.computeIfAbsent(bill.getString(asstacttypeField), v -> new HashSet(16));
                asstactIds.add(bill.getLong(asstactIdField));
                continue;
            }
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(entryField);
            for (DynamicObject entry : entries) {
                if (!ObjectUtils.isEmpty((Object)entry.get(accountField)) && !ObjectUtils.isEmpty((Object)entry.get(bebankField))) continue;
                Set asstactIds = asstactMap.computeIfAbsent(entry.getString(asstacttypeField), v -> new HashSet(16));
                asstactIds.add(entry.getLong(asstactIdField));
            }
        }
        if (ObjectUtils.isEmpty(asstactMap)) {
            return;
        }
        HashMap<Long, Map<String, Object>> accbebankMapByAsstactId = new HashMap<Long, Map<String, Object>>(16);
        for (Map.Entry asstactEntry : asstactMap.entrySet()) {
            switch ((String)asstactEntry.getKey()) {
                case "bos_user": {
                    accbebankMapByAsstactId.putAll(AsstactHelper.getErPayeerAccbebankMap((Set)asstactEntry.getValue()));
                    break;
                }
                case "bd_customer": 
                case "bd_supplier": {
                    accbebankMapByAsstactId.putAll(AsstactHelper.getCusOrSupAccbebankMap((String)asstactEntry.getKey(), (Set)asstactEntry.getValue()));
                }
            }
        }
        for (ExtendedDataEntity entity : entities) {
            DynamicObject bill = entity.getDataEntity();
            if (ObjectUtils.isEmpty((Object)entryField)) {
                Map accountBankInfo;
                if (!ObjectUtils.isEmpty((Object)bill.get(accountField)) && !ObjectUtils.isEmpty((Object)bill.get(bebankField)) || ObjectUtils.isEmpty((Object)(accountBankInfo = (Map)accbebankMapByAsstactId.get(bill.getLong(asstactIdField))))) continue;
                bill.set(accountField, accountBankInfo.get("accountStr"));
                bill.set(bebankField, accountBankInfo.get("bebank"));
                continue;
            }
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(entryField);
            for (DynamicObject entry : entries) {
                Map accountBankInfo;
                if (!ObjectUtils.isEmpty((Object)entry.get(accountField)) && !ObjectUtils.isEmpty((Object)entry.get(bebankField)) || ObjectUtils.isEmpty((Object)(accountBankInfo = (Map)accbebankMapByAsstactId.get(entry.getLong(asstactIdField))))) continue;
                entry.set(accountField, accountBankInfo.get("accountStr"));
                entry.set(bebankField, accountBankInfo.get("bebank"));
            }
        }
    }

    public static Map<Long, Map<String, Object>> getErPayeerAccbebankMap(Set<Long> userIds) {
        if (ObjectUtils.isEmpty(userIds)) {
            return new HashMap<Long, Map<String, Object>>(2);
        }
        HashMap<Long, Map<String, Object>> accbebankMapByUserId = new HashMap<Long, Map<String, Object>>(userIds.size());
        QFilter uFilter = new QFilter("payer", "in", userIds);
        uFilter = uFilter.and("status", "=", (Object)"C");
        uFilter = uFilter.and("enable", "=", (Object)Boolean.TRUE);
        Map payeerMap = BusinessDataServiceHelper.loadFromCache((String)"er_payeer", (String)"id,payer,payerbank,payeraccount,isdefault", (QFilter[])new QFilter[]{uFilter});
        for (DynamicObject payeer : payeerMap.values()) {
            Long userId = payeer.getLong("payer.id");
            HashMap<String, Object> map = (HashMap<String, Object>)accbebankMapByUserId.get(userId);
            if (!ObjectUtils.isEmpty((Object)map) && !payeer.getBoolean("isdefault")) continue;
            map = new HashMap<String, Object>(4);
            map.put("accountStr", payeer.getString("payeraccount"));
            map.put("bebank", payeer.getDynamicObject("payerbank"));
            map.put("bebankId", payeer.getLong("payerbank.id"));
            map.put("bebankName", payeer.getString("payerbank.name"));
            accbebankMapByUserId.put(userId, map);
        }
        return accbebankMapByUserId;
    }

    public static Map<Long, Map<String, Object>> getCusOrSupAccbebankMap(String asstactType, Set<Long> asstactIds) {
        if (ObjectUtils.isEmpty(asstactIds)) {
            return new HashMap<Long, Map<String, Object>>(2);
        }
        HashMap<Long, Map<String, Object>> accbebankMapByAsstactId = new HashMap<Long, Map<String, Object>>(asstactIds.size());
        Map asstactMap = BusinessDataServiceHelper.loadFromCache((String)asstactType, (String)"id,settlementtypeid,tx_register_no,bizpartner_address,bizpartner_phone,entry_bank.isdefault_bank,entry_bank.bankaccount,entry_bank.bank", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        for (DynamicObject asstact : asstactMap.values()) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            DynamicObjectCollection bankColls = asstact.getDynamicObjectCollection("entry_bank");
            for (DynamicObject bankInfo : bankColls) {
                if (!ObjectUtils.isEmpty(map) && !bankInfo.getBoolean("isdefault_bank")) continue;
                map.put("accountStr", bankInfo.getString("bankaccount"));
                map.put("bebank", bankInfo.getDynamicObject("bank"));
                map.put("bebankId", bankInfo.getLong("bank.id"));
                map.put("bebankName", bankInfo.getString("bank.name"));
            }
            map.put("settlementtypeid", asstact.getDynamicObject("settlementtypeid"));
            map.put("tx_register_no", asstact.getString("tx_register_no"));
            map.put("bizpartner_address", asstact.getLocaleString("bizpartner_address").getLocaleValue_zh_CN());
            map.put("bizpartner_phone", asstact.getString("bizpartner_phone"));
            accbebankMapByAsstactId.put(asstact.getLong("id"), map);
        }
        return accbebankMapByAsstactId;
    }

    public static void setAccountBankField(DynamicObject asstact, DynamicObject entity, String accountField, String bebankField) {
        if (entity.get(accountField) != null && entity.get(bebankField) != null) {
            return;
        }
        if (asstact != null) {
            Map<String, Object> accountBankInfo = AsstactHelper.getAccountBankInfo(asstact);
            entity.set(accountField, accountBankInfo.get("accountStr"));
            entity.set(bebankField, accountBankInfo.get("bebank"));
        }
    }

    private static Map<String, Object> getAccountBankInfo(DynamicObject asstact) {
        String accountStr = "";
        Long bebankId = 0L;
        DynamicObject bebank = null;
        String asstactType = asstact.getDataEntityType().getName();
        if ("bos_user".equals(asstactType)) {
            DynamicObject erPayeeInfo = AsstactHelper.getErPayeeInfo(asstact.getLong("id"));
            if (erPayeeInfo != null) {
                bebank = erPayeeInfo.getDynamicObject("payerbank");
                accountStr = erPayeeInfo.getString("payeraccount");
                bebankId = bebank.getLong("id");
            }
        } else if ("bd_customer".equals(asstactType) || "bd_supplier".equals(asstactType)) {
            asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)asstact.getPkValue(), (String)asstactType);
            DynamicObjectCollection bankInfoCollection = asstact.getDynamicObjectCollection("entry_bank");
            DynamicObject bankInfo = null;
            if (bankInfoCollection.size() > 0) {
                bankInfo = (DynamicObject)bankInfoCollection.get(0);
            }
            for (int i = 0; i < bankInfoCollection.size(); ++i) {
                DynamicObject bank = (DynamicObject)bankInfoCollection.get(i);
                if (!bank.getBoolean("isdefault_bank")) continue;
                bankInfo = bank;
                break;
            }
            if (bankInfo != null) {
                accountStr = bankInfo.getString("bankaccount");
                bebank = bankInfo.getDynamicObject("bank");
                if (!ObjectUtils.isEmpty((Object)bebank)) {
                    bebankId = bebank.getLong("id");
                }
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountStr", accountStr);
        map.put("bebankId", bebankId);
        map.put("bebank", bebank);
        return map;
    }

    public static Map<Object, Object> getaccbebankMap(DynamicObject asstact) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        String accountOb = null;
        Long bebankOb = null;
        DynamicObject settlementtypeId = null;
        if (asstact == null) {
            map.put("account", accountOb);
            map.put("bebank", bebankOb);
            map.put("settlementtype", settlementtypeId);
            return map;
        }
        String asstactType = asstact.getDataEntityType().getName();
        if ("bos_user".equals(asstactType)) {
            DynamicObject erPayeeInfo = AsstactHelper.getErPayeeInfo(asstact.getLong("id"));
            if (erPayeeInfo != null) {
                long bebank = erPayeeInfo.getDynamicObject("payerbank").getLong("id");
                accountOb = erPayeeInfo.getString("payeraccount");
                bebankOb = bebank;
                settlementtypeId = null;
            }
        } else if ("bd_customer".equals(asstactType) || "bd_supplier".equals(asstactType)) {
            asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)asstact.getPkValue(), (String)asstactType);
            DynamicObjectCollection bankColls = asstact.getDynamicObjectCollection("entry_bank");
            for (int i = 0; i < bankColls.size(); ++i) {
                DynamicObject bank;
                DynamicObject bankInfo = (DynamicObject)bankColls.get(i);
                if (bankInfo.getBoolean("isdefault_bank")) {
                    accountOb = bankInfo.getString("bankaccount");
                    bank = bankInfo.getDynamicObject("bank");
                    if (ObjectUtils.isEmpty((Object)bank)) break;
                    bebankOb = bank.getLong("id");
                    break;
                }
                if (i != 0) continue;
                accountOb = bankInfo.getString("bankaccount");
                bank = bankInfo.getDynamicObject("bank");
                if (ObjectUtils.isEmpty((Object)bank)) continue;
                bebankOb = bank.getLong("id");
            }
            settlementtypeId = asstact.getDynamicObject("settlementtypeid");
        } else {
            QFilter filter = new QFilter("company", "=", asstact.getPkValue());
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and(new QFilter("acctstatus", "=", (Object)"normal"));
            DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id,bank.id,bankaccountnumber,bank.bebank", (QFilter[])new QFilter[]{filter});
            if (!ObjectUtils.isEmpty((Object)account)) {
                accountOb = account.getString("bankaccountnumber");
                if (!ObjectUtils.isEmpty((Object)account.getDynamicObject("bank.bebank"))) {
                    bebankOb = (Long)account.getDynamicObject("bank.bebank").getPkValue();
                }
                settlementtypeId = null;
            }
        }
        map.put("account", accountOb);
        map.put("bebank", bebankOb);
        map.put("settlementtypeid", settlementtypeId);
        return map;
    }

    private static DynamicObject getErPayeeInfo(long userId) {
        DynamicObject defaultAccount = null;
        QFilter uFilter = new QFilter("payer", "=", (Object)userId);
        String selectFields = "id,payerbank,payeraccount";
        QFilter[] qFilters = new QFilter[]{uFilter = uFilter.and(new QFilter("status", "=", (Object)Character.valueOf('C'))).and(new QFilter("enable", "=", (Object)Boolean.TRUE))};
        Map defaultAccountMap = BusinessDataServiceHelper.loadFromCache((String)"er_payeer", (String)selectFields, (QFilter[])qFilters, (String)"isdefault desc");
        if (defaultAccountMap != null && defaultAccountMap.size() > 0) {
            defaultAccount = defaultAccountMap.values().toArray(new DynamicObject[0])[0];
        }
        return defaultAccount;
    }

    public static boolean isAsstactExistInternalBusinessUnit(String entityName, long asstactId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)asstactId)};
        DynamicObject entity = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)"id,number,internal_company", (QFilter[])filters);
        if (EmptyUtils.isEmpty(entity)) {
            return false;
        }
        DynamicObject businessUnit = entity.getDynamicObject("internal_company");
        return !EmptyUtils.isEmpty(businessUnit);
    }

    public static Map<Long, Boolean> isExistInternalBusinessUnit(String entityName, Long[] assIds) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(assIds.length);
        if (StringUtils.isEmpty(entityName) || EmptyUtils.isEmpty(assIds)) {
            return result;
        }
        Map assactMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,internal_company", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)assIds)});
        for (Map.Entry entrySet : assactMap.entrySet()) {
            DynamicObject asstact = (DynamicObject)entrySet.getValue();
            result.put(asstact.getLong("id"), EmptyUtils.isNotEmpty(asstact.getDynamicObject("internal_company")));
        }
        return result;
    }

    public static Map<Long, String> getAsstactNames(Map<String, Set<Object>> asstMap) {
        HashMap<Long, String> asstNameMap = new HashMap<Long, String>(2);
        try {
            for (Map.Entry<String, Set<Object>> entry : asstMap.entrySet()) {
                MainEntityType dt;
                String asstActType = entry.getKey();
                if ("other".equals(asstActType) || (dt = EntityMetadataCache.getDataEntityType((String)asstActType)) == null) continue;
                Map csMap = BusinessDataServiceHelper.loadFromCache((String)asstActType, (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
                for (Map.Entry cs : csMap.entrySet()) {
                    asstNameMap.put((Long)cs.getKey(), ((DynamicObject)cs.getValue()).getLocaleString("name").toString());
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return asstNameMap;
    }

    public static Map<Long, Boolean> isExistInternalBusinessUnit(DynamicObject[] bills) {
        Map<Long, Boolean> tempAssactMap;
        HashSet<Long> supplierIds = new HashSet<Long>(64);
        HashSet<Long> customerIds = new HashSet<Long>(64);
        for (DynamicObject adjust : bills) {
            String asstactType = adjust.getString("asstacttype");
            if ("bd_supplier".equals(asstactType)) {
                supplierIds.add(adjust.getLong("asstact.id"));
            }
            if (!"bd_customer".equals(asstactType)) continue;
            customerIds.add(adjust.getLong("asstact.id"));
        }
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(bills.length);
        if (EmptyUtils.isNotEmpty(supplierIds) && EmptyUtils.isNotEmpty(tempAssactMap = AsstactHelper.isExistInternalBusinessUnit("bd_supplier", supplierIds.toArray(new Long[0])))) {
            result.putAll(tempAssactMap);
        }
        if (EmptyUtils.isNotEmpty(customerIds) && EmptyUtils.isNotEmpty(tempAssactMap = AsstactHelper.isExistInternalBusinessUnit("bd_customer", customerIds.toArray(new Long[0])))) {
            result.putAll(tempAssactMap);
        }
        return result;
    }
}

