/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BillRelationBuilder;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.vo.BizBFRow;

public class BOTPHelper {
    private static final Log logger = LogFactory.getLog(BOTPHelper.class);

    public static boolean isPush(String entityNumber, Long billId) {
        return BFTrackerServiceHelper.isPush((String)entityNumber, (Long)billId);
    }

    public static boolean isPush(String entityNumber, String entryKey, Long entryId) {
        return BFTrackerServiceHelper.isPush((String)entityNumber, (String)entryKey, (Long)entryId);
    }

    public static boolean isPushedBy(DynamicObject bill, String ... possibleSources) {
        boolean ishasRation = false;
        String entity = bill.getDataEntityType().getName();
        Long pk = (Long)bill.getPkValue();
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)entity, (Long[])new Long[]{pk});
        for (String possibleSource : possibleSources) {
            HashSet sourcePks = (HashSet)sourceBills.get(possibleSource);
            boolean bl = ishasRation = sourcePks != null && !sourcePks.isEmpty();
            if (!ishasRation) continue;
            return true;
        }
        return ishasRation;
    }

    public static boolean isPushedBy(long pk, String entity, String ... possibleSources) {
        boolean ishasRation = false;
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)entity, (Long[])new Long[]{pk});
        for (String possibleSource : possibleSources) {
            HashSet sourcePks = (HashSet)sourceBills.get(possibleSource);
            boolean bl = ishasRation = sourcePks != null && !sourcePks.isEmpty();
            if (!ishasRation) continue;
            return true;
        }
        return ishasRation;
    }

    public static List<String> isPushedBy(DynamicObject bill, boolean isUp) {
        List<String> list = new ArrayList<String>();
        if (EmptyUtils.isEmpty(bill)) {
            return list;
        }
        String entity = bill.getDataEntityType().getName();
        Long pk = (Long)bill.getPkValue();
        Map sourceBills = null;
        sourceBills = isUp ? BFTrackerServiceHelper.findSourceBills((String)entity, (Long[])new Long[]{pk}) : BFTrackerServiceHelper.findTargetBills((String)entity, (Long[])new Long[]{pk});
        if (EmptyUtils.isNotEmpty(sourceBills)) {
            list = sourceBills.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
        }
        return list;
    }

    @Deprecated
    public static Map<String, HashSet<Long>> findTargetBills(String entityNumber, Long[] billIds) {
        return BFTrackerServiceHelper.findTargetBills((String)entityNumber, (Long[])billIds);
    }

    @Deprecated
    public static Map<String, HashSet<Long>> findTargetBills(String entityNumber, Long billId) {
        Long[] billIds = new Long[]{billId};
        return BOTPHelper.findTargetBills(entityNumber, billIds);
    }

    @Deprecated
    public static Set<Long> findTarBillIds(String entityNumber, Long billId, String tarEntityName) {
        Set<Long> set = new HashSet<Long>();
        Map<String, HashSet<Long>> sourMap = BOTPHelper.findTargetBills(entityNumber, billId);
        if (sourMap != null && sourMap.size() > 0 && sourMap.get(tarEntityName) != null) {
            set = sourMap.get(tarEntityName);
        }
        return set;
    }

    @Deprecated
    public static Map<Long, Set<Long>> findDirtTargetBillIds(String sourceEntityNumber, Long[] sourceBillIds, String targetEntityNumber, String targetEntityKey) {
        if (StringUtils.isEmpty((String)sourceEntityNumber) || ObjectUtils.isEmpty((Object[])sourceBillIds) || StringUtils.isEmpty((String)targetEntityNumber) || StringUtils.isEmpty((String)targetEntityKey)) {
            return new HashMap<Long, Set<Long>>(8);
        }
        Map directTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)sourceEntityNumber, (Long[])sourceBillIds);
        if (directTargetBills.isEmpty()) {
            return new HashMap<Long, Set<Long>>(8);
        }
        HashMap<Long, Set<Long>> directTargetBillIdMap = new HashMap<Long, Set<Long>>(sourceBillIds.length);
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(targetEntityNumber, targetEntityKey);
        Long targetBillTableId = mainTableDefine.getTableId();
        for (Long sourceBillId : sourceBillIds) {
            List BFInfo = (List)directTargetBills.get(sourceBillId);
            if (ObjectUtils.isEmpty((Object)BFInfo)) continue;
            Set targetBillIds = BFInfo.stream().filter(row -> targetBillTableId.equals(row.getId().getMainTableId())).map(row -> row.getId().getBillId()).collect(Collectors.toSet());
            directTargetBillIdMap.put(sourceBillId, targetBillIds);
        }
        return directTargetBillIdMap;
    }

    @Deprecated
    public static Map<String, HashSet<Long>> findSourceBills(String entityNumber, Long[] billIds) {
        return BFTrackerServiceHelper.findSourceBills((String)entityNumber, (Long[])billIds);
    }

    @Deprecated
    public static Map<String, HashSet<Long>> findSourceBills(String entityNumber, Long billId) {
        Long[] billIds = new Long[]{billId};
        return BOTPHelper.findSourceBills(entityNumber, billIds);
    }

    @Deprecated
    public static Set<Long> findSouBillIds(String entityNumber, Long billId, String sourEntityName) {
        Set<Long> set = new HashSet<Long>();
        Map<String, HashSet<Long>> sourMap = BOTPHelper.findSourceBills(entityNumber, billId);
        if (sourMap != null && sourMap.size() > 0 && sourMap.get(sourEntityName) != null) {
            set = sourMap.get(sourEntityName);
        }
        return set;
    }

    @Deprecated
    public static List<BFRow> loadSourceRowIds(String entityNumber, String entryKey, Long[] entryIds) {
        return BFTrackerServiceHelper.loadSourceRowIds((String)entityNumber, (String)entryKey, (Long[])entryIds);
    }

    @Deprecated
    public static Set<Long> loadSouEntryRowIds(String entityNumber, String entryKey, long entryId) {
        HashSet<Long> souEntryRowIds = new HashSet<Long>();
        List<BFRow> BFRowList = BOTPHelper.loadSourceRowIds(entityNumber, entryKey, new Long[]{entryId});
        for (BFRow row : BFRowList) {
            BFRowId id = row.getId();
            if (id.getEntryId() != entryId) continue;
            BFRowId souId = row.getSId();
            souEntryRowIds.add(souId.getEntryId());
        }
        return souEntryRowIds;
    }

    @Deprecated
    public static List<BFRow> loadTargetRowIds(String entityNumber, String entryKey, Long[] entryIds) {
        return BFTrackerServiceHelper.loadTargetRowIds((String)entityNumber, (String)entryKey, (Long[])entryIds);
    }

    @Deprecated
    public static Set<Long> loadTarEntryRowIds(String entityNumber, String entryKey, long entryId) {
        HashSet<Long> tarEntryRowIds = new HashSet<Long>();
        List<BFRow> BFRowList = BOTPHelper.loadTargetRowIds(entityNumber, entryKey, new Long[]{entryId});
        for (BFRow row : BFRowList) {
            BFRowId sId = row.getSId();
            if (sId.getEntryId() != entryId) continue;
            BFRowId tarId = row.getId();
            tarEntryRowIds.add(tarId.getEntryId());
        }
        return tarEntryRowIds;
    }

    public static List<DynamicObject> push(String sourceEntity, String targetEntity, List<Long> sourceBillPks) {
        return BOTPHelper.push(sourceEntity, targetEntity, null, sourceBillPks);
    }

    public static List<DynamicObject> push(String sourceEntity, String targetEntity, List<Long> sourceBillPks, String errorInfo) {
        return BOTPHelper.push(sourceEntity, targetEntity, null, sourceBillPks, errorInfo);
    }

    public static List<DynamicObject> push(String sourceEntity, String targetEntity, List<Long> sourceBillPks, boolean isHasRight, String appid) {
        return BOTPHelper.push(sourceEntity, targetEntity, null, sourceBillPks, isHasRight, appid);
    }

    public static List<DynamicObject> push(String sourceEntity, String targetEntity, String ruleId, List<Long> sourceBillPks) {
        ConvertOperationResult result = BOTPHelper.getConvertOperationResult(sourceEntity, targetEntity, ruleId, sourceBillPks);
        if (!result.isSuccess()) {
            throw new KDBizException(new ErrorCode("botp", result.getMessage()), new Object[]{result.getBillReports()});
        }
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        return result.loadTargetDataObjects(refDataProvider, mainType);
    }

    private static ConvertOperationResult getConvertOperationResult(String sourceEntity, String targetEntity, String ruleId, List<Long> sourceBillPks, boolean isHasRight, String appid) {
        logger.info("------BOTPHelper.push()------ ruleid = " + ruleId + ", srcEntity = " + sourceEntity + ", trgEntity = " + targetEntity);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(64);
        for (Long pk : sourceBillPks) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)pk);
            selectedRows.add(row);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(targetEntity);
        if (ruleId != null) {
            args.setRuleId(ruleId);
        }
        args.addCustomParam("bos_max_push_rows", ArApHelper.getMaxPushRows());
        args.setHasRight(isHasRight);
        if (appid != null) {
            args.setAppId(appid);
        }
        args.setSelectedRows(selectedRows);
        return ConvertServiceHelper.push((PushArgs)args);
    }

    public static List<DynamicObject> push(String sourceEntity, String targetEntity, String ruleId, List<Long> sourceBillPks, boolean isHasRight, String appid) {
        ConvertOperationResult result = BOTPHelper.getConvertOperationResult(sourceEntity, targetEntity, ruleId, sourceBillPks, isHasRight, appid);
        if (!result.isSuccess()) {
            throw new KDBizException(new ErrorCode("botp", result.getMessage()), new Object[]{result.getBillReports()});
        }
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        return result.loadTargetDataObjects(refDataProvider, mainType);
    }

    public static List<DynamicObject> push(String sourceEntity, String targetEntity, String ruleId, List<Long> sourceBillPks, String errorInfo) {
        ConvertOperationResult result = BOTPHelper.getConvertOperationResult(sourceEntity, targetEntity, ruleId, sourceBillPks);
        if (!result.isSuccess()) {
            throw new KDBizException(new ErrorCode("botp", errorInfo + " : " + result.getMessage()), new Object[]{result.getBillReports()});
        }
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        return result.loadTargetDataObjects(refDataProvider, mainType);
    }

    @Deprecated
    public static Map<String, Object> push4Result(String sourceEntity, String targetEntity, String ruleId, Map<Long, List<Long>> srcMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ConvertOperationResult result = BOTPHelper.getConvertOperationResult(sourceEntity, targetEntity, ruleId, srcMap);
        boolean fail = false;
        for (SourceBillReport billReport : result.getBillReports()) {
            if (billReport.isSuccess()) continue;
            fail = true;
            break;
        }
        if (!result.isSuccess() || fail) {
            map.put("convertResult", result);
        }
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        map.put("trgBills", result.loadTargetDataObjects(refDataProvider, mainType));
        return map;
    }

    @Deprecated
    private static ConvertOperationResult getConvertOperationResult(String sourceEntity, String targetEntity, String ruleId, Map<Long, List<Long>> srcMap) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(64);
        for (Map.Entry<Long, List<Long>> mEntry : srcMap.entrySet()) {
            ListSelectedRow row = new ListSelectedRow();
            Long pk = mEntry.getKey();
            row.setPrimaryKeyValue((Object)pk);
            List<Long> lst = mEntry.getValue();
            for (Long entryPk : lst) {
                row.setEntryPrimaryKeyValue((Object)entryPk);
            }
            selectedRows.add(row);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(targetEntity);
        if (ruleId != null) {
            args.setRuleId(ruleId);
        }
        args.setHasRight(true);
        args.setSelectedRows(selectedRows);
        args.addCustomParam("bos_max_push_rows", ArApHelper.getMaxPushRows());
        return ConvertServiceHelper.push((PushArgs)args);
    }

    public static Map<String, Object> push4Result(String sourceEntity, String targetEntity, String ruleId, List<Long> sourceBillPks) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ConvertOperationResult result = BOTPHelper.getConvertOperationResult(sourceEntity, targetEntity, ruleId, sourceBillPks);
        boolean fail = false;
        for (SourceBillReport billReport : result.getBillReports()) {
            if (billReport.isSuccess()) continue;
            fail = true;
            break;
        }
        if (!result.isSuccess() || fail) {
            map.put("convertResult", result);
        }
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        map.put("trgBills", result.loadTargetDataObjects(refDataProvider, mainType));
        return map;
    }

    public static Map<String, Object> push4Result(String sourceEntity, String targetEntity, String ruleId, List<Long> sourceBillPks, Map<String, String> paramMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ConvertOperationResult result = BOTPHelper.getConvertOperationResult(sourceEntity, targetEntity, ruleId, sourceBillPks, paramMap);
        boolean fail = false;
        for (SourceBillReport billReport : result.getBillReports()) {
            if (billReport.isSuccess()) continue;
            fail = true;
            break;
        }
        if (!result.isSuccess() || fail) {
            map.put("convertResult", result);
        }
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        map.put("trgBills", result.loadTargetDataObjects(refDataProvider, mainType));
        return map;
    }

    public static String getConvertReport(ConvertOperationResult result) {
        StringBuilder sb = new StringBuilder();
        for (SourceBillReport billReport : result.getBillReports()) {
            int row = 0;
            ++row;
            if (billReport.isSuccess()) continue;
            if (row != result.getBillReports().size()) {
                sb.append(billReport).append("; ");
                continue;
            }
            sb.append(billReport);
        }
        return sb.toString();
    }

    private static ConvertOperationResult getConvertOperationResult(String sourceEntity, String targetEntity, String ruleId, List<Long> sourceBillPks) {
        logger.info("------BOTPHelper.push()------ ruleid = " + ruleId + ", srcEntity = " + sourceEntity + ", trgEntity = " + targetEntity);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(64);
        for (Long pk : sourceBillPks) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)pk);
            selectedRows.add(row);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(targetEntity);
        if (ruleId != null) {
            args.setRuleId(ruleId);
        }
        args.addCustomParam("bos_max_push_rows", ArApHelper.getMaxPushRows());
        args.setHasRight(true);
        args.setSelectedRows(selectedRows);
        return ConvertServiceHelper.push((PushArgs)args);
    }

    private static ConvertOperationResult getConvertOperationResult(String sourceEntity, String targetEntity, String ruleId, List<Long> sourceBillPks, Map<String, String> paramMap) {
        logger.info("------BOTPHelper.push()------ ruleid = " + ruleId + ", srcEntity = " + sourceEntity + ", trgEntity = " + targetEntity);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(64);
        for (Long pk : sourceBillPks) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)pk);
            selectedRows.add(row);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(targetEntity);
        if (ruleId != null) {
            args.setRuleId(ruleId);
        }
        args.setHasRight(true);
        args.setSelectedRows(selectedRows);
        if (!paramMap.isEmpty()) {
            Set<Map.Entry<String, String>> entries = paramMap.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                args.addCustomParam(entry.getKey(), entry.getValue());
            }
        }
        args.addCustomParam("bos_max_push_rows", ArApHelper.getMaxPushRows());
        return ConvertServiceHelper.push((PushArgs)args);
    }

    public static DynamicObject[] push(String sourceEntity, String targetEntity, String ruleId, DynamicObject info) {
        return BOTPHelper.push(sourceEntity, targetEntity, ruleId, info, true);
    }

    public static DynamicObject[] push(String sourceEntity, String targetEntity, String ruleId, DynamicObject info, String errorInfo) {
        return BOTPHelper.push(sourceEntity, targetEntity, ruleId, info, true, errorInfo);
    }

    public static DynamicObject[] push(String sourceEntity, String targetEntity, String ruleId, DynamicObject info, boolean autoGenBillno) {
        List<DynamicObject> dynamicresults = BOTPHelper.push(sourceEntity, targetEntity, ruleId, Collections.singletonList(info.getLong("id")));
        DynamicObject[] dataEntities = new DynamicObject[dynamicresults.size()];
        for (int i = 0; i < dynamicresults.size(); ++i) {
            DynamicObject destBill;
            dataEntities[i] = destBill = dynamicresults.get(i);
            if (!autoGenBillno) continue;
            String billno = CodeRuleServiceHelper.getNumber((String)targetEntity, (DynamicObject)destBill, (String)destBill.getDynamicObject("org").getPkValue().toString());
            if (StringUtils.isEmpty((String)billno)) {
                ErrorCode ec = new ErrorCode("billNo", ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u6ca1\u6709\u7f16\u7801\u89c4\u5219\uff0c\u5355\u636e\u65e0\u6cd5\u751f\u6210\u3002", (String)"BOTPHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                throw new KDBizException(ec, new Object[0]);
            }
            dataEntities[i].set("billno", (Object)billno);
        }
        return dataEntities;
    }

    public static DynamicObject[] push(String sourceEntity, String targetEntity, String ruleId, DynamicObject info, boolean autoGenBillno, String errorInfo) {
        List<DynamicObject> dynamicresults = BOTPHelper.push(sourceEntity, targetEntity, ruleId, Collections.singletonList(info.getLong("id")), errorInfo);
        DynamicObject[] dataEntities = new DynamicObject[dynamicresults.size()];
        for (int i = 0; i < dynamicresults.size(); ++i) {
            DynamicObject destBill;
            dataEntities[i] = destBill = dynamicresults.get(i);
            if (!autoGenBillno) continue;
            String billno = CodeRuleServiceHelper.getNumber((String)targetEntity, (DynamicObject)destBill, (String)destBill.getDynamicObject("org").getPkValue().toString());
            if (StringUtils.isEmpty((String)billno)) {
                ErrorCode ec = new ErrorCode("billNo", ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u6ca1\u6709\u7f16\u7801\u89c4\u5219\uff0c\u5355\u636e\u65e0\u6cd5\u751f\u6210\u3002", (String)"BOTPHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                throw new KDBizException(ec, new Object[0]);
            }
            dataEntities[i].set("billno", (Object)billno);
        }
        return dataEntities;
    }

    public static DynamicObject[] push(String sourceEntity, String targetEntity, DynamicObject info) {
        String ruleId = BOTPHelper.getBotpRuled(sourceEntity, targetEntity);
        return BOTPHelper.push(sourceEntity, targetEntity, ruleId, info);
    }

    public static DynamicObject[] push(String sourceEntity, String targetEntity, DynamicObject info, String errorInfo) {
        String ruleId = BOTPHelper.getBotpRuled(sourceEntity, targetEntity);
        return BOTPHelper.push(sourceEntity, targetEntity, ruleId, info, errorInfo);
    }

    private static String getBotpRuled(String sourceEntity, String targetEntity) {
        QFilter[] filter = new QFilter[]{new QFilter("sourceentitynumber", "=", (Object)sourceEntity), new QFilter("targetentitynumber", "=", (Object)targetEntity), new QFilter("enabled", "=", (Object)Character.valueOf('1'))};
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"botp_crlist", (String)"id,defrule", (QFilter[])filter);
        if (rules.length < 1) {
            ErrorCode ec = new ErrorCode("getBotp", ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"BOTPHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        if (rules.length > 1) {
            for (DynamicObject rule : rules) {
                if (!rule.getBoolean("defrule")) continue;
                return rule.getString("id");
            }
        }
        return rules[0].getString("id");
    }

    public static void saveApRation4Unite(DynamicObject destInfo, String srcEntityKey, List<Long> srcIdList) {
        String targetBillType = destInfo.getDataEntityType().getName();
        BillRelationBuilder billRelationBuilder = new BillRelationBuilder(srcEntityKey, targetBillType);
        billRelationBuilder.saveRelation(srcIdList, destInfo.getLong("id"));
    }

    @Deprecated
    public static void deleteRation(Object Pk, String ... entityKeys) {
        List<Map<String, Object>> target = BOTPHelper.gettargetBill((Long)Pk);
        List<BizBFRow> list = BOTPHelper.getSoubill((Long)Pk, "getSoub");
        ArrayList source = new ArrayList(64);
        HashMap<String, Object> temp = null;
        for (int i = 0; i < list.size(); ++i) {
            temp = new HashMap<String, Object>();
            temp.put("id", list.get(i).getTbillId());
            temp.put("entity", BOTPHelper.getEntiKeyById(list.get(i).gettTableId()));
            temp.put("sourceEntity", BOTPHelper.getEntiKeyById(list.get(i).getsTableId()));
            temp.put("sourceBillId", list.get(i).getsBillid());
            source.add(temp);
        }
        ArrayList<Map<String, Object>> relations = new ArrayList<Map<String, Object>>();
        if (target != null) {
            relations.addAll(target);
        }
        if (source != null) {
            relations.addAll(source);
        }
        if (entityKeys.length == 0) {
            for (int j = 0; j < relations.size(); ++j) {
                BOTPHelper.deleteRation_NewMethod((Map)relations.get(j));
            }
        } else {
            for (int i = 0; i < entityKeys.length; ++i) {
                for (int j = 0; j < relations.size(); ++j) {
                    String entityKey = (String)((Map)relations.get(j)).get("entity");
                    String sourceEntityKey = (String)((Map)relations.get(j)).get("sourceEntity");
                    if (!entityKey.equals(entityKeys[i]) && !sourceEntityKey.equals(entityKeys[i])) continue;
                    BOTPHelper.deleteRation_NewMethod((Map)relations.get(j));
                }
            }
        }
    }

    public static List<Map<String, Object>> gettargetBill(Long id) {
        List<BizBFRow> list = BOTPHelper.getSoubill(id, "getTag");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(64);
        HashMap<String, Object> temp = null;
        for (int i = 0; i < list.size(); ++i) {
            temp = new HashMap<String, Object>();
            temp.put("id", list.get(i).getTbillId());
            temp.put("entity", BOTPHelper.getEntiKeyById(list.get(i).gettTableId()));
            temp.put("sourceEntity", BOTPHelper.getEntiKeyById(list.get(i).getsTableId()));
            temp.put("sourceBillId", list.get(i).getsBillid());
            result.add(temp);
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }

    private static List<BizBFRow> getSoubill(Long id, String operste) {
        String sql = null;
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        if ("getSoub".equals(operste)) {
            sql = "select FID,FSTABLEID,FSBILLID,FTTABLEID,FTBILLID from T_BOTP_BillTracker  WHERE FTBILLID= ?";
            params.add(new SqlParameter(":FTBILLID", -5, (Object)id));
        } else {
            sql = "select FID,FSTABLEID,FSBILLID,FTTABLEID,FTBILLID from T_BOTP_BillTracker  WHERE FSBILLID= ?";
            params.add(new SqlParameter(":FSBILLID", -5, (Object)id));
        }
        ResultSetHandler<List<BizBFRow>> action = new ResultSetHandler<List<BizBFRow>>(){

            public List<BizBFRow> handle(ResultSet rs) throws Exception {
                ArrayList<BizBFRow> rowIds = new ArrayList<BizBFRow>(64);
                while (rs.next()) {
                    Long id = rs.getLong("FID");
                    Long sTableId = rs.getLong("FSTABLEID");
                    Long sBillId = rs.getLong("FSBILLID");
                    Long tTableId = rs.getLong("FTTABLEID");
                    Long tBillId = rs.getLong("FTBILLID");
                    BizBFRow rowId = new BizBFRow(id, sBillId, sTableId, tTableId, tBillId);
                    rowIds.add(rowId);
                }
                return rowIds;
            }
        };
        List rowIds = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)action);
        return rowIds;
    }

    @Deprecated
    private static void deleteRation_NewMethod(Map<String, Object> map) {
        String entityKey = (String)map.get("entity");
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)entityKey);
        String tc = linkSet.getTrackerTable();
        String lk = null;
        List items = linkSet.getItems();
        if (items == null || items.size() <= 0) {
            throw new KDException(new ErrorCode("APBOTPERROR", ResManager.loadKDString((String)"\u6ca1\u6709\u5b9a\u4e49\u201clk\u8868\u201d\uff0c\u8bf7\u5728\u8bbe\u8ba1\u9875\u9762\u914d\u7f6e\u3002", (String)"BOTPHelper_2", (String)"fi-arapcommon", (Object[])new Object[0])), new Object[0]);
        }
        lk = ((LinkSetItemElement)items.get(0)).getTableName();
        BOTPHelper.deleteArRation(map, tc, lk);
        try (TXHandle h = TX.requiresNew();){
            BOTPHelper.deleteRation(map);
        }
    }

    public static Map<String, String> getRationTable(String entityKey) {
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)entityKey);
        String tc = linkSet.getTrackerTable();
        String lk = null;
        List items = linkSet.getItems();
        if (items == null || items.size() <= 0) {
            throw new KDException(new ErrorCode("APBOTPERROR", ResManager.loadKDString((String)"\u6ca1\u6709\u5b9a\u4e49\u201clk\u8868\u201d\uff0c\u8bf7\u5728\u8bbe\u8ba1\u9875\u9762\u914d\u7f6e\u3002", (String)"BOTPHelper_2", (String)"fi-arapcommon", (Object[])new Object[0])), new Object[0]);
        }
        lk = ((LinkSetItemElement)items.get(0)).getTableName();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tc", tc);
        map.put("lk", lk);
        return map;
    }

    @Deprecated
    public static void deleteRation(List<Map<String, Object>> relations, String tc, String lk) {
        for (Map<String, Object> map : relations) {
            BOTPHelper.deleteArRation(map, tc, lk);
            TXHandle h = TX.requiresNew();
            Throwable throwable = null;
            try {
                BOTPHelper.deleteRation(map);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
    }

    @Deprecated
    public static void deleteArRation(Map<String, Object> map, String tc, String lk) {
        Long FSBillId = (Long)map.get("sourceBillId");
        Long FTBILLID = (Long)map.get("id");
        ArrayList<SqlParameter> params_tc = new ArrayList<SqlParameter>();
        String sBuilder_tc = "delete from  " + tc + " where FSBillId= ? and FTBillId= ?";
        params_tc.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
        params_tc.add(new SqlParameter(":FTBillId", -5, (Object)FTBILLID));
        DB.execute((DBRoute)DBRouteConst.CAS, (String)sBuilder_tc, (Object[])params_tc.toArray(new SqlParameter[params_tc.size()]));
        ArrayList<SqlParameter> params_lk = new ArrayList<SqlParameter>();
        String sBuilder_lk = "delete from  " + lk + " where FSBillId= ? and FId= ?";
        params_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
        params_lk.add(new SqlParameter(":FId", -5, (Object)FTBILLID));
        DB.execute((DBRoute)DBRouteConst.CAS, (String)sBuilder_lk, (Object[])params_lk.toArray(new SqlParameter[params_lk.size()]));
    }

    @Deprecated
    public static Long getTableIdByEntityKey(String entityKey) {
        String querySql = String.format("SELECT FId,FEntityKey,FTableId FROM T_META_EntityInfo WHERE FEntityKey = %s", entityKey);
        TableDefine tableDefine = (TableDefine)DB.query((DBRoute)DBRoute.meta, (String)querySql, (ResultSetHandler)new ResultSetHandler<TableDefine>(){

            public TableDefine handle(ResultSet rs) throws Exception {
                TableDefine tableDefine = null;
                if (rs.next()) {
                    tableDefine = new TableDefine();
                    tableDefine.setEntityNumber(rs.getString("FId"));
                    tableDefine.setEntityKey(rs.getString("FEntityKey"));
                    tableDefine.setTableId(Long.valueOf(rs.getLong("FTableId")));
                }
                return tableDefine;
            }
        });
        return tableDefine.getTableId();
    }

    @Deprecated
    public static void deleteRation(Map<String, Object> map) {
        Long FSBillId = (Long)map.get("sourceBillId");
        Long FTBILLID = (Long)map.get("id");
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        String sBuilder = "delete from T_BOTP_BillTracker where FSBillId= ? and FTBillId= ?";
        params.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
        params.add(new SqlParameter(":FTBillId", -5, (Object)FTBILLID));
        DB.execute((DBRoute)DBRoute.basedata, (String)sBuilder, (Object[])params.toArray(new SqlParameter[params.size()]));
    }

    public static String getEntiKeyById(final Long tableId) {
        Object[] parameters = new SqlParameter[1];
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId, FEntityKey, FTableId ");
        sBuilder.append("FROM T_META_EntityInfo ");
        sBuilder.append("WHERE FTableId = ? ");
        parameters[0] = new SqlParameter(":FTableId", -5, (Object)tableId);
        ResultSetHandler<TableDefine> action = new ResultSetHandler<TableDefine>(){

            public TableDefine handle(ResultSet rs) throws Exception {
                TableDefine tableDefine = null;
                if (rs.next()) {
                    tableDefine = new TableDefine();
                    tableDefine.setEntityNumber(rs.getString("FId"));
                    tableDefine.setEntityKey(rs.getString("FEntityKey"));
                    tableDefine.setTableId(tableId);
                }
                return tableDefine;
            }
        };
        TableDefine tableDefine = (TableDefine)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])parameters, (ResultSetHandler)action);
        return tableDefine.getEntityNumber();
    }

    @Deprecated
    public static Map<Long, Long> getSourceEntryIdsMap(String entityName, String entryKey, Long[] entryIds, long targetBillId) {
        List bfRows = BFTrackerServiceHelper.loadLinkUpNodes((String)entityName, (String)entryKey, (Long[])entryIds);
        HashMap<Long, Long> entryIdMap = new HashMap<Long, Long>(16);
        for (BFRowLinkUpNode bfRowLinkUpNode : bfRows) {
            BFRowLinkUpNode targetNode = BOTPHelper.getTargetNode(bfRowLinkUpNode, targetBillId);
            if (targetNode == null) continue;
            entryIdMap.put(bfRowLinkUpNode.getRowId().getEntryId(), targetNode.getRowId().getEntryId());
        }
        return entryIdMap;
    }

    private static BFRowLinkUpNode getTargetNode(BFRowLinkUpNode currentNode, long targetBillId) {
        long currentNodeBillId = currentNode.getRowId().getBillId();
        if (targetBillId == currentNodeBillId) {
            return currentNode;
        }
        Map map = currentNode.getSNodes();
        Set values = map.entrySet();
        for (Map.Entry row : values) {
            BFRowLinkUpNode subNode = BOTPHelper.getTargetNode((BFRowLinkUpNode)row.getValue(), targetBillId);
            if (subNode == null) continue;
            return subNode;
        }
        return null;
    }

    @Deprecated
    public static Map<Long, List<Long>> loadNearUpBillIds(String entityNumber, String upEntityNumber, Long[] ids) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(ids.length);
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)upEntityNumber, (String)upEntityNumber);
        Long upTableId = tableDefine.getTableId();
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)entityNumber, (String)"", (Long[])ids);
        if (bfRowLinkUpNodes == null || bfRowLinkUpNodes.size() < 1) {
            return resultMap;
        }
        for (Long id : ids) {
            List nodes = bfRowLinkUpNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getBillId().compareTo(id) == 0).collect(Collectors.toList());
            ArrayList srcPks = new ArrayList(10);
            for (BFRowLinkUpNode node : nodes) {
                List<BFRowLinkUpNode> sourceNodes = BOTPHelper.findSourceNodes(node, upTableId, id);
                List pkList = sourceNodes.stream().map(srcNode -> srcNode.getRowId().getBillId()).collect(Collectors.toList());
                srcPks.addAll(pkList);
            }
            if (srcPks.isEmpty()) continue;
            resultMap.put(id, srcPks);
        }
        return resultMap;
    }

    private static List<BFRowLinkUpNode> findSourceNodes(BFRowLinkUpNode node, Long sMainTableId, Long id) {
        ArrayList<BFRowLinkUpNode> nodes = new ArrayList<BFRowLinkUpNode>(10);
        if (node.getRowId().getMainTableId().compareTo(sMainTableId) == 0 && node.getRowId().getBillId().compareTo(id) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                nodes.addAll(BOTPHelper.findSourceNodes(sNode, sMainTableId, id));
            }
        }
        return nodes;
    }

    @Deprecated
    public static Set<Long> loadNearUpBillIdSet(String entityNumber, String upEntityNumber, Long[] ids) {
        HashSet<Long> souIdSet = new HashSet<Long>(8);
        Map<Long, List<Long>> result = BOTPHelper.loadNearUpBillIds(entityNumber, upEntityNumber, ids);
        if (!result.isEmpty()) {
            for (Map.Entry<Long, List<Long>> entry : result.entrySet()) {
                List<Long> souIds = entry.getValue();
                souIdSet.addAll(souIds);
            }
        }
        return souIdSet;
    }

    @Deprecated
    public static List<Long> loadNearUpBillIds(String entityNumber, String upEntityNumber, Long id) {
        Long[] ids = new Long[]{id};
        Map<Long, List<Long>> longListMap = BOTPHelper.loadNearUpBillIds(entityNumber, upEntityNumber, ids);
        return longListMap.get(id);
    }

    @Deprecated
    public static List<BFRow> loadNearUpBillBFRows(String entityNumber, String upEntityNumber, Long id) {
        List<BFRow> bfRows = BOTPHelper.loadSourceRowIds(entityNumber, "", new Long[]{id});
        List<BFRow> filterBFRows = BOTPHelper.loadNearUpBillIds(bfRows, upEntityNumber, id, new ArrayList<BFRow>(10));
        return filterBFRows;
    }

    @Deprecated
    private static List<BFRow> loadNearUpBillIds(List<BFRow> bfRows, String upEntityNumber, Long id, List<BFRow> upRows) {
        ArrayList<BFRow> tmpBFRows = new ArrayList<BFRow>(bfRows.size());
        for (BFRow bfRow : bfRows) {
            if (!bfRow.getId().getBillId().equals(id)) continue;
            tmpBFRows.add(bfRow);
        }
        if (tmpBFRows.size() < 1) {
            return tmpBFRows;
        }
        for (BFRow tmpBFRow : tmpBFRows) {
            TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)tmpBFRow.getSId().getTableId());
            if (!tableDefine.getEntityNumber().equals(upEntityNumber)) {
                BOTPHelper.loadNearUpBillIds(bfRows, upEntityNumber, tmpBFRow.getSId().getBillId(), upRows);
                continue;
            }
            upRows.add(tmpBFRow);
        }
        return upRows;
    }

    @Deprecated
    public static Map<String, Set<Long>> loadNearUpBillsIdMap(String entityNumber, String[] upEntityNumbers, Long[] ids) {
        HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>(8);
        if (ObjectUtils.isEmpty((Object)entityNumber) || ObjectUtils.isEmpty((Object[])upEntityNumbers) || ObjectUtils.isEmpty((Object[])ids)) {
            return resultMap;
        }
        List<BFRow> bfRows = BOTPHelper.loadSourceRowIds(entityNumber, "", ids);
        if (bfRows == null || bfRows.size() < 1) {
            return resultMap;
        }
        for (String upEntityNumber : upEntityNumbers) {
            HashSet souIdset = new HashSet(8);
            for (Long id : ids) {
                List resultIds;
                List bfRowIds;
                List<BFRow> filterBFRows = BOTPHelper.loadNearUpBillIds(bfRows, upEntityNumber, id, new ArrayList<BFRow>(10));
                if (filterBFRows == null || filterBFRows.size() < 1 || (bfRowIds = filterBFRows.stream().filter(bfrow -> bfrow.getSId() != null).map(BFRow::getSId).collect(Collectors.toList())) == null || bfRowIds.size() < 1 || (resultIds = bfRowIds.stream().filter(bfrow -> bfrow.getBillId() != null).map(BFRowId::getBillId).collect(Collectors.toList())) == null || resultIds.size() < 1) continue;
                souIdset.addAll(resultIds);
            }
            if (souIdset.isEmpty()) continue;
            resultMap.put(upEntityNumber, souIdset);
        }
        return resultMap;
    }

    @Deprecated
    public static Map<Long, List<Long>> loadTargetBillIds(String sourceEntity, String targetEntity, List<Long> sourceIds) {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(16);
        for (Long sourceId : sourceIds) {
            Map sourceBillResult = BFTrackerServiceHelper.findTargetBills((String)sourceEntity, (Long[])new Long[]{sourceId});
            if (EmptyUtils.isEmpty(sourceBillResult.get(targetEntity))) continue;
            HashSet billIds = (HashSet)sourceBillResult.get(targetEntity);
            result.put(sourceId, new ArrayList(billIds));
        }
        return result;
    }

    @Deprecated
    public static Map<Long, Set<Long>> loadDirtTargetBillIds(String sourceEntity, String targetEntity, List<Long> sourceIds) {
        Map<Long, Map<String, Set<Long>>> dirtTargetBillMap = BOTPHelper.findDirtTargetBillMap(sourceEntity, sourceIds.toArray(new Long[0]));
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry<Long, Map<String, Set<Long>>> entry : dirtTargetBillMap.entrySet()) {
            Map<String, Set<Long>> value = entry.getValue();
            Set<Long> subValue = value.get(targetEntity);
            if (!EmptyUtils.isNotEmpty(subValue)) continue;
            result.put(entry.getKey(), subValue);
        }
        return result;
    }

    @Deprecated
    public static Map<Long, Map<String, Set<Long>>> findDirtTargetBillMap(String sourceEntityNumber, Long[] sourceBillIds) {
        HashMap<Long, Map<String, Set<Long>>> result = new HashMap<Long, Map<String, Set<Long>>>(8);
        if (StringUtils.isEmpty((String)sourceEntityNumber) || ObjectUtils.isEmpty((Object[])sourceBillIds)) {
            return result;
        }
        Map directTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)sourceEntityNumber, (Long[])sourceBillIds);
        if (directTargetBills.isEmpty()) {
            return result;
        }
        HashMap<Long, TableDefine> tableDefineMap = new HashMap<Long, TableDefine>(8);
        for (Long sourceBillId : sourceBillIds) {
            HashMap<String, HashSet<Long>> tarBillMap = new HashMap<String, HashSet<Long>>(8);
            List BFRowList = (List)directTargetBills.get(sourceBillId);
            if (BFRowList != null) {
                for (BFRow row : BFRowList) {
                    BFRowId bfRowId = row.getId();
                    Long mainTableId = bfRowId.getMainTableId();
                    TableDefine tableDefine = (TableDefine)tableDefineMap.get(mainTableId);
                    if (tableDefine == null) {
                        tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)mainTableId);
                        tableDefineMap.put(mainTableId, tableDefine);
                    }
                    Long billId = bfRowId.getBillId();
                    String tarBillEntity = tableDefine.getEntityNumber();
                    HashSet<Long> tarBillIds = (HashSet<Long>)tarBillMap.get(tarBillEntity);
                    if (tarBillIds != null) {
                        tarBillIds.add(billId);
                    } else {
                        tarBillIds = new HashSet<Long>(8);
                        tarBillIds.add(billId);
                    }
                    tarBillMap.put(tarBillEntity, tarBillIds);
                }
            }
            if (tarBillMap.isEmpty()) continue;
            result.put(sourceBillId, tarBillMap);
        }
        return result;
    }

    @Deprecated
    public static Map<Long, Map<String, Set<Long>>> loadAllTargetRowIdsMap(String sourceEntityName, String sourceEntryName, Long[] sourceEntryIds) {
        HashMap<Long, Map<String, Set<Long>>> result = new HashMap<Long, Map<String, Set<Long>>>(16);
        List bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)sourceEntityName, (String)sourceEntryName, (Long[])sourceEntryIds);
        if (bfRowLinkDownNodes == null || bfRowLinkDownNodes.size() < 1) {
            return result;
        }
        for (Long entryId : sourceEntryIds) {
            List nodes = bfRowLinkDownNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getEntryId().compareTo(entryId) == 0).collect(Collectors.toList());
            for (BFRowLinkDownNode node : nodes) {
                HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>();
                BOTPHelper.findTargetNodesByEntry(node, entryId, resultMap);
                result.put(entryId, resultMap);
            }
        }
        return result;
    }

    private static void findTargetNodesByEntry(BFRowLinkDownNode node, Long entryId, Map<String, Set<Long>> resultMap) {
        if (node.getRowId().getEntryId().compareTo(entryId) != 0) {
            TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)node.getRowId().getMainTableId());
            String targetEntityName = tableDefine.getEntityNumber();
            Set<Long> exitsSet = resultMap.get(targetEntityName);
            if (exitsSet == null) {
                exitsSet = new HashSet<Long>();
                resultMap.put(targetEntityName, exitsSet);
            }
            exitsSet.add(node.getRowId().getEntryId());
        }
        for (BFRowLinkDownNode tNode : node.getTNodes().values()) {
            BOTPHelper.findTargetNodesByEntry(tNode, entryId, resultMap);
        }
    }

    @Deprecated
    public static Map<Long, Set<Long>> loadTargetRowIdsMap(String sourceEntityName, String sourceEntryName, Long[] sourceEntryIds, String targetEntityName) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        Map<Long, Map<String, Set<Long>>> allTargetRowIdsMap = BOTPHelper.loadAllTargetRowIdsMap(sourceEntityName, sourceEntryName, sourceEntryIds);
        for (Map.Entry<Long, Map<String, Set<Long>>> entry : allTargetRowIdsMap.entrySet()) {
            Set specifiedTargetEntryIds = entry.getValue().getOrDefault(targetEntityName, new HashSet(16));
            if (EmptyUtils.isEmpty(specifiedTargetEntryIds)) continue;
            result.put(entry.getKey(), specifiedTargetEntryIds);
        }
        return result;
    }

    @Deprecated
    public static Map<Long, Map<String, Set<Long>>> loadAllSourceRowIdsMap(String targetEntityName, String targetEntryName, Long[] targetEntryIds) {
        HashMap<Long, Map<String, Set<Long>>> result = new HashMap<Long, Map<String, Set<Long>>>(16);
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)targetEntityName, (String)targetEntryName, (Long[])targetEntryIds);
        if (bfRowLinkUpNodes == null || bfRowLinkUpNodes.size() < 1) {
            return result;
        }
        for (Long entryId : targetEntryIds) {
            List nodes = bfRowLinkUpNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getEntryId().compareTo(entryId) == 0).collect(Collectors.toList());
            for (BFRowLinkUpNode node : nodes) {
                HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>();
                BOTPHelper.findSourceNodesByEntry(node, entryId, resultMap);
                result.put(entryId, resultMap);
            }
        }
        return result;
    }

    private static void findSourceNodesByEntry(BFRowLinkUpNode node, Long entryId, Map<String, Set<Long>> resultMap) {
        if (node.getRowId().getEntryId().compareTo(entryId) != 0) {
            TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)node.getRowId().getMainTableId());
            String sourceEntityName = tableDefine.getEntityNumber();
            Set<Long> exitsSet = resultMap.get(sourceEntityName);
            if (exitsSet == null) {
                exitsSet = new HashSet<Long>();
                resultMap.put(sourceEntityName, exitsSet);
            }
            exitsSet.add(node.getRowId().getEntryId());
        }
        for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
            BOTPHelper.findSourceNodesByEntry(sNode, entryId, resultMap);
        }
    }

    @Deprecated
    public static Map<Long, Set<Long>> loadSourceRowIdsMap(String targetEntityName, String targetEntryName, Long[] targetEntryIds, String sourceEntityName) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        Map<Long, Map<String, Set<Long>>> allSourceRowIdsMap = BOTPHelper.loadAllSourceRowIdsMap(targetEntityName, targetEntryName, targetEntryIds);
        for (Map.Entry<Long, Map<String, Set<Long>>> entry : allSourceRowIdsMap.entrySet()) {
            Set specifiedSourceEntryIds = entry.getValue().getOrDefault(sourceEntityName, new HashSet(16));
            if (EmptyUtils.isEmpty(specifiedSourceEntryIds)) continue;
            result.put(entry.getKey(), specifiedSourceEntryIds);
        }
        return result;
    }

    @Deprecated
    public static Map<BFRowId, BFRowId> loadTarToSrcBFRowMapByTarEntry(String tarEntityNumber, Long[] tarIds, Long[] tarEntryIds, String sourceEntity) {
        HashMap<BFRowId, BFRowId> result = new HashMap<BFRowId, BFRowId>(16);
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)tarEntityNumber, (String)"", (Long[])tarIds);
        if (bfRowLinkUpNodes == null || bfRowLinkUpNodes.size() < 1) {
            return result;
        }
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)sourceEntity, (String)sourceEntity);
        Long upTableId = tableDefine.getTableId();
        for (Long entryId : tarEntryIds) {
            BFRowLinkUpNode entryNode;
            List<BFRowLinkUpNode> sourceNodes;
            Optional<BFRowLinkUpNode> entryNodeOptional = bfRowLinkUpNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getEntryId().compareTo(entryId) == 0).findFirst();
            if (!entryNodeOptional.isPresent() || ObjectUtils.isEmpty(sourceNodes = BOTPHelper.findSourceEntryNodes(entryNode = entryNodeOptional.get(), upTableId, entryId))) continue;
            result.put(entryNode.getRowId(), sourceNodes.get(0).getRowId());
        }
        return result;
    }

    private static List<BFRowLinkUpNode> findSourceEntryNodes(BFRowLinkUpNode node, Long sMainTableId, Long entryId) {
        ArrayList<BFRowLinkUpNode> nodes = new ArrayList<BFRowLinkUpNode>(10);
        if (node.getRowId().getMainTableId().compareTo(sMainTableId) == 0 && node.getRowId().getEntryId().compareTo(entryId) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                nodes.addAll(BOTPHelper.findSourceEntryNodes(sNode, sMainTableId, entryId));
            }
        }
        return nodes;
    }

    @Deprecated
    public static Map<Long, List<Long>> loadNearTarBillIds(String entityNumber, String tarEntityNumber, Long[] ids) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(ids.length);
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)tarEntityNumber, (String)tarEntityNumber);
        Long upTableId = tableDefine.getTableId();
        List bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)entityNumber, (String)"", (Long[])ids);
        if (bfRowLinkDownNodes == null || bfRowLinkDownNodes.size() < 1) {
            return resultMap;
        }
        for (Long id : ids) {
            List nodes = bfRowLinkDownNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getBillId().compareTo(id) == 0).collect(Collectors.toList());
            ArrayList srcPks = new ArrayList(10);
            for (BFRowLinkDownNode node : nodes) {
                List<BFRowLinkDownNode> sourceNodes = BOTPHelper.findSourceNodes(node, upTableId, id);
                List pkList = sourceNodes.stream().map(srcNode -> srcNode.getRowId().getBillId()).collect(Collectors.toList());
                srcPks.addAll(pkList);
            }
            if (srcPks.isEmpty()) continue;
            resultMap.put(id, srcPks);
        }
        return resultMap;
    }

    private static List<BFRowLinkDownNode> findSourceNodes(BFRowLinkDownNode node, Long sMainTableId, Long id) {
        ArrayList<BFRowLinkDownNode> nodes = new ArrayList<BFRowLinkDownNode>(10);
        if (node.getRowId().getMainTableId().compareTo(sMainTableId) == 0 && node.getRowId().getBillId().compareTo(id) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkDownNode sNode : node.getTNodes().values()) {
                nodes.addAll(BOTPHelper.findSourceNodes(sNode, sMainTableId, id));
            }
        }
        return nodes;
    }

    @Deprecated
    public static void deleteRelation(Object Pk, String tarEntityKey) {
        List<BizBFRow> list = BOTPHelper.getSoubill((Long)Pk, "getSoub");
        for (int i = 0; i < list.size(); ++i) {
            Long tarBillId = list.get(i).getTbillId();
            Long srcBillId = list.get(i).getsBillid();
            BOTPHelper.deleteRelation(tarEntityKey, srcBillId, tarBillId);
        }
    }

    public static void deleteRelation(String tarEntityKey, Long tarBillId, Long srcBillId) {
        try (TXHandle h = TX.requiresNew();){
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
            String sBuilder = "delete from T_BOTP_BillTracker where FSBillId= ? and FTBillId= ?";
            params.add(new SqlParameter(":FSBillId", -5, (Object)srcBillId));
            params.add(new SqlParameter(":FTBillId", -5, (Object)tarBillId));
            DB.execute((DBRoute)DBRoute.basedata, (String)sBuilder, (Object[])params.toArray(new SqlParameter[0]));
        }
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)tarEntityKey);
        String hintTable = mt.getAlias();
        MainEntityType targetEntityType = MetadataServiceHelper.getDataEntityType((String)tarEntityKey);
        String dbRouteKey = targetEntityType.getDBRouteKey();
        DBRoute tarDbRoute = DBRoute.of((String)dbRouteKey);
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)tarEntityKey);
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, (Object)tarBillId)});){
            String tcTableName = linkSet.getTrackerTable();
            ArrayList<SqlParameter> paramTc = new ArrayList<SqlParameter>(2);
            String tcDeleteSql = "delete from " + tcTableName + " where FSBillId= ? and FTBillId= ?";
            paramTc.add(new SqlParameter(":FSBillId", -5, (Object)srcBillId));
            paramTc.add(new SqlParameter(":FTBillId", -5, (Object)tarBillId));
            DB.execute((DBRoute)tarDbRoute, (String)tcDeleteSql, (Object[])paramTc.toArray(new SqlParameter[0]));
            String wbTableName = linkSet.getWbSnapTable();
            ArrayList<SqlParameter> paramWb = new ArrayList<SqlParameter>(1);
            String wbDeleteSql = "delete from " + wbTableName + " where FSBillId= ?";
            paramWb.add(new SqlParameter(":FSBillId", -5, (Object)srcBillId));
            DB.execute((DBRoute)tarDbRoute, (String)wbDeleteSql, (Object[])paramWb.toArray(new SqlParameter[0]));
            List lkLinkSet = linkSet.getItems();
            for (LinkSetItemElement lkLink : lkLinkSet) {
                String lkTableName = lkLink.getTableName();
                ArrayList<SqlParameter> paramLk = new ArrayList<SqlParameter>(1);
                String lkDeleteSql = "delete from " + lkTableName + " where FSBillId= ?";
                paramLk.add(new SqlParameter(":FSBillId", -5, (Object)srcBillId));
                BOTPHelper.dbExecute(tarDbRoute, lkDeleteSql, paramLk);
            }
        }
    }

    private static void dbExecute(DBRoute dbRoute, String lkDeleteSql, List<SqlParameter> paramLk) {
        DB.execute((DBRoute)dbRoute, (String)lkDeleteSql, (Object[])paramLk.toArray(new SqlParameter[0]));
    }

    @Deprecated
    public static Map<Long, Set<Long>> findDirectSourceBillMap(String targetEntityName, String directSourceEntityName, Set<Long> targetFinBillIds) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        Map dirtSourceBills = BFTrackerServiceHelper.findDirtSourceBills((String)targetEntityName, (Long[])targetFinBillIds.toArray(new Long[0]));
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)directSourceEntityName, (String)directSourceEntityName);
        Long sourceTableId = tableDefine.getTableId();
        for (Map.Entry entry : dirtSourceBills.entrySet()) {
            List bfRows = (List)entry.getValue();
            Set sourceBillIds = bfRows.stream().filter(row -> row.getSId().getMainTableId().equals(sourceTableId)).map(row -> row.getSId().getBillId()).collect(Collectors.toSet());
            if (EmptyUtils.isEmpty(sourceBillIds)) continue;
            result.put((Long)entry.getKey(), sourceBillIds);
        }
        return result;
    }

    public static List<DynamicObject> push4Result(String sourceEntity, String sourceEntryEntity, String targetEntity, String ruleId, Map<Long, List<Long>> srcMap) {
        return BOTPHelper.push4Result(sourceEntity, sourceEntryEntity, targetEntity, ruleId, srcMap, null);
    }

    public static List<DynamicObject> push4Result(String sourceEntity, String sourceEntryEntity, String targetEntity, String ruleId, Map<Long, List<Long>> srcMap, Map<String, String> paramMap) {
        ConvertOperationResult result = BOTPHelper.getConvertOperationResult(sourceEntity, sourceEntryEntity, targetEntity, ruleId, srcMap, paramMap);
        boolean fail = false;
        for (SourceBillReport billReport : result.getBillReports()) {
            if (billReport.isSuccess()) continue;
            fail = true;
            break;
        }
        if (!result.isSuccess() || fail) {
            String convertReport = BOTPHelper.getConvertReport(result);
            if (ObjectUtils.isEmpty((Object)convertReport)) {
                convertReport = result.getMessage();
            }
            ErrorCode ec = new ErrorCode("botp", convertReport);
            throw new KDBizException(ec, new Object[0]);
        }
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        return result.loadTargetDataObjects(refDataProvider, mainType);
    }

    private static ConvertOperationResult getConvertOperationResult(String sourceEntity, String sourceEntryEntity, String targetEntity, String ruleId, Map<Long, List<Long>> srcMap, Map<String, String> paramMap) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(64);
        for (Map.Entry<Long, List<Long>> mEntry : srcMap.entrySet()) {
            List<Long> lst = mEntry.getValue();
            for (Long entryPk : lst) {
                ListSelectedRow row = new ListSelectedRow();
                Long pk = mEntry.getKey();
                row.setPrimaryKeyValue((Object)pk);
                row.setEntryPrimaryKeyValue((Object)entryPk);
                row.setEntryEntityKey(sourceEntryEntity);
                selectedRows.add(row);
            }
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(targetEntity);
        if (ruleId != null) {
            args.setRuleId(ruleId);
        }
        args.setHasRight(true);
        args.setSelectedRows(selectedRows);
        if (!ObjectUtils.isEmpty(paramMap)) {
            Set<Map.Entry<String, String>> entries = paramMap.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                args.addCustomParam(entry.getKey(), entry.getValue());
            }
        }
        args.addCustomParam("bos_max_push_rows", ArApHelper.getMaxPushRows());
        return ConvertServiceHelper.push((PushArgs)args);
    }

    @Deprecated
    public static Map<Long, List<Long>> loadTargetBillIdsMap(String entityNumber, Long[] ids, String targetEntity) {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(16);
        List bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)entityNumber, (String)"", (Long[])ids);
        if (bfRowLinkDownNodes == null || bfRowLinkDownNodes.size() < 1) {
            return result;
        }
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)targetEntity, (String)targetEntity);
        Long downTableId = tableDefine.getTableId();
        for (Long id : ids) {
            List entryNodeOptional = bfRowLinkDownNodes.stream().filter(bfRowLinkDownNode -> bfRowLinkDownNode.getRowId().getBillId().compareTo(id) == 0).collect(Collectors.toList());
            ArrayList<BFRowLinkDownNode> nodes = new ArrayList<BFRowLinkDownNode>(10);
            for (BFRowLinkDownNode node : entryNodeOptional) {
                List<BFRowLinkDownNode> targetNodes = BOTPHelper.findTargetNodes(node, downTableId, nodes);
                if (ObjectUtils.isEmpty(targetNodes) || targetNodes.size() <= 0) continue;
                List targetBillIds = targetNodes.stream().map(v -> v.getRowId().getBillId()).collect(Collectors.toList());
                result.put(id, targetBillIds);
            }
        }
        return result;
    }

    public static List<BFRowLinkDownNode> findTargetNodes(BFRowLinkDownNode node, Long sMainTableId, List<BFRowLinkDownNode> nodes) {
        Map tNodes = node.getTNodes();
        if (tNodes == null || tNodes.size() == 0) {
            return nodes;
        }
        for (Map.Entry entrySet : tNodes.entrySet()) {
            BFRowLinkDownNode targetNode = (BFRowLinkDownNode)entrySet.getValue();
            if (targetNode.getRowId().getMainTableId().compareTo(sMainTableId) == 0) {
                nodes.add(targetNode);
                if (targetNode.getTNodes() == null || targetNode.getTNodes().size() <= 0) continue;
                BOTPHelper.findTargetNodes(targetNode, sMainTableId, nodes);
                continue;
            }
            BOTPHelper.findTargetNodes(targetNode, sMainTableId, nodes);
        }
        return nodes;
    }

    @Deprecated
    public static List<BFRowLinkDownNode> findAllTargetNodes(BFRowLinkDownNode node, List<BFRowLinkDownNode> nodes) {
        Map tNodes = node.getTNodes();
        if (tNodes == null || tNodes.size() == 0) {
            return nodes;
        }
        for (Map.Entry entrySet : tNodes.entrySet()) {
            BFRowLinkDownNode targetNode = (BFRowLinkDownNode)entrySet.getValue();
            nodes.add(targetNode);
            BOTPHelper.findAllTargetNodes(targetNode, nodes);
        }
        return nodes;
    }

    @Deprecated
    public static Map<Long, Set<String>> findAllTargetBillEntityNum(String srcEntityNumber, Long[] srcBillIds) {
        HashMap<Long, Set<String>> map = new HashMap<Long, Set<String>>(8);
        if (StringUtils.isEmpty((String)srcEntityNumber) || srcBillIds.length == 0) {
            return map;
        }
        Map nodesMap = BFTrackerServiceHelper.loadBillLinkDownNodes((String)srcEntityNumber, (Long[])srcBillIds, (boolean)false);
        if (nodesMap != null && !nodesMap.isEmpty()) {
            for (Long srcId : srcBillIds) {
                HashSet<String> entityNumberSet = new HashSet<String>(8);
                ArrayList<BFRowLinkDownNode> listRow = new ArrayList<BFRowLinkDownNode>(8);
                BFRowLinkDownNode node = (BFRowLinkDownNode)nodesMap.get(srcId);
                if (node == null) continue;
                BOTPHelper.findAllTargetNodes(node, listRow);
                for (BFRowLinkDownNode bfRow : listRow) {
                    Long tarTableId = bfRow.getRowId().getTableId();
                    TableDefine tarTableDefine = EntityMetadataCache.loadTableDefine((Long)tarTableId);
                    entityNumberSet.add(tarTableDefine.getEntityNumber());
                }
                map.put(srcId, entityNumberSet);
            }
        }
        return map;
    }

    public static boolean ruleIsSetting(ConvertRuleElement rule, boolean onlySourceField, String fieldKey) {
        boolean isSetting = false;
        if (rule != null && !ObjectUtils.isEmpty((Object)fieldKey)) {
            List fieldMaps = rule.getFieldMapPolicy().getFieldMaps();
            for (FieldMapItem field : fieldMaps) {
                if (!fieldKey.equals(field.getTargetFieldKey())) continue;
                if ("SourceField".equals(field.getConvertType()) && !ObjectUtils.isEmpty((Object)field.getSourceFieldKey())) {
                    isSetting = true;
                    break;
                }
                if (onlySourceField || "SourceField".equals(field.getConvertType()) || ObjectUtils.isEmpty((Object)field.getFormula())) break;
                isSetting = true;
                break;
            }
        }
        return isSetting;
    }

    public static void checkGroupByModeStrategy(ConvertRuleElement rule) {
        Set noCheckRuleIdSet;
        String noCheckRuleIds = StdConfig.get("noCheckGroupByModeRuleId");
        if (noCheckRuleIds != null && (noCheckRuleIdSet = Arrays.stream(noCheckRuleIds.split(",")).collect(Collectors.toSet())).contains(rule.getId())) {
            return;
        }
        int groupByMode2 = rule.getGroupByPolicy().getGroupByMode2().getValue();
        String groupByField2 = rule.getGroupByPolicy().getGroupByField2();
        if (0 == groupByMode2 || 2 == groupByMode2 && !ObjectUtils.isEmpty((Object)groupByField2)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5206\u5f55\u884c\u5408\u5e76\u4e0b\u63a8\uff0c\u8bf7\u4fee\u6539\u8f6c\u6362\u89c4\u5219>\u5206\u5355\u5408\u5e76>\u5355\u636e\u4f53\u884c\u5408\u5e76\u7b56\u7565\u3002", (String)"BOTPHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    public static boolean isPushAndSave(ConvertRuleElement rule, DynamicObject bill) {
        return rule.isAutoSave() || bill.getLong("id") != 0L;
    }

    private static void findDirSourceNodesByEntry(BFRowLinkUpNode node, Long entryId, Map<String, Set<Long>> resultMap) {
        if (node.getRowId().getEntryId().compareTo(entryId) != 0) {
            Set<Long> exitsEntrySet = resultMap.get("entryid");
            Set<Long> exitsHeadSet = resultMap.get("id");
            if (exitsEntrySet == null) {
                exitsEntrySet = new HashSet<Long>(8);
                resultMap.put("entryid", exitsEntrySet);
            }
            if (exitsHeadSet == null) {
                exitsHeadSet = new HashSet<Long>(8);
                resultMap.put("id", exitsHeadSet);
            }
            exitsEntrySet.add(node.getRowId().getEntryId());
            exitsHeadSet.add(node.getRowId().getBillId());
            return;
        }
        for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
            BOTPHelper.findDirSourceNodesByEntry(sNode, entryId, resultMap);
        }
    }

    public static Map<Long, Map<String, Set<Long>>> loadAllSourceRowIdsMap(String targetEntityName, String targetEntryName, Long[] billIds, Long[] targetEntryIds) {
        HashMap<Long, Map<String, Set<Long>>> result = new HashMap<Long, Map<String, Set<Long>>>(16);
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)targetEntityName, (String)targetEntryName, (Long[])billIds, (Long[])targetEntryIds, (OperateOption)OperateOption.create());
        if (bfRowLinkUpNodes == null || bfRowLinkUpNodes.size() < 1) {
            return result;
        }
        for (Long entryId : targetEntryIds) {
            List nodes = bfRowLinkUpNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getEntryId().compareTo(entryId) == 0).collect(Collectors.toList());
            for (BFRowLinkUpNode node : nodes) {
                HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>();
                BOTPHelper.findDirSourceNodesByEntry(node, entryId, resultMap);
                result.put(entryId, resultMap);
            }
        }
        return result;
    }

    public static Map<Long, Long> loadSourceRowIdsMap(String entityNumber, String entryKey, Long[] ids, Long[] entryIds, String sourceEntity) {
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        Map<Long, BFRowId> BFRowIdResult = BOTPHelper.loadNearSrcBFRowIdMap(entityNumber, entryKey, ids, entryIds, sourceEntity);
        for (Map.Entry<Long, BFRowId> bfRowIdEntry : BFRowIdResult.entrySet()) {
            result.put(bfRowIdEntry.getKey(), bfRowIdEntry.getValue().getEntryId());
        }
        return result;
    }

    public static Map<Long, BFRowId> loadNearSrcBFRowIdMap(String entityNumber, String entryKey, Long[] ids, Long[] entryIds, String sourceEntity) {
        HashMap<Long, BFRowId> result = new HashMap<Long, BFRowId>(16);
        List bfRowLinkUpNodes = ObjectUtils.isEmpty((Object)entryKey) || ObjectUtils.isEmpty((Object[])entryIds) ? BFTrackerServiceHelper.loadLinkUpNodes((String)entityNumber, (String)"", (Long[])ids) : BFTrackerServiceHelper.loadLinkUpNodes((String)entityNumber, (String)entryKey, (Long[])ids, (Long[])entryIds, (OperateOption)OperateOption.create());
        if (ObjectUtils.isEmpty((Object)bfRowLinkUpNodes)) {
            return result;
        }
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)sourceEntity, (String)sourceEntity);
        Long upTableId = tableDefine.getTableId();
        for (Long entryId : entryIds) {
            BFRowLinkUpNode entryNode;
            List<BFRowLinkUpNode> sourceNodes;
            Optional<BFRowLinkUpNode> entryNodeOptional = bfRowLinkUpNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getEntryId().compareTo(entryId) == 0).findFirst();
            if (!entryNodeOptional.isPresent() || ObjectUtils.isEmpty(sourceNodes = BOTPHelper.findSourceEntryNodes(entryNode = entryNodeOptional.get(), upTableId, entryId))) continue;
            result.put(entryId, sourceNodes.get(0).getRowId());
        }
        return result;
    }

    public static Map<Long, List<Long>> loadNearUpBillIds(String entityNumber, String entryKey, Long[] billIds, Long[] entryIds, String upEntityNumber) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(billIds.length);
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)upEntityNumber, (String)upEntityNumber);
        Long upTableId = tableDefine.getTableId();
        List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)entityNumber, (String)entryKey, (Long[])billIds, (Long[])entryIds, (OperateOption)OperateOption.create());
        if (bfRowLinkUpNodes == null || bfRowLinkUpNodes.size() < 1) {
            return resultMap;
        }
        for (Long id : billIds) {
            List nodes = bfRowLinkUpNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getBillId().compareTo(id) == 0).collect(Collectors.toList());
            ArrayList srcPks = new ArrayList(10);
            for (BFRowLinkUpNode node : nodes) {
                List<BFRowLinkUpNode> sourceNodes = BOTPHelper.findSourceNodes(node, upTableId, id);
                List pkList = sourceNodes.stream().map(srcNode -> srcNode.getRowId().getBillId()).collect(Collectors.toList());
                srcPks.addAll(pkList);
            }
            if (srcPks.isEmpty()) continue;
            resultMap.put(id, srcPks);
        }
        return resultMap;
    }

    public static Map<Long, List<Long>> loadNearTarBillIds(String entityNumber, String entryKey, Long[] ids, Long[] entryIds, String tarEntityNumber) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(ids.length);
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)tarEntityNumber, (String)tarEntityNumber);
        Long upTableId = tableDefine.getTableId();
        List bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)entityNumber, (String)entryKey, (Long[])ids, (Long[])entryIds, (OperateOption)OperateOption.create());
        if (bfRowLinkDownNodes == null || bfRowLinkDownNodes.size() < 1) {
            return resultMap;
        }
        for (Long id : ids) {
            List nodes = bfRowLinkDownNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getBillId().compareTo(id) == 0).collect(Collectors.toList());
            ArrayList srcPks = new ArrayList(10);
            for (BFRowLinkDownNode node : nodes) {
                List<BFRowLinkDownNode> sourceNodes = BOTPHelper.findSourceNodes(node, upTableId, id);
                List pkList = sourceNodes.stream().map(srcNode -> srcNode.getRowId().getBillId()).collect(Collectors.toList());
                srcPks.addAll(pkList);
            }
            if (srcPks.isEmpty()) continue;
            resultMap.put(id, srcPks);
        }
        return resultMap;
    }

    public static Map<Long, List<BFRowId>> loadTarBFRowIdMap(String entityNumber, String entryKey, Long[] ids, Long[] entryIds, String tarEntityNumber) {
        HashMap<Long, List<BFRowId>> resultMap = new HashMap<Long, List<BFRowId>>(ids.length);
        if (ObjectUtils.isEmpty((Object[])ids) || ObjectUtils.isEmpty((Object[])entryIds)) {
            return resultMap;
        }
        List bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)entityNumber, (String)entryKey, (Long[])ids, (Long[])entryIds, (OperateOption)OperateOption.create());
        if (ObjectUtils.isEmpty((Object)bfRowLinkDownNodes)) {
            return resultMap;
        }
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)tarEntityNumber, (String)tarEntityNumber);
        Long tarTableId = tableDefine.getTableId();
        for (Long entryId : entryIds) {
            List entryNodeOptional = bfRowLinkDownNodes.stream().filter(bfRowLinkDownNode -> bfRowLinkDownNode.getRowId().getEntryId().compareTo(entryId) == 0).collect(Collectors.toList());
            ArrayList<BFRowLinkDownNode> nodes = new ArrayList<BFRowLinkDownNode>(10);
            for (BFRowLinkDownNode node : entryNodeOptional) {
                List<BFRowLinkDownNode> targetNodes = BOTPHelper.findTargetNodes(node, tarTableId, nodes);
                if (ObjectUtils.isEmpty(targetNodes)) continue;
                List targetNodeList = targetNodes.stream().map(targetNode -> targetNode.getRowId()).collect(Collectors.toList());
                resultMap.put(entryId, targetNodeList);
            }
        }
        return resultMap;
    }

    public static Map<Long, List<Long>> loadDirtTarBillIds(String entityNumber, Long[] ids, String tarEntityNumber) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(ids.length);
        OperateOption option = OperateOption.create();
        option.setVariableValue("botp_track_only_dirt_link", "true");
        List directBfRows = BFTrackerServiceHelper.loadTargetRowIds((String)entityNumber, (Long[])ids, (OperateOption)option);
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)tarEntityNumber, (String)tarEntityNumber);
        Long tarTableId = tableDefine.getTableId();
        for (BFRow bfRow : directBfRows) {
            BFRowId sId = bfRow.getSId();
            BFRowId rowId = bfRow.getId();
            if (!rowId.getMainTableId().equals(tarTableId)) continue;
            Long key = sId.getBillId();
            Long value = rowId.getBillId();
            List targetIds = resultMap.getOrDefault(key, new ArrayList(8));
            targetIds.add(value);
            resultMap.put(key, targetIds);
        }
        return resultMap;
    }

    public static Set<Long> loadDirtTargetBillIds(String entityNumber, Long[] ids, String tarEntityNumber) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("botp_track_only_dirt_link", "true");
        List bfRows = BFTrackerServiceHelper.loadTargetRowIds((String)entityNumber, (Long[])ids, (OperateOption)option);
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)tarEntityNumber, (String)tarEntityNumber);
        Long tableId = tableDefine.getTableId();
        Set<Long> billids = bfRows.stream().filter(bfRow -> bfRow.getId().getMainTableId().compareTo(tableId) == 0).map(bfRow -> bfRow.getId().getBillId()).collect(Collectors.toSet());
        return billids;
    }
}

