/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class BaseDataHelper {
    public static final String ExRate_CONVERT_MODE_DIRECT = "0";
    public static final String ExRate_CONVERT_MODE_INDIRECT = "1";

    public static BigDecimal getExchangeRate(Long orgId, String entity, Long sourceCurrencyId, Long targetCurrencyId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (date == null) {
            date = new Date();
        }
        if (sourceCurrencyId == null || sourceCurrencyId == 0L || targetCurrencyId == null || targetCurrencyId == 0L || sourceCurrencyId.equals(targetCurrencyId)) {
            return exchangeRate;
        }
        InitHelper init = new InitHelper(orgId, entity);
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)init.getExrateTable().getLong("id"), (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)date);
        return exchangeRate;
    }

    public static boolean checkPermission(long userId, long orgId, String appId, String entityId, String permissionItemId) {
        int res = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)appId, (String)entityId, (String)permissionItemId);
        return res != 0;
    }

    public static boolean checkCurrentUserPermission(long orgId, String appId, String entityId, String permissionItemId) {
        return BaseDataHelper.checkPermission(RequestContext.get().getCurrUserId(), orgId, appId, entityId, permissionItemId);
    }

    public static boolean checkCurrentUserPermission(String appId, String entityId, String permissionItemId, Set<Long> orgIds) {
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entityId, (String)permissionItemId);
        if (allPermOrgs.hasAllOrgPerm()) {
            return true;
        }
        List hasPermOrgs = allPermOrgs.getHasPermOrgs();
        return hasPermOrgs.containsAll(orgIds);
    }

    public static Map<Long, Boolean> loadCurrentUserOrgPermissionMap(String appId, String entityId, String permissionItemId, Set<Long> orgIds) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(orgIds.size());
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entityId, (String)permissionItemId);
        if (allPermOrgs.hasAllOrgPerm()) {
            for (Long orgId : orgIds) {
                result.put(orgId, Boolean.TRUE);
            }
        } else {
            List hasPermOrgs = allPermOrgs.getHasPermOrgs();
            for (Long orgId : orgIds) {
                if (hasPermOrgs.contains(orgId)) {
                    result.put(orgId, Boolean.TRUE);
                    continue;
                }
                result.put(orgId, Boolean.FALSE);
            }
        }
        return result;
    }

    @Deprecated
    public static BigDecimal getExchangeRate(Long exratetableId, Long srcCurrencyId, Long destCurrencyId, Date exrateDate) {
        return BaseDataHelper.getExchangeRate(exratetableId, srcCurrencyId, destCurrencyId, ExRate_CONVERT_MODE_DIRECT, exrateDate);
    }

    public static BigDecimal getExchangeRate(Long exratetableId, Long srcCurrencyId, Long destCurrencyId, String quotation, Date exrateDate) {
        boolean isIndirect;
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (exrateDate == null) {
            exrateDate = new Date();
        }
        if (srcCurrencyId == null || srcCurrencyId == 0L || destCurrencyId == null || destCurrencyId == 0L || srcCurrencyId.equals(destCurrencyId)) {
            return exchangeRate;
        }
        quotation = EmptyUtils.isEmpty(quotation) ? ((isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)srcCurrencyId, (Long)destCurrencyId, (Date)exrateDate)) ? "2" : ExRate_CONVERT_MODE_INDIRECT) : (ExRate_CONVERT_MODE_DIRECT.equals(quotation) ? ExRate_CONVERT_MODE_INDIRECT : "2");
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exratetableId, (Long)srcCurrencyId, (Long)destCurrencyId, (String)quotation, (Date)exrateDate);
        return exchangeRate;
    }

    public static Map<String, Object> getExchangeRateMap(Long exratetableId, Long srcCurrencyId, Long destCurrencyId, Date exrateDate) {
        Map<String, Object> exchangeRateMap = new HashMap<String, Object>(1);
        if (exrateDate == null) {
            exrateDate = new Date();
        }
        if (srcCurrencyId == null || srcCurrencyId == 0L || destCurrencyId == null || destCurrencyId == 0L) {
            return exchangeRateMap;
        }
        if (Long.compare(srcCurrencyId, destCurrencyId) == 0) {
            exchangeRateMap.put("quoteType", Boolean.FALSE);
            exchangeRateMap.put("exchangeRate", BigDecimal.ONE);
            return exchangeRateMap;
        }
        exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)srcCurrencyId, (Long)destCurrencyId, (Long)exratetableId, (Date)exrateDate);
        return exchangeRateMap;
    }

    public static List<String> getExtProperty(String billEntity) {
        long groupId = 746980810434842624L;
        DynamicObject[] asstDatas = BusinessDataServiceHelper.load((String)"bos_assistantdata_detail", (String)"number", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)groupId)});
        ArrayList<String> extProperty = new ArrayList<String>(64);
        for (DynamicObject asstData : asstDatas) {
            extProperty.add(asstData.getString("number"));
        }
        return extProperty;
    }

    public static Map<String, String> getMapperProperties(String billEntity) {
        HashMap<String, String> propertyMap = new HashMap<String, String>(16);
        QFilter entityFilter = new QFilter("billentity", "=", (Object)billEntity);
        DynamicObjectCollection mapper = QueryServiceHelper.query((String)"ap_bill_jou_mapper", (String)"billkey,journalkey", (QFilter[])new QFilter[]{entityFilter});
        for (DynamicObject row : mapper) {
            propertyMap.put(row.getString("journalkey"), row.getString("billkey"));
        }
        return propertyMap;
    }

    public static List<String> getVerifyExtProperty(String billEntity) {
        long groupId = "ap_verifyrecord".equals(billEntity) ? 839607605818093568L : 839607266532454400L;
        DynamicObject[] asstDatas = BusinessDataServiceHelper.load((String)"bos_assistantdata_detail", (String)"number", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)groupId)});
        ArrayList<String> extProperty = new ArrayList<String>(64);
        for (DynamicObject asstData : asstDatas) {
            extProperty.add(asstData.getString("number"));
        }
        return extProperty;
    }

    public static QFilter getBasedataFilter(String basedataType, Collection<Long> orgIds) {
        QFilter basedataFilter = null;
        for (Long orgId : orgIds) {
            QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)basedataType, (Long)orgId);
            if (basedataFilter == null) {
                basedataFilter = filter;
                continue;
            }
            basedataFilter.or(filter);
        }
        if (basedataFilter != null) {
            basedataFilter.and(new QFilter("status", "=", (Object)"C"));
        } else {
            basedataFilter = new QFilter("status", "=", (Object)"C");
        }
        return basedataFilter;
    }

    public static QFilter getBasedataFilter(String basedataType, long orgId) {
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(orgId);
        return BaseDataHelper.getBasedataFilter(basedataType, idList);
    }

    public static void filterMaterialVersion(IDataModel model, BasedataEdit materialVersionF7, String apOrar) {
        if ("ap".equals(apOrar)) {
            materialVersionF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                int currentRow = model.getEntryCurrentRowIndex("detailentry");
                DynamicObject material = (DynamicObject)model.getValue("material", currentRow);
                if (!ObjectUtils.isEmpty((Object)material)) {
                    long materialId = material.getLong("id");
                    QFilter filter = new QFilter("material", "=", (Object)materialId);
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                    listFilterParameter.setFilter(filter);
                }
            });
        } else {
            materialVersionF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                int currentRow = model.getEntryCurrentRowIndex("entry");
                DynamicObject material = (DynamicObject)model.getValue("e_material", currentRow);
                if (!ObjectUtils.isEmpty((Object)material)) {
                    long materialId = material.getLong("id");
                    QFilter filter = new QFilter("material", "=", (Object)materialId);
                    ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                    listFilterParameter.setFilter(filter);
                }
            });
        }
    }

    public static void taxratefilter(Date bizdate, BasedataEdit taxrateF7) {
        taxrateF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            if (!ObjectUtils.isEmpty((Object)bizdate)) {
                QFilter filter1 = new QFilter("activedate", "<=", (Object)bizdate);
                QFilter filter2 = new QFilter("expdate", ">", (Object)bizdate);
                QFilter filter3 = new QFilter("expdate", "is null", null);
                QFilter filter = filter1.and(filter3.or(filter2));
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    public static void getCustomerPks(List<Long> mulPks, List<Long> custPks) {
        QFilter qFilter = new QFilter("id", "in", mulPks);
        DynamicObjectCollection groups = QueryServiceHelper.query((String)"bd_customergroup", (String)"id, isleaf", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject group : groups) {
            long groupPk = group.getLong("id");
            QFilter cFilter = new QFilter("group", "=", (Object)groupPk);
            cFilter.and("status", "=", (Object)BillStatusEnum.AUDIT.getValue());
            cFilter.and("enable", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection customers = QueryServiceHelper.query((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{cFilter});
            for (DynamicObject customer : customers) {
                long custPk = customer.getLong("id");
                if (custPks.contains(custPk)) continue;
                custPks.add(custPk);
            }
            if (group.getBoolean("isleaf")) continue;
            QFilter pFilter = new QFilter("parent", "=", (Object)groupPk);
            DynamicObjectCollection children = QueryServiceHelper.query((String)"bd_customergroup", (String)"id", (QFilter[])new QFilter[]{pFilter});
            ArrayList<Long> groupPks = new ArrayList<Long>();
            for (DynamicObject child : children) {
                groupPks.add(child.getLong("id"));
            }
            if (groupPks.isEmpty()) continue;
            BaseDataHelper.getCustomerPks(groupPks, custPks);
        }
    }

    public static List<Long> getBaseDataIds(String entityName, long masterid) {
        Map baseDataMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)masterid)});
        return baseDataMap.values().stream().map(data -> data.getLong("id")).collect(Collectors.toList());
    }
}

