/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.list.ListFilterParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.service.ext.SettleMatchExtContext;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.sdk.fi.ap.extpoint.dap.IAfterGenerateVoucherExt;
import kd.sdk.fi.ap.extpoint.importext.IAfterImportDataExt;
import kd.sdk.fi.ap.extpoint.invoice.IInvoiceImport;
import kd.sdk.fi.ap.extpoint.list.IAfterBizProcess;
import kd.sdk.fi.ap.extpoint.list.IApproverSetting;
import kd.sdk.fi.ap.extpoint.list.IPayeeBankInfoFilter;
import kd.sdk.fi.ap.extpoint.payapply.ICasPayBillPayCallback;
import kd.sdk.fi.ap.extpoint.push.IPushAssignField;
import kd.sdk.fi.ap.extpoint.settle.IAfterSettleProcess;
import kd.sdk.fi.ap.extpoint.settle.IManualSettleCheck;
import kd.sdk.fi.ap.extpoint.settle.IPaySettleWarnFilter;
import kd.sdk.fi.ap.extpoint.settle.IPreSettleFilter;
import kd.sdk.fi.ap.extpoint.settle.ISettleMatchExt;
import kd.sdk.fi.ap.extpoint.woff.IAfterWoffProcess;
import kd.sdk.fi.ap.extpoint.woff.IWoffMatchExt;
import kd.sdk.fi.ar.extpoint.invoice.IInvIssueCallback;
import kd.sdk.fi.ar.extpoint.plan.IPlanRowSplit;

public class BizExtendHelper {
    public static void invokeIssueCallbackExt(String callBackVoJson) {
        PluginProxy pluginProxy = PluginProxy.create(IInvIssueCallback.class, (String)"FI_AR_INVOICE_ISSUECALLBACK");
        pluginProxy.callReplace(p -> {
            p.afterProcess(callBackVoJson);
            return null;
        });
    }

    public static void invokeAfterSettleCallback(List<SettleRecordVO> resultList, SettleSchemeVO scheme) {
        if (resultList == null || resultList.size() == 0 || scheme == null) {
            return;
        }
        String settleRecordJson = JSON.toJSONString(resultList);
        String schemeJson = JSON.toJSONString((Object)scheme);
        PluginProxy pluginProxy = PluginProxy.create(IAfterSettleProcess.class, (String)"FI_AFTER_SETTLE_EXTEND");
        pluginProxy.callReplace(p -> {
            p.afterProcess(schemeJson, settleRecordJson);
            return null;
        });
    }

    public static Map<String, List<String>> invoicePushAssignFieldCallback() {
        HashMap<String, List<String>> extendFieldMap = new HashMap<String, List<String>>(2);
        PluginProxy pluginProxy = PluginProxy.create(IPushAssignField.class, (String)"FI_PUSH_ASSIGN_FIELD_EXTEND");
        pluginProxy.callReplace(p -> {
            Map afterPushAssignFieldMap = p.getAfterPushAssignField();
            if (afterPushAssignFieldMap != null && !afterPushAssignFieldMap.isEmpty()) {
                extendFieldMap.putAll(afterPushAssignFieldMap);
            }
            return null;
        });
        return extendFieldMap;
    }

    public static Boolean invokeBeforeSettleCallback(IFormView view) {
        PluginProxy pluginProxy = PluginProxy.create(IManualSettleCheck.class, (String)"FI_BEFORE_MANUAL_SETTLE_CALLBACK");
        List pluginExecuteResults = pluginProxy.callReplace(p -> p.check(view));
        boolean checkResult = true;
        if (pluginExecuteResults != null && pluginExecuteResults.size() > 0) {
            for (Boolean result : pluginExecuteResults) {
                if (result.booleanValue()) continue;
                checkResult = result;
                break;
            }
        }
        return checkResult;
    }

    public static boolean settleMatchCallbackExt(BillSettleVO main, BillSettleVO asst, SettleSchemeVO scheme) {
        PluginProxy pluginProxy = SettleMatchExtContext.getSettleMatchExt();
        if (pluginProxy == null) {
            pluginProxy = PluginProxy.create(ISettleMatchExt.class, (String)"FI_BEFORE_SETTLE_MATCH_EXT");
            SettleMatchExtContext.setSettleMatchExt((PluginProxy<ISettleMatchExt>)pluginProxy);
        }
        if (pluginProxy.getPlugins().size() == 0) {
            return true;
        }
        String mainBillSettleVoJson = SerializationUtils.toJsonString((Object)main);
        String asstBillSettleVoJson = SerializationUtils.toJsonString((Object)asst);
        String schemeJson = SerializationUtils.toJsonString((Object)scheme);
        List pluginExecuteResults = pluginProxy.callReplace(p -> p.match(mainBillSettleVoJson, asstBillSettleVoJson, schemeJson));
        boolean checkResult = true;
        if (pluginExecuteResults != null && pluginExecuteResults.size() > 0) {
            for (Boolean result : pluginExecuteResults) {
                if (result.booleanValue()) continue;
                checkResult = result;
                break;
            }
        }
        return checkResult;
    }

    public static void afterImportInvoice(List<InvoiceVO> invoiceVOs, List<DynamicObject> downLoadInvs) {
        String invoiceVOsJSON = JSON.toJSONString(invoiceVOs);
        PluginProxy pluginProxy = PluginProxy.create(IInvoiceImport.class, (String)"FI_AP_INVOICE_AFTERINVOICEIM");
        pluginProxy.callReplace(p -> {
            p.afterImportInvoice(invoiceVOsJSON, downLoadInvs);
            return null;
        });
    }

    public static String showApproverCaptionExt() {
        PluginProxy pluginProxy = PluginProxy.create(IApproverSetting.class, (String)"FI_ARAP_SHOWAPPROVER_EXTEND");
        List captionList = pluginProxy.callReplace(IApproverSetting::showApproverCaptionExt);
        if (ObjectUtils.isEmpty((Object)captionList)) {
            return "";
        }
        return (String)captionList.get(0);
    }

    @Deprecated
    public static Map<String, String> showApproverExt() {
        HashMap<String, String> extendFieldMap = new HashMap<String, String>(2);
        PluginProxy pluginProxy = PluginProxy.create(IApproverSetting.class, (String)"FI_ARAP_SHOWAPPROVER_EXTEND");
        pluginProxy.callReplace(p -> {
            Map approverMap = p.showApproverExt();
            if (approverMap != null && !approverMap.isEmpty()) {
                extendFieldMap.putAll(approverMap);
            }
            return null;
        });
        return extendFieldMap;
    }

    public static Map<String, String> showApproverExt(List<String> billIds) {
        HashMap<String, String> extendFieldMap = new HashMap<String, String>(2);
        PluginProxy pluginProxy = PluginProxy.create(IApproverSetting.class, (String)"FI_ARAP_SHOWAPPROVER_EXTEND");
        pluginProxy.callReplace(p -> {
            Map approverMap = p.showApproverExt(billIds);
            if (approverMap != null && !approverMap.isEmpty()) {
                extendFieldMap.putAll(approverMap);
            }
            return null;
        });
        return extendFieldMap;
    }

    public static void afterGenerateVoucherApExt(String voucherOpValue, String billEntityNumber, Map<Long, Long> billPkMap) {
        PluginProxy pluginProxy = PluginProxy.create(IAfterGenerateVoucherExt.class, (String)"FI_AP_AFTER_VOUCHER_EXTEND");
        pluginProxy.callReplace(p -> {
            p.afterGenerateVoucher(voucherOpValue, billEntityNumber, billPkMap);
            return null;
        });
    }

    public static void afterGenerateVoucherArExt(String voucherOpValue, String billEntityNumber, Map<Long, Long> billPkMap) {
        PluginProxy pluginProxy = PluginProxy.create(IAfterGenerateVoucherExt.class, (String)"FI_AR_AFTER_VOUCHER_EXTEND");
        pluginProxy.callReplace(p -> {
            p.afterGenerateVoucher(voucherOpValue, billEntityNumber, billPkMap);
            return null;
        });
    }

    public static QFilter addFinapPaySettleWarnFilter(IDataModel model, String entity) {
        QFilter filter = null;
        PluginProxy pluginProxy = PluginProxy.create(IPaySettleWarnFilter.class, (String)"FI_AP_PAYSETTLEWARN_EXTEND");
        List filters = "cas_paybill".equals(entity) ? pluginProxy.callReplace(p -> p.addPayFilter(model)) : pluginProxy.callReplace(p -> p.addPaidFilter(model));
        for (QFilter qfilter : filters) {
            if (filter == null) {
                filter = qfilter;
                continue;
            }
            filter.and(qfilter);
        }
        return filter;
    }

    public static void casPayBillPayCallbackExt(Object params) {
        PluginProxy pluginProxy = PluginProxy.create(ICasPayBillPayCallback.class, (String)"FI_AP_CasPayBill_PayCALLBACK");
        pluginProxy.callReplace(p -> {
            p.afterProcess(params);
            return null;
        });
    }

    public static void afterImportDataApExt(ImportDataEventArgs e, Object plugin, IDataModel model) {
        PluginProxy pluginProxy = PluginProxy.create((Object)((IAfterImportDataExt)plugin), IAfterImportDataExt.class, (String)"FI_AP_AFTER_IMPORT_EXTEND");
        pluginProxy.callReplaceIfPresent(p -> {
            p.afterImportData(e, model);
            return null;
        });
    }

    public static void afterImportDataArExt(ImportDataEventArgs e, Object plugin, IDataModel model) {
        PluginProxy pluginProxy = PluginProxy.create((Object)((IAfterImportDataExt)plugin), IAfterImportDataExt.class, (String)"FI_AR_AFTER_IMPORT_EXTEND");
        pluginProxy.callReplaceIfPresent(p -> {
            p.afterImportData(e, model);
            return null;
        });
    }

    @Deprecated
    public static void invokePlanRowSplitExt(Object plugin, IFormView view) {
        PluginProxy pluginProxy = PluginProxy.create((Object)((IPlanRowSplit)plugin), IPlanRowSplit.class, (String)"FI_AR_PLANENTRY_SPLIT");
        pluginProxy.callReplaceIfPresent(p -> {
            p.splitPlanEntry(view);
            return null;
        });
    }

    @Deprecated
    public static void invokePlanRowSplitApExt(Object plugin, IFormView view) {
        PluginProxy pluginProxy = PluginProxy.create((Object)((IPlanRowSplit)plugin), IPlanRowSplit.class, (String)"FI_AP_PLANENTRY_SPLIT");
        pluginProxy.callReplaceIfPresent(p -> {
            p.splitPlanEntry(view);
            return null;
        });
    }

    public static void payeeBankInfoFilter(ListFilterParameter lfp, IFormView view) {
        PluginProxy pluginProxy = PluginProxy.create(IPayeeBankInfoFilter.class, (String)"FI_AP_PAYBANKFILTER_EXTEND");
        pluginProxy.callReplace(p -> {
            p.setIFilters(lfp, view);
            return null;
        });
    }

    public static void afterBizProcess(IFormView view, String bizName) {
        PluginProxy pluginProxy = PluginProxy.create(IAfterBizProcess.class, (String)"FI_AP_AFTERBIZPROCESS_EXTEND");
        pluginProxy.callReplace(p -> {
            p.afterBizProcess(view, bizName);
            return null;
        });
    }

    public static Map<String, String> moreMatchField(String woffMode, String finEntityKey) {
        HashMap<String, String> matchField = new HashMap<String, String>(2);
        PluginProxy pluginProxy = PluginProxy.create(IWoffMatchExt.class, (String)"FI_BEFORE_WOFF_MATCH_EXT");
        pluginProxy.callReplace(p -> {
            Map matchFieldMap = p.moreMatchField(woffMode, finEntityKey);
            if (!ObjectUtils.isEmpty((Object)matchFieldMap)) {
                matchField.putAll(matchFieldMap);
            }
            return null;
        });
        return matchField;
    }

    public static void afterProcess(boolean isWoff, String woffMode, Set<Long> finBillIds, Set<Long> srcBusBillIds, List<Object> woffBillIds) {
        PluginProxy pluginProxy = PluginProxy.create(IAfterWoffProcess.class, (String)"FI_AFTER_WOFF_EXTEND");
        pluginProxy.callReplace(p -> {
            p.afterProcess(isWoff, woffMode, finBillIds, srcBusBillIds, woffBillIds);
            return null;
        });
    }

    public static QFilter getFilterbeforeShowRecOrPayBillF7(IFormView view, String entityKey) {
        QFilter filter = null;
        List filters = new ArrayList(2);
        PluginProxy pluginProxy = PluginProxy.create(IPreSettleFilter.class, (String)"FI_ARAP_ADDPREFILTER_EXTEND");
        if ("cas_paybill".equals(entityKey)) {
            filters = pluginProxy.callReplace(p -> p.getPayExtFilter(view));
        } else if ("ap_paidbill".equals(entityKey)) {
            filters = pluginProxy.callReplace(p -> p.getPaidExtFilter(view));
        } else if ("cas_recbill".equals(entityKey)) {
            filters = pluginProxy.callReplace(p -> p.getRecExtFilter(view));
        } else if ("ar_receivedbill".equals(entityKey)) {
            filters = pluginProxy.callReplace(p -> p.getReceivedExtFilter(view));
        }
        for (QFilter qFilter : filters) {
            if (filter == null) {
                filter = qFilter;
                continue;
            }
            filter.and(qFilter);
        }
        return filter;
    }
}

