/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.util.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class BizPartnerHelper {
    private final Map<String, Object> asstactCache = new HashMap<String, Object>(2);

    public static DynamicObject getinternalOrg(DynamicObject custsupper) {
        DynamicObject asstact;
        DynamicObject intercompany;
        DynamicObject obj = null;
        if (custsupper != null && (custsupper.getDataEntityType().getName().equals("bd_supplier") || custsupper.getDataEntityType().getName().equals("bd_customer")) && (intercompany = (asstact = BusinessDataServiceHelper.loadSingle((Object)((Long)custsupper.getPkValue()), (String)custsupper.getDynamicObjectType().getName(), (String)"internal_company")).getDynamicObject("internal_company")) != null) {
            obj = BusinessDataServiceHelper.loadSingle((Object)intercompany.getPkValue(), (String)"bos_org");
        }
        return obj;
    }

    public static DynamicObject getbizPartner(Long srOorgId, Long tarOrgId, String field) {
        DynamicObject[] asstacts;
        if (srOorgId == null) {
            return null;
        }
        String entity = "bd_supplier";
        if (field.equals("iscustomer")) {
            entity = "bd_customer";
        }
        QFilter uFilter = new QFilter("internal_company", "=", (Object)srOorgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        uFilter.and(enableFilter).and(statusFilter);
        DynamicObjectCollection haveAccessAsstacts = BaseDataServiceHelper.queryBaseData((String)entity, (Long)tarOrgId, (QFilter)uFilter, (String)"id");
        if (haveAccessAsstacts.size() == 0) {
            asstacts = BusinessDataServiceHelper.load((String)entity, (String)"id,createorg.id,name", (QFilter[])new QFilter[]{uFilter});
        } else {
            List asstactIds = haveAccessAsstacts.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            asstacts = BusinessDataServiceHelper.load((String)entity, (String)"id,createorg.id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        }
        if (asstacts == null || asstacts.length == 0) {
            return null;
        }
        DynamicObject object = null;
        for (DynamicObject supplier : asstacts) {
            Long createOrgId = supplier.getLong("createorg.id");
            if (createOrgId == null || !tarOrgId.equals(createOrgId)) continue;
            object = supplier;
        }
        if (object == null) {
            object = asstacts[0];
        }
        return object;
    }

    public static boolean isbizPartner(Long pkValue, String field) {
        return BizPartnerHelper.getbizPartner(pkValue, field) != null;
    }

    public static boolean isinternalOrg(DynamicObject pkValue) {
        return BizPartnerHelper.getinternalOrg(pkValue) != null;
    }

    public static boolean isbizPartner(Long pkValue) {
        return BizPartnerHelper.getbizPartner(pkValue);
    }

    private static Boolean getbizPartner(Long orgId) {
        if (orgId == null) {
            return null;
        }
        QFilter uFilter = new QFilter("internal_company", "=", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter[] qFilters = new QFilter[]{uFilter.and(statusFilter).and(enableFilter)};
        return QueryServiceHelper.exists((String)"bd_supplier", (QFilter[])qFilters) || QueryServiceHelper.exists((String)"bd_customer", (QFilter[])qFilters);
    }

    public static DynamicObject getbizPartnerorder(Long orgPk, Long tarOrgId, String order) {
        if ("issupplier".equals(order)) {
            DynamicObject suObject = BizPartnerHelper.getbizPartner(orgPk, tarOrgId, "issupplier");
            if (suObject != null) {
                return suObject;
            }
            return BizPartnerHelper.getbizPartner(orgPk, tarOrgId, "iscustomer");
        }
        DynamicObject cuObject = BizPartnerHelper.getbizPartner(orgPk, tarOrgId, "iscustomer");
        if (cuObject != null) {
            return cuObject;
        }
        return BizPartnerHelper.getbizPartner(orgPk, tarOrgId, "issupplier");
    }

    public static DynamicObject getbizPartner(Long orgId, String field) {
        if (orgId == null) {
            return null;
        }
        String entity = "bd_supplier";
        if (field.equals("iscustomer")) {
            entity = "bd_customer";
        }
        QFilter uFilter = new QFilter("internal_company", "=", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter[] qFilters = new QFilter[]{uFilter.and(statusFilter).and(enableFilter)};
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)entity, (String)"id", (QFilter[])qFilters);
        return object;
    }

    public DynamicObject getApbizPartnerCache(Long orgId, Long billType) {
        String supplierKey = orgId + "_supplier";
        String customerKey = orgId + "_customer";
        Object asstact = this.asstactCache.get(supplierKey);
        QFilter[] qFilters = this.getFilter(orgId);
        if (asstact == null && (asstact = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,name", (QFilter[])qFilters)) != null) {
            this.asstactCache.put(supplierKey, asstact);
        }
        if (billType.equals(BillTypeConsts.APFIN_OTR) && asstact == null && (asstact = this.asstactCache.get(customerKey)) == null && (asstact = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (String)"id,name", (QFilter[])qFilters)) != null) {
            this.asstactCache.put(customerKey, asstact);
        }
        return (DynamicObject)asstact;
    }

    public DynamicObject getArbizPartnerCache(Long orgId, Long billType) {
        String supplierKey = orgId + "_supplier";
        String customerKey = orgId + "_customer";
        Object asstact = this.asstactCache.get(customerKey);
        QFilter[] qFilters = this.getFilter(orgId);
        if (asstact == null && (asstact = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (String)"id,name", (QFilter[])qFilters)) != null) {
            this.asstactCache.put(customerKey, asstact);
        }
        if (billType.equals(BillTypeConsts.ARFIN_OTR) && asstact == null && (asstact = this.asstactCache.get(supplierKey)) == null && (asstact = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (String)"id,name", (QFilter[])qFilters)) != null) {
            this.asstactCache.put(supplierKey, asstact);
        }
        return (DynamicObject)asstact;
    }

    public QFilter[] getFilter(Long orgId) {
        QFilter uFilter = new QFilter("internal_company", "=", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        return new QFilter[]{uFilter.and(statusFilter).and(enableFilter)};
    }

    public static DynamicObject[] getcussup(long orgPk) {
        int i;
        QFilter uFilter = new QFilter("internal_company", "=", (Object)orgPk);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter[] qFilters = new QFilter[]{uFilter.and(statusFilter).and(enableFilter)};
        DynamicObject[] customer = BusinessDataServiceHelper.load((String)"bd_customer", (String)"id,name", (QFilter[])qFilters);
        DynamicObject[] supplier = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,name", (QFilter[])qFilters);
        ArrayList<DynamicObject> listDy = new ArrayList<DynamicObject>(64);
        for (i = 0; i < customer.length; ++i) {
            listDy.add(customer[i]);
        }
        for (i = 0; i < supplier.length; ++i) {
            listDy.add(supplier[i]);
        }
        if (listDy.size() > 0) {
            DynamicObject[] dynamicObjects = new DynamicObject[listDy.size()];
            for (int i2 = 0; i2 < listDy.size(); ++i2) {
                dynamicObjects[i2] = (DynamicObject)listDy.get(i2);
            }
            return dynamicObjects;
        }
        return null;
    }

    public static DynamicObject[] getintcustomer(DynamicObjectCollection orgcoll) {
        QFilter uFilter = new QFilter("internal_company", "in", (Object)StringUtils.getPks(orgcoll));
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter[] qFilters = new QFilter[]{uFilter.and(statusFilter).and(enableFilter)};
        DynamicObject[] customer = BusinessDataServiceHelper.load((String)"bd_customer", (String)"id,name", (QFilter[])qFilters);
        return customer;
    }

    public static DynamicObject[] getintsupper(DynamicObjectCollection orgcoll) {
        QFilter uFilter = new QFilter("internal_company", "in", (Object)StringUtils.getPks(orgcoll));
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter[] qFilters = new QFilter[]{uFilter.and(statusFilter).and(enableFilter)};
        DynamicObject[] supper = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,name", (QFilter[])qFilters);
        return supper;
    }

    public static List<Long> getCusAndSupPksByPartners(DynamicObjectCollection bizpartnerFilters) {
        Stream stream;
        if (bizpartnerFilters == null) {
            ArrayList<String> roles = new ArrayList<String>(8);
            roles.add(",1,2,");
            roles.add(",2,1,");
            roles.add(",1,2,3,");
            roles.add(",1,3,2,");
            roles.add(",2,1,3,");
            roles.add(",2,3,1,");
            roles.add(",3,1,2,");
            roles.add(",3,2,1,");
            DynamicObjectCollection parteners = QueryServiceHelper.query((String)"bd_bizpartner", (String)"id", (QFilter[])new QFilter[]{new QFilter("partnerrole", "in", roles)});
            stream = parteners.stream();
        } else {
            stream = bizpartnerFilters.stream();
        }
        List pks = stream.map(dyb -> dyb.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizpartner", "in", pks)});
        DynamicObjectCollection customers = QueryServiceHelper.query((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizpartner", "in", pks)});
        List<Long> cusAndSupPks = Stream.concat(suppliers.stream(), customers.stream()).map(dyb -> dyb.getLong("id")).collect(Collectors.toList());
        return cusAndSupPks;
    }

    public static DataSet convertAsstactToBizPartner(DataSet dataSet, String[] leftSelectors, List<Long> orgPks) {
        DataSet copyDataSet = dataSet.copy();
        HashSet<Long> asstactIdSet = new HashSet<Long>(8);
        for (Row row : dataSet) {
            Long asstactId = row.getLong("asstact");
            asstactIdSet.add(asstactId);
        }
        if (asstactIdSet.isEmpty()) {
            return copyDataSet.select(leftSelectors);
        }
        String asstactString = StringUtils.longSetToString(asstactIdSet);
        String bizPartnerCusSql = new StringBuffer().append("SELECT c.FID cusid, s.FID pusid,c.fbizpartnerid ").append("FROM T_BD_Customer c, T_BD_Supplier s ").append("WHERE c.FBizPartnerID = s.FBizPartnerID ").append(" and c.fmasterid in ").append(asstactString).toString();
        String bizPartnerSupSql = new StringBuffer().append("SELECT c.FID cusid, s.FID pusid,c.fbizpartnerid ").append("FROM T_BD_Supplier s ,T_BD_Customer c ").append("WHERE c.FBizPartnerID = s.FBizPartnerID ").append(" and s.fmasterid in ").append(asstactString).toString();
        String bizPartnerUnionSql = new StringBuffer().append("select a.cusid unionkey,a.fbizpartnerid asstact from (").append(bizPartnerCusSql).append(") as a").append(" union ").append("select b.pusid unionkey,b.fbizpartnerid asstact from (").append(bizPartnerSupSql).append(") as b ").toString();
        DataSet bizPartnerDataSet = DB.queryDataSet((String)"commonquery", (DBRoute)DBRouteConst.BASEDATA, (String)bizPartnerUnionSql);
        DataSet convertDataSet = bizPartnerDataSet.join(copyDataSet, JoinType.INNER).on("unionKey", "asstact").select(new String[]{"asstact"}, (String[])ArrayUtils.removeElement((Object[])leftSelectors, (Object)"asstact")).finish();
        return convertDataSet;
    }
}

