/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.SettleEntryEnum;
import kd.fi.arapcommon.factory.SettleServiceFactory;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.SettleRecordOpHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.UnSettleParam;

public class CasCancelUnSettleServiceHelper {
    private static final Log logger = LogFactory.getLog(CasCancelUnSettleServiceHelper.class);

    public static void cancelPay(List<Long> billPks) {
        CasCancelUnSettleServiceHelper.unSettle(billPks, "cas_paybill", false);
    }

    public static void cancelRec(List<Long> billPks) {
        CasCancelUnSettleServiceHelper.unSettle(billPks, "cas_recbill", true);
    }

    public static void unSettle(List<Long> billPks, String entityKey, boolean isAr) {
        CasCancelUnSettleServiceHelper.unSettle4Main(billPks, isAr);
        CasCancelUnSettleServiceHelper.unSettle4Asst(billPks, entityKey, isAr);
    }

    private static void unSettle4Main(List<Long> billPks, boolean isAr) {
        String settleRecordEntity = isAr ? "ar_settlerecord" : "ap_settlerecord";
        DynamicObject[] settleRecords = CasCancelUnSettleServiceHelper.getSettleRecordsByMain(billPks, settleRecordEntity);
        if (settleRecords.length == 0) {
            return;
        }
        ArrayList<DynamicObject> detailSettleRecords = new ArrayList<DynamicObject>(settleRecords.length);
        ArrayList<DynamicObject> planSettleRecords = new ArrayList<DynamicObject>(settleRecords.length);
        for (DynamicObject settleRecord : settleRecords) {
            int settleModel = settleRecord.getInt("settleentry");
            if (SettleEntryEnum.DETAIL.getValue() == settleModel) {
                detailSettleRecords.add(settleRecord);
                continue;
            }
            planSettleRecords.add(settleRecord);
        }
        if (detailSettleRecords.size() > 0) {
            CasCancelUnSettleServiceHelper.unSettleByMain(detailSettleRecords, isAr);
        }
        if (planSettleRecords.size() > 0) {
            CasCancelUnSettleServiceHelper.unSettleByMain(planSettleRecords, isAr);
        }
    }

    private static void unSettleByMain(List<DynamicObject> settleRecords, boolean isAr) {
        String settleRecordEntity = isAr ? "ar_settlerecord" : "ap_settlerecord";
        ArrayList<DynamicObject> needDeleteRecords = new ArrayList<DynamicObject>(settleRecords.size());
        ArrayList<DynamicObject> needRedRecords = new ArrayList<DynamicObject>(settleRecords.size());
        CasCancelUnSettleServiceHelper.recordClassify(settleRecords.toArray(new DynamicObject[0]), needDeleteRecords, needRedRecords);
        if (needDeleteRecords.size() > 0) {
            CasCancelUnSettleServiceHelper.invokeUnSettle(needDeleteRecords, false);
        }
        if (needRedRecords.size() > 0) {
            List<DynamicObject> redSettleRecords = CasCancelUnSettleServiceHelper.pushRedSettleRecords(needRedRecords, isAr);
            CasCancelUnSettleServiceHelper.invokeSettleRecordSubmitAndAudit(settleRecordEntity, redSettleRecords);
            CasCancelUnSettleServiceHelper.updateSettleRecordRedFlag(needRedRecords);
            CasCancelUnSettleServiceHelper.invokeUnSettle(needRedRecords, true);
        }
    }

    private static void unSettle4Asst(List<Long> billPks, String entityKey, boolean isAr) {
        String settleRecordEntity = isAr ? "ar_settlerecord" : "ap_settlerecord";
        DynamicObject[] settleRecords = CasCancelUnSettleServiceHelper.getSettleRecordsByAsst(billPks, entityKey, settleRecordEntity);
        if (settleRecords.length == 0) {
            return;
        }
        ArrayList<DynamicObject> detailSettleRecords = new ArrayList<DynamicObject>(settleRecords.length);
        ArrayList<DynamicObject> planSettleRecords = new ArrayList<DynamicObject>(settleRecords.length);
        for (DynamicObject settleRecord : settleRecords) {
            int settleModel = settleRecord.getInt("settleentry");
            if (SettleEntryEnum.DETAIL.getValue() == settleModel) {
                detailSettleRecords.add(settleRecord);
                continue;
            }
            planSettleRecords.add(settleRecord);
        }
        if (detailSettleRecords.size() > 0) {
            CasCancelUnSettleServiceHelper.unSettleByAsst(detailSettleRecords, billPks, isAr);
        }
        if (planSettleRecords.size() > 0) {
            CasCancelUnSettleServiceHelper.unSettleByAsst(planSettleRecords, billPks, isAr);
        }
    }

    private static void unSettleByAsst(List<DynamicObject> settleRecords, List<Long> billPks, boolean isAr) {
        ArrayList<DynamicObject> wholeAndNeedDeleteRecords = new ArrayList<DynamicObject>(settleRecords.size());
        ArrayList<DynamicObject> wholeAndNeedRedRecords = new ArrayList<DynamicObject>(settleRecords.size());
        ArrayList<DynamicObject> partAndNeedDeleteRecords = new ArrayList<DynamicObject>(settleRecords.size());
        ArrayList<DynamicObject> partAndNeedRedRecords = new ArrayList<DynamicObject>(settleRecords.size());
        CasCancelUnSettleServiceHelper.recordClassify(settleRecords.toArray(new DynamicObject[0]), wholeAndNeedDeleteRecords, wholeAndNeedRedRecords, partAndNeedDeleteRecords, partAndNeedRedRecords, billPks);
        CasCancelUnSettleServiceHelper.resolveWholeNeedDeleteRecord(wholeAndNeedDeleteRecords);
        CasCancelUnSettleServiceHelper.resolveWholeNeedRedRecord(wholeAndNeedRedRecords, isAr);
        CasCancelUnSettleServiceHelper.resolvePartNeedDeleteRecord(partAndNeedDeleteRecords, billPks);
        CasCancelUnSettleServiceHelper.resolvePartNeedRedRecord(partAndNeedRedRecords, billPks, isAr);
    }

    private static DynamicObject[] getSettleRecordsByMain(List<Long> billPks, String settleRecordEntity) {
        QFilter filter = new QFilter("mainbillid", "in", billPks);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        return BusinessDataServiceHelper.load((String)settleRecordEntity, (String)CommonSettleServiceHelper.getSettleRecordSelector(), (QFilter[])filter.toArray());
    }

    private static DynamicObject[] getSettleRecordsByAsst(List<Long> billPks, String entityKey, String settleRecordEntity) {
        QFilter filter = new QFilter("entry.billid", "in", billPks);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] settleRecords = SettleRecordQueryHelper.getSettleRecords(settleRecordEntity, CommonSettleServiceHelper.getSettleRecordSelector(), entityKey, billPks.toArray(), filter);
        List<DynamicObject> settleRecordList = Arrays.stream(settleRecords).collect(Collectors.toList());
        Iterator settleRecordItr = settleRecordList.iterator();
        while (settleRecordItr.hasNext()) {
            boolean isRemove = false;
            boolean isNeedUnSettle = false;
            DynamicObject settleRecord = (DynamicObject)settleRecordItr.next();
            DynamicObjectCollection entries = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long asstBillId = entry.getLong("billid");
                boolean hadWriteOff = entry.getBoolean("e_hadwrittenoff");
                if (!billPks.contains(asstBillId)) continue;
                if (hadWriteOff) {
                    isRemove = true;
                    continue;
                }
                isNeedUnSettle = true;
            }
            if (!isRemove) continue;
            if (isNeedUnSettle) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u4ed8\u6b3e\u6216\u53d6\u6d88\u6536\u6b3e\u7684\u5355\u636e\u4e2d\u65e2\u5b58\u5728\u88ab\u7ea2\u51b2\u8fc7\u7684\u5355\u636e\uff0c\u53c8\u5b58\u5728\u9700\u8981\u53cd\u7ed3\u7b97\u7684\u6570\u636e\uff0c\u8bf7\u6309\u7167\u8fd9\u4e24\u79cd\u60c5\u51b5\u5206\u5f00\u53d6\u6d88\u4ed8\u6b3e\u4e0e\u53d6\u6d88\u6536\u6b3e\u3002", (String)"CasCancelUnSettleServiceHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            settleRecordItr.remove();
        }
        return settleRecordList.toArray(new DynamicObject[0]);
    }

    private static void invokeUnSettle(List<DynamicObject> settleRecords, boolean isRedSettleRecord) {
        Map<String, List<DynamicObject>> map = SettleRecordOpHelper.classfySettleRecord(settleRecords.toArray(new DynamicObject[0]));
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            String key = entry.getKey();
            logger.info("CasCancelUnSettleServiceHelper.invokeUnSettle settlerelation:" + key);
            AbstractSettleTemplate service = SettleServiceFactory.getService(key);
            UnSettleParam unSettleParam = new UnSettleParam();
            unSettleParam.setUnSettleByListOP(false);
            unSettleParam.setRedSettleRecord(isRedSettleRecord);
            service.unSettle(entry.getValue().toArray(new DynamicObject[0]), unSettleParam);
        }
    }

    private static void resolveWholeNeedDeleteRecord(List<DynamicObject> wholeAndNeedDeleteRecords) {
        if (wholeAndNeedDeleteRecords.size() != 0) {
            CasCancelUnSettleServiceHelper.invokeUnSettle(wholeAndNeedDeleteRecords, false);
        }
    }

    private static void resolveWholeNeedRedRecord(List<DynamicObject> wholeAndNeedRedRecords, boolean isAr) {
        String settleRecordEntity;
        String string = settleRecordEntity = isAr ? "ar_settlerecord" : "ap_settlerecord";
        if (wholeAndNeedRedRecords.size() == 0) {
            return;
        }
        List<DynamicObject> redSettleRecords = null;
        try {
            redSettleRecords = CasCancelUnSettleServiceHelper.pushRedSettleRecords(wholeAndNeedRedRecords, isAr);
        }
        catch (KDBizException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e94\u4ed8\u7ed3\u7b97\u8bb0\u5f55\u7ea2\u51b2\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"CasCancelUnSettleServiceHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]), e.getMessage()));
        }
        CasCancelUnSettleServiceHelper.invokeSettleRecordSubmitAndAudit(settleRecordEntity, redSettleRecords);
        CasCancelUnSettleServiceHelper.updateSettleRecordRedFlag(wholeAndNeedRedRecords);
        CasCancelUnSettleServiceHelper.invokeUnSettle(wholeAndNeedRedRecords, true);
    }

    private static void resolvePartNeedDeleteRecord(List<DynamicObject> partAndNeedDeleteRecords, List<Long> asstIds) {
        Long asstBillId;
        DynamicObject entry;
        DynamicObjectCollection entries;
        if (partAndNeedDeleteRecords.size() == 0) {
            return;
        }
        for (DynamicObject partNeedDeleteRecord : partAndNeedDeleteRecords) {
            DynamicObjectCollection entries2 = partNeedDeleteRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry2 : entries2) {
                boolean hadWriteOff = entry2.getBoolean("e_hadwrittenoff");
                if (!hadWriteOff) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u64cd\u4f5c\u65f6\u5b58\u5728\u4e00\u5bf9\u591a\u7684\u7ed3\u7b97\u8bb0\u5f55\u7684\u8f85\u65b9\u5b58\u5728\u88ab\u7ea2\u51b2\u7684\u5206\u5f55\uff0c\u4e0d\u5141\u8bb8\u53cd\u64cd\u4f5c\uff0c\u8bf7\u5148\u5220\u9664\u5bf9\u5e94\u7684\u7ea2\u51b2\u7ed3\u7b97\u8bb0\u5f55\uff0c\u518d\u6267\u884c\u53cd\u64cd\u4f5c\u3002", (String)"AbsAutoSettleService_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
        ArrayList<DynamicObject> partRecordsTemp = new ArrayList<DynamicObject>(partAndNeedDeleteRecords.size());
        CloneUtils clone = new CloneUtils(false, false);
        for (DynamicObject settleRecord : partAndNeedDeleteRecords) {
            partRecordsTemp.add((DynamicObject)clone.clone((IDataEntityBase)settleRecord));
        }
        for (DynamicObject partRecord : partAndNeedDeleteRecords) {
            entries = partRecord.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                entry = (DynamicObject)iterator.next();
                asstBillId = entry.getLong("billid");
                if (asstIds.contains(asstBillId)) continue;
                iterator.remove();
            }
        }
        CasCancelUnSettleServiceHelper.repairSettleRecordMainData(partAndNeedDeleteRecords);
        CasCancelUnSettleServiceHelper.invokeUnSettle(partAndNeedDeleteRecords, true);
        for (DynamicObject partRecord : partRecordsTemp) {
            entries = partRecord.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                entry = (DynamicObject)iterator.next();
                asstBillId = entry.getLong("billid");
                if (!asstIds.contains(asstBillId)) continue;
                iterator.remove();
            }
        }
        CasCancelUnSettleServiceHelper.repairSettleRecordMainData(partRecordsTemp);
        CasCancelUnSettleServiceHelper.updateSettleRecordRedFlagForPart(partRecordsTemp);
        SettleRecordOpHelper.updateSettleRecordsByPart(partRecordsTemp.toArray(new DynamicObject[0]));
    }

    private static void repairSettleRecordMainData(List<DynamicObject> partAndNeedDeleteRecords) {
        for (DynamicObject partRecord : partAndNeedDeleteRecords) {
            DynamicObjectCollection entries = partRecord.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            BigDecimal tempSettleAmt = BigDecimal.ZERO;
            BigDecimal tempSettleLocalAmt = BigDecimal.ZERO;
            BigDecimal tempSwapL = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                tempSettleAmt = tempSettleAmt.add(entry.getBigDecimal("settleamt"));
                tempSettleLocalAmt = tempSettleLocalAmt.add(entry.getBigDecimal("localsettleamt"));
                tempSwapL = tempSwapL.add(entry.getBigDecimal("e_swappl"));
            }
            partRecord.set("totalsettleamt", (Object)tempSettleAmt.abs().multiply(new BigDecimal(partRecord.getBigDecimal("totalsettleamt").signum())));
            partRecord.set("localtotalsettleamt", (Object)tempSettleLocalAmt.abs().multiply(new BigDecimal(partRecord.getBigDecimal("localtotalsettleamt").signum())));
            partRecord.set("swappl", (Object)tempSwapL.abs().multiply(new BigDecimal(partRecord.getBigDecimal("swappl").signum())));
        }
    }

    private static void resolvePartNeedRedRecord(List<DynamicObject> partAndNeedRedRecords, List<Long> billPks, boolean isAr) {
        String settleRecordEntity;
        String string = settleRecordEntity = isAr ? "ar_settlerecord" : "ap_settlerecord";
        if (partAndNeedRedRecords.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> partRecordsTemp = new ArrayList<DynamicObject>(partAndNeedRedRecords.size());
        CloneUtils clone = new CloneUtils(false, false);
        for (DynamicObject settleRecord : partAndNeedRedRecords) {
            partRecordsTemp.add((DynamicObject)clone.clone((IDataEntityBase)settleRecord));
        }
        for (DynamicObject partRecord : partAndNeedRedRecords) {
            DynamicObjectCollection entries = partRecord.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                Long asstBillId = entry.getLong("billid");
                if (billPks.contains(asstBillId)) continue;
                iterator.remove();
            }
        }
        CasCancelUnSettleServiceHelper.repairSettleRecordMainData(partAndNeedRedRecords);
        CasCancelUnSettleServiceHelper.invokeUnSettle(partAndNeedRedRecords, true);
        List<DynamicObject> redSettleRecords = null;
        try {
            redSettleRecords = CasCancelUnSettleServiceHelper.pushRedSettleRecords(partAndNeedRedRecords, isAr);
        }
        catch (KDBizException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e94\u4ed8\u7ed3\u7b97\u8bb0\u5f55\u7ea2\u51b2\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"CasCancelUnSettleServiceHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]), e.getMessage()));
        }
        for (DynamicObject partRecord : redSettleRecords) {
            DynamicObjectCollection entries = partRecord.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                Long asstBillId = entry.getLong("billid");
                if (billPks.contains(asstBillId)) continue;
                iterator.remove();
            }
        }
        CasCancelUnSettleServiceHelper.repairSettleRecordMainData(redSettleRecords);
        CasCancelUnSettleServiceHelper.invokeSettleRecordSubmitAndAudit(settleRecordEntity, redSettleRecords);
        CasCancelUnSettleServiceHelper.updateSettleRecordRedFlag(partRecordsTemp, billPks);
        DynamicObject[] results = partRecordsTemp.toArray(new DynamicObject[0]);
        SaveServiceHelper.update((DynamicObject[])results);
    }

    private static void updateSettleRecordRedFlag(List<DynamicObject> needRedRecords) {
        for (DynamicObject record : needRedRecords) {
            record.set("hadwrittenoff", (Object)1);
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                entry.set("e_hadwrittenoff", (Object)1);
            }
        }
        DynamicObject[] results = needRedRecords.toArray(new DynamicObject[0]);
        SaveServiceHelper.update((DynamicObject[])results);
    }

    private static void updateSettleRecordRedFlag(List<DynamicObject> needRedRecords, List<Long> asstIds) {
        for (DynamicObject record : needRedRecords) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long asstId = entry.getLong("billid");
                if (!asstIds.contains(asstId)) continue;
                entry.set("e_hadwrittenoff", (Object)1);
            }
        }
        CasCancelUnSettleServiceHelper.updateSettleRecordRedFlagForPart(needRedRecords);
    }

    private static void updateSettleRecordRedFlagForPart(List<DynamicObject> settleRecords) {
        for (DynamicObject record : settleRecords) {
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            boolean isFlag = true;
            for (DynamicObject entry : entries) {
                boolean isHadWrittenOff = entry.getBoolean("e_hadwrittenoff");
                if (isHadWrittenOff) continue;
                isFlag = false;
            }
            if (!isFlag) continue;
            record.set("hadwrittenoff", (Object)1);
        }
    }

    private static List<DynamicObject> pushRedSettleRecords(List<DynamicObject> needRedRecords, boolean isAr) {
        String entityKey = isAr ? "ar_settlerecord" : "ap_settlerecord";
        String settleRecordRedRuleId = isAr ? "750450292776019968" : "733772355079280640";
        List<Long> resultIds = needRedRecords.stream().map(result -> result.getLong("id")).collect(Collectors.toList());
        return BOTPHelper.push(entityKey, entityKey, settleRecordRedRuleId, resultIds);
    }

    private static void invokeSettleRecordSubmitAndAudit(String entityKey, List<DynamicObject> redSettleRecords) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("mutex_writeback", "false");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)entityKey, (DynamicObject[])redSettleRecords.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult(saveResult);
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)entityKey, (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
        OperationHelper.assertResult(submitResult);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)entityKey, (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
        OperationHelper.assertResult(auditResult);
    }

    private static void recordClassify(DynamicObject[] settleRecords, List<DynamicObject> deleteRecords, List<DynamicObject> redRecords) {
        HashMap<String, Date> currentDateMap = new HashMap<String, Date>();
        boolean redAllSettleRecord = CommonSettleServiceHelper.isRedAllSettleRecord();
        if (redAllSettleRecord) {
            Collections.addAll(redRecords, settleRecords);
        } else {
            for (DynamicObject result : settleRecords) {
                Date currentDate;
                long orgId = result.getLong("org.id");
                String mainBillEntity = result.getString("billentity");
                String initEntity = "ap_finapbill".equals(mainBillEntity) || "cas_paybill".equals(mainBillEntity) || "ap_paidbill".equals(mainBillEntity) ? "ap_init" : "ar_init";
                Date date = (Date)currentDateMap.get(initEntity + orgId);
                if (date != null) {
                    currentDate = date;
                } else {
                    InitHelper init = new InitHelper(orgId, initEntity);
                    currentDate = init.getCurrentDate() != null ? init.getCurrentDate() : init.getStartDate();
                    currentDateMap.put(initEntity + orgId, currentDate);
                }
                if (result.getBoolean("isvoucher") || DateUtils.getDiffDays(result.getDate("settledate"), currentDate) > 0) {
                    redRecords.add(result);
                    continue;
                }
                deleteRecords.add(result);
            }
        }
        logger.info("CasCancelUnSettleServiceHelper.recordClassify redRecords:" + redRecords.size());
        logger.info("CasCancelUnSettleServiceHelper.recordClassify deleteRecords:" + deleteRecords.size());
    }

    private static void recordClassify(DynamicObject[] settleRecords, List<DynamicObject> wholeAndNeedDeleteRecords, List<DynamicObject> wholeAndNeedRedRecords, List<DynamicObject> partAndNeedDeleteRecords, List<DynamicObject> partAndNeedRedRecords, List<Long> billPks) {
        boolean redAllSettleRecord = CommonSettleServiceHelper.isRedAllSettleRecord();
        HashMap<String, Date> currentDateMap = new HashMap<String, Date>();
        for (DynamicObject result : settleRecords) {
            Date currentDate;
            boolean isWhole = true;
            DynamicObjectCollection entrys = result.getDynamicObjectCollection("entry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                long asstBillId = entry.getLong("billid");
                if (billPks.contains(asstBillId)) continue;
                isWhole = false;
                break;
            }
            long orgId = result.getLong("org.id");
            String mainBillEntity = result.getString("billentity");
            String initEntity = "ap_finapbill".equals(mainBillEntity) || "cas_paybill".equals(mainBillEntity) || "ap_paidbill".equals(mainBillEntity) ? "ap_init" : "ar_init";
            Date date = (Date)currentDateMap.get(initEntity + orgId);
            if (date != null) {
                currentDate = date;
            } else {
                InitHelper init = new InitHelper(orgId, initEntity);
                currentDate = init.getCurrentDate() != null ? init.getCurrentDate() : init.getStartDate();
                currentDateMap.put(initEntity + orgId, currentDate);
            }
            if (redAllSettleRecord) {
                if (isWhole) {
                    wholeAndNeedRedRecords.add(result);
                    continue;
                }
                partAndNeedRedRecords.add(result);
                continue;
            }
            if (result.getBoolean("isvoucher") || DateUtils.getDiffDays(result.getDate("settledate"), currentDate) > 0) {
                if (isWhole) {
                    wholeAndNeedRedRecords.add(result);
                    continue;
                }
                partAndNeedRedRecords.add(result);
                continue;
            }
            if (isWhole) {
                wholeAndNeedDeleteRecords.add(result);
                continue;
            }
            partAndNeedDeleteRecords.add(result);
        }
        logger.info("CasCancelUnSettleServiceHelper.recordClassify wholeAndNeedRedRecords:" + wholeAndNeedRedRecords.size());
        logger.info("CasCancelUnSettleServiceHelper.recordClassify partAndNeedRedRecords:" + partAndNeedRedRecords.size());
        logger.info("CasCancelUnSettleServiceHelper.recordClassify wholeAndNeedDeleteRecords:" + wholeAndNeedDeleteRecords.size());
        logger.info("CasCancelUnSettleServiceHelper.recordClassify partAndNeedDeleteRecords:" + partAndNeedDeleteRecords.size());
    }
}

