/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.arapcommon.consts.DBRouteConst;

public class FinArBillPlanHelper {
    private static BigDecimal zero = BigDecimal.ZERO;

    public static void savePlanEntry(DynamicObject finBill) {
        BigDecimal sumAmount = finBill.getBigDecimal("recamount");
        BigDecimal sumAmtLoc = finBill.getBigDecimal("reclocalamt");
        DynamicObjectCollection newPlanEntry = finBill.getDynamicObjectCollection("planentity");
        DynamicObject newPlanRow = new DynamicObject(newPlanEntry.getDynamicObjectType());
        newPlanRow.set("planduedate", (Object)finBill.getDate("duedate"));
        newPlanRow.set("planpricetax", (Object)sumAmount);
        newPlanRow.set("planpricetaxloc", (Object)sumAmtLoc);
        newPlanRow.set("unplansettleamt", (Object)sumAmount);
        newPlanRow.set("unplansettlelocamt", (Object)sumAmtLoc);
        newPlanRow.set("plansettledamt", (Object)zero);
        newPlanRow.set("plansettledlocamt", (Object)zero);
        newPlanRow.set("unplanlockamt", (Object)sumAmount);
        newPlanRow.set("planlockedamt", (Object)zero);
        newPlanRow.set("seq", (Object)(newPlanEntry.size() + 1));
        newPlanEntry.add((Object)newPlanRow);
    }

    public static void lockedPlan(Long srcBillId, BigDecimal lockedAmt) {
        String selector = "id,planentity.id,planentity.planlockedamt,planentity.unplanlockamt";
        QFilter filter = new QFilter("id", "=", (Object)srcBillId);
        filter.and("planentity.unplanlockamt", ">", (Object)zero);
        DynamicObjectCollection plans = QueryServiceHelper.query((String)"ar_finarbill", (String)selector, (QFilter[])new QFilter[]{filter}, (String)"planentity.seq asc");
        if (plans.size() < 1) {
            return;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        long modifierId = RequestContext.get().getCurrUserId();
        Date modifyTime = Date.from(Instant.now());
        for (DynamicObject plan : plans) {
            BigDecimal unPlanLockAmt = plan.getBigDecimal("planentity.unplanlockamt");
            if (zero.compareTo(unPlanLockAmt) >= 0) continue;
            if (lockedAmt.compareTo(unPlanLockAmt) > 0) {
                paramList.add(new Object[]{unPlanLockAmt, unPlanLockAmt, modifierId, modifyTime, plan.getLong("planentity.id")});
                lockedAmt = lockedAmt.subtract(unPlanLockAmt);
                continue;
            }
            paramList.add(new Object[]{lockedAmt, lockedAmt, modifierId, modifyTime, plan.getLong("planentity.id")});
            break;
        }
        String sql = "update t_ar_finarplanentry set fplanlockedamt = fplanlockedamt+?,funplanlockamt = funplanlockamt-?,fmodifierid = ?,fmodifytime = ? where fentryid=?";
        DB.executeBatch((DBRoute)DBRouteConst.AP, (String)sql, paramList);
    }

    @Deprecated
    public static void unLockPlan(Object srcEntryId, BigDecimal unLockAmt) {
        QFilter qf = new QFilter("entry.id", "=", srcEntryId);
        qf.and("recamount", "=", (Object)BigDecimal.ZERO);
        boolean isZeroBill = QueryServiceHelper.exists((String)"ar_finarbill", (QFilter[])new QFilter[]{qf});
        String selector = "id,planentity.id,planentity.planlockedamt,planentity.unplanlockamt";
        QFilter filter = new QFilter("entry.id", "=", srcEntryId);
        DynamicObjectCollection plans = QueryServiceHelper.query((String)"ar_finarbill", (String)selector, (QFilter[])new QFilter[]{filter}, (String)"planentity.seq desc");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        long modifierId = RequestContext.get().getCurrUserId();
        Date modifyTime = Date.from(Instant.now());
        for (DynamicObject plan : plans) {
            if (isZeroBill) {
                paramList.add(new Object[]{unLockAmt, unLockAmt, modifierId, modifyTime, plan.getLong("planentity.id")});
                continue;
            }
            BigDecimal planLockedAmt = plan.getBigDecimal("planentity.planlockedamt");
            if (zero.compareTo(planLockedAmt) >= 0) continue;
            if (unLockAmt.compareTo(planLockedAmt) > 0) {
                paramList.add(new Object[]{planLockedAmt, planLockedAmt, modifierId, modifyTime, plan.getLong("planentity.id")});
                unLockAmt = unLockAmt.subtract(planLockedAmt);
                continue;
            }
            paramList.add(new Object[]{unLockAmt, unLockAmt, modifierId, modifyTime, plan.getLong("planentity.id")});
            break;
        }
        String sql = "update t_ar_finarplanentry set fplanlockedamt = fplanlockedamt-?,funplanlockamt = funplanlockamt+?,fmodifierid = ?,fmodifytime = ? where fentryid=?";
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRouteConst.AP, (String)sql, paramList);
        }
    }

    public static void unLockPlan(long sourceBillId, Object srcEntryId, BigDecimal unLockAmt) {
        QFilter qf = new QFilter("id", "=", (Object)sourceBillId);
        qf.and(new QFilter("entry.id", "=", srcEntryId));
        qf.and("recamount", "=", (Object)BigDecimal.ZERO);
        boolean isZeroBill = QueryServiceHelper.exists((String)"ar_finarbill", (QFilter[])new QFilter[]{qf});
        String selector = "id,planentity.id,planentity.planlockedamt,planentity.unplanlockamt,planentity.planpricetax";
        QFilter filter = new QFilter("id", "=", (Object)sourceBillId);
        filter.and(new QFilter("entry.id", "=", srcEntryId));
        DynamicObjectCollection plans = QueryServiceHelper.query((String)"ar_finarbill", (String)selector, (QFilter[])new QFilter[]{filter}, (String)"planentity.seq desc");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        long modifierId = RequestContext.get().getCurrUserId();
        Date modifyTime = Date.from(Instant.now());
        for (DynamicObject plan : plans) {
            if (isZeroBill) {
                paramList.add(new Object[]{unLockAmt, unLockAmt, modifierId, modifyTime, plan.getLong("planentity.id"), sourceBillId});
                continue;
            }
            BigDecimal planPriceTax = plan.getBigDecimal("planentity.planpricetax");
            BigDecimal planLockedAmt = plan.getBigDecimal("planentity.planlockedamt");
            if (planPriceTax.signum() == 0 || planPriceTax.signum() > 0 && planLockedAmt.signum() <= 0 || planPriceTax.signum() < 0 && planLockedAmt.signum() >= 0) continue;
            if (unLockAmt.compareTo(planLockedAmt) > 0) {
                paramList.add(new Object[]{planLockedAmt, planLockedAmt, modifierId, modifyTime, plan.getLong("planentity.id"), sourceBillId});
                unLockAmt = unLockAmt.subtract(planLockedAmt);
                continue;
            }
            paramList.add(new Object[]{unLockAmt, unLockAmt, modifierId, modifyTime, plan.getLong("planentity.id"), sourceBillId});
            break;
        }
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_ar_finarplan", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, (Object)sourceBillId)});){
            String sql = "update t_ar_finarplanentry set fplanlockedamt = fplanlockedamt-?,funplanlockamt = funplanlockamt+?,fmodifierid = ?,fmodifytime = ? where fentryid=? and fid = ?";
            if (!paramList.isEmpty()) {
                DB.executeBatch((DBRoute)DBRouteConst.AP, (String)sql, paramList);
            }
        }
    }
}

