/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.List;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;

public class OperationHelper {
    public static void assertResult(OperationResult result) {
        OperationHelper.assertResult(null, result);
    }

    public static void assertResult(String entityKey, OperationResult result) {
        String entityName = "";
        if (entityKey != null) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityKey);
            entityName = dt.getDisplayName().getLocaleValue();
        }
        if (result.isSuccess()) {
            return;
        }
        List validateInfos = result.getAllErrorOrValidateInfo();
        if (validateInfos == null || validateInfos.isEmpty()) {
            throw new KDBizException(entityName + result.getMessage());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(entityName);
        for (IOperateInfo err : validateInfos) {
            sb.append(err.getMessage()).append('\n');
        }
        ErrorCode errorCode = new ErrorCode("ARAP_OPERATION_RESULT", sb.toString());
        throw new KDBizException(errorCode, new Object[0]);
    }
}

