/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OrgHelper {
    public static final String ORGTYPE_BANKROLL = "fisbankroll";
    public static final String ORGTYPE_SALE = "fissale";
    public static final String ORGTYPE_ACCOUNT = "fisaccounting";

    @Deprecated
    public static DynamicObjectCollection getAuthorizedBankOrg(Long userID, String entityID, String permissionItem, String attributes) {
        return OrgHelper.getAuthorizedBankOrgByAppId(userID, "ar", entityID, permissionItem, attributes);
    }

    @Deprecated
    public static DynamicObjectCollection getAuthorizedBankOrgByAppId(Long userID, String appId, String entityID, String permissionItem, String attributes) {
        Map orgMap;
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter functionFilter = new QFilter(attributes, "=", (Object)Boolean.TRUE);
        String selector = "id,number,name,fisaccounting,fisbankroll,fissale,fispurchase";
        if (result.hasAllOrgPerm()) {
            orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)selector, (QFilter[])new QFilter[]{enableFilter, functionFilter});
        } else {
            List orgIdList = result.getHasPermOrgs();
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
            orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)selector, (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter});
        }
        DynamicObjectCollection orgColl = new DynamicObjectCollection();
        for (DynamicObject org : orgMap.values()) {
            orgColl.add((Object)org);
        }
        return orgColl;
    }

    @Deprecated
    public static DynamicObjectCollection getAuthorizedBankOrg(String entityID, String permissionItem) {
        Long userId = RequestContext.get().getCurrUserId();
        return OrgHelper.getAuthorizedBankOrg(userId, entityID, permissionItem, ORGTYPE_ACCOUNT);
    }

    @Deprecated
    public static DynamicObjectCollection getAuthorizedBankOrgByAppId(String appId, String entityID, String permissionItem) {
        Long userId = RequestContext.get().getCurrUserId();
        return OrgHelper.getAuthorizedBankOrgByAppId(userId, appId, entityID, permissionItem, ORGTYPE_ACCOUNT);
    }

    public static List<DynamicObject> getAuthorizedInitializedOrgs(String entityID, String permissionItem, boolean isAr) {
        List<Long> idList = OrgHelper.getAuthorizedBankOrgIds(isAr ? "ar" : "ap", entityID, permissionItem);
        DynamicObject[] initInfos = BusinessDataServiceHelper.load((String)OrgHelper.getInitEntityKey(isAr), (String)"id,org", (QFilter[])new QFilter[]{new QFilter("org", "in", idList), new QFilter("isfinishinit", "=", (Object)Boolean.TRUE)});
        ArrayList<DynamicObject> orgs = new ArrayList<DynamicObject>(64);
        for (DynamicObject initInfo : initInfos) {
            orgs.add(initInfo.getDynamicObject("org"));
        }
        return orgs;
    }

    public static List<DynamicObject> getAuthorizedInitializedOrgs(String entityID, String permissionItem) {
        List<Long> arIdList = OrgHelper.getAuthorizedBankOrgIds("ar", entityID, permissionItem);
        List<Long> apIdList = OrgHelper.getAuthorizedBankOrgIds("ap", entityID, permissionItem);
        QFilter[] filterAr = new QFilter("org", "in", arIdList).and(new QFilter("isfinishinit", "=", (Object)Boolean.TRUE)).toArray();
        DynamicObject[] arInitInfos = BusinessDataServiceHelper.load((String)"ar_init", (String)"id,org", (QFilter[])filterAr);
        QFilter[] filterAp = new QFilter("org", "in", apIdList).and(new QFilter("isfinishinit", "=", (Object)Boolean.TRUE)).toArray();
        DynamicObject[] apInitInfos = BusinessDataServiceHelper.load((String)"ap_init", (String)"id,org", (QFilter[])filterAp);
        return Stream.concat(Stream.of(arInitInfos), Stream.of(apInitInfos)).map(dyb -> dyb.getDynamicObject("org")).collect(Collectors.toList());
    }

    public static DynamicObject getAuthorizedBankOrg(String appId, String entityID, String permissionItem) {
        DynamicObject org;
        Long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter functionFilter = new QFilter(ORGTYPE_ACCOUNT, "=", (Object)Boolean.TRUE);
        String selector = "id,number,name,fisaccounting,fisbankroll,fissale,fispurchase";
        if (result.hasAllOrgPerm()) {
            org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)selector, (QFilter[])new QFilter[]{enableFilter, functionFilter});
        } else {
            List orgIdList = result.getHasPermOrgs();
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
            org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)selector, (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter});
        }
        return org;
    }

    public static boolean checkloginOrg(boolean isAr) {
        long orgId = RequestContext.get().getOrgId();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter statusFilter = new QFilter("isfinishinit", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.exists((String)OrgHelper.getInitEntityKey(isAr), (QFilter[])new QFilter[]{orgFilter, statusFilter});
    }

    public static List<Long> getAuthorizedInitializedOrgIds(String entityID, String permissionItem, boolean isAr) {
        List<Long> idList = OrgHelper.getAuthorizedBankOrgIds(isAr ? "ar" : "ap", entityID, permissionItem);
        ArrayList<Long> orgIds = new ArrayList<Long>(idList.size());
        if (!idList.isEmpty()) {
            DataSet rows = QueryServiceHelper.queryDataSet((String)"getAuthorizedInitializedOrgIds", (String)OrgHelper.getInitEntityKey(isAr), (String)"id,org", (QFilter[])new QFilter[]{new QFilter("org", "in", idList), new QFilter("isfinishinit", "=", (Object)Boolean.TRUE)}, (String)"");
            for (Row row : rows) {
                orgIds.add(row.getLong("org"));
            }
        }
        return orgIds;
    }

    public static List<Long> getAuthorizedBankOrgIds(String appId, String entityID, String permissionItem) {
        Long userID = RequestContext.get().getCurrUserId();
        return OrgHelper.getAuthorizedBankOrgIds(userID, appId, entityID, permissionItem, ORGTYPE_ACCOUNT);
    }

    public static List<Long> getAuthorizedBankOrgIds(Long userID, String appId, String entityID, String permissionItem, String attributes) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter functionFilter = new QFilter(attributes, "=", (Object)Boolean.TRUE);
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        if (result.hasAllOrgPerm()) {
            DataSet rows = QueryServiceHelper.queryDataSet((String)"getAuthorizedBankOrgIds", (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{enableFilter, functionFilter}, (String)"");
            for (Row row : rows) {
                orgIds.add(row.getLong("id"));
            }
        } else {
            List orgIdList = result.getHasPermOrgs();
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
            DataSet rows = QueryServiceHelper.queryDataSet((String)"getAuthorizedBankOrgIds", (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter}, (String)"");
            for (Row row : rows) {
                orgIds.add(row.getLong("id"));
            }
        }
        return orgIds;
    }

    private static String getInitEntityKey(boolean isAr) {
        return isAr ? "ar_init" : "ap_init";
    }
}

