/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.ArApProcessParamsHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;
import kd.fi.arapcommon.service.helper.SettleLogHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;

public class PaySettle4ScmcHelper {
    private static final Log logger = LogFactory.getLog(PaySettle4ScmcHelper.class);

    public static void disposeCoreBillExceptScmc(List<Map<String, Object>> rowList, boolean settle) {
        if (!ObjectUtils.isEmpty(rowList)) {
            PaySettle4ScmcHelper.setDisposeParameterValue(rowList);
            PaySettle4ScmcHelper.disposeEcContractIncomeapply(rowList, settle);
            PaySettle4ScmcHelper.disposeEcContractPaymentapply(rowList, settle);
            PaySettle4ScmcHelper.disposeOmOutsourceBill(rowList, settle);
        }
    }

    @Deprecated
    public static void disposeCoreBill(List<Map<String, Object>> rowList, boolean settle) {
        if (!ObjectUtils.isEmpty(rowList)) {
            PaySettle4ScmcHelper.setDisposeParameterValue(rowList);
            PaySettle4ScmcHelper.disposePmOrder(rowList, settle);
            PaySettle4ScmcHelper.disposePmContract(rowList, settle);
            PaySettle4ScmcHelper.disposeSmOrder(rowList, settle);
            PaySettle4ScmcHelper.disposeSalContract(rowList, settle);
            PaySettle4ScmcHelper.disposeEcContractIncomeapply(rowList, settle);
            PaySettle4ScmcHelper.disposeEcContractPaymentapply(rowList, settle);
            PaySettle4ScmcHelper.disposeOmOutsourceBill(rowList, settle);
        }
    }

    @Deprecated
    public static void disposePmOrder(List<Map<String, Object>> rowList, boolean settle) {
        ArrayList<Map<String, Object>> orderRowList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : rowList) {
            if (!"pm_purorderbill".equals(row.get("mainbilltype")) || !"bd_supplier".equals(row.get("asstacttype"))) continue;
            orderRowList.add(row);
        }
        if (orderRowList.size() > 0) {
            SettleLogHelper.logInvokeScmcParam(orderRowList, settle);
            if (ECServiceHelper.isSettleWbOrderOpened()) {
                long uniqueKey = DB.genGlobalLongId();
                for (Map map : orderRowList) {
                    map.put("uniquekey", uniqueKey);
                }
                logger.info("disposePmOrder-consistency-true");
                CommonParam param = new CommonParam();
                param.put((Object)"list", orderRowList);
                ECServiceHelper.beginAndRegister("ap_settle", "ap_settle_wborder", "scmc", "pm", "WbPaidAmountService", (Param)param, "");
            } else {
                try (TXHandle tx = TX.requiresNew((String)"settleinvokeScmc");){
                    try {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurService", (String)"WbPaidAmount", (Object[])new Object[]{orderRowList});
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    @Deprecated
    public static void disposePmContract(List<Map<String, Object>> rowList, boolean settle) {
        ArrayList<Map<String, Object>> contractRowList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : rowList) {
            if (!"conm_purcontract".equals(row.get("mainbilltype")) || !"bd_supplier".equals(row.get("asstacttype"))) continue;
            contractRowList.add(row);
        }
        if (contractRowList.size() > 0) {
            SettleLogHelper.logInvokeScmcParam(contractRowList, settle);
            try (TXHandle tx = TX.requiresNew((String)"settleinvokeScmc");){
                try {
                    DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"PurConmService", (String)"WbPaidAmount", (Object[])new Object[]{contractRowList});
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    @Deprecated
    public static void disposeSmOrder(List<Map<String, Object>> rowList, boolean settle) {
        ArrayList<Map<String, Object>> orderRowList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : rowList) {
            if (!"sm_salorder".equals(row.get("mainbilltype")) || !"bd_customer".equals(row.get("asstacttype"))) continue;
            orderRowList.add(row);
        }
        if (orderRowList.size() > 0) {
            SettleLogHelper.logInvokeScmcParam(orderRowList, settle);
            if (ECServiceHelper.isSettleWbOrderOpened()) {
                long uniqueKey = DB.genGlobalLongId();
                for (Map map : orderRowList) {
                    map.put("uniquekey", uniqueKey);
                }
                logger.info("disposeSmOrder-consistency-true");
                CommonParam param = new CommonParam();
                param.put((Object)"list", orderRowList);
                ECServiceHelper.beginAndRegister("ar_settle", "ar_settle_wborder", "scmc", "sm", "WbRecAmountService", (Param)param, "");
            } else {
                try (TXHandle tx = TX.requiresNew((String)"settleinvokeScmc");){
                    try {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sm", (String)"SalService", (String)"wbPaidAmount", (Object[])new Object[]{orderRowList});
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    @Deprecated
    public static void disposeArToSalOrder(List<Map<String, Object>> params) {
        if (params.size() > 0) {
            if (ECServiceHelper.isSettleWbOrderAndConOpened()) {
                long uniqueKey = DB.genGlobalLongId();
                for (Map<String, Object> dispose : params) {
                    dispose.put("uniquekey", uniqueKey);
                }
                logger.info("disposeArToSalOrder-consistency-true");
                CommonParam param = new CommonParam();
                param.put((Object)"list", params);
                param.put((Object)"method", (Object)"wbSOAr");
                List<Object> arApBillIds = params.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
                logger.info("disposeArToSalOrder-maybe-lock-billid: " + arApBillIds);
                ECServiceHelper.beginAndRegisterWithBusInfo("ar_settle", "ar_settle_wborder", "scmc", "sm", "SalWbService", (Param)param, "", arApBillIds);
            } else {
                try (TXHandle tx = TX.requiresNew((String)"settleinvokeScmc");){
                    try {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sm", (String)"SalWbService", (String)"wbSOAr", (Object[])new Object[]{params});
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    @Deprecated
    public static void disposeArRevcfmToSalOrder(List<Map<String, Object>> params) {
        if (params.size() > 0) {
            if (ECServiceHelper.isSettleWbOrderAndConOpened()) {
                long uniqueKey = DB.genGlobalLongId();
                for (Map<String, Object> dispose : params) {
                    dispose.put("uniquekey", uniqueKey);
                }
                logger.info("disposeArRevcfmToSalOrder-consistency-true");
                CommonParam param = new CommonParam();
                param.put((Object)"list", params);
                param.put((Object)"method", (Object)"wbSORevCfm");
                List<Object> arApBillIds = params.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
                logger.info("disposeArRevcfmToSalOrder-maybe-lock-billid: " + arApBillIds);
                ECServiceHelper.beginAndRegisterWithBusInfo("ar_settle", "ar_settle_wborder", "scmc", "sm", "SalWbService", (Param)param, "", arApBillIds);
            } else {
                try (TXHandle tx = TX.requiresNew((String)"settleinvokeScmc");){
                    try {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sm", (String)"SalWbService", (String)"wbSORevCfm", (Object[])new Object[]{params});
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    @Deprecated
    public static void disposeSaleCont(List<Map<String, Object>> params) {
        if (params.size() > 0) {
            if (ECServiceHelper.isSettleWbOrderAndConOpened()) {
                long uniqueKey = DB.genGlobalLongId();
                for (Map<String, Object> dispose : params) {
                    dispose.put("uniquekey", uniqueKey);
                }
                logger.info("disposeSaleCont-consistency-true");
                CommonParam param = new CommonParam();
                param.put((Object)"list", params);
                param.put((Object)"method", (Object)"wbSalContAr");
                logger.info("disposeSaleCont-pararms: " + params);
                List<Object> arApBillIds = params.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
                logger.info("disposeSaleCont-maybe-lock-billid: " + arApBillIds);
                ECServiceHelper.beginAndRegisterWithBusInfo("ar_settle", "ar_settle_wbconm", "scmc", "conm", "SalConmService", (Param)param, "", arApBillIds);
            } else {
                try (TXHandle tx = TX.requiresNew((String)"settleinvokeScmc");){
                    try {
                        DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"SalConmService", (String)"wbSalContAr", (Object[])new Object[]{params});
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
            }
        }
    }

    @Deprecated
    public static void disposeSalContract(List<Map<String, Object>> rowList, boolean settle) {
        ArrayList<Map<String, Object>> contractRowList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : rowList) {
            if (!"conm_salcontract".equals(row.get("mainbilltype")) || !"bd_customer".equals(row.get("asstacttype"))) continue;
            contractRowList.add(row);
        }
        if (contractRowList.size() > 0) {
            SettleLogHelper.logInvokeScmcParam(contractRowList, settle);
            try (TXHandle tx = TX.requiresNew((String)"settleinvokeScmc");){
                try {
                    DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"SalConmService", (String)"WbRecAmount", (Object[])new Object[]{contractRowList});
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    public static void disposeEcContractIncomeapply(List<Map<String, Object>> rowList, boolean settle) {
        ArrayList<Map<String, Object>> orderRowList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : rowList) {
            if (!"ec_incomeapply".equals(row.get("mainbilltype"))) continue;
            orderRowList.add(row);
        }
        if (orderRowList.size() > 0) {
            SettleLogHelper.logInvokeScmcParam(orderRowList, settle);
            try (TXHandle tx = TX.requiresNew((String)"settleinvokeEc");){
                try {
                    DispatchServiceHelper.invokeBizService((String)"ec", (String)"contract", (String)"ApplyAmoutUpdateService", (String)"applyAmountUpdate", (Object[])new Object[]{orderRowList});
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    public static void disposeEcContractPaymentapply(List<Map<String, Object>> rowList, boolean settle) {
        ArrayList<Map<String, Object>> orderRowList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : rowList) {
            if (!"ec_paymentapply".equals(row.get("mainbilltype"))) continue;
            orderRowList.add(row);
        }
        if (orderRowList.size() > 0) {
            SettleLogHelper.logInvokeScmcParam(orderRowList, settle);
            try (TXHandle tx = TX.requiresNew((String)"settleinvokeEc");){
                try {
                    DispatchServiceHelper.invokeBizService((String)"ec", (String)"contract", (String)"ApplyAmoutUpdateService", (String)"applyAmountUpdate", (Object[])new Object[]{orderRowList});
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    public static void disposeFeeBill(Collection<DynamicObject> objColl, boolean settle) {
        if (!ObjectUtils.isEmpty(objColl)) {
            ArrayList billObject = new ArrayList();
            for (DynamicObject obj : objColl) {
                String sourceBillType = obj.getString("sourcebilltype");
                if (!"er_publicreimbursebill".equals(sourceBillType)) continue;
                DynamicObjectCollection entryColl = obj.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : entryColl) {
                    HashMap<String, Object> detail = new HashMap<String, Object>();
                    detail.put("billId", entry.getLong("e_sourcebillid"));
                    detail.put("billEntryId", entry.getLong("e_sourcebillentryid"));
                    detail.put("settleStatus", obj.getString("settlestatus"));
                    billObject.add(detail);
                }
            }
            if (billObject.size() > 0) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("operateName", settle ? "settle" : "unsettle");
                result.put("billObject", billObject);
                result.put("sourceEntityName", "er_publicreimbursebill");
                result.put("targetEntityName", "ap_finapbill");
                logger.info("------begin invoke er service-----" + result.size() + result);
                CommonParam param = new CommonParam();
                param.put((Object)"result", result);
                ECServiceHelper.beginAndRegister("ap_settle", "ap_settle_wbfee", "fi", "ap", "ApSettleWBFeeEC", (Param)param, "");
            }
        }
    }

    public static void disposeOmOutsourceBill(List<Map<String, Object>> rowList, boolean settle) {
        ArrayList<Map<String, Object>> orderRowList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : rowList) {
            if (!"pm_om_purorderbill".equals(row.get("mainbilltype"))) continue;
            orderRowList.add(row);
        }
        if (orderRowList.size() > 0) {
            SettleLogHelper.logInvokeScmcParam(orderRowList, settle);
            try (TXHandle tx = TX.requiresNew((String)"settleinvokeOm");){
                try {
                    DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurMoService", (String)"WbPaidAmount", (Object[])new Object[]{orderRowList});
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    @Deprecated
    public static void invokeSm(List<SettleRecordVO> resultList, boolean settle) {
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        for (SettleRecordVO vo : resultList) {
            if (vo.getCorebillId() <= 0L) continue;
            List<SettleRecordEntryVO> entrys = vo.getEntrys();
            for (SettleRecordEntryVO entryVo : entrys) {
                HashMap<String, Number> row = new HashMap<String, Number>();
                row.put("mainbillid", vo.getCorebillId());
                row.put("mainbillentryid", vo.getCorebillEntryId());
                row.put("apbillid", vo.getMainBillId());
                row.put("apbillentryid", vo.getMainBillEntryId());
                row.put("currencyid", entryVo.getCurrencyId());
                BigDecimal settleAmt = entryVo.getSettleAmt();
                if (SettleRelationEnum.ARPAYSETTLE.getValue().equals(vo.getSettleRela())) {
                    settleAmt = settleAmt.negate();
                }
                row.put("paidamount", settle ? settleAmt : settleAmt.negate());
                rowList.add(row);
            }
        }
        if (rowList.size() > 0) {
            SettleLogHelper.logInvokeScmcParam(rowList, settle);
            try (TXHandle tx = TX.requiresNew((String)"settleinvokeSm");){
                try {
                    DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sm", (String)"SalService", (String)"wbPaidAmount", (Object[])new Object[]{rowList});
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    @Deprecated
    public static void invokeScmc(List<SettleRecordVO> resultList, boolean settle) {
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        for (SettleRecordVO vo : resultList) {
            if (vo.getCorebillId() <= 0L) continue;
            List<SettleRecordEntryVO> entrys = vo.getEntrys();
            for (SettleRecordEntryVO entryVo : entrys) {
                HashMap<String, Number> row = new HashMap<String, Number>();
                row.put("mainbillid", vo.getCorebillId());
                row.put("mainbillentryid", vo.getCorebillEntryId());
                row.put("apbillid", vo.getMainBillId());
                row.put("apbillentryid", vo.getMainBillEntryId());
                row.put("currencyid", entryVo.getCurrencyId());
                BigDecimal settleAmt = entryVo.getSettleAmt();
                if (SettleRelationEnum.APRECSETTLE.getValue().equals(vo.getSettleRela())) {
                    settleAmt = settleAmt.negate();
                }
                row.put("paidamount", settle ? settleAmt : settleAmt.negate());
                rowList.add(row);
            }
        }
        if (rowList.size() > 0) {
            SettleLogHelper.logInvokeScmcParam(rowList, settle);
            try (TXHandle tx = TX.requiresNew((String)"settleinvokeScmc");){
                try {
                    DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurService", (String)"WbPaidAmount", (Object[])new Object[]{rowList});
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private static void setDisposeParameterValue(List<Map<String, Object>> rowList) {
        Map<Object, List<Map>> rowMap = rowList.stream().collect(Collectors.groupingBy(row -> row.get("asstacttype")));
        HashMap<Long, Boolean> internalMap = new HashMap<Long, Boolean>(8);
        for (Map.Entry<Object, List<Map>> entry : rowMap.entrySet()) {
            String asstactType = String.valueOf(entry.getKey());
            List<Map> rows = entry.getValue();
            Set asstactIds = rows.stream().map(row -> Long.parseLong(String.valueOf(row.get("asstactid")))).collect(Collectors.toSet());
            DynamicObjectCollection asstacts = new DynamicObjectCollection();
            if ("bd_supplier".equals(asstactType) || "bd_customer".equals(asstactType)) {
                asstacts = QueryServiceHelper.query((String)asstactType, (String)"id,internal_company", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
            }
            if (ObjectUtils.isEmpty((Object)asstacts)) continue;
            Map<Long, Long> asstactMap = asstacts.stream().collect(Collectors.toMap(asstact -> asstact.getLong("id"), asstact -> asstact.getLong("internal_company")));
            for (Map row2 : rows) {
                long asstactId = Long.parseLong(String.valueOf(row2.get("asstactid")));
                Boolean internal = (Boolean)internalMap.get(asstactId);
                if (!ObjectUtils.isEmpty((Object)internal)) continue;
                if (asstactMap.get(asstactId) == null || asstactMap.get(asstactId) == 0L) {
                    internalMap.put(asstactId, Boolean.FALSE);
                    continue;
                }
                internalMap.put(asstactId, Boolean.TRUE);
            }
        }
        for (Map map : rowList) {
            long asstactId = Long.parseLong(String.valueOf(map.get("asstactid")));
            map.put("internal_company", internalMap.getOrDefault(asstactId, false));
        }
    }

    @Deprecated
    public static void writeBackPmOrder(List<Map<String, Object>> rowList, boolean settle) {
        if (EmptyUtils.isEmpty(rowList)) {
            return;
        }
        logger.info("writeBackPmOrder - param is : " + rowList);
        if (ECServiceHelper.isSettleWbOrderAndConOpened()) {
            long uniqueKey = DB.genGlobalLongId();
            for (Map<String, Object> param : rowList) {
                param.put("uniquekey", uniqueKey);
            }
            logger.info("writeBackPmOrder-consistency-true");
            CommonParam param = new CommonParam();
            param.put((Object)"list", rowList);
            List<Object> arApBillIds = rowList.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
            logger.info("writeBackPmOrder-maybe-lock-billid: " + arApBillIds);
            ECServiceHelper.beginAndRegisterWithBusInfo("ap_settle", "ap_settle_wborder", "scmc", "pm", "WbApQtyAndAmountService", (Param)param, "", arApBillIds);
        } else {
            try (TXHandle tx = TX.requiresNew((String)"writeBackPmOrder");){
                try {
                    Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurFiService", (String)"WbApQtyAndAmount", (Object[])new Object[]{rowList});
                    if (result != null && !Boolean.TRUE.equals(result.get("success"))) {
                        throw new KDBizException(String.valueOf(result.get("message")));
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    @Deprecated
    public static void writeBackContract(List<Map<String, Object>> rowList, boolean settle) {
        if (EmptyUtils.isEmpty(rowList)) {
            return;
        }
        logger.info("writeBackContract - param is : " + rowList);
        if (ECServiceHelper.isSettleWbOrderAndConOpened()) {
            long uniqueKey = DB.genGlobalLongId();
            for (Map<String, Object> param : rowList) {
                param.put("uniquekey", uniqueKey);
            }
            logger.info("writeBackContract-consistency-true");
            CommonParam param = new CommonParam();
            param.put((Object)"list", rowList);
            param.put((Object)"method", (Object)"wbPurContAp");
            List<Object> arApBillIds = rowList.stream().filter(row -> row.get("ArApBillId") != null).map(row -> row.get("ArApBillId")).distinct().collect(Collectors.toList());
            logger.info("writeBackContract-maybe-lock-billid: " + arApBillIds);
            ECServiceHelper.beginAndRegisterWithBusInfo("ap_settle", "ap_settle_wbconm", "scmc", "conm", "PurConmService", (Param)param, "", arApBillIds);
        } else {
            logger.info("writeBackContract use ordinary interface ");
            try (TXHandle tx = TX.requiresNew((String)"writeBackContract");){
                try {
                    DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"PurConmService", (String)"wbPurContAp", (Object[])new Object[]{rowList});
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    @Deprecated
    public static void writeBackScmcBill(DynamicObject[] entities, boolean isSettle) {
        ArApProcessParamsHelper.writeBackScmcBill(entities, isSettle);
    }
}

