/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.botp.helper.SystemStatusCtrolHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PeriodHelper {
    private static final String SELETOR = "id,number,name,periodyear,periodnumber,isadjustperiod,periodtype,begindate,enddate";

    public static long getPeriodTypeId(long orgId) {
        DynamicObject periodType = SystemStatusCtrolHelper.getPeriodType((long)orgId);
        return periodType == null ? 0L : periodType.getLong("id");
    }

    public static DynamicObjectCollection getPeriodList(long periodTypeId) {
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)periodTypeId), new QFilter("isadjustperiod", "=", (Object)"0")};
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_period");
        Map periodMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)entityType, (QFilter[])filters);
        DynamicObjectCollection periodColl = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        for (DynamicObject period : periodMap.values()) {
            periodColl.add((Object)period);
        }
        return periodColl;
    }

    public static DynamicObject[] getPeriodListOrder(long periodTypeId) {
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)periodTypeId), new QFilter("isadjustperiod", "=", (Object)"0")};
        Map periodMap = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)SELETOR, (QFilter[])filters, (String)"enddate desc");
        return periodMap.values().toArray(new DynamicObject[0]);
    }

    public static DynamicObject getPeriodByDate(long orgId, Date date) {
        long periodTypeId = PeriodHelper.getPeriodTypeId(orgId);
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date), new QFilter("periodtype", "=", (Object)periodTypeId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }

    public static DynamicObject getPeriodByDateAndPeriodType(long periodTypeId, Date date) {
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)date), new QFilter("enddate", ">=", (Object)date), new QFilter("periodtype", "=", (Object)periodTypeId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }

    public static DynamicObject getPeriodById(long id) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bd_period", (String)SELETOR);
    }

    public static DynamicObject getPeriodByYearAndNumber(long periodtypeId, int periodyear, int periodnumber) {
        return PeriodHelper.getPeriodByYearAndNumberNoT(periodtypeId, periodyear, periodnumber, true);
    }

    public static DynamicObject getPeriodByYearAndNumberNoT(long periodtypeId, int periodyear, int periodnumber, boolean isAdjustPeriod) {
        QFilter[] filters = new QFilter[]{new QFilter("periodyear", "=", (Object)periodyear), new QFilter("periodnumber", "=", (Object)periodnumber), new QFilter("periodtype", "=", (Object)periodtypeId), new QFilter("isadjustperiod", "=", (Object)isAdjustPeriod)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])filters);
    }

    public static DynamicObject getNextPeriod(long id) {
        DynamicObject period = PeriodHelper.getPeriodById(id);
        int periodYear = period.getInt("periodyear");
        int periodNumber = period.getInt("periodnumber");
        if (periodNumber < 12) {
            ++periodNumber;
        } else {
            ++periodYear;
            periodNumber = 1;
        }
        DynamicObject nextPeriod = PeriodHelper.getPeriodByYearAndNumberNoT(period.getDynamicObject("periodtype").getLong("id"), periodYear, periodNumber, false);
        return nextPeriod;
    }

    public static DynamicObject getNextPeriodByDo(DynamicObject period) {
        int periodYear = period.getInt("periodyear");
        int periodNumber = period.getInt("periodnumber");
        if (periodNumber < 12) {
            ++periodNumber;
        } else {
            ++periodYear;
            periodNumber = 1;
        }
        DynamicObject nextPeriod = PeriodHelper.getPeriodByYearAndNumberNoT(period.getDynamicObject("periodtype").getLong("id"), periodYear, periodNumber, false);
        return nextPeriod;
    }

    public static DynamicObject getPrevPeriod(long id) {
        DynamicObject period = PeriodHelper.getPeriodById(id);
        return PeriodHelper.getPrevPeriodByDO(period);
    }

    public static DynamicObject getPrevPeriodByDO(DynamicObject period) {
        if (period == null) {
            return null;
        }
        int periodYear = period.getInt("periodyear");
        int periodNumber = period.getInt("periodnumber");
        if (periodNumber > 1) {
            --periodNumber;
        } else {
            --periodYear;
            periodNumber = 12;
        }
        DynamicObject nextPeriod = PeriodHelper.getPeriodByYearAndNumberNoT(period.getDynamicObject("periodtype").getLong("id"), periodYear, periodNumber, false);
        return nextPeriod;
    }

    public static List<Long> getPrevPeriod(Collection<DynamicObject> periods) {
        ArrayList<Long> prePeriodPks = new ArrayList<Long>(8);
        for (DynamicObject period : periods) {
            int periodYear = period.getInt("periodyear");
            int periodNumber = period.getInt("periodnumber");
            if (periodNumber > 1) {
                --periodNumber;
            } else {
                --periodYear;
                periodNumber = 12;
            }
            QFilter[] filters = new QFilter[]{new QFilter("periodyear", "=", (Object)periodYear), new QFilter("periodnumber", "=", (Object)periodNumber), new QFilter("periodtype", "=", (Object)period.getDynamicObject("periodtype").getLong("id"))};
            DynamicObject prePeriod = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"id", (QFilter[])filters);
            prePeriodPks.add(prePeriod.getLong("id"));
        }
        return prePeriodPks;
    }

    public static boolean before(DynamicObject period1, DynamicObject period2) {
        if (period1 == null || period2 == null) {
            return false;
        }
        return period1.getInt("periodyear") < period2.getInt("periodyear") || period1.getInt("periodyear") == period2.getInt("periodyear") && period1.getInt("periodnumber") < period2.getInt("periodnumber");
    }

    public static boolean beforeEquals(DynamicObject period1, DynamicObject period2) {
        if (period1 == null || period2 == null) {
            return false;
        }
        return period1.getInt("periodyear") < period2.getInt("periodyear") || period1.getInt("periodyear") == period2.getInt("periodyear") && period1.getInt("periodnumber") <= period2.getInt("periodnumber");
    }

    public static boolean after(DynamicObject period1, DynamicObject period2) {
        if (period1 == null || period2 == null) {
            return false;
        }
        return period1.getInt("periodyear") > period2.getInt("periodyear") || period1.getInt("periodyear") == period2.getInt("periodyear") && period1.getInt("periodnumber") > period2.getInt("periodnumber");
    }

    public static boolean afterEquals(DynamicObject period1, DynamicObject period2) {
        if (period1 == null || period2 == null) {
            return false;
        }
        return period1.getInt("periodyear") > period2.getInt("periodyear") || period1.getInt("periodyear") == period2.getInt("periodyear") && period1.getInt("periodnumber") >= period2.getInt("periodnumber");
    }

    public static boolean identical(DynamicObject period1, DynamicObject period2) {
        if (period1 == null || period2 == null) {
            return false;
        }
        return period1.getInt("periodyear") == period2.getInt("periodyear") && period1.getInt("periodnumber") == period2.getInt("periodnumber");
    }

    public static DynamicObject getLastPeriod(long orgid) {
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)PeriodHelper.getPeriodTypeId(orgid))};
        Map periodArrMap = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)SELETOR, (QFilter[])filters, (String)"begindate desc");
        return periodArrMap != null && periodArrMap.size() > 0 ? periodArrMap.values().toArray(new DynamicObject[0])[0] : null;
    }

    public static List<DynamicObject> getOriginPeriods(long orgId) {
        ArrayList<DynamicObject> nearstPeriods = new ArrayList<DynamicObject>(10);
        DynamicObject startPeriod = SystemStatusCtrolHelper.getStartPeriod((long)orgId);
        DynamicObject currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod((long)orgId);
        if (null == startPeriod || null == currentPeriod) {
            return nearstPeriods;
        }
        nearstPeriods.add(currentPeriod);
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)PeriodHelper.getPeriodTypeId(orgId)), new QFilter("begindate", "<", (Object)currentPeriod.getDate("begindate")), new QFilter("begindate", ">=", (Object)startPeriod.getDate("begindate"))};
        Map periods = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)SELETOR, (QFilter[])filters, (String)"begindate desc");
        nearstPeriods.addAll(periods.values());
        return nearstPeriods;
    }

    public static DynamicObject getCasInitInfo(long orgId) {
        return SystemStatusCtrolHelper.getSystemStatusCtrol((long)orgId);
    }

    public static DynamicObject getBeginPeriod(Long orgId, DynamicObject cPeriod, Date endDate) {
        if (cPeriod == null) {
            return null;
        }
        Date cPeriodEndDate = cPeriod.getDate("enddate");
        if (endDate.after(cPeriodEndDate)) {
            return cPeriod;
        }
        return PeriodHelper.getPeriodByDate(orgId, endDate);
    }
}

