/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;

public class QuotationHelper {
    private final Map<String, Tuple<String, BigDecimal>> exchangeCache = new HashMap<String, Tuple<String, BigDecimal>>(8);

    public void getExchangeRate4Import(IDataModel model) {
        DynamicObject srcCurrency = (DynamicObject)model.getValue("currency");
        DynamicObject destCurrency = (DynamicObject)model.getValue("basecurrency");
        DynamicObject exrateTable = (DynamicObject)model.getValue("exratetable");
        BigDecimal srcExchangeRate = (BigDecimal)model.getValue("exchangerate");
        boolean noSrcExchange = (srcExchangeRate = this.converExchange(srcExchangeRate)).compareTo(BigDecimal.ZERO) == 0;
        long srcCurrencyId = srcCurrency.getLong("id");
        long destCurrencyId = destCurrency.getLong("id");
        long exrateTableId = exrateTable.getLong("id");
        Date exrateDate = (Date)model.getValue("exratedate");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String strExrateDate = formatter.format(exrateDate);
        String exchangeId = srcCurrencyId + "_" + destCurrencyId + "_" + exrateTableId + "_" + strExrateDate;
        Tuple tuple = this.exchangeCache.get(exchangeId);
        if (tuple == null) {
            Map<String, Object> exrateMap = BaseDataHelper.getExchangeRateMap(exrateTableId, srcCurrencyId, destCurrencyId, exrateDate);
            if (exrateMap != null) {
                boolean quoteType = (Boolean)exrateMap.get("quoteType");
                String quotation = quoteType ? "1" : "0";
                model.setValue("quotation", (Object)quotation);
                BigDecimal exchangeRate = (BigDecimal)exrateMap.get("exchangeRate");
                model.setValue("exchangerate", (Object)exchangeRate);
                tuple = Tuple.create((Object)quotation, (Object)exchangeRate);
                this.exchangeCache.put(exchangeId, (Tuple<String, BigDecimal>)tuple);
            }
        } else {
            model.setValue("quotation", tuple.item1);
            model.setValue("exchangerate", tuple.item2);
        }
        if (!noSrcExchange) {
            model.setValue("exchangerate", (Object)srcExchangeRate);
        }
    }

    private BigDecimal converExchange(BigDecimal srcExchangeRate) {
        if (srcExchangeRate.compareTo(BigDecimal.ONE) == 0) {
            srcExchangeRate = BigDecimal.ZERO;
        }
        return srcExchangeRate;
    }

    public static void getExchangeRate(IDataModel model) {
        String quotation;
        DynamicObject srcCurrency = (DynamicObject)model.getValue("currency");
        DynamicObject destCurrency = (DynamicObject)model.getValue("basecurrency");
        DynamicObject exrateTable = (DynamicObject)model.getValue("exratetable");
        BigDecimal srcExchangeRate = (BigDecimal)model.getValue("exchangerate");
        long srcCurrencyId = srcCurrency.getLong("id");
        long destCurrencyId = destCurrency.getLong("id");
        long exrateTableId = exrateTable.getLong("id");
        Date exrateDate = (Date)model.getValue("exratedate");
        boolean isIndirect = BaseDataServiceHelper.getRateConversionConfig((Long)srcCurrencyId, (Long)destCurrencyId, (Date)exrateDate);
        String srcquotation = isIndirect ? "2" : "1";
        String string = quotation = isIndirect ? "1" : "0";
        if (srcExchangeRate.compareTo(BigDecimal.ONE) == 0) {
            BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exrateTableId, (Long)srcCurrencyId, (Long)destCurrencyId, (String)srcquotation, (Date)exrateDate);
            if (exchangeRate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u6c47\u7387\u4e3a\u7a7a\u3002", (String)"QuotationHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            model.setValue("exchangerate", (Object)exchangeRate);
        }
        model.setValue("quotation", (Object)quotation);
    }

    public static BigDecimal getLocamtByQuotation(String quotation, BigDecimal srcAmt, BigDecimal exchangeRate, int amtprecision) {
        if ("1".equals(quotation)) {
            return srcAmt.divide(exchangeRate, amtprecision, RoundingMode.HALF_UP);
        }
        return srcAmt.multiply(exchangeRate).setScale(amtprecision, RoundingMode.HALF_UP);
    }

    public Tuple<String, BigDecimal> getExchangeRateMap(Long exrateTableId, Long srcCurrencyId, Long destCurrencyId, Date exrateDate) {
        Tuple tupleDefault = Tuple.create((Object)"0", (Object)BigDecimal.ONE);
        if (srcCurrencyId == null || srcCurrencyId == 0L || destCurrencyId == null || destCurrencyId == 0L || srcCurrencyId.equals(destCurrencyId)) {
            return tupleDefault;
        }
        if (exrateDate == null) {
            exrateDate = new Date();
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String exchangeId = srcCurrencyId + "_" + destCurrencyId + "_" + exrateTableId + "_" + formatter.format(exrateDate);
        Tuple tuple = this.exchangeCache.get(exchangeId);
        if (tuple == null) {
            Map<String, Object> exrateMap = BaseDataHelper.getExchangeRateMap(exrateTableId, srcCurrencyId, destCurrencyId, exrateDate);
            if (exrateMap != null) {
                boolean quoteType = (Boolean)exrateMap.get("quoteType");
                String quotation = quoteType ? "1" : "0";
                BigDecimal exchangeRate = (BigDecimal)exrateMap.get("exchangeRate");
                tuple = Tuple.create((Object)quotation, (Object)exchangeRate);
                this.exchangeCache.put(exchangeId, (Tuple<String, BigDecimal>)tuple);
            } else {
                tuple = tupleDefault;
                this.exchangeCache.put(exchangeId, (Tuple<String, BigDecimal>)tupleDefault);
            }
        }
        return tuple;
    }
}

