/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.taxc.vo.BillTaxLogVo;
import kd.bos.ext.taxc.vo.TaxAmountLineVo;
import kd.bos.ext.taxc.vo.TaxAmountMaterialLineVo;
import kd.bos.ext.taxc.vo.TaxMaterialLineVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.JsonUtils;

public class TaxHelper {
    private static Log logger = LogFactory.getLog(TaxHelper.class);
    private static Set<String> taxBillNameList = new HashSet<String>(8);

    public static Set<String> getTaxBillNameList() {
        return taxBillNameList;
    }

    public static String getBillDetailEntryName(String entityName) {
        if (EmptyUtils.isEmpty(entityName)) {
            return "";
        }
        String name = "entry";
        switch (entityName) {
            case "ap_finapbill": {
                name = "detailentry";
                break;
            }
            case "ar_finarbill": 
            case "ar_invoice": 
            case "ap_invoice": {
                name = "entry";
                break;
            }
            case "sm_salorder": 
            case "im_saloutbill": 
            case "im_purinbill": 
            case "im_purorderbill": {
                name = "billentry";
            }
        }
        return name;
    }

    public static String getBillDetailEntrySourceBillName(String entityName) {
        String name = "e_srcentryid";
        if ("ap_finapbill".equalsIgnoreCase(entityName)) {
            name = "e_sourcebillentryid";
        }
        return name;
    }

    public static List<TaxMaterialLineVo> listTaxCode(DynamicObject entity) {
        try {
            String sourceBillType = entity.getString("sourceBillType");
            long sourceBillId = entity.getLong("sourcebillid");
            String sourceBillDetailEntryName = TaxHelper.getBillDetailEntryName(sourceBillType);
            String sourceDetailEntryName = TaxHelper.getBillDetailEntrySourceBillName(entity.getDataEntityType().getName());
            String jsonResult = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"BillTaxService", (String)"service", (Object[])new Object[]{entity.getDataEntityType().getName(), sourceBillType, sourceBillId, sourceBillDetailEntryName, sourceDetailEntryName, entity});
            logger.info("list taxCode result :" + jsonResult);
            if (EmptyUtils.isEmpty(jsonResult)) {
                return Collections.emptyList();
            }
            return JSON.parseArray((String)jsonResult, TaxMaterialLineVo.class);
        }
        catch (Exception e) {
            logger.info("list taxCode error :" + e);
            TaxHelper.sendSystemMessage(ResManager.loadKDString((String)"\u8ba1\u7a0e\u670d\u52a1\u83b7\u53d6\u7a0e\u7801\u63a5\u53e3\u5f02\u5e38\u3002", (String)"TaxHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]), entity);
            return Collections.emptyList();
        }
    }

    public static List<TaxAmountMaterialLineVo> listAllTaxLine(DynamicObject entity) {
        try {
            String jsonResult = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"BillTaxLineService", (String)"wholeService", (Object[])new Object[]{entity.getDataEntityType().getName(), entity});
            logger.info("list all tax line result :" + jsonResult);
            if (EmptyUtils.isEmpty(jsonResult)) {
                return Collections.emptyList();
            }
            return JSON.parseArray((String)jsonResult, TaxAmountMaterialLineVo.class);
        }
        catch (Exception e) {
            logger.info("list all tax line error :" + e);
            TaxHelper.sendSystemMessage(ResManager.loadKDString((String)"\u8ba1\u7a0e\u670d\u52a1\u83b7\u53d6\u5168\u90e8\u7a0e\u884c\u63a5\u53e3\u5f02\u5e38\u3002", (String)"TaxHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]), entity);
            return Collections.emptyList();
        }
    }

    public static List<TaxAmountLineVo> listTaxLine(DynamicObject entity, DynamicObject detailEntryEntity) {
        try {
            String jsonResult = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"BillTaxLineService", (String)"partService", (Object[])new Object[]{entity.getDataEntityType().getName(), entity, detailEntryEntity});
            logger.info("list tax code line result:" + jsonResult);
            if (EmptyUtils.isEmpty(jsonResult)) {
                return Collections.emptyList();
            }
            return JSON.parseArray((String)jsonResult, TaxAmountLineVo.class);
        }
        catch (Exception e) {
            logger.info("list tax code line error :" + e);
            TaxHelper.sendSystemMessage(ResManager.loadKDString((String)"\u8ba1\u7a0e\u670d\u52a1\u83b7\u53d6\u90e8\u5206\u7a0e\u884c\u63a5\u53e3\u5f02\u5e38\u3002", (String)"TaxHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]), entity);
            return Collections.emptyList();
        }
    }

    public static Map<Long, DynamicObject> getTaxCodeIdMap(List<TaxMaterialLineVo> materialLineList) {
        ArrayList taxCodeIds = new ArrayList(100);
        for (TaxMaterialLineVo materialLine : materialLineList) {
            if (EmptyUtils.isEmpty(materialLine)) continue;
            materialLine.getTaxLineVos().forEach(taxLine -> taxCodeIds.add(taxLine.getTaxCode()));
        }
        List ids = taxCodeIds.stream().distinct().collect(Collectors.toList());
        Map resultMap = BusinessDataServiceHelper.loadFromCache((String)"bastax_taxcode", (String)"id,number", (QFilter[])new QFilter("id", "in", ids).toArray());
        return resultMap.values().stream().collect(Collectors.toMap(result -> result.getLong("id"), Function.identity()));
    }

    public static Map<Long, DynamicObject> getTaxCategoryIdMap(List<TaxMaterialLineVo> materialLineList) {
        ArrayList taxCodeIds = new ArrayList(100);
        for (TaxMaterialLineVo materialLine : materialLineList) {
            if (EmptyUtils.isEmpty(materialLine)) continue;
            materialLine.getTaxLineVos().forEach(taxLine -> taxCodeIds.add(taxLine.getTaxType()));
        }
        List ids = taxCodeIds.stream().distinct().collect(Collectors.toList());
        Map resultMap = BusinessDataServiceHelper.loadFromCache((String)"bd_taxcategory", (String)"id,number,simplecode", (QFilter[])new QFilter("id", "in", ids).toArray());
        return resultMap.values().stream().collect(Collectors.toMap(result -> result.getLong("id"), Function.identity()));
    }

    public static Map<Long, DynamicObject> getTaxRateIdMap(List<TaxMaterialLineVo> materialLineList) {
        ArrayList taxCodeIds = new ArrayList(100);
        for (TaxMaterialLineVo materialLine : materialLineList) {
            if (EmptyUtils.isEmpty(materialLine)) continue;
            materialLine.getTaxLineVos().forEach(taxLine -> taxCodeIds.add(taxLine.getTaxRate()));
        }
        List ids = taxCodeIds.stream().distinct().collect(Collectors.toList());
        Map resultMap = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id,number,taxrate", (QFilter[])new QFilter("id", "in", ids).toArray());
        return resultMap.values().stream().collect(Collectors.toMap(result -> result.getLong("id"), Function.identity()));
    }

    public static boolean isNeedTax(long orgId, boolean ar) {
        Object taxParam = ar ? SystemParameterHelper.getARAppParameter(orgId, "ar_030") : SystemParameterHelper.getAPAppParameter(orgId, "ap_030");
        logger.info("isNeedTax :" + taxParam);
        if (EmptyUtils.isEmpty(taxParam)) {
            return false;
        }
        return (Boolean)taxParam;
    }

    public static void recordTaxLog(DynamicObject[] entities, boolean isAr) {
        if (ObjectUtils.isEmpty((Object[])entities)) {
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>(entities.length);
        for (DynamicObject dataEntity : entities) {
            long orgId2 = dataEntity.getLong("org.id");
            orgIds.add(orgId2);
        }
        Map<Long, Object> paramMap = SystemParameterHelper.batchGetAppParameter(isAr, new ArrayList<Long>(orgIds), isAr ? "ar_030" : "ap_030");
        for (Map.Entry<Long, Object> entrySet : paramMap.entrySet()) {
            Object param = entrySet.getValue();
            if (!ObjectUtils.isEmpty((Object)param) && ((Boolean)param).booleanValue()) continue;
            orgIds.remove(entrySet.getKey());
        }
        if (orgIds.isEmpty()) {
            logger.info("\u8ba1\u7a0e\u670d\u52a1\u7cfb\u7edf\u53c2\u6570\u672a\u5f00\u542f");
            return;
        }
        orgIds.removeIf(orgId -> !SystemParameterHelper.getAppBooleanParam("17BW0FN8JGFV", orgId, "uselog"));
        if (orgIds.isEmpty()) {
            logger.info("\u7a0e\u52a1\u4e91\u7cfb\u7edf\u53c2\u6570\u672a\u5f00\u542f");
            return;
        }
        List<DynamicObject> writeLogBills = Arrays.stream(entities).filter(entity -> orgIds.contains(entity.getLong("org.id"))).collect(Collectors.toList());
        try {
            List<BillTaxLogVo> params = TaxHelper.listBillTaxLog(writeLogBills.toArray(new DynamicObject[0]));
            String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"BillTaxLogService", (String)"callLogService", (Object[])new Object[]{JsonUtils.objToJson(params)});
            logger.info("record tax log result:" + result);
        }
        catch (Exception e) {
            logger.info("record tax log error:" + e);
        }
    }

    private static List<BillTaxLogVo> listBillTaxLog(DynamicObject[] entities) {
        ArrayList<BillTaxLogVo> result = new ArrayList<BillTaxLogVo>(16);
        for (DynamicObject entity : entities) {
            long billId = entity.getLong("id");
            if (billId == 0L) continue;
            BillTaxLogVo log = new BillTaxLogVo();
            log.setBillId(Long.valueOf(entity.getLong("id")));
            log.setBillno(entity.getString("billno"));
            result.add(log);
        }
        return result;
    }

    private static void sendSystemMessage(String messagePrefix, DynamicObject entity) {
        try {
            String sourceBillType = entity.getString("sourcebilltype");
            String sourceBillNo = entity.getString("sourcebillno");
            long sourceBillId = entity.getLong("sourcebillid");
            DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])new QFilter("number", "in", Arrays.asList("90015574", "00017118")).toArray());
            Long userId = RequestContext.get().getCurrUserId();
            ArrayList<Long> receivers = new ArrayList<Long>();
            receivers.add(userId);
            if (EmptyUtils.isNotEmpty(users)) {
                receivers.addAll(users.stream().map(user -> user.getLong("id")).collect(Collectors.toList()));
            }
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setType("warning");
            messageInfo.setTitle(ResManager.loadKDString((String)"\u6d88\u606f\u4e2d\u5fc3\u6765\u4fe1\u3002", (String)"TaxHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            String content = String.format(ResManager.loadKDString((String)"%1$s:\u6e90\u5355\u7c7b\u578b:%2$s\uff0c\u6e90\u5355ID\uff1a%3$l\uff0c\u6e90\u5355\u7f16\u7801:%4$s", (String)"TaxHelper_4", (String)"fi-arapcommon", (Object[])new Object[0]), messagePrefix, sourceBillType, sourceBillId, sourceBillNo);
            messageInfo.setContent(content);
            messageInfo.setSenderName(ResManager.loadKDString((String)"\u7a0e\u52a1\u4e91", (String)"TaxHelper_5", (String)"fi-arapcommon", (Object[])new Object[0]));
            messageInfo.setUserIds(receivers);
            messageInfo.setTag(ResManager.loadKDString((String)"\u5fc5\u8bfb", (String)"TaxHelper_6", (String)"fi-arapcommon", (Object[])new Object[0]));
            messageInfo.setNotifyType(MessageChannels.MC.getNumber());
            Long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
            logger.info("\u8ba1\u7a0e\u7cfb\u7edf\u6d88\u606fID:" + msgId);
        }
        catch (Exception e) {
            logger.info("\u8ba1\u7a0e\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\u5f02\u5e38:" + e);
        }
    }

    static {
        taxBillNameList.add("ar_finarbill");
        taxBillNameList.add("ap_finapbill");
        taxBillNameList.add("ar_busbill");
        taxBillNameList.add("ap_busbill");
    }
}

