/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class UnitConvertHelper {
    public static final String UNIT_PRECISION = "precision";
    public static final String UNIT_PRECISIONTYPE = "precisionaccount";

    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = BigDecimal.ONE;
        if (srcUnitId.equals(desUnitId)) {
            return unitRate;
        }
        DynamicObject muConv1 = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        if (!ObjectUtils.isEmpty((Object)muConv1) && muConv1.getInt("numerator") != 0) {
            unitRate = muConv1.getBigDecimal("numerator").divide(muConv1.getBigDecimal("denominator"), 10, RoundingMode.HALF_UP);
        } else {
            DynamicObject muConv2 = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)desUnitId, (Long)srcUnitId);
            if (!ObjectUtils.isEmpty((Object)muConv2) && muConv2.getInt("numerator") != 0) {
                unitRate = muConv2.getBigDecimal("denominator").divide(muConv2.getBigDecimal("numerator"), 10, RoundingMode.HALF_UP);
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ONE;
        }
        return unitRate;
    }

    public static BigDecimal getBaseunitqty(BigDecimal quantity, BigDecimal covertRate, DynamicObject baseUnit) {
        BigDecimal baseunitqty = BigDecimal.ZERO;
        if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
            covertRate = BigDecimal.ONE;
        }
        int precisionaccount = 4;
        int precision = 10;
        if (baseUnit == null) {
            baseunitqty = quantity.multiply(covertRate).setScale(precision, precisionaccount);
            return baseunitqty;
        }
        precisionaccount = baseUnit.getInt(UNIT_PRECISIONTYPE);
        precision = baseUnit.getInt(UNIT_PRECISION);
        baseunitqty = precisionaccount == 2 ? quantity.multiply(covertRate).setScale(precision, 1) : (precisionaccount == 3 ? quantity.multiply(covertRate).setScale(precision, 0) : quantity.multiply(covertRate).setScale(precision, 4));
        return baseunitqty;
    }

    public static BigDecimal getUnitQty(BigDecimal baseQuantity, BigDecimal covertRate, DynamicObject unit) {
        BigDecimal unitQty = BigDecimal.ZERO;
        if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
            covertRate = BigDecimal.ONE;
        }
        if (!ObjectUtils.isEmpty((Object)unit)) {
            int precisionaccount = unit.getInt(UNIT_PRECISIONTYPE);
            int precision = unit.getInt(UNIT_PRECISION);
            unitQty = precisionaccount == 2 ? baseQuantity.divide(covertRate, precision, 1) : (precisionaccount == 3 ? baseQuantity.divide(covertRate, precision, 0) : baseQuantity.divide(covertRate, precision, 4));
        } else {
            unitQty = baseQuantity.divide(covertRate).setScale(10, 4);
        }
        return unitQty;
    }

    public static int getPrecision(DynamicObject unit) {
        int precision = 10;
        if (unit != null) {
            precision = unit.getInt(UNIT_PRECISION);
        }
        return precision;
    }

    public static int getPrecisionType(DynamicObject unit) {
        int precisionType = 4;
        if (unit != null && StringUtils.isNotBlank((Object)unit.get(UNIT_PRECISIONTYPE))) {
            String precisionAccount;
            switch (precisionAccount = unit.getString(UNIT_PRECISIONTYPE)) {
                case "1": {
                    precisionType = 4;
                    break;
                }
                case "2": {
                    precisionType = 1;
                    break;
                }
                case "3": {
                    precisionType = 0;
                    break;
                }
            }
        }
        return precisionType;
    }
}

