/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.enums.UpgradeDataIntervalEnum;
import kd.fi.arapcommon.enums.UpgradeDataRangeEnum;
import kd.fi.arapcommon.enums.UpgradeExecuteStatusEnum;
import kd.fi.arapcommon.service.upgrade.AbstractUpgradeHandle;
import kd.fi.arapcommon.service.upgrade.IUpgradeHandle;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.vo.BatchUpdateParam;
import kd.fi.arapcommon.vo.UpgradeConfigEntryVO;
import kd.fi.arapcommon.vo.UpgradeConfigVO;

public class UpgradeConfigHelper {
    private static final Log logger = LogFactory.getLog(UpgradeConfigHelper.class);

    public static UpgradeDataIntervalEnum getIntervalByDataCount(UpgradeConfigVO configVO) {
        DataSet queryDataCount;
        if (configVO == null || ObjectUtils.isEmpty((Object)configVO.getBizObj()) || ObjectUtils.isEmpty((Object)configVO.getPlugin())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u786e\u8ba4\u76f8\u5e94\u5165\u53c2\u503c\u662f\u5426\u6b63\u786e\u3002", (String)"UpgradeConfigHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        AbstractUpgradeHandle upgradeService = (AbstractUpgradeHandle)TypesContainer.createInstance((String)configVO.getPlugin());
        String upgradeEntryName = upgradeService.getUpgradeEntryName();
        if (upgradeService.isNewVersion()) {
            String queryFilter = upgradeService.getQueryFilter();
            String querySql = ObjectUtils.isEmpty((Object)upgradeEntryName) ? "select count(1) from " + configVO.getTableName() + " where " + upgradeService.getDateFieldName() + " >= ?" : "select count(b.fentryid) from " + upgradeEntryName + " b left join " + configVO.getTableName() + " a on b.fid = a.fid  where a." + upgradeService.getDateFieldName() + " >= ?";
            if (!ObjectUtils.isEmpty((Object)queryFilter)) {
                querySql = querySql + " and " + queryFilter;
            }
            java.util.Date lastMonth = DateUtils.getLastDay(configVO.getDataEndTime(), 31);
            queryDataCount = DB.queryDataSet((String)"querydatacount", (DBRoute)new DBRoute("fi"), (String)querySql, (Object[])new Object[]{lastMonth});
        } else {
            java.util.Date lastMonth = DateUtils.getLastDay(configVO.getDataEndTime(), 31);
            QFilter filter = new QFilter("bizdate", ">=", (Object)lastMonth);
            filter = upgradeService.getQFilter() == null ? filter : filter.and(upgradeService.getQFilter());
            queryDataCount = QueryServiceHelper.queryDataSet((String)"querydatacount", (String)configVO.getBizObj(), (String)"count(1)", (QFilter[])new QFilter[]{filter}, (String)"");
        }
        int count = queryDataCount.next().getInteger(ObjectUtils.isEmpty((Object)upgradeEntryName) ? "count(1)" : "count(b.fentryid)");
        String unRealDataCount = StdConfig.get("UpgradeConfigDataCount");
        if (!ObjectUtils.isEmpty((Object)unRealDataCount)) {
            count = Integer.parseInt(unRealDataCount);
        }
        return UpgradeDataIntervalEnum.getIntervalByDataCount(count);
    }

    public static void batchExecute(BatchUpdateParam paramVO) {
        UpgradeConfigVO configVO = UpgradeConfigHelper.batchParamToConfigVO(paramVO);
        if (configVO == null || ObjectUtils.isEmpty((Object)configVO.getBizObj()) || ObjectUtils.isEmpty((Object)configVO.getPlugin())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u786e\u8ba4\u76f8\u5e94\u5165\u53c2\u503c\u662f\u5426\u6b63\u786e\u3002", (String)"UpgradeConfigHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        DataSet dataSet = DB.queryDataSet((String)"queryIsExist", (DBRoute)DBRouteConst.AP, (String)"select fid from t_arap_upgradeconfig where fplugin = ?;", (Object[])new Object[]{paramVO.getPlugin()});
        if (dataSet.hasNext()) {
            Long id = dataSet.next().getLong("fid");
            DB.execute((DBRoute)DBRouteConst.AP, (String)"delete from t_arap_upgradeconfig where fid = ?", (Object[])new Object[]{id});
            DB.execute((DBRoute)DBRouteConst.AP, (String)"delete from t_arap_upgradeentry where fid = ?", (Object[])new Object[]{id});
        }
        IUpgradeHandle upgradeService = (IUpgradeHandle)TypesContainer.createInstance((String)configVO.getPlugin());
        if (paramVO.isOnlyInsertConfig()) {
            UpgradeConfigHelper.updateUpgradeTask(configVO);
            ThreadPools.executeOnceIncludeRequestContext((String)"UpgradeConfigHelper.upgrade", () -> {
                logger.info("executeOnceIncludeRequestContext to execute");
                upgradeService.batchExecute(configVO);
            });
        } else {
            upgradeService.batchExecute(configVO);
        }
        if (configVO.getStopDate() != null) {
            UpgradeConfigVO upgradeConfigVO = new UpgradeConfigVO();
            upgradeConfigVO.setBillId(configVO.getBillId());
            upgradeConfigVO.setDataStartDate(configVO.getDataStartDate());
            upgradeConfigVO.setDataEndTime(configVO.getStopDate());
            upgradeConfigVO.setBizObj(configVO.getBizObj());
            upgradeConfigVO.setIntervalDays(configVO.getIntervalDays());
            upgradeConfigVO.setPlugin(configVO.getPlugin());
            upgradeConfigVO.setFirst(false);
            upgradeConfigVO.setCreateUpgradeTask(false);
            ThreadPools.executeOnceIncludeRequestContext((String)"UpgradeConfigHelper.upgrade", () -> {
                logger.info("executeOnceIncludeRequestContext to execute");
                upgradeService.batchExecute(upgradeConfigVO);
            });
        }
    }

    public static UpgradeConfigVO batchParamToConfigVO(BatchUpdateParam paramVO) {
        if (ObjectUtils.isEmpty((Object)paramVO)) {
            return null;
        }
        UpgradeConfigVO configVO = new UpgradeConfigVO();
        configVO.setBizObj(paramVO.getBizObj());
        configVO.setPlugin(paramVO.getPlugin());
        configVO.setFirst(true);
        configVO.setDataEndTime(paramVO.getDateEndTime());
        configVO.setUpgradePlugin(paramVO.isUpgradePlugin());
        String tableName = MetadataServiceHelper.getDataEntityType((String)configVO.getBizObj()).getAlias();
        configVO.setTableName(tableName);
        UpgradeDataIntervalEnum intervalEnum = UpgradeConfigHelper.getIntervalByDataCount(configVO);
        configVO.setIntervalDays(intervalEnum.getInterval());
        if (UpgradeDataIntervalEnum.OVERMUCH == intervalEnum) {
            paramVO.setOnlyInsertConfig(true);
        }
        UpgradeDataRangeEnum upgradeDataRange = UpgradeDataIntervalEnum.LITTLE == intervalEnum ? UpgradeDataRangeEnum.ALL : paramVO.getUpgradeDataRange();
        configVO.setDataStartDate(DateUtils.getLastDay(DateUtils.getDataFormat(new java.util.Date(), true), upgradeDataRange.getValue()));
        if (paramVO.isOnlyInsertConfig()) {
            return configVO;
        }
        if (UpgradeDataIntervalEnum.MANY == intervalEnum) {
            configVO.setStopDate(DateUtils.getLastDay(DateUtils.getDataFormat(new java.util.Date(), false), 30));
        }
        return configVO;
    }

    @Deprecated
    public static java.util.Date getEarlyEnableDate(String entity) {
        if (ObjectUtils.isEmpty((Object)entity)) {
            return null;
        }
        String init = entity.startsWith("ap") ? "ap_init" : "ar_init";
        DataSet initDataSet = QueryServiceHelper.queryDataSet((String)"queryealardate", (String)init, (String)"startdate", null, (String)"startdate asc", (int)1);
        if (!initDataSet.hasNext()) {
            return null;
        }
        return initDataSet.next().getDate("startdate");
    }

    public static void updateUpgradeTask(UpgradeConfigVO configVO) {
        if (configVO.isCreateUpgradeTask()) {
            long billId = DB.genLongId((String)"t_arap_upgradeconfig");
            Object[] param = new Object[14];
            param[0] = billId;
            param[1] = new SimpleDateFormat("yyyyMMddHHmmssSSSS").format(new java.util.Date());
            param[2] = "C";
            param[3] = UpgradeExecuteStatusEnum.WAIT.getValue();
            param[4] = configVO.getPlugin();
            param[5] = configVO.getIntervalDays();
            param[6] = configVO.getBizObj();
            if (configVO.getDataStartDate() != null) {
                param[7] = new Date(configVO.getDataStartDate().getTime());
            }
            java.util.Date dataEndTime = configVO.getStopDate() == null ? configVO.getDataEndTime() : configVO.getStopDate();
            param[8] = new Date(dataEndTime.getTime());
            param[9] = RequestContext.get().getTraceId();
            param[10] = RequestContext.get().getCurrUserId();
            param[11] = RequestContext.get().getCurrUserId();
            param[12] = new Date(new java.util.Date().getTime());
            param[13] = Boolean.TRUE;
            try (TXHandle tx = TX.requiresNew((String)"createNewUpgradeTask");){
                try {
                    String insertSql = "insert into t_arap_upgradeconfig(fid,fbillno,fbillstatus,fexecutestatus,fplugin,fintervaldays,fbizobj,fdatestarttime,fdateendtime,ftraceid,fexecutorid,fcreatorid,fcreatetime,fisdefault) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
                    DB.execute((DBRoute)DBRouteConst.AP, (String)insertSql, (Object[])param);
                    configVO.setBillId(billId);
                }
                catch (Exception exc) {
                    logger.info("UpgradeConfigHelper : " + exc.getMessage());
                    tx.markRollback();
                }
            }
        }
        if (!configVO.isCreateUpgradeTask() && configVO.getBillId() != 0L) {
            try (TXHandle tx = TX.requiresNew((String)"updateUpgradeTask");){
                try {
                    String sql = "update t_arap_upgradeconfig set fexecutestatus = ?,ftraceid = ?,fexecutorid=? where fid = ?;";
                    DB.execute((DBRoute)DBRouteConst.AP, (String)sql, (Object[])new Object[]{UpgradeExecuteStatusEnum.DOING.getValue(), RequestContext.get().getTraceId(), RequestContext.get().getCurrUserId(), configVO.getBillId()});
                }
                catch (Exception exc) {
                    logger.info("UpgradeConfigHelper : " + exc.getMessage());
                    tx.markRollback();
                }
            }
        }
    }

    public static void createUpgradeTaskEntry(List<UpgradeConfigEntryVO> entryVOList) {
        if (ObjectUtils.isEmpty(entryVOList)) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(entryVOList.size());
        long[] entryIds = DB.genLongIds((String)"t_arap_upgradeentry", (int)entryVOList.size());
        for (int i = 0; i < entryVOList.size(); ++i) {
            java.util.Date dataEndTime;
            UpgradeConfigEntryVO entryVO = entryVOList.get(i);
            if (entryVO.getEntryId() != 0L || entryVO.getBillId() == 0L) continue;
            Object[] param = new Object[7];
            param[0] = entryVO.getBillId();
            param[1] = entryIds[i];
            entryVO.setEntryId(entryIds[i]);
            java.util.Date dataStartDate = entryVO.getDataStartDate();
            if (dataStartDate != null) {
                param[2] = new Date(dataStartDate.getTime());
            }
            if ((dataEndTime = entryVO.getDataEndTime()) != null) {
                param[3] = new Date(dataEndTime.getTime());
            }
            param[4] = UpgradeExecuteStatusEnum.WAIT.getValue();
            param[5] = entryVO.getSeq();
            param[6] = entryVO.isFirst() && entryVO.isCreateUpgradeTask();
            params.add(param);
        }
        if (!params.isEmpty()) {
            try (TXHandle tx = TX.requiresNew((String)"createUpgradeTaskEntry");){
                try {
                    String sql = "insert into t_arap_upgradeentry(fid,fentryid,fdatastartdate,fdataenddate,fexecutestatus,fseq,fisupgradeplugin) values(?,?,?,?,?,?,?);";
                    DB.executeBatch((DBRoute)DBRouteConst.AP, (String)sql, params);
                }
                catch (Exception exc) {
                    logger.info("UpgradeConfigHelper : " + exc.getMessage());
                    tx.markRollback();
                }
            }
        }
    }

    public static void updateUpgradeTaskEntry(UpgradeConfigEntryVO entryVO) {
        if (entryVO == null || entryVO.getEntryId() == 0L) {
            return;
        }
        ArrayList<Object> params = new ArrayList<Object>(8);
        params.add(new java.util.Date());
        params.add(entryVO.getExecuteStatus());
        params.add(RequestContext.get().getTraceId());
        params.add(entryVO.getEntryId());
        try (TXHandle tx = TX.requiresNew((String)"updateUpgradeTaskEntry");){
            try {
                String sql = "update t_arap_upgradeentry set fexecutetimes = fexecutetimes + 1,ftaskstartdate = ?,fexecutestatus = ?,ftraceid=?,ftaskenddate=null,fexceptioninfo=' ',fexceptioninfo_tag = ' ' where fentryid = ?;";
                DB.execute((DBRoute)DBRouteConst.AP, (String)sql, (Object[])params.toArray(new Object[0]));
            }
            catch (Exception exc) {
                logger.info("UpgradeConfigHelper : " + exc.getMessage());
                tx.markRollback();
            }
        }
    }

    public static void updateUpgradeTaskEntryAfterExecute(UpgradeConfigEntryVO entryVO) {
        if (entryVO == null || entryVO.getEntryId() == 0L) {
            return;
        }
        try (TXHandle tx = TX.requiresNew((String)"updateUpgradeTaskEntryAfterExecute");){
            try {
                String updateEntry = "update t_arap_upgradeentry set ftaskenddate = ? ,fexecutestatus = ?,fexceptioninfo=?,fexceptioninfo_tag = ? where fentryid = ?;";
                DB.execute((DBRoute)DBRouteConst.AP, (String)updateEntry, (Object[])new Object[]{new java.util.Date(), entryVO.getExecuteStatus(), entryVO.getExceptionInfo(), entryVO.getExceptionInfoTag(), entryVO.getEntryId()});
            }
            catch (Exception exc) {
                logger.info("UpgradeConfigHelper : " + exc.getMessage());
                tx.markRollback();
            }
        }
    }

    public static void updateUpgradeTaskHeadAfterExecute(UpgradeConfigVO configVO) {
        if (configVO == null || configVO.getBillId() == 0L || configVO.isCreateUpgradeTask()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew((String)"updateUpgradeTaskHeadAfterExecute");){
            try {
                String sql = "select fentryid from t_arap_upgradeentry where fid = ? and fexecutestatus <> ?;";
                DataSet dataSet = DB.queryDataSet((String)"queryErrorEntry", (DBRoute)DBRouteConst.AP, (String)sql, (Object[])new Object[]{configVO.getBillId(), UpgradeExecuteStatusEnum.DONE.getValue()});
                String executeStatus = null;
                executeStatus = dataSet.hasNext() ? UpgradeExecuteStatusEnum.FAILED.getValue() : UpgradeExecuteStatusEnum.DONE.getValue();
                String updateHead = "update t_arap_upgradeconfig set fexecutestatus = ? where fid = ?;";
                DB.execute((DBRoute)DBRouteConst.AP, (String)updateHead, (Object[])new Object[]{executeStatus, configVO.getBillId()});
            }
            catch (Exception exc) {
                logger.info("UpgradeConfigHelper : " + exc.getMessage());
                tx.markRollback();
            }
        }
    }

    public static boolean isHistoryBill(String key, java.util.Date createtime) {
        logger.info("UpgradeConfigHelper.isHistoryBill.key:" + key);
        boolean flag = false;
        String upgradeDateStr = StdConfig.get(key);
        if (EmptyUtils.isEmpty(upgradeDateStr)) {
            return false;
        }
        logger.info("UpgradeConfigHelper.isHistoryBill.upgradeDateStr:" + upgradeDateStr);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        java.util.Date upgradeDate = null;
        try {
            upgradeDate = sdf.parse(upgradeDateStr);
        }
        catch (ParseException parseException) {
            logger.error("UpgradeConfigHelper.isHistoryBill.context", (Object)parseException.getMessage());
        }
        if (upgradeDate == null) {
            return false;
        }
        if (createtime != null && upgradeDate != null && createtime.before(upgradeDate)) {
            flag = true;
        }
        return flag;
    }

    public static java.util.Date getUpgradeTime(String key) {
        String upgradedDate = StdConfig.get(key);
        return upgradedDate == null ? null : DateUtils.parseDate(String.valueOf(upgradedDate), "yyyy-MM-dd HH:mm:ss");
    }
}

