/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.WriteOffBillWriteBackHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class WriteBackBillQueryHelper {
    private static Map<String, String> billNameToSelectFieldMap = new HashMap<String, String>(16);

    public static String getSelectField(String sourceBillEntityName) {
        return billNameToSelectFieldMap.getOrDefault(sourceBillEntityName, "id");
    }

    public static List<DynamicObject> listSameSourceAdjustBusBill(List<DynamicObject> finBillList, boolean arBill) {
        String targetBillName = arBill ? "ar_busbill" : "ap_busbill";
        List finBillIds = finBillList.stream().map(entity -> entity.getLong("sourcebillid")).collect(Collectors.toList());
        DynamicObject[] results = BusinessDataServiceHelper.load((String)targetBillName, (String)WriteBackBillQueryHelper.getSelectField(targetBillName), (QFilter[])new QFilter("srcfinbillid", "in", finBillIds).toArray());
        return Arrays.asList(results);
    }

    public static Map<Long, DynamicObject> getSourceBusBillIdMap(List<DynamicObject> sameSourceAdjustBusBillList, boolean arBill) {
        String targetBillName = arBill ? "ar_busbill" : "ap_busbill";
        List sourceBillIds = sameSourceAdjustBusBillList.stream().map(entity -> entity.getLong("sourcebillid")).collect(Collectors.toList());
        DynamicObject[] results = BusinessDataServiceHelper.load((String)targetBillName, (String)WriteBackBillQueryHelper.getSelectField(targetBillName), (QFilter[])new QFilter("id", "in", sourceBillIds).and(new QFilter("isselfwoff", "=", (Object)Boolean.FALSE)).toArray());
        return Arrays.stream(results).collect(Collectors.toMap(entity -> entity.getLong("id"), Function.identity()));
    }

    public static Map<Long, DynamicObject> getSourceFinBillIdMap(List<Long> ids, boolean arBill) {
        String targetBillName = arBill ? "ar_finarbill" : "ap_finapbill";
        DynamicObject[] results = BusinessDataServiceHelper.load((String)targetBillName, (String)WriteBackBillQueryHelper.getSelectField(targetBillName), (QFilter[])new QFilter("id", "in", ids).toArray());
        HashMap<Long, DynamicObject> sourceFinBillIdMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject result : results) {
            sourceFinBillIdMap.put(result.getLong("id"), result);
        }
        return sourceFinBillIdMap;
    }

    public static Map<Long, Long> getBusBillToFinBillDetailEntryIdMap(DynamicObject finBill, DynamicObject targetBill) {
        String entityNumber = finBill.getDataEntityType().getName();
        String targetEntityName = targetBill.getDataEntityType().getName();
        Map<String, String> finBillPropertyMap = WriteOffBillWriteBackHelper.getFinBillPropertyMap(entityNumber);
        String finDetailEntryName = finBillPropertyMap.get("detailEntry");
        DynamicObjectCollection collection = finBill.getDynamicObjectCollection(finDetailEntryName);
        List<Long> entryIds = collection.stream().map(entry -> entry.getLong("id")).collect(Collectors.toList());
        boolean sameSourceBill = WriteBackBillQueryHelper.isSameSourceBill(finBill, targetEntityName);
        if (!sameSourceBill) {
            Map<Long, Long> result = BOTPHelper.getSourceEntryIdsMap(entityNumber, finDetailEntryName, entryIds.toArray(new Long[0]), targetBill.getLong("id"));
            HashMap<Long, Long> sourceEntryIdsToFinBillMap = new HashMap<Long, Long>(16);
            result.keySet().forEach(key -> sourceEntryIdsToFinBillMap.put((Long)result.get(key), (Long)key));
            return sourceEntryIdsToFinBillMap;
        }
        DynamicObjectCollection busCollection = targetBill.getDynamicObjectCollection("entry");
        long targetBillId = targetBill.getLong("sourcebillid");
        Map<Long, Long> busBillToSourceEntryIdsMap = BOTPHelper.getSourceEntryIdsMap(targetEntityName, "entry", (Long[])busCollection.stream().map(entry -> entry.getLong("id")).toArray(Long[]::new), targetBillId);
        HashMap sourceEntryIdsToBusBillMap = new HashMap(16);
        busBillToSourceEntryIdsMap.keySet().forEach(key -> sourceEntryIdsToBusBillMap.put(busBillToSourceEntryIdsMap.get(key), key));
        Map<Long, Long> finBillToSourceEntryIdsMap = BOTPHelper.getSourceEntryIdsMap(entityNumber, finDetailEntryName, entryIds.toArray(new Long[0]), targetBillId);
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        finBillToSourceEntryIdsMap.keySet().forEach(key -> {
            long sourceBillId = (Long)finBillToSourceEntryIdsMap.get(key);
            long busBillEntryId = (Long)sourceEntryIdsToBusBillMap.get(sourceBillId);
            result.put(busBillEntryId, (Long)key);
        });
        return result;
    }

    public static Map<Long, Long> getWriteOffEntryIdToSrcBusEntryIdMap(DynamicObject writeOffBill, DynamicObject srcBusBill, boolean arBill) {
        boolean sameSourceBill = WriteBackBillQueryHelper.isSameSourceBill(writeOffBill, arBill);
        String writeOffBillEntityName = arBill ? "ar_finarbill" : "ap_finapbill";
        String busBillEntityName = arBill ? "ar_busbill" : "ap_busbill";
        Map<String, String> finBillPropertyMap = WriteOffBillWriteBackHelper.getFinBillPropertyMap(writeOffBillEntityName);
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        if (!sameSourceBill) {
            long srcBusBillId = srcBusBill.getLong("id");
            return BOTPHelper.getSourceEntryIdsMap(writeOffBillEntityName, finBillPropertyMap.get("detailEntry"), (Long[])writeOffBill.getDynamicObjectCollection(finBillPropertyMap.get("detailEntry")).stream().map(entry -> entry.getLong("id")).toArray(Long[]::new), srcBusBillId);
        }
        String srcBillEntityName = srcBusBill.getString("sourcebilltype");
        Map<Long, Long> srcBusEntryIdToSourceEntryIdsMap = WriteBackBillQueryHelper.getBillEntryIdToSrcBillEntryIdMap(busBillEntityName, "entry", (Long[])srcBusBill.getDynamicObjectCollection("entry").stream().map(entry -> entry.getLong("id")).toArray(Long[]::new), srcBillEntityName);
        Map<Long, Long> writeOffEntryIdToSourceEntryIdsMap = WriteBackBillQueryHelper.getBillEntryIdToSrcBillEntryIdMap(writeOffBillEntityName, finBillPropertyMap.get("detailEntry"), (Long[])writeOffBill.getDynamicObjectCollection(finBillPropertyMap.get("detailEntry")).stream().map(entry -> entry.getLong("id")).toArray(Long[]::new), srcBillEntityName);
        HashMap sourceEntryIdsToSrcBusEntryIdMap = new HashMap(16);
        srcBusEntryIdToSourceEntryIdsMap.keySet().forEach(key -> sourceEntryIdsToSrcBusEntryIdMap.put(srcBusEntryIdToSourceEntryIdsMap.get(key), key));
        writeOffEntryIdToSourceEntryIdsMap.keySet().forEach(key -> {
            Object srcEntryId = writeOffEntryIdToSourceEntryIdsMap.get(key);
            Object srcBusEntryId = sourceEntryIdsToSrcBusEntryIdMap.get(srcEntryId);
            if (srcBusEntryId != null) {
                result.put((Long)key, (Long)srcBusEntryId);
            }
        });
        if (arBill && result.size() == 0) {
            WriteBackBillQueryHelper.getWriteOffEntryIdToSrcBillEntryIdMap(writeOffBill, srcBusBill, finBillPropertyMap, result);
        }
        return result;
    }

    private static void getWriteOffEntryIdToSrcBillEntryIdMap(DynamicObject writeOffBill, DynamicObject srcBusBill, Map<String, String> finBillPropertyMap, Map<Long, Long> result) {
        DynamicObjectCollection entryCol = writeOffBill.getDynamicObjectCollection(finBillPropertyMap.get("detailEntry"));
        for (DynamicObject entryInfo : entryCol) {
            String coreBillType = entryInfo.getString("e_corebilltype");
            String coreBillNo = entryInfo.getString("e_corebillno");
            int coreBillEntrySeq = entryInfo.getInt("e_corebillentryseq");
            DynamicObjectCollection srcBusEntryCol = srcBusBill.getDynamicObjectCollection("entry");
            for (DynamicObject srcBusEntryInfo : srcBusEntryCol) {
                String s_coreBillType = srcBusEntryInfo.getString("e_corebilltype");
                String s_coreBillNo = srcBusEntryInfo.getString("e_corebillno");
                int s_coreBillEntrySeq = srcBusEntryInfo.getInt("e_corebillentryseq");
                if (coreBillEntrySeq != s_coreBillEntrySeq || !coreBillType.equals(s_coreBillType) || !coreBillNo.equals(s_coreBillNo)) continue;
                result.put(entryInfo.getLong("id"), srcBusEntryInfo.getLong("id"));
            }
        }
    }

    private static Map<Long, Long> getBillEntryIdToSrcBillEntryIdMap(String targetBillName, String targetBillEntryName, Long[] entryIds, String sourceBillName) {
        Map<Long, Set<Long>> relation = BOTPHelper.loadSourceRowIdsMap(targetBillName, targetBillEntryName, entryIds, sourceBillName);
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        for (Map.Entry<Long, Set<Long>> entry : relation.entrySet()) {
            result.put(entry.getKey(), entry.getValue().iterator().next());
        }
        return result;
    }

    public static boolean isSameSourceBill(DynamicObject finBill, String targetEntityName) {
        List<DynamicObject> sourceBusBillList = WriteBackBillQueryHelper.getSourceBillByFinBill(finBill, targetEntityName);
        return !EmptyUtils.isNotEmpty(sourceBusBillList);
    }

    public static boolean isSameSourceBill(DynamicObject writeOffFinBill, boolean arBill) {
        String busBillEntityName = arBill ? "ar_busbill" : "ap_busbill";
        String entityNumber = writeOffFinBill.getDataEntityType().getName();
        List<Long> billIds = BOTPHelper.loadNearUpBillIds(entityNumber, busBillEntityName, writeOffFinBill.getLong("id"));
        return EmptyUtils.isEmpty(billIds);
    }

    public static List<DynamicObject> getSourceBillByFinBill(DynamicObject finBill, String sourceBillEntityName) {
        String entityNumber = finBill.getDataEntityType().getName();
        Set<Long> billIds = BOTPHelper.findSouBillIds(entityNumber, finBill.getLong("id"), sourceBillEntityName);
        if (EmptyUtils.isEmpty(billIds)) {
            return Collections.emptyList();
        }
        String selectFields = WriteBackBillQueryHelper.getSelectField(sourceBillEntityName);
        DynamicObject[] busBillList = BusinessDataServiceHelper.load((String)sourceBillEntityName, (String)selectFields, (QFilter[])new QFilter("id", "in", billIds).toArray());
        return Arrays.asList(busBillList);
    }

    static {
        billNameToSelectFieldMap.put("ar_busbill", "id,billno,sourcebillid,writeoffbusiness,sourcebilltype,srcfinbillid,invoicedamt,uninvoicedamt,invoicedlocamt,uninvoicedlocamt,payproperty,unwoffamt,unwofflocamt,unwoffnotaxamt,unwoffnotaxlocamt,unwofftax,unwofftaxlocal,modifier,modifytime,entry.id,entry.e_recamount,entry.e_reclocalamt,entry.e_invoicedqty,entry.e_invoicedamt,entry.e_invoicedlocamt,entry.e_quantity,entry.e_invoicedqty,entry.e_uninvoicedamt,entry.e_uninvoicedlocamt,entry.e_uninvoicedqty,entry.e_iswriteoff,entry.e_srcentryid,e_unwoffqty,e_unwoffamt,e_unwofflocamt,entry.e_unwoffnotaxamt,entry.e_unwoffnotaxlocamt,entry.e_unwofftax,entry.e_unwofftaxlocal,entry.e_unitprice,e_ispresent,mostsrcbusbillid,entry.e_mostsrcbusentryid,entry.e_mostsrcbusbillid,entry.e_invoicednotaxamt,entry.e_invnotaxlocalamt,entry.e_uninvnotaxamt,entry.e_uninvnotaxlocalamt,entry.e_amount,entry.e_localamt,entry.e_corebilltype,entry.e_corebillno,entry.e_corebillentryseq");
        billNameToSelectFieldMap.put("ap_busbill", "id,billno,sourcebillid,writeoffbusiness,sourcebilltype,srcfinbillid,invoicedamt,uninvoicedamt,invoicedlocamt,uninvoicedlocamt,payproperty,unwoffamt,unwofflocamt,unwoffnotaxamt,unwoffnotaxlocamt,unwofftax,unwofftaxlocal,modifier,modifytime,entry.id,entry.e_pricetaxtotal,entry.e_pricetaxtotalbase,entry.e_invoicedqty,entry.e_invoicedamt,entry.e_invoicedlocamt,entry.e_quantity,entry.e_invoicedqty,entry.e_uninvoicedamt,entry.e_uninvoicedlocamt,entry.e_uninvoicedqty,entry.e_iswriteoff,entry.e_srcentryid,e_unwoffqty,e_unwoffamt,e_unwofflocamt,entry.e_unwoffnotaxamt,entry.e_unwoffnotaxlocamt,entry.e_unwofftax,entry.e_unwofftaxlocal,entry.e_unitprice,e_ispresent,mostsrcbusbillid,entry.e_mostsrcbusentryid,entry.e_mostsrcbusbillid,entry.e_invoicednotaxamt,entry.e_invnotaxlocalamt,entry.e_uninvnotaxamt,entry.e_uninvnotaxlocalamt,entry.e_amount,entry.e_localamt");
        billNameToSelectFieldMap.put("ar_finarbill", "id,sourcebillid,entry.id,entry.e_srcentryid,entry.e_recamount,entry.e_quantity,entry.e_reclocalamt,entry.e_corebilltype,entry.e_corebillno,entry.e_corebillentryseq");
        billNameToSelectFieldMap.put("ap_finapbill", "id,sourcebillid,detailentry.id,detailentry.e_sourcebillentryid,detailentry.e_pricetaxtotal,detailentry.quantity,detailentry.e_pricetaxtotalbase");
    }
}

