/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.arapcommon.service.BusBillWriteBackFromFinBillService;
import kd.fi.arapcommon.service.woff.WoffHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class WriteOffBillWriteBackHelper {
    private static Map<String, String> finArBillPropertyMap = new HashMap<String, String>(16);
    private static Map<String, String> finApBillPropertyMap = new HashMap<String, String>(16);
    private static Map<String, String> arBusBillPropertyMap = new HashMap<String, String>(16);
    private static Map<String, String> apBusBillPropertyMap = new HashMap<String, String>(16);

    public static void writeBackForSave(DynamicObject[] billList, boolean reverse) {
        List<DynamicObject> writeOffBillList = WriteOffBillWriteBackHelper.listWriteOffBill(billList);
        if (EmptyUtils.isEmpty(writeOffBillList)) {
            return;
        }
        WoffHelper.executeWriteOffBillWoff(writeOffBillList);
        BusBillWriteBackFromFinBillService busService = new BusBillWriteBackFromFinBillService();
        busService.writeBack(writeOffBillList, reverse);
    }

    public static void writeBackForUnAudit(DynamicObject[] billList, boolean reverse) {
        List<DynamicObject> writeOffBillList = WriteOffBillWriteBackHelper.listWriteOffBill(billList);
        if (EmptyUtils.isEmpty(writeOffBillList)) {
            return;
        }
        BusBillWriteBackFromFinBillService busService = new BusBillWriteBackFromFinBillService();
        busService.writeBack(writeOffBillList, reverse);
        WoffHelper.executeWriteOffBillUnWoff(writeOffBillList);
    }

    private static List<DynamicObject> listWriteOffBill(DynamicObject[] billList) {
        ArrayList<DynamicObject> writeOffBillList = new ArrayList<DynamicObject>(16);
        for (DynamicObject bill : billList) {
            boolean writeOff = bill.getBoolean("iswrittenoff");
            if (!writeOff) continue;
            writeOffBillList.add(bill);
        }
        return writeOffBillList;
    }

    public static Map<String, String> getFinBillPropertyMap(boolean arBill) {
        return arBill ? finArBillPropertyMap : finApBillPropertyMap;
    }

    public static Map<String, String> getFinBillPropertyMap(String entityName) {
        if ("ar_finarbill".equals(entityName)) {
            return finArBillPropertyMap;
        }
        return finApBillPropertyMap;
    }

    public static Map<String, String> getBusBillPropertyMap(boolean arBill) {
        return arBill ? arBusBillPropertyMap : apBusBillPropertyMap;
    }

    public static Map<String, String> getBusBillPropertyMap(String entityName) {
        if ("ar_busbill".equals(entityName)) {
            return arBusBillPropertyMap;
        }
        return apBusBillPropertyMap;
    }

    private static void setFinArBillProperty() {
        finArBillPropertyMap.put("detailEntry", "entry");
        finArBillPropertyMap.put("e_recAmt", "e_recamount");
        finArBillPropertyMap.put("e_quantity", "e_quantity");
        finArBillPropertyMap.put("e_recLocalAmt", "e_reclocalamt");
        finArBillPropertyMap.put("e_sourceEntryId", "e_srcentryid");
        finArBillPropertyMap.put("e_amount", "e_amount");
        finArBillPropertyMap.put("e_locamt", "e_localamt");
    }

    private static void setFinApBillProperty() {
        finApBillPropertyMap.put("detailEntry", "detailentry");
        finApBillPropertyMap.put("e_recAmt", "e_pricetaxtotal");
        finApBillPropertyMap.put("e_quantity", "quantity");
        finApBillPropertyMap.put("e_recLocalAmt", "e_pricetaxtotalbase");
        finApBillPropertyMap.put("e_sourceEntryId", "e_sourcebillentryid");
        finApBillPropertyMap.put("e_amount", "e_amount");
        finApBillPropertyMap.put("e_locamt", "e_amountbase");
    }

    private static void setArBusBillProperty() {
        arBusBillPropertyMap.put("e_recAmt", "e_recamount");
        arBusBillPropertyMap.put("e_recLocalAmt", "e_reclocalamt");
    }

    private static void setApBusBillProperty() {
        apBusBillPropertyMap.put("e_recAmt", "e_pricetaxtotal");
        apBusBillPropertyMap.put("e_recLocalAmt", "e_pricetaxtotalbase");
    }

    public static void resetHeadAmt(DynamicObject busBill) {
        BigDecimal headInvoiceAmt = BigDecimal.ZERO;
        BigDecimal headUnInvoiceAmt = BigDecimal.ZERO;
        BigDecimal headInvoiceLocalAmt = BigDecimal.ZERO;
        BigDecimal headUnInvoiceLocalAmt = BigDecimal.ZERO;
        BigDecimal headUnWoffAmt = BigDecimal.ZERO;
        BigDecimal headUnWoffLocAmt = BigDecimal.ZERO;
        for (DynamicObject detailRow : busBill.getDynamicObjectCollection("entry")) {
            BigDecimal invoiceAmt = detailRow.getBigDecimal("e_invoicedamt");
            BigDecimal unInvoiceAmt = detailRow.getBigDecimal("e_uninvoicedamt");
            BigDecimal invoiceLocalAmt = detailRow.getBigDecimal("e_invoicedlocamt");
            BigDecimal unInvoiceLocalAmt = detailRow.getBigDecimal("e_uninvoicedlocamt");
            BigDecimal unWoffAmt = detailRow.getBigDecimal("e_unwoffamt");
            BigDecimal unWoffLocAmt = detailRow.getBigDecimal("e_unwofflocamt");
            headInvoiceAmt = headInvoiceAmt.add(invoiceAmt);
            headUnInvoiceAmt = headUnInvoiceAmt.add(unInvoiceAmt);
            headInvoiceLocalAmt = headInvoiceLocalAmt.add(invoiceLocalAmt);
            headUnInvoiceLocalAmt = headUnInvoiceLocalAmt.add(unInvoiceLocalAmt);
            headUnWoffAmt = headUnWoffAmt.add(unWoffAmt);
            headUnWoffLocAmt = headUnWoffLocAmt.add(unWoffLocAmt);
        }
        busBill.set("invoicedamt", (Object)headInvoiceAmt);
        busBill.set("uninvoicedamt", (Object)headUnInvoiceAmt);
        busBill.set("invoicedlocamt", (Object)headInvoiceLocalAmt);
        busBill.set("uninvoicedlocamt", (Object)headUnInvoiceLocalAmt);
        busBill.set("unwoffamt", (Object)headUnWoffAmt);
        busBill.set("unwofflocamt", (Object)headUnWoffLocAmt);
    }

    public static BigDecimal getInvoiceQty(DynamicObject busBillDetailRow, boolean arBill) {
        BigDecimal busRecAmt;
        BigDecimal quantity = busBillDetailRow.getBigDecimal("e_quantity");
        BigDecimal busUnInvoiceAmt = busBillDetailRow.getBigDecimal("e_uninvoicedamt");
        BigDecimal coefficient = busUnInvoiceAmt.multiply(busRecAmt = busBillDetailRow.getBigDecimal(WriteOffBillWriteBackHelper.getBusBillPropertyMap(arBill).get("e_recAmt")));
        return coefficient.compareTo(BigDecimal.ZERO) > 0 ? BigDecimal.ZERO : quantity;
    }

    static {
        WriteOffBillWriteBackHelper.setFinArBillProperty();
        WriteOffBillWriteBackHelper.setFinApBillProperty();
        WriteOffBillWriteBackHelper.setArBusBillProperty();
        WriteOffBillWriteBackHelper.setApBusBillProperty();
    }
}

