/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.impt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class ArApSettleSchemeImport
extends BatchImportPlugin {
    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        HashMap<String, DynamicObject> orgMap = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> userMap = new HashMap<String, DynamicObject>();
        while (iterator.hasNext()) {
            JSONObject executer;
            ImportBillData importBillData = iterator.next();
            JSONObject data = importBillData.getData();
            String message = null;
            if (data.get((Object)"number") == null) {
                message = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u3010\u65b9\u6848\u7f16\u7801\u3011\u5b57\u6bb5\u3002", (String)"ArApSettleSchemeImport_0", (String)"fi-arapcommon", (Object[])new Object[0]);
            } else if (data.get((Object)"name") == null) {
                message = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u3010\u65b9\u6848\u540d\u79f0\u3011\u5b57\u6bb5\u3002", (String)"ArApSettleSchemeImport_1", (String)"fi-arapcommon", (Object[])new Object[0]);
            }
            Object orgEntry = data.get((Object)"orgentry");
            if (orgEntry != null) {
                for (Object row : (JSONArray)orgEntry) {
                    Object orgRow = ((JSONObject)row).get((Object)"org");
                    if (orgRow == null) continue;
                    String orgNum = String.valueOf(((JSONObject)orgRow).get((Object)"number"));
                    String orgName = String.valueOf(((JSONObject)orgRow).get((Object)"name"));
                    QFilter qFilter = null;
                    if (this.isNotEmpty(orgNum)) {
                        if (orgMap.get(orgNum) != null) continue;
                        qFilter = new QFilter("number", "=", (Object)orgNum);
                    } else {
                        if (!this.isNotEmpty(orgName)) {
                            message = ResManager.loadKDString((String)"\u8bf7\u8f93\u51fa\u7ed3\u7b97\u7ec4\u7ec7\u7f16\u7801\u6216\u540d\u79f0\u3002", (String)"ArApSettleSchemeImport_2", (String)"fi-arapcommon", (Object[])new Object[0]);
                            break;
                        }
                        qFilter = new QFilter("name", "=", (Object)orgName);
                    }
                    DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id, number, name", (QFilter[])new QFilter[]{qFilter});
                    if (ObjectUtils.isEmpty((Object)org)) {
                        message = String.format(ResManager.loadKDString((String)"\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u7f16\u7801\u201c%1$s\u201d\uff0c\u540d\u79f0\u201c%2$s\u201d\u3002", (String)"ArApSettleSchemeImport_3", (String)"fi-arapcommon", (Object[])new Object[0]), orgNum, orgName);
                        break;
                    }
                    orgMap.put(org.getString("number"), org);
                }
            } else {
                message = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u3010\u4f7f\u7528\u7ec4\u7ec7\u3011\u5b57\u6bb5\u3002", (String)"ArApSettleSchemeImport_4", (String)"fi-arapcommon", (Object[])new Object[0]);
            }
            if ((executer = (JSONObject)data.get((Object)"executer")) == null) {
                message = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u3010\u6267\u884c\u4eba\u3011\u5b57\u6bb5\u3002", (String)"ArApSettleSchemeImport_5", (String)"fi-arapcommon", (Object[])new Object[0]);
            } else {
                DynamicObject user;
                String userNumber = String.valueOf(executer.get((Object)"number"));
                if (this.isNotEmpty(userNumber) && (user = (DynamicObject)userMap.get(userNumber)) == null) {
                    QFilter qFilter = new QFilter("number", "=", (Object)userNumber);
                    user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id, number", (QFilter[])new QFilter[]{qFilter});
                    if (ObjectUtils.isEmpty((Object)user)) {
                        message = String.format(ResManager.loadKDString((String)"\u201c\u6267\u884c\u4eba\u201d\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u5de5\u53f7\u201c%s\u201d\u3002", (String)"ArApSettleSchemeImport_6", (String)"fi-arapcommon", (Object[])new Object[0]), executer);
                    } else {
                        userMap.put(userNumber, user);
                    }
                }
            }
            Object ruleEntry = data.get((Object)"ruleentry");
            if (ruleEntry != null) {
                Set<String> settleTypes = this.getSettleTypes();
                for (Object rule : (JSONArray)ruleEntry) {
                    String mainDateSrc;
                    JSONObject ruleJson = (JSONObject)rule;
                    String settleRelation = String.valueOf(ruleJson.get((Object)"settlerelation"));
                    if (!settleTypes.contains(settleRelation)) {
                        message = String.format(ResManager.loadKDString((String)"\u3010\u7ed3\u7b97\u5173\u7cfb\u3011\u4e0d\u5b58\u5728\uff1a\u201c%s\u201d\u3002", (String)"ArApSettleSchemeImport_7", (String)"fi-arapcommon", (Object[])new Object[0]), settleRelation);
                        break;
                    }
                    if (("appaysettle".equals(settleRelation) || "recsettle".equals(settleRelation)) && ruleJson.get((Object)"asstbill") == null) {
                        message = ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u662f\u5e94\u4ed8\u4ed8\u6b3e\u7ed3\u7b97/\u5e94\u6536\u6536\u6b3e\u7ed3\u7b97\u65f6\uff0c\u8bf7\u8f93\u5165\u8f85\u65b9\u5355\u636e\u3002", (String)"ArApSettleSchemeImport_8", (String)"fi-arapcommon", (Object[])new Object[0]);
                        break;
                    }
                    List<String> entityByRelation = SettleRelationEnum.getEntityByRelation(settleRelation);
                    String mainBillEntity = entityByRelation.get(0);
                    String asstBillEntity = entityByRelation.get(1);
                    DynamicObject mainBill = BusinessDataServiceHelper.newDynamicObject((String)mainBillEntity);
                    DynamicObject assBill = BusinessDataServiceHelper.newDynamicObject((String)asstBillEntity);
                    String matchFieldInfo = String.valueOf(ruleJson.get((Object)"matchfieldinfo"));
                    if (this.isNotEmpty(matchFieldInfo)) {
                        List fieldEntrys = (List)SerializationUtils.fromJsonString((String)matchFieldInfo, List.class);
                        for (Map fieldEntry : fieldEntrys) {
                            if (ObjectUtils.isEmpty(fieldEntry.get("asstfield")) || ObjectUtils.isEmpty(fieldEntry.get("mainfield"))) continue;
                            String asstField = String.valueOf(fieldEntry.get("asstfield"));
                            String mainField = String.valueOf(fieldEntry.get("mainfield"));
                            mainField = mainField.split("\\.")[0];
                            asstField = asstField.split("\\.")[0];
                            if (mainBill.containsProperty(mainField) && assBill.containsProperty(asstField)) continue;
                            message = String.format(ResManager.loadKDString((String)"\u5339\u914d\u5b57\u6bb5\u4fe1\u606f\u5b57\u6bb5\u914d\u7f6e\u9519\u8bef\uff0c\u5b57\u6bb5\u3010%1$s\u3011\u6216\u3010%2$s\u3011\u4e0d\u5b58\u5728\u3002", (String)"ArApSettleSchemeImport_9", (String)"fi-arapcommon", (Object[])new Object[0]), mainField, asstField);
                            break;
                        }
                    }
                    if (this.isNotEmpty(mainDateSrc = String.valueOf(ruleJson.get((Object)"maindatesrc"))) && !mainBill.containsProperty(mainDateSrc)) {
                        message = String.format(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u65e5\u671f\u6765\u6e90\u5b57\u6bb5\u3010%1$s\u3011\u4e0d\u5b58\u5728\u3002", (String)"ArApSettleSchemeImport_10", (String)"fi-arapcommon", (Object[])new Object[0]), mainDateSrc);
                        break;
                    }
                    String asstDateSrc = String.valueOf(ruleJson.get((Object)"asstdatesrc"));
                    if (this.isNotEmpty(asstDateSrc) && !assBill.containsProperty(asstDateSrc)) {
                        message = String.format(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u65e5\u671f\u6765\u6e90\u5b57\u6bb5\u3010%1$s\u3011\u4e0d\u5b58\u5728\u3002", (String)"ArApSettleSchemeImport_11", (String)"fi-arapcommon", (Object[])new Object[0]), mainDateSrc);
                        break;
                    }
                    String mainFilter = String.valueOf(ruleJson.get((Object)"mainfilter_tag"));
                    String asstFilter = String.valueOf(ruleJson.get((Object)"asstfilter_tag"));
                    if (this.isNotEmpty(mainFilter)) {
                        try {
                            this.buildQFilter(mainFilter, mainBillEntity);
                        }
                        catch (Exception e) {
                            message = e.getMessage();
                            break;
                        }
                    }
                    if (!this.isNotEmpty(asstFilter)) continue;
                    try {
                        this.buildQFilter(asstFilter, asstBillEntity);
                    }
                    catch (Exception e) {
                        message = e.getMessage();
                        break;
                    }
                }
            }
            if (message == null) continue;
            logger.log(Integer.valueOf(importBillData.getStartIndex()), message).fail();
            iterator.remove();
        }
        return super.save(rowdatas, logger);
    }

    private QFilter buildQFilter(String conditionVal, String billEntityName) {
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionVal, CRCondition.class);
        FilterCondition filterCondition = condition.getFilterCondition();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billEntityName);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
        filterBuilder.buildFilter(false);
        QFilter qfilter = filterBuilder.getQFilter();
        if (StringUtils.isNotEmpty(condition.getExpression())) {
            QFilter of = QFilter.of((String)condition.getExpression(), (Object[])new Object[0]);
            qfilter = EmptyUtils.isEmpty(qfilter) ? of : qfilter.and(of);
        }
        return qfilter;
    }

    private Set<String> getSettleTypes() {
        HashSet<String> settleTypes = new HashSet<String>(8);
        if (this.getBillFormId().startsWith("ar_")) {
            settleTypes.add("recsettle");
            settleTypes.add("arself");
            settleTypes.add("recself");
            settleTypes.add("arapsettle");
            settleTypes.add("recpaysettle");
        } else {
            settleTypes.add("appaysettle");
            settleTypes.add("apself");
            settleTypes.add("payself");
            settleTypes.add("aparsettle");
            settleTypes.add("payrecsettle");
        }
        return settleTypes;
    }

    private boolean isNotEmpty(String str) {
        return StringUtils.isNotEmpty(str) && !"null".equals(str);
    }
}

