/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.impt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.QuotationHelper;
import kd.fi.arapcommon.util.QueryUtil;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.ImportSettleVo;

public abstract class BaseSettleImportPlugin
extends BatchImportPlugin {
    private final Map<String, Object> dataCache = new HashMap<String, Object>(2);
    private final QueryUtil queryUtil = new QueryUtil();
    public static final String FINAPBILL = "billno,bizdate,org.number org,asstacttype,asstact.id asstact,currency.id,exchangerate,pricetaxtotal,detailentry.unlockamt unlockamt,basecurrency.id,exratetable.id,exratedate,quotation,id,billstatus";
    public static final String FINARBILL = "billno,bizdate,org.number org,asstacttype,asstact.id asstact,currency.id,exchangerate,recamount pricetaxtotal,entry.e_unlockamt unlockamt,basecurrency.id,exratetable.id,exratedate,quotation,id,billstatus";
    public static final String RECBILL = "billno,bizdate,payertype asstacttype,payer asstact,entry.e_settleorg.number org,currency.id,exchangerate,entry.e_receivableamt pricetaxtotal,entry.e_unsettledamt unlockamt,basecurrency.id,exratetable.id,exratedate,quotation,id,billstatus";
    public static final String PAYBILL = "billno,bizdate,payeetype asstacttype,payee asstact,entry.settleorg.number org,currency.id,exchangerate,entry.e_payableamt pricetaxtotal,entry.e_unsettledamt unlockamt,basecurrency.id,exratetable.id,exratedate,payquotation quotation,id,billstatus";

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.checkBatchNo(rowdatas);
        Map<String, Set<String>> billNoTypeGroup = this.getBillNoGroupByType(rowdatas);
        Map<String, Map<String, ImportSettleVo>> billMapGroupByType = this.getAllBills(billNoTypeGroup);
        this.loopRowDatas(rowdatas, logger, billMapGroupByType);
        return super.save(rowdatas, logger);
    }

    public void loopRowDatas(List<ImportBillData> rowdatas, ImportLogger logger, Map<String, Map<String, ImportSettleVo>> billGroupByType) {
        List<String> rightRelation = this.getSettleRelation();
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData rowdata = iterator.next();
            JSONObject data = rowdata.getData();
            String message = this.checkAndPut(data, billGroupByType, rightRelation);
            if (message == null) continue;
            logger.log(Integer.valueOf(rowdata.getStartIndex()), message).fail();
            iterator.remove();
        }
    }

    public abstract String checkDataInfo(JSONObject var1, String var2, List<String> var3, Map<String, ImportSettleVo> var4, ImportSettleVo var5, List<ImportSettleVo> var6, String var7, String var8, String var9, String var10);

    private void checkBatchNo(List<ImportBillData> rowdatas) {
        HashSet<String> batchNos = new HashSet<String>(2);
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            String batchNumber = (String)data.get((Object)"batchnumber");
            batchNos.add(batchNumber);
            if (batchNos.size() <= 1) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u6279\u6b21\u53f7\u5fc5\u987b\u4e00\u81f4", (String)"BaseSettleImportPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        boolean existsBatchNo = QueryServiceHelper.exists((String)this.getEntityName(), (QFilter[])new QFilter[]{new QFilter("batchnumber", "=", batchNos.iterator().next())});
        if (existsBatchNo) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u7b97\u6279\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"BaseSettleImportPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    public abstract String getEntityName();

    private String checkAndPut(JSONObject data, Map<String, Map<String, ImportSettleVo>> billGroupByType, List<String> relations) {
        String message = null;
        JSONObject orgJson = (JSONObject)data.get((Object)"org");
        String orgNumber = orgJson.getString("number");
        String settleRelation = data.getString("settlerelation");
        try {
            List<ImportSettleVo> asstBillVos;
            ImportSettleVo mainBillVo;
            message = this.checkOrg(orgNumber);
            if (message != null) {
                return message;
            }
            if (!relations.contains(settleRelation)) {
                return String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e0d\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BaseSettleImportPlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]), orgNumber);
            }
            String mainBillNo = data.getString("mainbillnum");
            List<String> asstBillNos = this.getAsstBillnos(data);
            List<String> entitys = SettleRelationEnum.getEntityByRelation(settleRelation);
            String mainEntity = entitys.get(0);
            String asstEneity = entitys.get(1);
            Map<String, ImportSettleVo> mainSettleVoMap = billGroupByType.get(mainEntity);
            Map<String, ImportSettleVo> asstSettleVoMap = billGroupByType.get(asstEneity);
            message = this.checkDataInfo(data, mainBillNo, asstBillNos, asstSettleVoMap, mainBillVo = mainSettleVoMap.get(mainBillNo), asstBillVos = this.getAsstBill(asstEneity, billGroupByType, asstBillNos), settleRelation, orgNumber, mainEntity, asstEneity);
            if (message == null) {
                this.putBillFromVo(data, mainBillVo, asstSettleVoMap, mainEntity, asstEneity);
            }
        }
        catch (KDBizException e) {
            message = e.getMessage();
        }
        return message;
    }

    private void putBillFromVo(JSONObject data, ImportSettleVo mainBillVo, Map<String, ImportSettleVo> asstBillVoMap, String mainEntity, String asstEntity) {
        String mainQuotation = mainBillVo.getQuotation();
        BigDecimal totalsettleamt = data.getBigDecimal("totalsettleamt");
        BigDecimal mainExchangeRate = mainBillVo.getExchangerate();
        int mainPrecision = mainBillVo.getPrecision();
        data.put("mainbizdate", (Object)mainBillVo.getBizdate());
        data.put("mainasstacttype", (Object)mainBillVo.getAsstacttype());
        data.put("mainasstactid", (Object)mainBillVo.getAssttactNumber());
        data.put("maincurrency", (Object)mainBillVo.getCurrencyId());
        data.put("exchangerate", (Object)mainExchangeRate);
        data.put("mainpayableamt", (Object)mainBillVo.getPricetaxtotal());
        data.put("totalunsettledamt", (Object)mainBillVo.getCanSettleamt());
        data.put("localtotalsettleamt", (Object)QuotationHelper.getLocamtByQuotation(mainQuotation, totalsettleamt, mainExchangeRate, mainPrecision));
        data.put("basecurrency", (Object)mainBillVo.getBaseCurrencyId());
        data.put("exratetable", (Object)mainBillVo.getExratetableId());
        data.put("exratedate", (Object)mainBillVo.getExrateDate());
        data.put("quotation", (Object)mainQuotation);
        data.put("mainbillid", (Object)mainBillVo.getId());
        data.put("billentity", (Object)mainEntity);
        JSONArray rows = (JSONArray)data.get((Object)"entry");
        for (Object o : rows) {
            JSONObject row = (JSONObject)o;
            String asstBillNo = (String)row.get((Object)"billnum");
            ImportSettleVo asstBillVo = asstBillVoMap.get(asstBillNo);
            String asstQuotation = asstBillVo.getQuotation();
            BigDecimal asstExchangeRate = asstBillVo.getExchangerate();
            BigDecimal settleamt = row.getBigDecimal("settleamt");
            int asstPrecision = asstBillVo.getPrecision();
            row.put("billdate", (Object)asstBillVo.getBizdate());
            row.put("asstacttype", (Object)asstBillVo.getAsstacttype());
            row.put("asstactid", (Object)asstBillVo.getAssttactNumber());
            row.put("asstact", (Object)asstBillVo.getAssttactNumber());
            row.put("currency", (Object)asstBillVo.getCurrencyId());
            row.put("e_exchangerate", (Object)asstExchangeRate);
            row.put("payableamt", (Object)asstBillVo.getPricetaxtotal());
            row.put("unsettledamt", (Object)asstBillVo.getCanSettleamt());
            row.put("settleamt", (Object)settleamt);
            row.put("localsettleamt", (Object)QuotationHelper.getLocamtByQuotation(asstQuotation, settleamt, asstExchangeRate, asstPrecision));
            row.put("e_basecurrency", (Object)asstBillVo.getBaseCurrencyId());
            row.put("e_exratetable", (Object)asstBillVo.getExratetableId());
            row.put("e_exratedate", (Object)asstBillVo.getExrateDate());
            row.put("e_quotation", (Object)asstQuotation);
            row.put("billid", (Object)asstBillVo.getId());
            row.put("e_billentity", (Object)asstEntity);
        }
    }

    private List<ImportSettleVo> getAsstBill(String entity, Map<String, Map<String, ImportSettleVo>> billGroupByType, List<String> asstBillNos) {
        ArrayList<ImportSettleVo> asstBillVos = new ArrayList<ImportSettleVo>(2);
        Map<String, ImportSettleVo> importSettleVoMap = billGroupByType.get(entity);
        for (String asstBillNo : asstBillNos) {
            ImportSettleVo asstBillVo = importSettleVoMap.get(asstBillNo);
            if (ObjectUtils.isEmpty((Object)asstBillVo)) continue;
            asstBillVos.add(asstBillVo);
        }
        return asstBillVos;
    }

    private List<String> getAsstBillnos(JSONObject data) {
        ArrayList<String> asstBillnos = new ArrayList<String>(2);
        JSONArray rows = (JSONArray)data.get((Object)"entry");
        for (int i = 0; i < rows.size(); ++i) {
            JSONObject row = (JSONObject)rows.get(i);
            asstBillnos.add((String)row.get((Object)"billnum"));
        }
        return asstBillnos;
    }

    public String checkAsstBillNo(List<String> asstBillNos, Map<String, ImportSettleVo> asstVos, String orgNumber, String entity) {
        for (String asstBillNo : asstBillNos) {
            ImportSettleVo asstBillVo = asstVos.get(asstBillNo);
            String existsAsstBill = this.existsBillNo(asstBillVo, orgNumber, entity, asstBillNo);
            if (existsAsstBill == null) continue;
            return existsAsstBill;
        }
        return null;
    }

    public String checkCanSettleAmt(JSONObject data, String settleRelation, ImportSettleVo mainBillVo, List<ImportSettleVo> asstBillVos, String relationName) {
        Long mainCurrencyId;
        if (mainBillVo == null || asstBillVos == null) {
            return null;
        }
        HashSet<Long> asstCurrencyIds = new HashSet<Long>(2);
        BigDecimal mainCurrentAmt = data.getBigDecimal("totalsettleamt");
        BigDecimal mainCanSettleAmt = mainBillVo.getCanSettleamt();
        int mainResult = mainCanSettleAmt.compareTo(mainCurrentAmt);
        if ("aprecsettle".equals(settleRelation) || "arpaysettle".equals(settleRelation) ? mainResult > -1 : mainResult < 0) {
            return String.format(ResManager.loadKDString((String)"%s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u4e3b\u65b9\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u5355\u636e\u53ef\u7ed3\u7b97\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BaseSettleImportPlugin_3", (String)"fi-arapcommon", (Object[])new Object[0]), relationName);
        }
        JSONArray rows = (JSONArray)data.get((Object)"entry");
        BigDecimal asstCurrentAmt = BigDecimal.ZERO;
        BigDecimal asstCanSettleAmt = BigDecimal.ZERO;
        for (Object o : rows) {
            JSONObject row = (JSONObject)o;
            asstCurrentAmt = asstCurrentAmt.add(row.getBigDecimal("settleamt"));
        }
        for (ImportSettleVo asstBillVo : asstBillVos) {
            asstCanSettleAmt = asstCanSettleAmt.add(asstBillVo.getCanSettleamt());
            asstCurrencyIds.add(asstBillVo.getCurrencyId());
        }
        int asstResult = asstCanSettleAmt.compareTo(asstCurrentAmt);
        if ("apself".equals(settleRelation) || "arself".equals(settleRelation) || "payself".equals(settleRelation) || "recself".equals(settleRelation) ? asstResult > -1 : asstResult < 0) {
            return String.format(ResManager.loadKDString((String)"%s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u4e3b\u65b9\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u8d85\u8fc7\u5355\u636e\u53ef\u7ed3\u7b97\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BaseSettleImportPlugin_3", (String)"fi-arapcommon", (Object[])new Object[0]), relationName);
        }
        if (asstCurrencyIds.size() == 1 && asstCurrencyIds.contains(mainCurrencyId = mainBillVo.getCurrencyId()) && mainCurrentAmt.compareTo(asstCurrentAmt) != 0) {
            return String.format(ResManager.loadKDString((String)"%s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u4e3b\u8f85\u65b9\u5355\u636e\u5e01\u79cd\u76f8\u540c\uff0c\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u5fc5\u987b\u76f8\u540c\u3002", (String)"BaseSettleImportPlugin_4", (String)"fi-arapcommon", (Object[])new Object[0]), relationName);
        }
        return null;
    }

    public Long BizPartnerId(ImportSettleVo vo) {
        String asstactType = vo.getAsstacttype();
        Long asstactNumber = vo.getAssttactNumber();
        if ("bd_customer".equals(asstactType)) {
            String key = "bd_customer" + asstactNumber;
            Long bizPartnerId = (Long)this.dataCache.get(key);
            if (bizPartnerId == null) {
                DynamicObject customer = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstactNumber)});
                bizPartnerId = customer.getLong("bizpartner.id");
                this.dataCache.put(key, bizPartnerId);
            }
            return bizPartnerId;
        }
        if ("bd_supplier".equals(asstactType)) {
            String key = "bd_supplier" + asstactNumber;
            Long bizPartnerId = (Long)this.dataCache.get(key);
            if (bizPartnerId == null) {
                DynamicObject supplier = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)asstactNumber)});
                bizPartnerId = supplier.getLong("bizpartner.id");
                this.dataCache.put(key, bizPartnerId);
            }
            return bizPartnerId;
        }
        return null;
    }

    public String asstactCheck(ImportSettleVo mainVo, List<ImportSettleVo> asstVos, String settleRelation) {
        String mainAsstType = mainVo.getAsstacttype();
        Long mainAsstId = mainVo.getAssttactNumber();
        for (ImportSettleVo asstVo : asstVos) {
            String asstAsstType = asstVo.getAsstacttype();
            Long asstAsstId = asstVo.getAssttactNumber();
            if (mainAsstType.equals(asstAsstType) || mainAsstId.equals(asstAsstId)) continue;
            return String.format(ResManager.loadKDString((String)"%s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u4e3b\u8f85\u65b9\u5355\u636e\u7684\u5f80\u6765\u7c7b\u578b\u3001\u5f80\u6765\u6237\u5fc5\u987b\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BaseSettleImportPlugin_5", (String)"fi-arapcommon", (Object[])new Object[0]), settleRelation);
        }
        return null;
    }

    public String existsBillNo(ImportSettleVo vo, String orgNumber, String entity, String billNo) {
        if ("ap_finapbill".equals(entity)) {
            if (vo == null || !vo.getOrgName().equals(orgNumber)) {
                return String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7%1$s\u4e0b\u4e0d\u5b58\u5728\u5355\u636e\u7f16\u53f7%2$s\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u3002", (String)"BaseSettleImportPlugin_6", (String)"fi-arapcommon", (Object[])new Object[0]), orgNumber, billNo);
            }
            String mainBillStatus = vo.getStatus();
            if (!"C".equals(mainBillStatus)) {
                return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BaseSettleImportPlugin_7", (String)"fi-arapcommon", (Object[])new Object[0]), vo.getBillno());
            }
        } else if ("ar_finarbill".equals(entity)) {
            if (vo == null || !vo.getOrgName().equals(orgNumber)) {
                return String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7%1$s\u4e0b\u4e0d\u5b58\u5728\u5355\u636e\u7f16\u53f7%2$s\u7684\u8d22\u52a1\u5e94\u6536\u5355\u3002", (String)"BaseSettleImportPlugin_8", (String)"fi-arapcommon", (Object[])new Object[0]), orgNumber, billNo);
            }
            String mainBillStatus = vo.getStatus();
            if (!"C".equals(mainBillStatus)) {
                return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BaseSettleImportPlugin_9", (String)"fi-arapcommon", (Object[])new Object[0]), vo.getBillno());
            }
        } else if ("cas_paybill".equals(entity)) {
            if (vo == null || !vo.getOrgName().equals(orgNumber)) {
                return String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7%1$s\u4e0b\u4e0d\u5b58\u5728\u5355\u636e\u7f16\u53f7%2$s\u7684\u4ed8\u6b3e\u5355\u3002", (String)"BaseSettleImportPlugin_10", (String)"fi-arapcommon", (Object[])new Object[0]), orgNumber, billNo);
            }
            String asstBillStatus = vo.getStatus();
            if (!"D".equals(asstBillStatus)) {
                return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u4ed8\u6b3e\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BaseSettleImportPlugin_11", (String)"fi-arapcommon", (Object[])new Object[0]), billNo);
            }
        } else {
            if (vo == null || !vo.getOrgName().equals(orgNumber)) {
                return String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7%1$s\u4e0b\u4e0d\u5b58\u5728\u5355\u636e\u7f16\u53f7%2$s\u7684\u6536\u6b3e\u5355\u3002", (String)"BaseSettleImportPlugin_12", (String)"fi-arapcommon", (Object[])new Object[0]), orgNumber, billNo);
            }
            String asstBillStatus = vo.getStatus();
            if (!"D".equals(asstBillStatus)) {
                return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\u7684\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u5df2\u6536\u6b3e\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BaseSettleImportPlugin_13", (String)"fi-arapcommon", (Object[])new Object[0]), billNo);
            }
        }
        return null;
    }

    public String checkDirection(ImportSettleVo mainBillVo, List<ImportSettleVo> asstBillVos, String settleRelation) {
        BigDecimal mainCanSettleAmt = mainBillVo.getCanSettleamt();
        int mainDirection = mainCanSettleAmt.signum();
        if (mainDirection == 0) {
            return String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u53ef\u7ed3\u7b97\u91d1\u989d\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseSettleImportPlugin_14", (String)"fi-arapcommon", (Object[])new Object[0]), mainBillVo.getBillno());
        }
        for (ImportSettleVo asstBillVo : asstBillVos) {
            int asstDirection = asstBillVo.getCanSettleamt().signum();
            if (asstDirection == 0) {
                return String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u53ef\u7ed3\u7b97\u91d1\u989d\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseSettleImportPlugin_14", (String)"fi-arapcommon", (Object[])new Object[0]), asstBillVo.getBillno());
            }
            if (asstDirection == mainDirection) continue;
            return String.format(ResManager.loadKDString((String)"%s\u7ed3\u7b97\u5173\u7cfb\u4e0b\uff0c\u4e3b\u8f85\u65b9\u5355\u636e\u91d1\u989d\u65b9\u5411\u5fc5\u987b\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BaseSettleImportPlugin_15", (String)"fi-arapcommon", (Object[])new Object[0]), settleRelation);
        }
        return null;
    }

    public String checkOrg(String orgNumber) {
        DynamicObject init;
        String message = null;
        String orgKey = "bos_org_" + orgNumber;
        DynamicObject org = (DynamicObject)this.dataCache.get(orgKey);
        if (org == null) {
            org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
            this.dataCache.put(orgKey, org);
        }
        if ((init = this.queryUtil.getInitObj(org.getLong("id"), "ap_init")) == null || init.getDate("startdate") == null) {
            message = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7%s\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"BaseSettleImportPlugin_16", (String)"fi-arapcommon", (Object[])new Object[0]), orgNumber);
        }
        return message;
    }

    private Map<String, Map<String, ImportSettleVo>> getAllBills(Map<String, Set<String>> billNoGroupByType) {
        HashMap<String, Map<String, ImportSettleVo>> bills = new HashMap<String, Map<String, ImportSettleVo>>(2);
        Set<String> finApBillNo = billNoGroupByType.get("apbill");
        Set<String> finArBillNo = billNoGroupByType.get("arbill");
        Set<String> payBillNo = billNoGroupByType.get("paybill");
        Set<String> recBillNo = billNoGroupByType.get("recbill");
        if (finApBillNo.size() > 0) {
            Map<String, ImportSettleVo> finApBills = this.getBatchBillMap(finApBillNo, "ap_finapbill", FINAPBILL);
            bills.put("ap_finapbill", finApBills);
        }
        if (finArBillNo.size() > 0) {
            Map<String, ImportSettleVo> finArBills = this.getBatchBillMap(finArBillNo, "ar_finarbill", FINARBILL);
            bills.put("ar_finarbill", finArBills);
        }
        if (payBillNo.size() > 0) {
            Map<String, ImportSettleVo> payBills = this.getBatchBillMap(payBillNo, "cas_paybill", PAYBILL);
            bills.put("cas_paybill", payBills);
        }
        if (recBillNo.size() > 0) {
            Map<String, ImportSettleVo> recBills = this.getBatchBillMap(recBillNo, "cas_recbill", RECBILL);
            bills.put("cas_recbill", recBills);
        }
        return bills;
    }

    public Map<String, ImportSettleVo> getBatchBillMap(Set<String> billNos, String entity, String selector) {
        Map<String, ImportSettleVo> importSettleVoMap = new HashMap<String, ImportSettleVo>(8);
        if (ObjectUtils.isEmpty(billNos) || StringUtils.isEmpty(entity) || StringUtils.isEmpty(selector)) {
            return importSettleVoMap;
        }
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entity, (String)selector, (QFilter[])new QFilter[]{new QFilter("billno", "in", billNos)});
        Map<String, List<DynamicObject>> importSettleVos = bills.stream().collect(Collectors.groupingBy(v -> v.getString("billno")));
        importSettleVoMap = this.mergeBillByNo(importSettleVos, entity);
        return importSettleVoMap;
    }

    private Map<String, ImportSettleVo> mergeBillByNo(Map<String, List<DynamicObject>> importSettleVos, String entity) {
        HashMap<String, ImportSettleVo> importSettleVoMap = new HashMap<String, ImportSettleVo>(8);
        for (Map.Entry<String, List<DynamicObject>> entry : importSettleVos.entrySet()) {
            List<DynamicObject> value = entry.getValue();
            DynamicObject bill = value.get(0);
            Long baseCurrencyId = bill.getLong("basecurrency.id");
            String currencyKey = "currency_" + baseCurrencyId;
            Object precision = this.dataCache.get(currencyKey);
            if (ObjectUtils.isEmpty((Object)precision)) {
                DynamicObject basecurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)baseCurrencyId, (String)"bd_currency");
                precision = basecurrency.get("amtprecision");
                this.dataCache.put(currencyKey, precision);
            }
            ImportSettleVo importSettleVo = new ImportSettleVo();
            importSettleVo.setBillno(bill.getString("billno"));
            importSettleVo.setBizdate(bill.getDate("bizdate"));
            importSettleVo.setCurrencyId(bill.getLong("currency.id"));
            importSettleVo.setExchangerate(bill.getBigDecimal("exchangerate"));
            importSettleVo.setBaseCurrencyId(bill.getLong("basecurrency.id"));
            importSettleVo.setPrecision((Integer)precision);
            importSettleVo.setExratetableId(bill.getLong("exratetable.id"));
            importSettleVo.setExrateDate(bill.getDate("exratedate"));
            importSettleVo.setId(bill.getLong("id"));
            importSettleVo.setOrgName(bill.getString("org"));
            importSettleVo.setAsstacttype(bill.getString("asstacttype"));
            importSettleVo.setAssttactNumber(bill.getLong("asstact"));
            importSettleVo.setQuotation(bill.getString("quotation"));
            importSettleVo.setStatus(bill.getString("billstatus"));
            importSettleVo.setPricetaxtotal(bill.getBigDecimal("pricetaxtotal"));
            BigDecimal canSettleAmt = BigDecimal.ZERO;
            for (DynamicObject entryrow : value) {
                canSettleAmt = canSettleAmt.add(entryrow.getBigDecimal("unlockamt"));
            }
            importSettleVo.setCanSettleamt(canSettleAmt);
            if ("cas_paybill".equals(entity) || "cas_recbill".equals(entity)) {
                BigDecimal pricetaxtotal = BigDecimal.ZERO;
                for (DynamicObject entryrow : value) {
                    pricetaxtotal = pricetaxtotal.add(entryrow.getBigDecimal("pricetaxtotal"));
                }
                importSettleVo.setPricetaxtotal(pricetaxtotal);
            }
            importSettleVoMap.put(bill.getString("billno"), importSettleVo);
        }
        return importSettleVoMap;
    }

    private Map<String, Set<String>> getBillNoGroupByType(List<ImportBillData> rowdatas) {
        HashMap<String, Set<String>> billGroupByType = new HashMap<String, Set<String>>(2);
        Map<String, List<ImportBillData>> settlerelation = rowdatas.stream().collect(Collectors.groupingBy(v -> v.getData().getString("settlerelation")));
        HashSet<String> finApBillNos = new HashSet<String>(2);
        HashSet<String> finArBillNos = new HashSet<String>(2);
        HashSet<String> recBillNos = new HashSet<String>(2);
        HashSet<String> payBillNos = new HashSet<String>(2);
        for (Map.Entry<String, List<ImportBillData>> entry : settlerelation.entrySet()) {
            String key = entry.getKey();
            List<ImportBillData> value = entry.getValue();
            switch (key) {
                case "appaysettle": {
                    this.getSettleBillNo(value, finApBillNos, payBillNos);
                    break;
                }
                case "payself": {
                    this.getSettleBillNo(value, payBillNos, payBillNos);
                    break;
                }
                case "apself": {
                    this.getSettleBillNo(value, finApBillNos, finApBillNos);
                    break;
                }
                case "aparsettle": {
                    this.getSettleBillNo(value, finApBillNos, finArBillNos);
                    break;
                }
                case "payrecsettle": {
                    this.getSettleBillNo(value, payBillNos, recBillNos);
                    break;
                }
                case "aprecsettle": {
                    this.getSettleBillNo(value, finApBillNos, recBillNos);
                    break;
                }
                case "recsettle": {
                    this.getSettleBillNo(value, finArBillNos, recBillNos);
                    break;
                }
                case "arself": {
                    this.getSettleBillNo(value, finArBillNos, finArBillNos);
                    break;
                }
                case "arapsettle": {
                    this.getSettleBillNo(value, finArBillNos, finApBillNos);
                    break;
                }
                case "recself": {
                    this.getSettleBillNo(value, recBillNos, recBillNos);
                    break;
                }
                case "recpaysettle": {
                    this.getSettleBillNo(value, recBillNos, payBillNos);
                    break;
                }
                case "arpaysettle": {
                    this.getSettleBillNo(value, finArBillNos, payBillNos);
                }
            }
        }
        billGroupByType.put("apbill", finApBillNos);
        billGroupByType.put("arbill", finArBillNos);
        billGroupByType.put("paybill", payBillNos);
        billGroupByType.put("recbill", recBillNos);
        return billGroupByType;
    }

    private void getSettleBillNo(List<ImportBillData> importBillDatas, Set<String> mainBillNos, Set<String> asstBillNos) {
        for (ImportBillData importBillData : importBillDatas) {
            JSONObject data = importBillData.getData();
            mainBillNos.add((String)data.get((Object)"mainbillnum"));
            JSONArray rows = (JSONArray)data.get((Object)"entry");
            for (int i = 0; i < rows.size(); ++i) {
                JSONObject row = (JSONObject)rows.get(i);
                asstBillNos.add((String)row.get((Object)"billnum"));
            }
        }
    }

    public abstract List<String> getSettleRelation();

    protected boolean isForceBatch() {
        return true;
    }
}

