/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.init;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.init.ISchemeImport;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public abstract class AbstractSchemeImport
implements ISchemeImport {
    protected String entityKey;
    protected Long orgPk;
    protected DynamicObject init;

    public AbstractSchemeImport(String entityKey, Long orgPk, DynamicObject init) {
        this.entityKey = entityKey;
        this.orgPk = orgPk;
        this.init = init;
    }

    @Override
    public List<Map<String, Object>> convert(List<Map<String, Object>> balanceList, DynamicObject entry) {
        ArrayList<Map<String, Object>> impDatas = new ArrayList<Map<String, Object>>(balanceList.size());
        for (Map<String, Object> balance : balanceList) {
            Map<String, Object> dataMap = this.buildBill(balance, entry);
            impDatas.add(dataMap);
        }
        return impDatas;
    }

    private Map<String, Object> buildBill(Map<String, Object> balance, DynamicObject entry) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        dataMap.put("org", this.basedata(this.orgPk));
        dataMap.put("billsrctype", BillSrcTypeEnum.GLIMPT.getValue());
        Date bizDate = DateUtils.getLastDay(this.init.getDate("startdate"), 1);
        dataMap.put("bizdate", bizDate);
        dataMap.put("currency", this.basedata(Long.valueOf(balance.get("currency").toString())));
        dataMap.put("exratedate", bizDate);
        this.billProperty(dataMap, balance, entry);
        ArrayList<Map<String, Object>> entries = new ArrayList<Map<String, Object>>(1);
        Map<String, Object> entryMap = this.setEntry(balance, entry);
        this.setMappingField(dataMap, entryMap, balance, entry);
        entries.add(entryMap);
        if ("ap_finapbill".equals(this.entityKey)) {
            dataMap.put("detailentry", entries);
        } else {
            dataMap.put("entry", entries);
        }
        return dataMap;
    }

    private void setMappingField(Map<String, Object> dataMap, Map<String, Object> entryMap, Map<String, Object> balance, DynamicObject entry) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.entityKey);
        for (int i = 0; i < 6; ++i) {
            String fieldKey = entry.getString("e_mappingfield" + (i + 1));
            if (ObjectUtils.isEmpty((Object)fieldKey)) continue;
            DynamicObject m_asstactitem = entry.getDynamicObject("e_asstactitem" + (i + 1));
            Object pk = balance.get(m_asstactitem.getString("flexfield"));
            Map<String, Object> value = this.basedata(Long.parseLong(pk.toString()));
            IDataEntityProperty prop = mainType.findProperty(fieldKey);
            if (ObjectUtils.isEmpty((Object)prop)) {
                String mappingfieldname = entry.getString("e_mappingfieldname" + (i + 1));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0a\u4e0d\u5b58\u5728%2$s\u5b57\u6bb5\u3002", (String)"AbstractSchemeImport_0", (String)"fi-arapcommon", (Object[])new Object[0]), this.entityKey, mappingfieldname));
            }
            if (prop.getParent() instanceof MainEntityType) {
                dataMap.put(fieldKey, value);
                continue;
            }
            if (!(prop.getParent() instanceof EntryType)) continue;
            entryMap.put(fieldKey, value);
        }
    }

    protected Map<String, Object> setEntry(Map<String, Object> balance, DynamicObject entry) {
        HashMap<String, Object> entryMap = new HashMap<String, Object>(0);
        if ("ap_finapbill".equals(this.entityKey)) {
            entryMap.put("material", this.basedata(entry.getDynamicObject("e_material")));
            entryMap.put("expenseitem", this.basedata(entry.getDynamicObject("e_expenseitem")));
        } else {
            entryMap.put("e_material", this.basedata(entry.getDynamicObject("e_material")));
            entryMap.put("e_expenseitem", this.basedata(entry.getDynamicObject("e_expenseitem")));
        }
        this.billEntryProperty(entryMap, balance, entry);
        return entryMap;
    }

    protected Map<String, Object> basedata(DynamicObject obj) {
        Map<String, Object> basedate = null;
        if (!ObjectUtils.isEmpty((Object)obj)) {
            basedate = this.basedata((Long)obj.getPkValue());
        }
        return basedate;
    }

    protected Map<String, Object> basedata(Long pk) {
        HashMap<String, Long> basedate = null;
        if (EmptyUtils.isNotEmpty(pk)) {
            basedate = new HashMap<String, Long>(1);
            basedate.put("id", pk);
        }
        return basedate;
    }

    protected abstract void billProperty(Map<String, Object> var1, Map<String, Object> var2, DynamicObject var3);

    protected abstract void billEntryProperty(Map<String, Object> var1, Map<String, Object> var2, DynamicObject var3);

    protected long getAsstactitemPk(String asstacttype, long asstactitemPk) {
        if (asstactitemPk == 0L) {
            return asstactitemPk;
        }
        DynamicObject asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)asstactitemPk, (String)asstacttype, (String)"id");
        if (EmptyUtils.isEmpty(asstact) && EmptyUtils.isNotEmpty(asstact = BusinessDataServiceHelper.loadSingleFromCache((String)asstacttype, (String)"id", (QFilter[])new QFilter[]{new QFilter("internal_company", "=", (Object)asstactitemPk)}))) {
            asstactitemPk = asstact.getLong("id");
        }
        return asstactitemPk;
    }

    protected Long getFisbankroll(Long orgid) {
        DynamicObjectCollection structure;
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)"bos_org", (String)"id, fisbankroll, structure, structure.viewparent");
        if (!EmptyUtils.isEmpty(org) && !org.getBoolean("fisbankroll") && (structure = org.getDynamicObjectCollection("structure")) != null && structure.size() > 0) {
            DynamicObject s = (DynamicObject)structure.get(0);
            DynamicObject viewparent = s.getDynamicObject("viewparent");
            if (viewparent != null && viewparent.getLong("id") != orgid.longValue()) {
                Long parentId = viewparent.getLong("id");
                return this.getFisbankroll(parentId);
            }
            orgid = 0L;
        }
        return orgid;
    }
}

