/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.init;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.init.ISchemeImport;

public class GlImportFactory {
    private static final Log logger = LogFactory.getLog(GlImportFactory.class);
    private static Map<String, String> serviceMap = new HashMap<String, String>(6);

    public static ISchemeImport getService(String entityKey, Long orgPk, DynamicObject init) {
        ISchemeImport iScheme = null;
        String className = serviceMap.get(entityKey);
        if (className == null) {
            throw new KDBizException(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b\u672a\u627e\u5230\u3002", (String)"GlImportFactory_0", (String)"fi-arapcommon", (Object[])new Object[]{entityKey}));
        }
        try {
            Class<?> forName = Class.forName(className);
            Constructor<?> constructor = forName.getConstructor(String.class, Long.class, DynamicObject.class);
            iScheme = (ISchemeImport)constructor.newInstance(entityKey, orgPk, init);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            logger.error("---glimport.newInstance---", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b\u672a\u627e\u5230\u3002", (String)"GlImportFactory_0", (String)"fi-arapcommon", (Object[])new Object[]{entityKey})), new Object[0]);
        }
        catch (Exception e) {
            logger.error("---glimport.convert---", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u5bfc\u5165\u65b9\u6848\u8f6c\u6362\u5f02\u5e38\uff1a%s", (String)"GlImportFactory_1", (String)"fi-arapcommon", (Object[])new Object[]{e.getMessage()})), new Object[0]);
        }
        return iScheme;
    }

    static {
        serviceMap.put("ap_busbill", "kd.fi.arapcommon.init.impl.BusApBillSchemeImpl");
        serviceMap.put("ap_finapbill", "kd.fi.arapcommon.init.impl.FinApBillSchemeImpl");
        serviceMap.put("ap_paidbill", "kd.fi.arapcommon.init.impl.PaidBillSchemeImpl");
        serviceMap.put("ar_busbill", "kd.fi.arapcommon.init.impl.BusArBillSchemeImpl");
        serviceMap.put("ar_finarbill", "kd.fi.arapcommon.init.impl.FinArBillSchemeImpl");
        serviceMap.put("ar_receivedbill", "kd.fi.arapcommon.init.impl.ReceivedBillSchemeImpl");
    }
}

