/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.init;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.util.DateUtils;

public class GlImportLogService {
    private static final String SUCCESS = "0";
    private static final String IMPORT = "1";

    public static DynamicObject newImportLog(DynamicObject scheme, long userId) {
        DynamicObject settleLog = BusinessDataServiceHelper.newDynamicObject((String)"ar_glimportlog");
        settleLog.set("billno", (Object)new SimpleDateFormat("yyyyMMddHHmmssSSSS").format(new Date()));
        settleLog.set("executor", (Object)userId);
        settleLog.set("creator", (Object)userId);
        settleLog.set("starttime", (Object)new Date());
        settleLog.set("importstate", (Object)IMPORT);
        settleLog.set("org", (Object)scheme.getDynamicObject("useorg"));
        settleLog.set("schemeid", scheme.getPkValue());
        try (TXHandle tx = TX.requiresNew((String)"newImportLog");){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{settleLog});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        return settleLog;
    }

    public static void updateErrorInfo(DynamicObject importLog, String errorInfo) {
        importLog.set("errordesc", (Object)(errorInfo.length() > 255 ? errorInfo.substring(0, 255) : errorInfo));
        importLog.set("errordesc_tag", (Object)errorInfo);
    }

    public static void updateSuccDataCount(DynamicObject importLog, String entityKey, int count) {
        Map<String, String> fieldMapping = GlImportLogService.getImpCountFieldMapping();
        importLog.set(fieldMapping.get(entityKey), (Object)count);
    }

    public static void updateProgressComplete(DynamicObject importLog) {
        importLog.set("importstate", (Object)SUCCESS);
        importLog.set("endtime", (Object)new Date());
        String endDate = DateUtils.formatString(importLog.getDate("endtime"), "yyyy-MM-dd HH:mm:ss");
        String startDate = DateUtils.formatString(importLog.getDate("starttime"), "yyyy-MM-dd HH:mm:ss");
        long useTime = DateUtils.parseDate(endDate, "yyyy-MM-dd HH:mm:ss").getTime() - DateUtils.parseDate(startDate, "yyyy-MM-dd HH:mm:ss").getTime();
        BigDecimal useTimeSeconds = BigDecimal.valueOf(useTime).divide(BigDecimal.valueOf(1000L), 0, RoundingMode.HALF_UP);
        importLog.set("usetime", (Object)useTimeSeconds);
        try (TXHandle tx = TX.requiresNew((String)"updateSettleLog");){
            try {
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{importLog});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static Map<String, String> getImpCountFieldMapping() {
        HashMap<String, String> fieldMapping = new HashMap<String, String>(6);
        fieldMapping.put("ap_busbill", "apbusbillcount");
        fieldMapping.put("ap_finapbill", "apfinbillcount");
        fieldMapping.put("ap_paidbill", "paidbillcount");
        fieldMapping.put("ar_busbill", "arbusbillcount");
        fieldMapping.put("ar_finarbill", "arfinbillcount");
        fieldMapping.put("ar_receivedbill", "receivedbillcount");
        return fieldMapping;
    }
}

