/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.init;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.init.InitServiceHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.service.BalanceService;
import kd.fi.arapcommon.service.CloseRecordService;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class InitReconcileService {
    private int BATCHCOUNT = 0;
    private boolean isAr;
    private JournalService journalService = new JournalService();

    public InitReconcileService(boolean isAr) {
        this.isAr = isAr;
    }

    public void rebuild(DynamicObject[] inits) {
        for (DynamicObject init : inits) {
            this.rebuild(init);
        }
    }

    public void rebuild(DynamicObject init) {
        try (TXHandle tx = TX.requiresNew((String)"init.rebuild");){
            try {
                if (!init.getBoolean("isfinishinit")) {
                    long orgPk = init.getDynamicObject("org").getLong("id");
                    if (this.isAr) {
                        this.pushJournal("ar_finarbill", orgPk, true);
                        this.pushJournal("ar_busbill", orgPk, true);
                        this.pushJournal("ar_receivedbill", orgPk, false);
                    } else {
                        this.pushJournal("ap_finapbill", orgPk, true);
                        this.pushJournal("ap_busbill", orgPk, true);
                        this.pushJournal("ap_paidbill", orgPk, false);
                    }
                    Date startDate = init.getDate("startdate");
                    Date stopDate = DateUtils.getLastDay(startDate, 1);
                    CloseRecordService closeRecordService = new CloseRecordService(!this.isAr);
                    closeRecordService.deleteCloseRecordByAntiInit(orgPk);
                    closeRecordService.saveCloseRecord(orgPk, stopDate);
                    BalanceService balanceService = new BalanceService(this.isAr ? "ar" : "ap");
                    balanceService.deleteBalanceByInit(orgPk);
                    balanceService.saveBalance(orgPk, null, stopDate);
                }
            }
            catch (Exception ex) {
                tx.markRollback();
                throw ex;
            }
        }
    }

    private void pushJournal(String entityKey, long orgPk, boolean isPeriod) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("org", "=", (Object)orgPk);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()));
        qFilters.add(qFilter);
        if (isPeriod) {
            qFilters.add(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
        }
        LinkedList<Long> ids = new LinkedList<Long>();
        if (this.BATCHCOUNT == 0) {
            this.BATCHCOUNT = InitServiceHelper.getInitBatchHandleCount();
        }
        try (DataSet billDataSet = QueryServiceHelper.queryDataSet((String)"arap.queryPeriodBill", (String)entityKey, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), null);){
            for (Row bill : billDataSet) {
                ids.add(bill.getLong("id"));
                if (ids.size() != this.BATCHCOUNT) continue;
                this.doPushJournal(ids, entityKey);
                ids.clear();
            }
        }
        if (!ids.isEmpty()) {
            this.doPushJournal(ids, entityKey);
        }
    }

    private void doPushJournal(List<Long> ids, String entityKey) {
        DynamicObjectType subEntityType = EntityMetadataUtils.getSubEntityType(entityKey, "bizdate, bookdate");
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[0]), (DynamicObjectType)subEntityType);
        if (!"ar_receivedbill".equals(entityKey) && !"ap_paidbill".equals(entityKey)) {
            for (DynamicObject bill : bills) {
                bill.set("bookdate", (Object)bill.getDate("bizdate"));
            }
        }
        this.journalService.pushAndSaveJournals(bills);
    }
}

