/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.init.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.AsstactHelper;
import kd.fi.arapcommon.init.AbstractSchemeImport;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinApBillSchemeImpl
extends AbstractSchemeImport {
    public FinApBillSchemeImpl(String entityKey, Long orgPk, DynamicObject init) {
        super(entityKey, orgPk, init);
    }

    @Override
    protected void billProperty(Map<String, Object> dataMap, Map<String, Object> balance, DynamicObject entry) {
        dataMap.put("billtypeid", this.basedata(entry.getDynamicObject("e_billtype")));
        dataMap.put("biztype", this.basedata(entry.getDynamicObject("e_biztype")));
        Date bizDate = (Date)dataMap.get("bizdate");
        dataMap.put("duedate", bizDate);
        dataMap.put("bookdate", bizDate);
        String asstacttype = entry.getString("e_asstacttype");
        dataMap.put("asstacttype", asstacttype);
        Object asstactitem = balance.get(entry.getString("e_asstactitem.flexfield"));
        long asstactitemPk = this.getAsstactitemPk(asstacttype, Long.parseLong(asstactitem.toString()));
        dataMap.put("asstact", this.basedata(asstactitemPk));
        dataMap.put("payorg", this.basedata(this.getFisbankroll(this.orgPk)));
        dataMap.put("purorg", this.basedata(this.orgPk));
        dataMap.put("purmode", "CREDIT");
        Map asstactMap = (Map)dataMap.get("asstact");
        if (asstactMap != null && EmptyUtils.isNotEmpty(asstactMap.get("id"))) {
            DynamicObject asstact = BusinessDataServiceHelper.loadSingleFromCache(asstactMap.get("id"), (String)asstacttype, (String)"id, name, number");
            Map<Object, Object> map = AsstactHelper.getaccbebankMap(asstact);
            dataMap.put("payeebanknum", map.get("account"));
            dataMap.put("bebank", this.basedata((Long)map.get("bebank")));
        }
        dataMap.put("payproperty", this.basedata(entry.getDynamicObject("e_appayproperty")));
        dataMap.put("isfx", Boolean.FALSE);
        dataMap.put("isfxpricetaxtotal", Boolean.FALSE);
        dataMap.put("isincludetax", Boolean.TRUE);
        dataMap.put("ispricetotal", Boolean.TRUE);
        dataMap.put("isexpensealloc", Boolean.FALSE);
        dataMap.put("isperiod", Boolean.TRUE);
    }

    @Override
    protected void billEntryProperty(Map<String, Object> entryMap, Map<String, Object> balance, DynamicObject entry) {
        entryMap.put("linetype", this.basedata(entry.getDynamicObject("e_linetype")));
        entryMap.put("ispresent", Boolean.FALSE);
        BigDecimal quantity = BigDecimal.ONE;
        BigDecimal unitprice = BigDecimal.ZERO;
        BigDecimal beginfor = new BigDecimal(balance.get("beginfor").toString());
        if (EmptyUtils.isNotEmpty(beginfor)) {
            if (beginfor.compareTo(BigDecimal.ZERO) < 0) {
                quantity = BigDecimal.ONE.negate();
            }
            unitprice = beginfor.abs();
        }
        if ("1".equals(entry.getString("e_balancedc"))) {
            quantity = quantity.negate();
        }
        entryMap.put("quantity", quantity);
        entryMap.put("price", unitprice);
        entryMap.put("e_pricetaxtotal", quantity.multiply(unitprice));
    }
}

