/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.intertax;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.arapcommon.intertax.InterTaxServiceHelper;
import kd.fi.arapcommon.intertax.TaxRuleService;

public class FinBillInterTaxSubmitOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] datas = this.getDataEntities();
                String entityId = FinBillInterTaxSubmitOp.this.billEntityType.getName();
                for (ExtendedDataEntity data : datas) {
                    DynamicObject finBill = data.getDataEntity();
                    if (!finBill.getBoolean("isintertax")) continue;
                    String asstacttype = finBill.getString("asstacttype");
                    String asstacttype2 = "1";
                    if ("bd_customer".equals(asstacttype)) {
                        asstacttype2 = "2";
                    } else if (!"bd_supplier".equals(asstacttype)) continue;
                    DynamicObject asstact = finBill.getDynamicObject("asstact");
                    if (ObjectUtils.isEmpty((Object)asstact)) continue;
                    String entryKey = "ap_finapbill".equals(entityId) ? "detailentry" : "entry";
                    DynamicObjectCollection detialColls = finBill.getDynamicObjectCollection(entryKey);
                    for (int entryIndex = 0; entryIndex < detialColls.size(); ++entryIndex) {
                        String materialKey;
                        DynamicObject detial = (DynamicObject)detialColls.get(entryIndex);
                        DynamicObject material = detial.getDynamicObject(materialKey = "ap_finapbill".equals(entityId) ? "material" : "e_material");
                        if (ObjectUtils.isEmpty((Object)material)) continue;
                        String groupid = TaxRuleService.query(String.valueOf(material.getPkValue()), asstacttype2, String.valueOf(asstact.getPkValue()));
                        DynamicObject taxGroup = detial.getDynamicObject("e_taxgroup");
                        if (ObjectUtils.isEmpty((Object)taxGroup) && !ObjectUtils.isEmpty((Object)groupid)) {
                            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"%s\u884c\u7269\u6599\u6709\u5bf9\u5e94\u7a0e\u7ec4\uff0c\u800c\u5355\u636e\u4e2d\u6ca1\u6709\u9009\u62e9\u7a0e\u7ec4\u3002", (String)"FinBillInterTaxSubmitOp_0", (String)"fi-arapcommon", (Object[])new Object[0]), entryIndex + 1));
                            continue;
                        }
                        if (!ObjectUtils.isEmpty((Object)taxGroup) && ObjectUtils.isEmpty((Object)groupid)) {
                            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"%s\u884c\u7269\u6599\u6ca1\u6709\u5bf9\u5e94\u7a0e\u7ec4\uff0c\u800c\u5355\u636e\u4e2d\u9009\u62e9\u4e86\u7a0e\u7ec4\u3002", (String)"FinBillInterTaxSubmitOp_1", (String)"fi-arapcommon", (Object[])new Object[0]), entryIndex + 1));
                            continue;
                        }
                        if (ObjectUtils.isEmpty((Object)taxGroup) && ObjectUtils.isEmpty((Object)groupid)) continue;
                        boolean taxroundrule = finBill.getBoolean("taxroundrule");
                        int scale = finBill.getDynamicObject("currency").getInt("amtprecision");
                        this.perfectMatch(data, entityId, taxroundrule, scale, detial, Long.valueOf(groupid));
                    }
                }
            }

            private void perfectMatch(ExtendedDataEntity data, String entityId, boolean taxroundrule, int scale, DynamicObject detial, Long groupid) {
                DynamicObjectCollection taxsubColls = detial.getDynamicObjectCollection("subentryentity");
                Map<Long, DynamicObject> taxRowMap = InterTaxServiceHelper.getAllTaxEntry(taxsubColls.getDynamicObjectType(), groupid);
                if (ObjectUtils.isEmpty((Object)taxsubColls) && !ObjectUtils.isEmpty(taxRowMap)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u7269\u6599\u6709\u5bf9\u5e94\u56fd\u9645\u7a0e\u660e\u7ec6\uff0c\u800c\u5355\u636e\u4e2d\u6ca1\u6709\u7ef4\u62a4\u3002", (String)"FinBillInterTaxSubmitOp_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                } else if (!ObjectUtils.isEmpty((Object)taxsubColls) && ObjectUtils.isEmpty(taxRowMap)) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u7269\u6599\u6ca1\u6709\u5bf9\u5e94\u56fd\u9645\u7a0e\u660e\u7ec6\uff0c\u800c\u5355\u636e\u4e2d\u7ef4\u62a4\u4e86\u3002", (String)"FinBillInterTaxSubmitOp_3", (String)"fi-arapcommon", (Object[])new Object[0]));
                } else if (!ObjectUtils.isEmpty((Object)taxsubColls) || !ObjectUtils.isEmpty(taxRowMap)) {
                    if (taxsubColls.size() != taxRowMap.size()) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u7269\u6599\u5bf9\u5e94\u56fd\u9645\u7a0e\u660e\u7ec6\u4e0e\u5355\u636e\u5f55\u5165\u4e2a\u6570\u4e0d\u540c\u3002", (String)"FinBillInterTaxSubmitOp_4", (String)"fi-arapcommon", (Object[])new Object[0]));
                    } else {
                        InterTaxServiceHelper.calculateTaxEntry(entityId, taxroundrule, scale, detial, false, taxRowMap.values());
                        for (DynamicObject taxsub : taxsubColls) {
                            DynamicObject taxcategory = taxsub.getDynamicObject("s_taxcategory");
                            if (ObjectUtils.isEmpty((Object)taxcategory)) {
                                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"%s\u884c\u7a0e\u79cd\u4e3a\u7a7a\u3002", (String)"FinBillInterTaxSubmitOp_5", (String)"fi-arapcommon", (Object[])new Object[0]), taxsub.getInt("seq")));
                                continue;
                            }
                            BigDecimal s_tax = taxsub.getBigDecimal("s_tax");
                            DynamicObject taxRow = taxRowMap.get(taxcategory.getLong("id"));
                            if (ObjectUtils.isEmpty((Object)taxRow)) {
                                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u7a0e\u79cd\u5728\u67e5\u8be2\u7ed3\u679c\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"FinBillInterTaxSubmitOp_6", (String)"fi-arapcommon", (Object[])new Object[0]), taxsub.getInt("seq")));
                                continue;
                            }
                            if (s_tax.compareTo(taxRow.getBigDecimal("s_tax")) == 0 || s_tax.negate().compareTo(taxRow.getBigDecimal("s_tax")) == 0) continue;
                            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"%s\u884c\u7a0e\u989d\u4e0e\u67e5\u8be2\u7ed3\u679c\u4e0d\u7b49\u3002", (String)"FinBillInterTaxSubmitOp_7", (String)"fi-arapcommon", (Object[])new Object[0]), taxsub.getInt("seq")));
                        }
                    }
                }
            }
        });
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("isintertax");
        list.add("asstacttype");
        list.add("asstact");
        list.add("currency");
        list.add("taxroundrule");
        String entityId = this.billEntityType.getName();
        if ("ap_finapbill".equals(entityId)) {
            list.add("discountmode");
            list.add("discountrate");
            list.add("quantity");
            list.add("price");
        } else {
            list.add("e_discountmode");
            list.add("e_discountrate");
            list.add("e_quantity");
            list.add("e_unitprice");
        }
        list.add("e_taxgroup");
        list.add("subentryentity");
        list.add("subentryentity.seq");
        list.add("s_taxcategory");
        list.add("s_isinpricetax");
        if ("ar_busbill".equals(entityId) || "ar_finarbill".equals(entityId)) {
            list.add("s_isoutputtax");
        } else {
            list.add("s_isinputtax");
        }
        list.add("s_taxrateid");
        list.add("s_taxrate");
        list.add("s_taxtime");
        list.add("s_includetail");
        list.add("s_includediscount");
        list.add("s_includevat");
        list.add("s_taxbasetype");
        list.add("s_taxbase");
        list.add("s_tax");
        list.add("s_candeductible");
        list.add("s_deductionrate");
        list.add("s_deductible");
        list.add("s_nondeductible");
        list.add("entity.seq");
    }
}

