/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.intertax;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.intertax.InterTaxService;
import kd.fi.arapcommon.intertax.TaxService;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class InterTaxGTEConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ArrayList<String> entityKeys = new ArrayList<String>();
        entityKeys.add("ar_busbill");
        entityKeys.add("ar_finarbill");
        entityKeys.add("ap_finapbill");
        for (String entityKey : entityKeys) {
            ExtendedDataEntity[] entitys;
            for (ExtendedDataEntity entity : entitys = entitySet.FindByEntityKey(entityKey)) {
                DynamicObject bill = entity.getDataEntity();
                String entryKey = "entry";
                String e_pricetaxtotalKey = "e_recamount";
                if ("ap_finapbill".equals(entityKey)) {
                    entryKey = "detailentry";
                    e_pricetaxtotalKey = "e_pricetaxtotal";
                }
                BigDecimal exchangerate = bill.getBigDecimal("exchangerate");
                BigDecimal head_pricetaxtotal = BigDecimal.ZERO;
                DynamicObjectCollection detialColls = bill.getDynamicObjectCollection(entryKey);
                for (DynamicObject detial : detialColls) {
                    Object taxrateid;
                    Object taxsub22;
                    DynamicObjectCollection taxColls = detial.getDynamicObjectCollection("subentryentity");
                    HashSet<Long> taxrateids = new HashSet<Long>();
                    for (Object taxsub22 : taxColls) {
                        taxrateid = taxsub22.getDynamicObject("s_taxrateid");
                        if (ObjectUtils.isEmpty((Object)taxrateid)) continue;
                        taxrateids.add(taxrateid.getLong("id"));
                    }
                    ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
                    taxsub22 = taxrateids.iterator();
                    while (taxsub22.hasNext()) {
                        taxrateid = (Long)taxsub22.next();
                        result.addAll(TaxService.query("rate", (Long)taxrateid));
                    }
                    if (ObjectUtils.isEmpty(result)) {
                        head_pricetaxtotal = head_pricetaxtotal.add(detial.getBigDecimal(e_pricetaxtotalKey));
                        continue;
                    }
                    DynamicObjectType taxDyType = taxColls.getDynamicObjectType();
                    taxColls.clear();
                    for (Map map : result) {
                        DynamicObject taxRow = this.getTaxRow(map, taxDyType, false);
                        taxColls.add((Object)taxRow);
                        if (!((Boolean)map.get("isdeducttax")).booleanValue()) continue;
                        DynamicObject taxRow1 = this.getTaxRow(map, taxDyType, false);
                        taxColls.add((Object)taxRow1);
                    }
                    BigDecimal pricetaxtotal = this.calculateTaxEntry(entityKey, exchangerate, detial, detial.getInt("seq") - 1, true, (Collection<DynamicObject>)taxColls);
                    head_pricetaxtotal = head_pricetaxtotal.add(pricetaxtotal);
                }
                BigDecimal head_pricetaxtotalbase = head_pricetaxtotal.multiply(exchangerate);
                if ("ar_busbill".equals(entityKey) || "ar_finarbill".equals(entityKey)) {
                    bill.set("recamount", (Object)head_pricetaxtotal);
                    bill.set("reclocalamt", (Object)head_pricetaxtotalbase);
                    bill.set("uninvoicedamt", (Object)head_pricetaxtotal);
                    if ("ar_finarbill".equals(entityKey)) {
                        bill.set("unsettleamount", (Object)head_pricetaxtotal);
                        bill.set("unsettlelocalamt", (Object)head_pricetaxtotalbase);
                    } else {
                        bill.set("uninvoicedlocamt", (Object)head_pricetaxtotalbase);
                    }
                } else {
                    bill.set("pricetaxtotal", (Object)head_pricetaxtotal);
                    bill.set("pricetaxtotalbase", (Object)head_pricetaxtotalbase);
                    bill.set("unsettleamount", (Object)head_pricetaxtotal);
                    bill.set("unsettleamountbase", (Object)head_pricetaxtotalbase);
                }
                DynamicObjectCollection planColls = bill.getDynamicObjectCollection("planentity");
                for (DynamicObject plan : planColls) {
                    plan.set("planpricetax", (Object)head_pricetaxtotal);
                    plan.set("planpricetaxloc", (Object)head_pricetaxtotalbase);
                    plan.set("unplanlockamt", (Object)head_pricetaxtotal);
                    plan.set("unplansettleamt", (Object)head_pricetaxtotal);
                    plan.set("unplansettlelocamt", (Object)head_pricetaxtotalbase);
                }
            }
        }
    }

    private DynamicObject getTaxRow(Map<String, Object> taxrateEntry, DynamicObjectType taxDyType, boolean isSplit) {
        DynamicObject taxRow = new DynamicObject(taxDyType);
        DynamicObject taxrateid = BusinessDataServiceHelper.loadSingle((Object)taxrateEntry.get("id"), (String)"gte_tax_rate");
        taxRow.set("s_taxrateid", (Object)taxrateid);
        DynamicObject taxclass = BusinessDataServiceHelper.loadSingle((Object)taxrateEntry.get("taxclassid"), (String)"bd_taxclass");
        taxRow.set("s_taxcategory", (Object)taxclass);
        taxRow.set("s_simplecode", taxrateEntry.get("taxcalsstype"));
        taxRow.set("s_taxcalsstype", taxrateEntry.get("taxcalsstype"));
        taxRow.set("s_isinpricetax", taxrateEntry.get("includetax"));
        BigDecimal taxrate = (BigDecimal)taxrateEntry.get("taxrate");
        taxRow.set("s_taxrate", (Object)(isSplit ? taxrate.negate() : taxrate));
        taxRow.set("s_taxtime", taxrateEntry.get("dkssd"));
        taxRow.set("s_includevat", taxrateEntry.get("includingvat"));
        taxRow.set("s_taxbasetype", taxrateEntry.get("taxbasetype"));
        taxRow.set("s_candeductible", taxrateEntry.get("allowdeduct"));
        taxRow.set("s_deduct", taxrateEntry.get("ductrattype"));
        taxRow.set("s_deductionrate", taxrateEntry.get("deductrate"));
        return taxRow;
    }

    private BigDecimal calculateTaxEntry(String entityId, BigDecimal exchangerate, DynamicObject detial, int entryIndex, boolean updateDetial, Collection<DynamicObject> taxRowColls) {
        BigDecimal quantity = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal premiumrate = BigDecimal.ZERO;
        String discountmodeKey = "e_discountmode";
        BigDecimal discountrate = BigDecimal.ZERO;
        if ("ap_finapbill".equals(entityId) || entityId.endsWith("ap_finchange")) {
            quantity = detial.getBigDecimal("quantity");
            price = detial.getBigDecimal("price");
            premiumrate = detial.getBigDecimal("e_premiumrate");
            discountmodeKey = "discountmode";
            discountrate = detial.getBigDecimal("discountrate");
        } else {
            quantity = detial.getBigDecimal("e_quantity");
            price = detial.getBigDecimal("e_unitprice");
            discountrate = detial.getBigDecimal("e_discountrate");
        }
        String discountmode = detial.getString(discountmodeKey);
        BigDecimal e_vattax = BigDecimal.ZERO;
        BigDecimal e_paytax = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : taxRowColls) {
            if (!"1".equals(dynamicObject.getString("s_simplecode"))) continue;
            InterTaxService interTaxService = this.calculateTaxEntry(dynamicObject, quantity, price, premiumrate, discountmode, discountrate, BigDecimal.ZERO);
            BigDecimal s_tax = this.updateTaxEntry(dynamicObject, interTaxService);
            e_vattax = e_vattax.add(s_tax);
            if (!"2".equals(dynamicObject.getString("s_taxtime"))) continue;
            e_paytax = e_paytax.add(s_tax);
        }
        BigDecimal e_tax = e_vattax;
        for (DynamicObject taxsub : taxRowColls) {
            if ("1".equals(taxsub.getString("s_simplecode"))) continue;
            InterTaxService interTaxService = this.calculateTaxEntry(taxsub, quantity, price, premiumrate, discountmode, discountrate, e_vattax);
            BigDecimal s_tax = this.updateTaxEntry(taxsub, interTaxService);
            if ("2".equals(taxsub.getString("s_taxtime"))) {
                e_paytax = e_paytax.add(s_tax);
            }
            e_tax = e_tax.add(s_tax);
        }
        detial.set("e_vattax", (Object)e_vattax);
        detial.set("e_tax", (Object)e_tax);
        BigDecimal bigDecimal = detial.getBigDecimal("e_amount").add(e_tax);
        BigDecimal pricetaxtotalbase = bigDecimal.multiply(exchangerate);
        if ("ar_busbill".equals(entityId) || "ar_finarbill".equals(entityId)) {
            detial.set("e_rectax", (Object)e_paytax);
            detial.set("e_recamount", (Object)bigDecimal);
            detial.set("e_reclocalamt", (Object)pricetaxtotalbase);
            detial.set("e_uninvoicedamt", (Object)bigDecimal);
            if ("ar_finarbill".equals(entityId)) {
                detial.set("e_unlockamt", (Object)bigDecimal);
                detial.set("e_unsettleamt", (Object)bigDecimal);
                detial.set("e_unsettlelocalamt", (Object)pricetaxtotalbase);
            } else {
                detial.set("e_uninvoicedlocamt", (Object)pricetaxtotalbase);
            }
        } else {
            detial.set("e_paytax", (Object)e_paytax);
            detial.set("e_pricetaxtotal", (Object)bigDecimal);
            detial.set("e_pricetaxtotalbase", (Object)pricetaxtotalbase);
            detial.set("unlockamt", (Object)bigDecimal);
            detial.set("unsettleamt", (Object)bigDecimal);
            detial.set("unsettleamtbase", (Object)pricetaxtotalbase);
        }
        return bigDecimal;
    }

    public InterTaxService calculateTaxEntry(DynamicObject taxsub, BigDecimal quantity, BigDecimal price, BigDecimal premiumrate, String discountmode, BigDecimal discountrate, BigDecimal vattax) {
        BigDecimal taxrate = taxsub.getBigDecimal("s_taxrate");
        InterTaxService interTaxService = new InterTaxService(quantity, price, taxrate);
        interTaxService.setIncludediscount(taxsub.getBoolean("s_includediscount"));
        interTaxService.calculateDiscountAmt(discountmode, discountrate);
        interTaxService.setIsnegate("2".equals(taxsub.getString("s_simplecode")));
        if (taxsub.getBoolean("s_includevat")) {
            interTaxService.setVatAmt(vattax);
        }
        BigDecimal deductionrate = taxsub.getBigDecimal("s_deductionrate");
        interTaxService.setDeductionrate(taxsub.getBigDecimal("s_deductionrate"));
        boolean includetail = taxsub.getBoolean("s_includetail");
        if (!includetail) {
            interTaxService.setTailRate(premiumrate);
        }
        interTaxService.setIsinpricetax(taxsub.getBoolean("s_isinpricetax"));
        interTaxService.setIstaxbaseAmt("1".equals(taxsub.getString("s_taxbasetype")));
        interTaxService.calculateTax();
        if ("2".equals(taxsub.getString("s_simplecode")) && "2".equals(taxsub.getString("s_taxtime"))) {
            interTaxService.setTax(BigDecimal.ZERO);
        }
        BigDecimal oldTaxbase = taxsub.getBigDecimal("s_taxbase");
        BigDecimal oldTaxassessamt = taxsub.getBigDecimal("s_taxassessamt");
        BigDecimal s_tax = interTaxService.getTax();
        if (oldTaxassessamt.compareTo(BigDecimal.ZERO) != 0 && oldTaxassessamt.compareTo(oldTaxbase) != 0) {
            s_tax = taxsub.getBigDecimal("s_tax");
        }
        if (EntityMetadataUtils.isExistProperty(taxsub, "s_taxctrlamt")) {
            BigDecimal oldTax = taxsub.getBigDecimal("s_tax");
            BigDecimal oldTaxctrlamt = taxsub.getBigDecimal("s_taxctrlamt");
            if (oldTaxctrlamt.compareTo(BigDecimal.ZERO) == 0 || oldTaxctrlamt.compareTo(oldTax) == 0) {
                oldTaxctrlamt = s_tax;
            }
            BigDecimal deductible = oldTaxctrlamt.multiply(deductionrate).divide(new BigDecimal(100));
            interTaxService.setDeductible(deductible);
            interTaxService.setNondeductible(oldTaxctrlamt.subtract(deductible));
        }
        return interTaxService;
    }

    private BigDecimal updateTaxEntry(DynamicObject taxsub, InterTaxService interTaxService) {
        BigDecimal oldTaxbase = taxsub.getBigDecimal("s_taxbase");
        BigDecimal oldTaxassessamt = taxsub.getBigDecimal("s_taxassessamt");
        BigDecimal oldTax = taxsub.getBigDecimal("s_tax");
        BigDecimal taxbase = interTaxService.getTaxbase();
        taxsub.set("s_taxbase", (Object)taxbase);
        taxsub.set("s_deductible", (Object)interTaxService.getDeductible());
        taxsub.set("s_nondeductible", (Object)interTaxService.getNondeductible());
        BigDecimal s_tax = interTaxService.getTax();
        if (oldTaxassessamt.compareTo(BigDecimal.ZERO) == 0 || oldTaxassessamt.compareTo(oldTaxbase) == 0) {
            taxsub.set("s_taxassessamt", (Object)taxbase);
            oldTaxassessamt = taxbase;
        } else {
            s_tax = taxsub.getBigDecimal("s_tax");
        }
        taxsub.set("s_tax", (Object)s_tax);
        if (EntityMetadataUtils.isExistProperty(taxsub, "s_taxctrlamt")) {
            BigDecimal oldTaxctrlamt = taxsub.getBigDecimal("s_taxctrlamt");
            if (oldTaxctrlamt.compareTo(BigDecimal.ZERO) == 0 || oldTaxctrlamt.compareTo(oldTax) == 0) {
                taxsub.set("s_taxctrlamt", (Object)s_tax);
                oldTaxctrlamt = s_tax;
            } else {
                taxsub.set("s_taxrate", (Object)oldTaxctrlamt.divide(oldTaxassessamt, 10, RoundingMode.HALF_DOWN).multiply(new BigDecimal(100)));
            }
            return oldTaxctrlamt;
        }
        return s_tax;
    }
}

