/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.intertax;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.intertax.InterTaxService;
import kd.fi.arapcommon.intertax.TaxRuleService;

public class InterTaxHelper {
    private IFormView formView;
    private IDataModel dataModel;
    private String entityId;
    private String entryKey;
    private boolean taxroundrule = false;
    private int scale = 2;
    private PropertyChangedArgs propertyChangedArgs;
    private String operateKey;

    public InterTaxHelper(IFormView formView, PropertyChangedArgs propertyChangedArgs) {
        this.formView = formView;
        this.dataModel = formView.getModel();
        this.entityId = formView.getEntityId();
        this.entryKey = "entry";
        if ("ap_finapbill".equals(this.entityId) || this.entityId.endsWith("ap_finchange")) {
            this.entryKey = "detailentry";
        }
        this.taxroundrule = (Boolean)this.dataModel.getValue("taxroundrule");
        DynamicObject currency = (DynamicObject)this.dataModel.getValue("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            this.scale = currency.getInt("amtprecision");
        }
        this.propertyChangedArgs = propertyChangedArgs;
    }

    public InterTaxHelper(IFormView formView, String operateKey) {
        this.formView = formView;
        this.dataModel = formView.getModel();
        this.entityId = formView.getEntityId();
        this.entryKey = "entry";
        if ("ap_finapbill".equals(this.entityId) || this.entityId.endsWith("ap_finchange")) {
            this.entryKey = "detailentry";
        }
        this.taxroundrule = (Boolean)this.dataModel.getValue("taxroundrule");
        DynamicObject currency = (DynamicObject)this.dataModel.getValue("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            this.scale = currency.getInt("amtprecision");
        }
        this.operateKey = operateKey;
    }

    public void propertyChanged_taxentry() {
        int index;
        boolean isintertax = (Boolean)this.dataModel.getValue("isintertax");
        if (!isintertax) {
            this.clearAllTaxEntry();
            return;
        }
        MainEntityType mainType = this.dataModel.getDataEntityType();
        boolean hasTaxgroup = mainType.findProperty("e_taxgroup") != null;
        boolean hasTaxctrlamt = mainType.findProperty("s_taxctrlamt") != null;
        String key = this.propertyChangedArgs.getProperty().getName();
        ChangeData[] changeData = this.propertyChangedArgs.getChangeSet();
        int entryIndex = index = changeData[0].getRowIndex();
        switch (key) {
            case "asstact": {
                if (!hasTaxgroup) break;
                this.prepareData();
                this.invokeTaxAllMaterial();
                this.calculateAllTaxEntry();
                break;
            }
            case "taxroundrule": {
                this.calculateAllTaxEntry();
                break;
            }
            case "e_material": 
            case "material": {
                String groupid;
                DynamicObject material;
                if (!hasTaxgroup || ObjectUtils.isEmpty((Object)(material = (DynamicObject)changeData[0].getNewValue())) || ObjectUtils.isEmpty((Object)(groupid = this.invokeTax(material.getLong("id"))))) break;
                this.dataModel.setValue("e_taxgroup", (Object)Long.valueOf(groupid), index);
                break;
            }
            case "e_taxgroup": {
                DynamicObject taxgroup = (DynamicObject)changeData[0].getNewValue();
                if (!ObjectUtils.isEmpty((Object)taxgroup)) {
                    this.getSubByTaxGroup(index, taxgroup.getLong("id"));
                    break;
                }
                this.clearAllTaxEntry(entryIndex);
                break;
            }
            case "s_taxrateid": {
                DynamicObject taxrateid = (DynamicObject)changeData[0].getNewValue();
                this.updateSubEntryByEaxrateid(taxrateid, entryIndex);
                entryIndex = changeData[0].getParentRowIndex();
            }
            case "e_quantity": 
            case "quantity": 
            case "e_unitprice": 
            case "price": 
            case "e_discountmode": 
            case "e_discountrate": 
            case "e_premiumrate": {
                this.calculateTaxEntry(entryIndex);
                break;
            }
            case "s_taxassessamt": {
                BigDecimal oldTaxctrlamt;
                BigDecimal taxbase = (BigDecimal)changeData[0].getNewValue();
                BigDecimal taxrate = (BigDecimal)this.dataModel.getValue("s_taxrate", index);
                BigDecimal oldTax = (BigDecimal)this.dataModel.getValue("s_tax", index);
                BigDecimal newTax = taxbase.multiply(taxrate).divide(new BigDecimal(100));
                if (hasTaxctrlamt && ((oldTaxctrlamt = (BigDecimal)this.dataModel.getValue("s_taxctrlamt", index)).compareTo(BigDecimal.ZERO) == 0 || oldTaxctrlamt.compareTo(oldTax) == 0)) {
                    this.dataModel.beginInit();
                    this.dataModel.setValue("s_taxctrlamt", (Object)newTax, index);
                    this.dataModel.endInit();
                }
                this.dataModel.setValue("s_tax", (Object)newTax, index);
            }
            case "s_taxctrlamt": {
                entryIndex = changeData[0].getParentRowIndex();
                this.calculateTaxEntry(entryIndex);
            }
        }
        this.calculateHeadAmt();
    }

    private void prepareData() {
        String asstacttype = (String)this.dataModel.getValue("asstacttype");
        String asstacttype2 = "1";
        if ("bd_customer".equals(asstacttype)) {
            asstacttype2 = "2";
        } else if (!"bd_supplier".equals(asstacttype)) {
            return;
        }
        DynamicObject asstact = (DynamicObject)this.dataModel.getValue("asstact");
        if (ObjectUtils.isEmpty((Object)asstact)) {
            this.clearAllTaxEntry();
            return;
        }
        this.formView.getFormShowParameter().setCustomParam("asstacttype", (Object)asstacttype2);
        this.formView.getFormShowParameter().setCustomParam("asstactid", asstact.getPkValue());
    }

    private void invokeTaxAllMaterial() {
        DynamicObjectCollection detialColls = this.dataModel.getEntryEntity(this.entryKey);
        if (detialColls == null) {
            return;
        }
        for (int entryIndex = 0; entryIndex < detialColls.size(); ++entryIndex) {
            String groupid;
            DynamicObject material;
            DynamicObject detial = (DynamicObject)detialColls.get(entryIndex);
            String materialKey = "e_material";
            if ("ap_finapbill".equals(this.entityId) || this.entityId.endsWith("ap_finchange")) {
                materialKey = "material";
            }
            if (ObjectUtils.isEmpty((Object)(material = detial.getDynamicObject(materialKey))) || ObjectUtils.isEmpty((Object)(groupid = this.invokeTax(material.getLong("id"))))) continue;
            this.dataModel.beginInit();
            this.dataModel.setValue("e_taxgroup", (Object)Long.valueOf(groupid), entryIndex);
            this.dataModel.endInit();
        }
    }

    private String invokeTax(Long materialId) {
        String groupid = null;
        Map taxKeys = this.formView.getFormShowParameter().getCustomParams();
        if (!ObjectUtils.isEmpty(taxKeys.get("asstactid"))) {
            groupid = TaxRuleService.query(materialId.toString(), (String)taxKeys.get("asstacttype"), taxKeys.get("asstactid").toString());
        }
        return groupid;
    }

    public void calculateAllTaxEntry() {
        DynamicObjectCollection detialColls = this.dataModel.getEntryEntity(this.entryKey);
        for (DynamicObject detial : detialColls) {
            DynamicObjectCollection taxColls = detial.getDynamicObjectCollection("subentryentity");
            this.calculateTaxEntry(detial, true, (Collection<DynamicObject>)taxColls);
        }
        this.updateTaxSubEntry();
        this.formView.updateView(this.entryKey);
    }

    private void calculateTaxEntry(int entryIndex) {
        DynamicObject detial = (DynamicObject)this.dataModel.getEntryEntity(this.entryKey).get(entryIndex);
        DynamicObjectCollection taxColls = detial.getDynamicObjectCollection("subentryentity");
        this.calculateTaxEntry(detial, true, (Collection<DynamicObject>)taxColls);
        this.updateTaxSubEntry();
        this.formView.updateView(this.entryKey);
    }

    private void calculateTaxEntry(DynamicObject detial, boolean updateDetial, Collection<DynamicObject> taxRowColls) {
        BigDecimal quantity = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        String discountmodeKey = "e_discountmode";
        BigDecimal discountrate = BigDecimal.ZERO;
        if ("ap_finapbill".equals(this.entityId) || this.entityId.endsWith("ap_finchange")) {
            quantity = detial.getBigDecimal("quantity");
            price = detial.getBigDecimal("price");
            discountmodeKey = "discountmode";
            discountrate = detial.getBigDecimal("discountrate");
        } else {
            quantity = detial.getBigDecimal("e_quantity");
            price = detial.getBigDecimal("e_unitprice");
            discountrate = detial.getBigDecimal("e_discountrate");
        }
        String discountmode = detial.getString(discountmodeKey);
        BigDecimal e_vattax = BigDecimal.ZERO;
        BigDecimal e_paytax = BigDecimal.ZERO;
        for (DynamicObject taxsub : taxRowColls) {
            if (!"VAT".equals(taxsub.getString("s_simplecode"))) continue;
            InterTaxService interTaxService = this.calculateTaxEntry(taxsub, quantity, price, discountmode, discountrate, BigDecimal.ZERO);
            BigDecimal s_tax = this.updateTaxEntry(taxsub, interTaxService);
            e_vattax = e_vattax.add(s_tax);
            if (!"receipt".equals(taxsub.getString("s_taxtime")) && !"pay".equals(taxsub.getString("s_taxtime"))) continue;
            e_paytax = e_paytax.add(s_tax);
        }
        BigDecimal e_tax = e_vattax;
        for (DynamicObject taxsub : taxRowColls) {
            if ("VAT".equals(taxsub.getString("s_simplecode"))) continue;
            InterTaxService interTaxService = this.calculateTaxEntry(taxsub, quantity, price, discountmode, discountrate, e_vattax);
            BigDecimal s_tax = this.updateTaxEntry(taxsub, interTaxService);
            if ("receipt".equals(taxsub.getString("s_taxtime")) || "pay".equals(taxsub.getString("s_taxtime"))) {
                e_paytax = e_paytax.add(s_tax);
            }
            e_tax = e_tax.add(s_tax);
        }
        if (updateDetial) {
            detial.set("e_vattax", (Object)e_vattax);
            detial.set("e_tax", (Object)e_tax);
            if ("ar_busbill".equals(this.entityId) || "ar_finarbill".equals(this.entityId) || this.entityId.contains("ar_finarbill")) {
                detial.set("e_rectax", (Object)e_paytax);
                detial.set("e_recamount", (Object)e_tax.add(detial.getBigDecimal("e_amount")));
            } else {
                detial.set("e_paytax", (Object)e_paytax);
                detial.set("e_pricetaxtotal", (Object)e_tax.add(detial.getBigDecimal("e_amount")));
            }
        }
    }

    public InterTaxService calculateTaxEntry(DynamicObject taxsub, BigDecimal quantity, BigDecimal price, String discountmode, BigDecimal discountrate, BigDecimal vattax) {
        BigDecimal taxrate = taxsub.getBigDecimal("s_taxrate");
        InterTaxService interTaxService = new InterTaxService(quantity, price, taxrate);
        interTaxService.setIncludediscount(taxsub.getBoolean("s_includediscount"));
        interTaxService.calculateDiscountAmt(discountmode, discountrate);
        interTaxService.setIsnegate("WHT".equals(taxsub.getString("s_simplecode")));
        if (taxsub.getBoolean("s_includevat")) {
            interTaxService.setVatAmt(vattax);
        }
        if (taxsub.getBoolean("s_candeductible")) {
            interTaxService.setDeductionrate(taxsub.getBigDecimal("s_deductionrate"));
        }
        interTaxService.setIsinpricetax(taxsub.getBoolean("s_isinpricetax"));
        interTaxService.setIstaxbaseAmt("2".equals(taxsub.getString("s_taxbasetype")));
        interTaxService.calculateTax();
        return interTaxService;
    }

    private BigDecimal updateTaxEntry(DynamicObject taxsub, InterTaxService interTaxService) {
        boolean hasTaxctrlamt;
        BigDecimal oldTaxbase = taxsub.getBigDecimal("s_taxbase");
        BigDecimal oldTaxassessamt = taxsub.getBigDecimal("s_taxassessamt");
        BigDecimal oldTax = taxsub.getBigDecimal("s_tax");
        BigDecimal taxbase = interTaxService.getTaxbase();
        taxsub.set("s_taxbase", (Object)taxbase);
        taxsub.set("s_deductible", (Object)interTaxService.getDeductible());
        taxsub.set("s_nondeductible", (Object)interTaxService.getNondeductible());
        BigDecimal s_tax = interTaxService.getTax();
        if (oldTaxassessamt.compareTo(BigDecimal.ZERO) == 0 || oldTaxassessamt.compareTo(oldTaxbase) == 0) {
            taxsub.set("s_taxassessamt", (Object)taxbase);
            oldTaxassessamt = taxbase;
        } else {
            s_tax = taxsub.getBigDecimal("s_tax");
        }
        if (this.taxroundrule) {
            s_tax = s_tax.setScale(this.scale, RoundingMode.HALF_DOWN);
        }
        taxsub.set("s_tax", (Object)s_tax);
        MainEntityType mainType = this.dataModel.getDataEntityType();
        boolean bl = hasTaxctrlamt = mainType.findProperty("s_taxctrlamt") != null;
        if (!hasTaxctrlamt) {
            return s_tax;
        }
        BigDecimal oldTaxctrlamt = taxsub.getBigDecimal("s_taxctrlamt");
        if (oldTaxctrlamt.compareTo(BigDecimal.ZERO) == 0 || oldTaxctrlamt.compareTo(oldTax) == 0) {
            taxsub.set("s_taxctrlamt", (Object)s_tax);
            oldTaxctrlamt = s_tax;
        } else {
            taxsub.set("s_taxrate", (Object)oldTaxctrlamt.divide(oldTaxassessamt, 10, RoundingMode.HALF_DOWN).multiply(new BigDecimal(100)));
        }
        return oldTaxctrlamt;
    }

    private void calculateHeadAmt() {
        DynamicObjectCollection entrycolls = this.dataModel.getEntryEntity(this.entryKey);
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        switch (this.entityId) {
            case "ar_busbill": 
            case "ar_finarbill": {
                for (DynamicObject entry : entrycolls) {
                    pricetaxtotal = pricetaxtotal.add(entry.getBigDecimal("e_recamount"));
                }
                this.dataModel.setValue("recamount", (Object)pricetaxtotal);
                break;
            }
            case "ap_busbill": {
                for (DynamicObject entry : entrycolls) {
                    pricetaxtotal = pricetaxtotal.add(entry.getBigDecimal("e_pricetaxtotal"));
                }
                this.dataModel.setValue("pricetaxtotal", (Object)pricetaxtotal);
            }
        }
        if ("ap_finapbill".equals(this.entityId) || this.entityId.endsWith("ap_finchange")) {
            BigDecimal paytax = BigDecimal.ZERO;
            for (DynamicObject entry : entrycolls) {
                paytax = paytax.add(entry.getBigDecimal("e_paytax"));
                pricetaxtotal = pricetaxtotal.add(entry.getBigDecimal("e_pricetaxtotal"));
            }
            this.dataModel.setValue("paytax", (Object)paytax.setScale(this.scale, RoundingMode.HALF_DOWN));
            this.dataModel.setValue("pricetaxtotal", (Object)pricetaxtotal);
        }
    }

    private void clearAllTaxEntry(int entryIndex) {
        DynamicObjectCollection detialColls = this.dataModel.getEntryEntity(this.entryKey);
        DynamicObject detial = (DynamicObject)detialColls.get(entryIndex);
        detial.set("subentryentity", null);
        this.updateTaxSubEntry();
    }

    private void updateTaxSubEntry() {
        MainEntityType mainType = this.dataModel.getDataEntityType();
        boolean hasTaxctrlamt = mainType.findProperty("s_taxctrlamt") != null;
        DynamicObjectCollection detialColls = this.dataModel.getEntryEntity(this.entryKey);
        for (DynamicObject detial : detialColls) {
            DynamicObjectCollection taxColls = detial.getDynamicObjectCollection("subentryentity");
            for (DynamicObject taxsub : taxColls) {
                taxsub.set("s_taxbase", (Object)taxsub.getBigDecimal("s_taxbase").setScale(this.scale, RoundingMode.HALF_DOWN));
                taxsub.set("s_taxassessamt", (Object)taxsub.getBigDecimal("s_taxassessamt").setScale(this.scale, RoundingMode.HALF_DOWN));
                taxsub.set("s_tax", (Object)taxsub.getBigDecimal("s_tax").setScale(this.scale, RoundingMode.HALF_DOWN));
                if (hasTaxctrlamt) {
                    taxsub.set("s_taxctrlamt", (Object)taxsub.getBigDecimal("s_taxctrlamt").setScale(this.scale, RoundingMode.HALF_DOWN));
                }
                taxsub.set("s_deductible", (Object)taxsub.getBigDecimal("s_deductible").setScale(this.scale, RoundingMode.HALF_DOWN));
                taxsub.set("s_nondeductible", (Object)taxsub.getBigDecimal("s_nondeductible").setScale(this.scale, RoundingMode.HALF_DOWN));
            }
        }
        this.formView.updateView("subentryentity");
    }

    public void clearAllTaxEntry() {
        DynamicObjectCollection detialColls = this.dataModel.getEntryEntity(this.entryKey);
        for (DynamicObject detial : detialColls) {
            detial.set("subentryentity", null);
        }
        this.formView.updateView("subentryentity");
    }

    public void afterDoOperation() {
        if ("deletesubentry".equals(this.operateKey)) {
            int entryIndex = this.dataModel.getEntryCurrentRowIndex(this.entryKey);
            this.calculateTaxEntry(entryIndex);
        }
    }

    private DynamicObjectCollection queryTaxgroup(Long taxGroupId) {
        DynamicObjectCollection taxgroupColls = QueryServiceHelper.query((String)"bd_taxgroup", (String)"id,entryentity.id,entryentity.taxrateid.id,entryentity.taxrateid.taxrate,entryentity.taxrateid.taxcategoryid,entryentity.taxrateid.taxcategoryid.simplecode,entryentity.taxrateid.rebaterate,entryentity.taxrateid.taxtime,entryentity.taxrateid.taxscope,entryentity.taxrateid.taxratetype,entryentity.taxrateid.tcvat,entryentity.taxrateid.rebate,entryentity.taxrateid.rest,entryentity.taxrateid.taxbase,entryentity.taxrateid.offset", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxGroupId)});
        return taxgroupColls;
    }

    public void getSubByTaxGroup(int entryIndex, Long taxGroupId) {
        DynamicObjectCollection taxgroupColls = this.queryTaxgroup(taxGroupId);
        if (ObjectUtils.isEmpty((Object)taxgroupColls)) {
            return;
        }
        int taxrateSize = taxgroupColls.size();
        this.dataModel.deleteEntryData("subentryentity");
        this.dataModel.batchCreateNewEntryRow("subentryentity", taxrateSize);
        DynamicObject detial = (DynamicObject)this.dataModel.getEntryEntity(this.entryKey).get(entryIndex);
        DynamicObjectCollection taxColls = detial.getDynamicObjectCollection("subentryentity");
        int subIndex = 0;
        this.dataModel.beginInit();
        for (DynamicObject taxrateEntry : taxgroupColls) {
            this.fillTaxRow(taxrateEntry, subIndex++, false);
            if (!taxrateEntry.getBoolean("entryentity.taxrateid.offset")) continue;
            this.dataModel.createNewEntryRow("subentryentity");
            this.fillTaxRow(taxrateEntry, subIndex++, true);
        }
        this.calculateTaxEntry(detial, true, (Collection<DynamicObject>)taxColls);
        this.dataModel.endInit();
        this.updateTaxSubEntry();
        this.formView.updateView(this.entryKey);
    }

    private void fillTaxRow(DynamicObject taxrateEntry, int subIndex, boolean isSplit) {
        this.dataModel.setValue("s_taxcategory", (Object)taxrateEntry.getLong("entryentity.taxrateid.taxcategoryid"), subIndex);
        this.dataModel.setValue("s_simplecode", (Object)taxrateEntry.getString("entryentity.taxrateid.taxcategoryid.simplecode"), subIndex);
        this.dataModel.setValue("s_isinpricetax", (Object)"1".equals(taxrateEntry.getString("entryentity.taxrateid.taxscope")), subIndex);
        String entityId = this.dataModel.getDataEntityType().getName();
        String taxratetype = taxrateEntry.getString("entryentity.taxrateid.taxratetype");
        if ("ar_busbill".equals(entityId) || "ar_finarbill".equals(entityId)) {
            this.dataModel.setValue("s_isoutputtax", (Object)"2".equals(taxratetype), subIndex);
        } else {
            this.dataModel.setValue("s_isinputtax", (Object)"1".equals(taxratetype), subIndex);
        }
        this.dataModel.setValue("s_taxrateid", (Object)taxrateEntry.getLong("entryentity.taxrateid.id"), subIndex);
        BigDecimal taxrate = taxrateEntry.getBigDecimal("entryentity.taxrateid.taxrate");
        this.dataModel.setValue("s_taxrate", (Object)(isSplit ? taxrate.negate() : taxrate), subIndex);
        String taxtime = taxrateEntry.getString("entryentity.taxrateid.taxtime");
        String s_taxtime = "invoice";
        if ("2".equals(taxtime)) {
            s_taxtime = "ar_busbill".equals(entityId) || "ar_finarbill".equals(entityId) ? "receipt" : "pay";
        }
        this.dataModel.setValue("s_taxtime", (Object)s_taxtime, subIndex);
        this.dataModel.setValue("s_includetail", (Object)taxrateEntry.getBoolean("entryentity.taxrateid.rest"), subIndex);
        this.dataModel.setValue("s_includediscount", (Object)taxrateEntry.getBoolean("entryentity.taxrateid.rebate"), subIndex);
        this.dataModel.setValue("s_includevat", (Object)taxrateEntry.getBoolean("entryentity.taxrateid.tcvat"), subIndex);
        this.dataModel.setValue("s_taxbasetype", (Object)taxrateEntry.getString("entryentity.taxrateid.taxbase"), subIndex);
        this.dataModel.setValue("s_deductionrate", (Object)taxrateEntry.getBigDecimal("entryentity.taxrateid.rebaterate"), subIndex);
    }

    private void updateSubEntryByEaxrateid(DynamicObject taxrateid, int index) {
        if (ObjectUtils.isEmpty((Object)taxrateid)) {
            this.dataModel.deleteEntryRow("subentryentity", index);
            this.dataModel.insertEntryRow("subentryentity", index);
            return;
        }
        this.dataModel.beginInit();
        this.fillTaxRowByTaxRate(taxrateid, index, false);
        if (taxrateid.getBoolean("offset")) {
            int insertIndex = this.dataModel.insertEntryRow("subentryentity", index + 1);
            this.dataModel.setValue("s_taxrateid", (Object)taxrateid.getLong("id"), insertIndex);
            this.fillTaxRowByTaxRate(taxrateid, insertIndex, true);
        }
        this.dataModel.endInit();
    }

    private void fillTaxRowByTaxRate(DynamicObject taxrateid, int subIndex, boolean isSplit) {
        DynamicObject taxcategory = taxrateid.getDynamicObject("taxcategoryid");
        this.dataModel.setValue("s_taxcategory", (Object)taxcategory.getLong("id"), subIndex);
        this.dataModel.setValue("s_isinpricetax", (Object)"1".equals(taxrateid.getString("taxscope")), subIndex);
        String taxratetype = taxrateid.getString("taxratetype");
        if ("ar_busbill".equals(this.entityId) || "ar_finarbill".equals(this.entityId)) {
            this.dataModel.setValue("s_isoutputtax", (Object)"2".equals(taxratetype), subIndex);
        } else {
            this.dataModel.setValue("s_isinputtax", (Object)"1".equals(taxratetype), subIndex);
        }
        BigDecimal taxrate = taxrateid.getBigDecimal("taxrate");
        this.dataModel.setValue("s_taxrate", (Object)(isSplit ? taxrate.negate() : taxrate), subIndex);
        String taxtime = taxrateid.getString("taxtime");
        String s_taxtime = "invoice";
        if ("2".equals(taxtime)) {
            s_taxtime = "receipt";
        } else if ("3".equals(taxtime)) {
            s_taxtime = "pay";
        }
        this.dataModel.setValue("s_taxtime", (Object)s_taxtime, subIndex);
        this.dataModel.setValue("s_includetail", (Object)taxrateid.getBoolean("rest"), subIndex);
        this.dataModel.setValue("s_includediscount", (Object)taxrateid.getBoolean("rebate"), subIndex);
        this.dataModel.setValue("s_includevat", (Object)taxrateid.getBoolean("tcvat"), subIndex);
        this.dataModel.setValue("s_taxbasetype", (Object)taxrateid.getString("taxbase"), subIndex);
        this.dataModel.setValue("s_deductionrate", (Object)taxrateid.getBigDecimal("rebaterate"), subIndex);
    }
}

