/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.intertax;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class InterTaxService {
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private BigDecimal quantity;
    private BigDecimal unitprice;
    private BigDecimal taxunitprice;
    private boolean isinpricetax;
    private BigDecimal taxrate;
    private boolean includetail;
    private BigDecimal tailrate;
    private boolean includediscount;
    private String discountmode;
    private BigDecimal discountrate;
    private BigDecimal discountAmt;
    private boolean includevat;
    private BigDecimal vatAmt;
    private boolean istaxbaseAmt;
    private BigDecimal taxbase;
    private BigDecimal tax;
    private boolean isnegate;
    private boolean candeductible;
    private BigDecimal deductionrate;
    private BigDecimal deductible;
    private BigDecimal nondeductible;

    public InterTaxService(BigDecimal quantity, BigDecimal unitprice, BigDecimal taxrate) {
        this.quantity = quantity;
        this.unitprice = unitprice;
        this.taxrate = taxrate;
        this.includetail = true;
        this.tailrate = ZERO;
        this.includediscount = false;
        this.discountmode = "NULL";
        this.discountrate = ZERO;
        this.discountAmt = ZERO;
        this.includevat = false;
        this.vatAmt = ZERO;
        this.isnegate = false;
        this.candeductible = false;
        this.deductionrate = ZERO;
        this.istaxbaseAmt = false;
    }

    public void calculateDiscountAmt(String discountmode, BigDecimal discountrate) {
        this.discountAmt = ZERO;
        switch (discountmode) {
            case "PERUNIT": {
                this.discountAmt = this.quantity.multiply(discountrate);
                break;
            }
            case "PERCENT": {
                this.discountAmt = this.quantity.multiply(this.unitprice).multiply(discountrate).divide(HUNDRED, RoundingMode.HALF_DOWN);
            }
        }
    }

    public void calculateTax() {
        BigDecimal temtaxrate = BigDecimal.ONE.add(this.taxrate.divide(HUNDRED));
        if (this.isinpricetax) {
            this.taxunitprice = this.unitprice;
            this.unitprice = this.taxunitprice.divide(temtaxrate, RoundingMode.HALF_DOWN);
        } else {
            this.taxunitprice = this.unitprice.multiply(temtaxrate);
        }
        this.taxbase = this.istaxbaseAmt ? this.quantity.multiply(this.taxunitprice) : this.quantity.multiply(this.unitprice);
        if (this.includediscount) {
            this.taxbase = this.taxbase.subtract(this.discountAmt);
        }
        if (!this.includetail) {
            this.taxbase = this.taxbase.multiply(BigDecimal.ONE.subtract(this.tailrate.divide(HUNDRED)));
        }
        if (this.includevat) {
            this.taxbase = this.taxbase.add(this.vatAmt);
        }
        this.tax = this.taxbase.multiply(this.taxrate.divide(HUNDRED));
        if (this.isnegate) {
            this.tax = this.tax.negate();
        }
        this.deductible = this.tax.multiply(this.deductionrate).divide(HUNDRED);
        this.nondeductible = this.tax.subtract(this.deductible);
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public BigDecimal getUnitprice() {
        return this.unitprice;
    }

    public BigDecimal getTaxunitprice() {
        return this.taxunitprice;
    }

    public boolean isIsinpricetax() {
        return this.isinpricetax;
    }

    public void setIsinpricetax(boolean isinpricetax) {
        this.isinpricetax = isinpricetax;
    }

    public BigDecimal getTaxrate() {
        return this.taxrate;
    }

    public boolean isIncludetail() {
        return this.includetail;
    }

    public void setIncludetail(boolean includetail) {
        this.includetail = includetail;
    }

    public BigDecimal getTailRate() {
        return this.tailrate;
    }

    public void setTailRate(BigDecimal tailrate) {
        this.includetail = false;
        this.tailrate = tailrate;
    }

    public boolean isIncludediscount() {
        return this.includediscount;
    }

    public void setIncludediscount(boolean includediscount) {
        this.includediscount = includediscount;
    }

    public String getDiscountmode() {
        return this.discountmode;
    }

    public void setDiscountmode(String discountmode) {
        this.discountmode = discountmode;
    }

    public BigDecimal getDiscountrate() {
        return this.discountrate;
    }

    public void setDiscountrate(BigDecimal discountrate) {
        this.discountrate = discountrate;
    }

    public BigDecimal getDiscountAmt() {
        return this.discountAmt;
    }

    public void setDiscountAmt(BigDecimal discountAmt) {
        this.discountAmt = discountAmt;
    }

    public boolean isIncludevat() {
        return this.includevat;
    }

    public void setIncludevat(boolean includevat) {
        this.includevat = includevat;
    }

    public BigDecimal getVatAmt() {
        return this.vatAmt;
    }

    public void setVatAmt(BigDecimal vatAmt) {
        this.includevat = true;
        this.vatAmt = vatAmt;
    }

    public boolean isIstaxbaseAmt() {
        return this.istaxbaseAmt;
    }

    public void setIstaxbaseAmt(boolean istaxbaseAmt) {
        this.istaxbaseAmt = istaxbaseAmt;
    }

    public BigDecimal getTaxbase() {
        return this.taxbase;
    }

    public BigDecimal getTax() {
        return this.tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public boolean isIsnegate() {
        return this.isnegate;
    }

    public void setIsnegate(boolean isnegate) {
        this.isnegate = isnegate;
    }

    public boolean isCandeductible() {
        return this.candeductible;
    }

    public void setCandeductible(boolean candeductible) {
        this.candeductible = candeductible;
    }

    public BigDecimal getDeductionrate() {
        return this.deductionrate;
    }

    public void setDeductionrate(BigDecimal deductionrate) {
        this.deductionrate = deductionrate;
    }

    public BigDecimal getDeductible() {
        return this.deductible;
    }

    public void setDeductible(BigDecimal deductible) {
        this.deductible = deductible;
    }

    public BigDecimal getNondeductible() {
        return this.nondeductible;
    }

    public void setNondeductible(BigDecimal nondeductible) {
        this.nondeductible = nondeductible;
    }
}

