/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.intertax;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.intertax.InterTaxService;
import kd.fi.arapcommon.intertax.TaxRuleService;

public class InterTaxServiceHelper {
    public static void propertyChanged_taxentry(IFormView formView, PropertyChangedArgs e) {
        IDataModel dataModel = formView.getModel();
        boolean isintertax = (Boolean)dataModel.getValue("isintertax");
        if (!isintertax) {
            return;
        }
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        int index = changeData[0].getRowIndex();
        MainEntityType mainType = dataModel.getDataEntityType();
        boolean hasTaxgroup = mainType.findProperty("e_taxgroup") != null;
        String entityId = formView.getEntityId();
        int entryIndex = index;
        switch (key) {
            case "isintertax": 
            case "taxroundrule": 
            case "asstact": {
                if (!hasTaxgroup) break;
                InterTaxServiceHelper.prepareData(formView);
                InterTaxServiceHelper.invokeTaxAllMaterial(formView);
                InterTaxServiceHelper.calculateAllTaxEntry(formView);
                break;
            }
            case "e_material": 
            case "material": {
                String groupid;
                DynamicObject material;
                if (!hasTaxgroup || ObjectUtils.isEmpty((Object)(material = (DynamicObject)changeData[0].getNewValue())) || ObjectUtils.isEmpty((Object)(groupid = InterTaxServiceHelper.invokeTax(formView, material.getLong("id"))))) break;
                InterTaxServiceHelper.getSubByTaxGroup(formView, entryIndex, Long.valueOf(groupid));
                break;
            }
            case "e_taxgroup": {
                DynamicObject taxgroup = (DynamicObject)changeData[0].getNewValue();
                if (!ObjectUtils.isEmpty((Object)taxgroup)) {
                    InterTaxServiceHelper.getSubByTaxGroup(formView, index, taxgroup.getLong("id"));
                    break;
                }
                InterTaxServiceHelper.clearAllTaxEntry(formView, entryIndex);
                break;
            }
            case "e_quantity": 
            case "quantity": 
            case "e_unitprice": 
            case "price": 
            case "e_discountmode": 
            case "e_discountrate": 
            case "e_premiumrate": {
                InterTaxServiceHelper.calculateAllTaxEntry(formView, entryIndex, false);
                break;
            }
            case "s_taxtime": 
            case "s_tax": {
                InterTaxServiceHelper.calculateAllTaxEntry(formView, changeData[0].getParentRowIndex(), true);
                break;
            }
            case "s_taxcategory": {
                DynamicObject taxcategory = (DynamicObject)changeData[0].getNewValue();
                if (!ObjectUtils.isEmpty((Object)taxcategory) && "VAT".equals(taxcategory.getString("simplecode"))) {
                    dataModel.setValue("s_includevat", (Object)Boolean.FALSE, index);
                    formView.setEnable(Boolean.FALSE, index, new String[]{"s_includevat"});
                } else {
                    formView.setEnable(Boolean.TRUE, index, new String[]{"s_includevat"});
                }
                entryIndex = changeData[0].getParentRowIndex();
                InterTaxServiceHelper.calculateAllTaxEntry(formView, entryIndex, true);
                InterTaxServiceHelper.calculateAllIncludevatTaxEntry(formView, entryIndex);
                break;
            }
            case "s_taxrateid": {
                DynamicObject taxrate = (DynamicObject)changeData[0].getNewValue();
                BigDecimal s_taxrateid = ObjectUtils.isEmpty((Object)taxrate) ? BigDecimal.ZERO : taxrate.getBigDecimal("taxrate");
                dataModel.setValue("s_taxrate", (Object)s_taxrateid, index);
            }
            case "s_isinpricetax": 
            case "s_includetail": 
            case "s_includediscount": 
            case "s_includevat": 
            case "s_taxbasetype": 
            case "s_candeductible": 
            case "s_deductionrate": {
                entryIndex = changeData[0].getParentRowIndex();
                if ("ap_finapbill".equals(entityId)) {
                    InterTaxServiceHelper.calculateTaxEntry_FinAp(dataModel, entryIndex, index);
                } else {
                    InterTaxServiceHelper.calculateTaxEntry(dataModel, entryIndex, index);
                }
                InterTaxServiceHelper.calculateAllTaxEntry(formView, entryIndex, true);
                break;
            }
            case "s_taxassessamt": {
                BigDecimal taxbase = (BigDecimal)changeData[0].getNewValue();
                BigDecimal taxrate1 = (BigDecimal)dataModel.getValue("s_taxrate", index);
                dataModel.setValue("s_tax", (Object)taxbase.multiply(taxrate1).divide(new BigDecimal(100)), index);
                entryIndex = changeData[0].getParentRowIndex();
                InterTaxServiceHelper.calculateAllTaxEntry(formView, entryIndex, true);
                InterTaxServiceHelper.calculateAllIncludevatTaxEntry(formView, entryIndex);
            }
        }
        InterTaxServiceHelper.calculatePayTax(formView);
    }

    private static InterTaxService calculateTaxEntry(IDataModel dataModel, int entryIndex, int subIndex) {
        boolean candeductible;
        InterTaxService interTaxService = new InterTaxService((BigDecimal)dataModel.getValue("e_quantity", entryIndex), (BigDecimal)dataModel.getValue("e_unitprice", entryIndex), (BigDecimal)dataModel.getValue("s_taxrate", subIndex));
        String discountmode = (String)dataModel.getValue("e_discountmode", entryIndex);
        BigDecimal discountrate = (BigDecimal)dataModel.getValue("e_discountrate", entryIndex);
        interTaxService.setIncludediscount((Boolean)dataModel.getValue("s_includediscount", subIndex));
        interTaxService.calculateDiscountAmt(discountmode, discountrate);
        dataModel.setValue("e_discountamount", (Object)interTaxService.getDiscountAmt(), entryIndex);
        DynamicObject taxcategory = (DynamicObject)dataModel.getValue("s_taxcategory", subIndex);
        String taxcategorySimplecode = ObjectUtils.isEmpty((Object)taxcategory) ? "" : taxcategory.getString("simplecode");
        interTaxService.setIsnegate("CDT".equals(taxcategorySimplecode));
        if (((Boolean)dataModel.getValue("s_includevat", subIndex)).booleanValue()) {
            interTaxService.setVatAmt((BigDecimal)dataModel.getValue("e_vattax", entryIndex));
        }
        if (candeductible = ((Boolean)dataModel.getValue("s_candeductible", subIndex)).booleanValue()) {
            interTaxService.setDeductionrate((BigDecimal)dataModel.getValue("s_deductionrate", subIndex));
        }
        interTaxService.setIsinpricetax((Boolean)dataModel.getValue("s_isinpricetax", subIndex));
        interTaxService.setIstaxbaseAmt("2".equals(dataModel.getValue("s_taxbasetype", subIndex)));
        interTaxService.calculateTax();
        dataModel.setValue("s_taxbase", (Object)interTaxService.getTaxbase(), subIndex);
        dataModel.setValue("s_taxassessamt", (Object)interTaxService.getTaxbase(), subIndex);
        dataModel.setValue("s_tax", (Object)interTaxService.getTax(), subIndex);
        dataModel.setValue("s_deductible", (Object)interTaxService.getDeductible(), subIndex);
        dataModel.setValue("s_nondeductible", (Object)interTaxService.getNondeductible(), subIndex);
        return interTaxService;
    }

    private static InterTaxService calculateTaxEntry_FinAp(IDataModel dataModel, int entryIndex, int subIndex) {
        boolean candeductible;
        DynamicObject taxcategory;
        InterTaxService interTaxService = new InterTaxService((BigDecimal)dataModel.getValue("quantity", entryIndex), (BigDecimal)dataModel.getValue("price", entryIndex), (BigDecimal)dataModel.getValue("s_taxrate", subIndex));
        String discountmode = (String)dataModel.getValue("discountmode", entryIndex);
        BigDecimal discountrate = (BigDecimal)dataModel.getValue("discountrate", entryIndex);
        interTaxService.setIncludediscount((Boolean)dataModel.getValue("s_includediscount", subIndex));
        interTaxService.calculateDiscountAmt(discountmode, discountrate);
        dataModel.setValue("discountamount", (Object)interTaxService.getDiscountAmt(), entryIndex);
        boolean includetail = (Boolean)dataModel.getValue("s_includetail", subIndex);
        if (!includetail) {
            interTaxService.setTailRate((BigDecimal)dataModel.getValue("e_premiumrate", entryIndex));
        }
        String taxcategorySimplecode = ObjectUtils.isEmpty((Object)(taxcategory = (DynamicObject)dataModel.getValue("s_taxcategory", subIndex))) ? "" : taxcategory.getString("simplecode");
        interTaxService.setIsnegate("CDT".equals(taxcategorySimplecode));
        if (((Boolean)dataModel.getValue("s_includevat", subIndex)).booleanValue()) {
            interTaxService.setVatAmt((BigDecimal)dataModel.getValue("e_vattax", entryIndex));
        }
        if (candeductible = ((Boolean)dataModel.getValue("s_candeductible", subIndex)).booleanValue()) {
            interTaxService.setDeductionrate((BigDecimal)dataModel.getValue("s_deductionrate", subIndex));
        }
        interTaxService.setIsinpricetax((Boolean)dataModel.getValue("s_isinpricetax", subIndex));
        interTaxService.setIstaxbaseAmt("2".equals(dataModel.getValue("s_taxbasetype", subIndex)));
        interTaxService.calculateTax();
        dataModel.setValue("s_taxbase", (Object)interTaxService.getTaxbase(), subIndex);
        dataModel.setValue("s_taxassessamt", (Object)interTaxService.getTaxbase(), subIndex);
        dataModel.setValue("s_tax", (Object)interTaxService.getTax(), subIndex);
        dataModel.setValue("s_deductible", (Object)interTaxService.getDeductible(), subIndex);
        dataModel.setValue("s_nondeductible", (Object)interTaxService.getNondeductible(), subIndex);
        return interTaxService;
    }

    private static void calculateAllTaxEntry(IFormView formView, int entryIndex, boolean onlySum) {
        IDataModel dataModel = formView.getModel();
        String entityId = formView.getEntityId();
        boolean taxroundrule = (Boolean)dataModel.getValue("taxroundrule");
        DynamicObject currency = (DynamicObject)dataModel.getValue("currency");
        int scale = currency.getInt("amtprecision");
        BigDecimal e_tax = BigDecimal.ZERO;
        BigDecimal e_vattax = BigDecimal.ZERO;
        BigDecimal e_paytax = BigDecimal.ZERO;
        DynamicObjectCollection subcolls = dataModel.getEntryEntity("subentryentity");
        for (int subIndex = 0; subIndex < subcolls.size(); ++subIndex) {
            DynamicObject subentry = (DynamicObject)subcolls.get(subIndex);
            BigDecimal s_tax = subentry.getBigDecimal("s_tax");
            if (taxroundrule) {
                s_tax = s_tax.setScale(scale, RoundingMode.HALF_DOWN);
            }
            if (onlySum) {
                e_tax = e_tax.add(s_tax);
            } else {
                InterTaxService interTaxService = null;
                interTaxService = "ap_finapbill".equals(entityId) ? InterTaxServiceHelper.calculateTaxEntry_FinAp(dataModel, entryIndex, subIndex) : InterTaxServiceHelper.calculateTaxEntry(dataModel, entryIndex, subIndex);
                s_tax = interTaxService.getTax();
                if (taxroundrule) {
                    s_tax = s_tax.setScale(scale, RoundingMode.HALF_DOWN);
                }
                e_tax = e_tax.add(s_tax);
            }
            DynamicObject taxcategory = (DynamicObject)dataModel.getValue("s_taxcategory", subIndex);
            if (!ObjectUtils.isEmpty((Object)taxcategory) && "VAT".equals(taxcategory.getString("simplecode"))) {
                e_vattax = e_vattax.add(s_tax);
            }
            if (!"receipt".equals(subentry.getString("s_taxtime")) && !"pay".equals(subentry.getString("s_taxtime"))) continue;
            e_paytax = e_paytax.add(s_tax);
        }
        dataModel.setValue("e_tax", (Object)e_tax, entryIndex);
        dataModel.setValue("e_vattax", (Object)e_vattax, entryIndex);
        if ("ar_busbill".equals(entityId) || "ar_finarbill".equals(entityId)) {
            dataModel.setValue("e_rectax", (Object)e_paytax, entryIndex);
            dataModel.setValue("e_recamount", (Object)e_tax.add((BigDecimal)dataModel.getValue("e_amount")), entryIndex);
        } else {
            dataModel.setValue("e_paytax", (Object)e_paytax, entryIndex);
            dataModel.setValue("e_pricetaxtotal", (Object)e_tax.add((BigDecimal)dataModel.getValue("e_amount")), entryIndex);
        }
    }

    private static void calculatePayTax(IFormView formView) {
        IDataModel dataModel = formView.getModel();
        String entityId = formView.getEntityId();
        if (!"ap_finapbill".equals(entityId)) {
            return;
        }
        DynamicObjectCollection entrycolls = dataModel.getEntryEntity("detailentry");
        BigDecimal paytax = BigDecimal.ZERO;
        for (DynamicObject entry : entrycolls) {
            paytax = paytax.add(entry.getBigDecimal("e_paytax"));
        }
        dataModel.setValue("paytax", (Object)paytax);
    }

    private static void calculateAllIncludevatTaxEntry(IFormView formView, int entryIndex) {
        IDataModel dataModel = formView.getModel();
        String entityId = formView.getEntityId();
        boolean taxroundrule = (Boolean)dataModel.getValue("taxroundrule");
        DynamicObject currency = (DynamicObject)dataModel.getValue("currency");
        int scale = currency.getInt("amtprecision");
        BigDecimal e_tax = BigDecimal.ZERO;
        BigDecimal e_paytax = BigDecimal.ZERO;
        DynamicObjectCollection subcolls = dataModel.getEntryEntity("subentryentity");
        for (int subIndex = 0; subIndex < subcolls.size(); ++subIndex) {
            DynamicObject taxcategory;
            DynamicObject subentry = (DynamicObject)subcolls.get(subIndex);
            BigDecimal s_tax = subentry.getBigDecimal("s_tax");
            if (taxroundrule) {
                s_tax = s_tax.setScale(scale, RoundingMode.HALF_DOWN);
            }
            if ((ObjectUtils.isEmpty((Object)(taxcategory = (DynamicObject)dataModel.getValue("s_taxcategory", subIndex))) || !"VAT".equals(taxcategory.getString("simplecode"))) && subentry.getBoolean("s_includevat")) {
                InterTaxService interTaxService = null;
                interTaxService = "ap_finapbill".equals(entityId) ? InterTaxServiceHelper.calculateTaxEntry_FinAp(dataModel, entryIndex, subIndex) : InterTaxServiceHelper.calculateTaxEntry(dataModel, entryIndex, subIndex);
                s_tax = interTaxService.getTax();
                if (taxroundrule) {
                    s_tax = s_tax.setScale(scale, RoundingMode.HALF_DOWN);
                }
            }
            e_tax = e_tax.add(s_tax);
            if (!"receipt".equals(subentry.getString("s_taxtime")) && !"pay".equals(subentry.getString("s_taxtime"))) continue;
            e_paytax = e_paytax.add(s_tax);
        }
        dataModel.setValue("e_tax", (Object)e_tax, entryIndex);
        if ("ar_busbill".equals(entityId) || "ar_finarbill".equals(entityId)) {
            dataModel.setValue("e_rectax", (Object)e_paytax, entryIndex);
            dataModel.setValue("e_recamount", (Object)e_tax.add((BigDecimal)dataModel.getValue("e_amount")), entryIndex);
        } else {
            dataModel.setValue("e_paytax", (Object)e_paytax, entryIndex);
            dataModel.setValue("e_pricetaxtotal", (Object)e_tax.add((BigDecimal)dataModel.getValue("e_amount")), entryIndex);
        }
        formView.updateView("subentryentity");
    }

    public static void afterDeleteTaxSub(IFormView formView, AfterDoOperationEventArgs args) {
        switch (args.getOperateKey()) {
            case "deletesubentry": {
                IDataModel dataModel = formView.getModel();
                String entityId = formView.getEntityId();
                String entryKey = "ap_finapbill".equals(entityId) ? "detailentry" : "entry";
                int entryIndex = dataModel.getEntryCurrentRowIndex(entryKey);
                InterTaxServiceHelper.calculateAllTaxEntry(formView, entryIndex, true);
            }
        }
    }

    private static DynamicObjectCollection queryTaxgroup(Long taxGroupId) {
        DynamicObjectCollection taxgroupColls = QueryServiceHelper.query((String)"bd_taxgroup", (String)"id,entryentity.id,entryentity.taxrateid.id,entryentity.taxrateid.taxrate,entryentity.taxrateid.taxcategoryid,entryentity.taxrateid.taxcategoryid.simplecode,entryentity.taxrateid.rebaterate,entryentity.taxrateid.taxtime,entryentity.taxrateid.taxscope,entryentity.taxrateid.taxratetype,entryentity.taxrateid.tcvat,entryentity.taxrateid.rebate,entryentity.taxrateid.rest,entryentity.taxrateid.taxbase,entryentity.taxrateid.offset", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxGroupId)});
        return taxgroupColls;
    }

    public static void getSubByTaxGroup(IFormView formView, int entryIndex, Long taxGroupId) {
        DynamicObjectCollection taxgroupColls = InterTaxServiceHelper.queryTaxgroup(taxGroupId);
        if (ObjectUtils.isEmpty((Object)taxgroupColls)) {
            return;
        }
        int taxrateSize = taxgroupColls.size();
        IDataModel dataModel = formView.getModel();
        dataModel.deleteEntryData("subentryentity");
        dataModel.batchCreateNewEntryRow("subentryentity", taxrateSize);
        int subIndex = 0;
        for (DynamicObject taxrateEntry : taxgroupColls) {
            InterTaxServiceHelper.fillTaxRow(taxrateEntry, dataModel, subIndex++, false);
            if (!taxrateEntry.getBoolean("entryentity.taxrateid.offset")) continue;
            dataModel.createNewEntryRow("subentryentity");
            InterTaxServiceHelper.fillTaxRow(taxrateEntry, dataModel, subIndex++, true);
        }
        InterTaxServiceHelper.calculateAllTaxEntry(formView, entryIndex, false);
    }

    private static void fillTaxRow(DynamicObject taxrateEntry, IDataModel dataModel, int subIndex, boolean isSplit) {
        dataModel.setValue("s_taxcategory", (Object)taxrateEntry.getLong("entryentity.taxrateid.taxcategoryid"), subIndex);
        dataModel.setValue("s_isinpricetax", (Object)"1".equals(taxrateEntry.getString("entryentity.taxrateid.taxscope")), subIndex);
        String entityId = dataModel.getDataEntityType().getName();
        String taxratetype = taxrateEntry.getString("entryentity.taxrateid.taxratetype");
        if ("ar_busbill".equals(entityId) || "ar_finarbill".equals(entityId)) {
            dataModel.setValue("s_isoutputtax", (Object)"2".equals(taxratetype), subIndex);
        } else {
            dataModel.setValue("s_isinputtax", (Object)"1".equals(taxratetype), subIndex);
        }
        dataModel.setValue("s_taxrateid", (Object)taxrateEntry.getLong("entryentity.taxrateid.id"), subIndex);
        BigDecimal taxrate = taxrateEntry.getBigDecimal("entryentity.taxrateid.taxrate");
        dataModel.setValue("s_taxrate", (Object)(isSplit ? taxrate.negate() : taxrate), subIndex);
        String taxtime = taxrateEntry.getString("entryentity.taxrateid.taxtime");
        String s_taxtime = "invoice";
        if ("2".equals(taxtime)) {
            s_taxtime = "receipt";
        } else if ("3".equals(taxtime)) {
            s_taxtime = "pay";
        }
        dataModel.setValue("s_taxtime", (Object)s_taxtime, subIndex);
        dataModel.setValue("s_includetail", (Object)taxrateEntry.getBoolean("entryentity.taxrateid.rest"), subIndex);
        dataModel.setValue("s_includediscount", (Object)taxrateEntry.getBoolean("entryentity.taxrateid.rebate"), subIndex);
        dataModel.setValue("s_includevat", (Object)taxrateEntry.getBoolean("entryentity.taxrateid.tcvat"), subIndex);
        dataModel.setValue("s_taxbasetype", (Object)taxrateEntry.getString("entryentity.taxrateid.taxbase"), subIndex);
        dataModel.setValue("s_deductionrate", (Object)taxrateEntry.getBigDecimal("entryentity.taxrateid.rebaterate"), subIndex);
    }

    private static DynamicObjectCollection getAllDetial(IFormView formView) {
        IDataModel dataModel = formView.getModel();
        String entityId = formView.getEntityId();
        String entryKey = "ap_finapbill".equals(entityId) ? "detailentry" : "entry";
        return dataModel.getEntryEntity(entryKey);
    }

    private static void clearAllTaxEntry(IFormView formView, int entryIndex) {
        DynamicObjectCollection detialColls = InterTaxServiceHelper.getAllDetial(formView);
        DynamicObject detial = (DynamicObject)detialColls.get(entryIndex);
        DynamicObjectCollection taxColls = detial.getDynamicObjectCollection("subentryentity");
        taxColls.clear();
        formView.updateView("subentryentity");
    }

    public static void clearAllTaxEntry(IFormView formView) {
        DynamicObjectCollection detialColls = InterTaxServiceHelper.getAllDetial(formView);
        for (DynamicObject detial : detialColls) {
            DynamicObjectCollection taxColls = detial.getDynamicObjectCollection("subentryentity");
            taxColls.clear();
        }
        formView.updateView("subentryentity");
    }

    private static void prepareData(IFormView formView) {
        IDataModel dataModel = formView.getModel();
        String asstacttype = (String)dataModel.getValue("asstacttype");
        String asstacttype2 = "1";
        if ("bd_customer".equals(asstacttype)) {
            asstacttype2 = "2";
        } else if (!"bd_supplier".equals(asstacttype)) {
            return;
        }
        DynamicObject asstact = (DynamicObject)dataModel.getValue("asstact");
        if (ObjectUtils.isEmpty((Object)asstact)) {
            InterTaxServiceHelper.clearAllTaxEntry(formView);
            return;
        }
        formView.getFormShowParameter().setCustomParam("asstacttype", (Object)asstacttype2);
        formView.getFormShowParameter().setCustomParam("asstactid", asstact.getPkValue());
    }

    private static void invokeTaxAllMaterial(IFormView formView) {
        IDataModel dataModel = formView.getModel();
        String entityId = formView.getEntityId();
        String entryKey = "ap_finapbill".equals(entityId) ? "detailentry" : "entry";
        DynamicObjectCollection detialColls = dataModel.getEntryEntity(entryKey);
        for (int entryIndex = 0; entryIndex < detialColls.size(); ++entryIndex) {
            String groupid;
            String materialKey;
            DynamicObject detial = (DynamicObject)detialColls.get(entryIndex);
            DynamicObject material = detial.getDynamicObject(materialKey = "ap_finapbill".equals(entityId) ? "material" : "e_material");
            if (ObjectUtils.isEmpty((Object)material) || ObjectUtils.isEmpty((Object)(groupid = InterTaxServiceHelper.invokeTax(formView, material.getLong("id"))))) continue;
            dataModel.setValue("e_taxgroup", (Object)Long.valueOf(groupid), entryIndex);
        }
        formView.updateView(entryKey);
    }

    private static String invokeTax(IFormView formView, Long materialId) {
        String groupid = null;
        Map taxKeys = formView.getFormShowParameter().getCustomParams();
        if (!ObjectUtils.isEmpty(taxKeys.get("asstactid"))) {
            groupid = TaxRuleService.query(materialId.toString(), (String)taxKeys.get("asstacttype"), taxKeys.get("asstactid").toString());
        }
        return groupid;
    }

    public static void calculateAllTaxEntry(IFormView formView) {
        IDataModel dataModel = formView.getModel();
        boolean isintertax = (Boolean)dataModel.getValue("isintertax");
        if (!isintertax) {
            return;
        }
        boolean taxroundrule = (Boolean)dataModel.getValue("taxroundrule");
        DynamicObject currency = (DynamicObject)dataModel.getValue("currency");
        int scale = currency.getInt("amtprecision");
        String entityId = formView.getEntityId();
        String entryKey = "ap_finapbill".equals(entityId) ? "detailentry" : "entry";
        DynamicObjectCollection detialColls = dataModel.getEntryEntity(entryKey);
        for (DynamicObject detial : detialColls) {
            DynamicObjectCollection taxColls = detial.getDynamicObjectCollection("subentryentity");
            InterTaxServiceHelper.calculateTaxEntry(entityId, taxroundrule, scale, detial, true, (Collection<DynamicObject>)taxColls);
        }
        formView.updateView("subentryentity");
        formView.updateView(entryKey);
    }

    public static void calculateTaxEntry(String entityId, boolean taxroundrule, int scale, DynamicObject detial, boolean updateDetial, Collection<DynamicObject> taxRowColls) {
        BigDecimal quantity = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        String discountmodeKey = "e_discountmode";
        BigDecimal discountrate = BigDecimal.ZERO;
        if ("ap_finapbill".equals(entityId)) {
            quantity = detial.getBigDecimal("quantity");
            price = detial.getBigDecimal("price");
            discountmodeKey = "discountmode";
            discountrate = detial.getBigDecimal("discountrate");
        } else {
            quantity = detial.getBigDecimal("e_quantity");
            price = detial.getBigDecimal("e_unitprice");
            discountrate = detial.getBigDecimal("e_discountrate");
        }
        String discountmode = detial.getString(discountmodeKey);
        BigDecimal e_vattax = BigDecimal.ZERO;
        BigDecimal e_paytax = BigDecimal.ZERO;
        for (DynamicObject taxsub : taxRowColls) {
            if (!"VAT".equals(taxsub.getString("s_simplecode"))) continue;
            InterTaxService interTaxService = InterTaxServiceHelper.calculateTaxEntry(taxsub, quantity, price, discountmode, discountrate, BigDecimal.ZERO);
            BigDecimal s_tax = interTaxService.getTax();
            if (taxroundrule) {
                s_tax = s_tax.setScale(scale, RoundingMode.HALF_DOWN);
            }
            e_vattax = e_vattax.add(s_tax);
            taxsub.set("s_taxbase", (Object)interTaxService.getTaxbase());
            taxsub.set("s_taxassessamt", (Object)interTaxService.getTaxbase());
            taxsub.set("s_tax", (Object)s_tax);
            taxsub.set("s_deductible", (Object)interTaxService.getDeductible());
            taxsub.set("s_nondeductible", (Object)interTaxService.getNondeductible());
            if (!"receipt".equals(taxsub.getString("s_taxtime")) && !"pay".equals(taxsub.getString("s_taxtime"))) continue;
            e_paytax = e_paytax.add(s_tax);
        }
        BigDecimal e_tax = e_vattax;
        for (DynamicObject taxsub : taxRowColls) {
            if ("VAT".equals(taxsub.getString("s_simplecode"))) continue;
            InterTaxService interTaxService = InterTaxServiceHelper.calculateTaxEntry(taxsub, quantity, price, discountmode, discountrate, e_vattax);
            taxsub.set("s_taxbase", (Object)interTaxService.getTaxbase());
            taxsub.set("s_taxassessamt", (Object)interTaxService.getTaxbase());
            BigDecimal s_tax = interTaxService.getTax();
            taxsub.set("s_tax", (Object)s_tax);
            taxsub.set("s_deductible", (Object)interTaxService.getDeductible());
            taxsub.set("s_nondeductible", (Object)interTaxService.getNondeductible());
            if (taxroundrule) {
                s_tax = s_tax.setScale(scale, RoundingMode.HALF_DOWN);
            }
            if ("receipt".equals(taxsub.getString("s_taxtime")) || "pay".equals(taxsub.getString("s_taxtime"))) {
                e_paytax = e_paytax.add(s_tax);
            }
            e_tax = e_tax.add(s_tax);
        }
        if (updateDetial) {
            detial.set("e_vattax", (Object)e_vattax);
            detial.set("e_tax", (Object)e_tax);
            if ("ar_busbill".equals(entityId) || "ar_finarbill".equals(entityId)) {
                detial.set("e_rectax", (Object)e_paytax);
                detial.set("e_recamount", (Object)e_tax.add(detial.getBigDecimal("e_amount")));
            } else {
                detial.set("e_paytax", (Object)e_paytax);
                detial.set("e_pricetaxtotal", (Object)e_tax.add(detial.getBigDecimal("e_amount")));
            }
        }
    }

    public static InterTaxService calculateTaxEntry(DynamicObject taxsub, BigDecimal quantity, BigDecimal price, String discountmode, BigDecimal discountrate, BigDecimal vattax) {
        BigDecimal taxrate = taxsub.getBigDecimal("s_taxrate");
        InterTaxService interTaxService = new InterTaxService(quantity, price, taxrate);
        interTaxService.setIncludediscount(taxsub.getBoolean("s_includediscount"));
        interTaxService.calculateDiscountAmt(discountmode, discountrate);
        interTaxService.setIsnegate("CDT".equals(taxsub.getString("s_simplecode")));
        if (taxsub.getBoolean("s_includevat")) {
            interTaxService.setVatAmt(vattax);
        }
        if (taxsub.getBoolean("s_candeductible")) {
            interTaxService.setDeductionrate(taxsub.getBigDecimal("s_deductionrate"));
        }
        interTaxService.setIsinpricetax(taxsub.getBoolean("s_isinpricetax"));
        interTaxService.setIstaxbaseAmt("2".equals(taxsub.getString("s_taxbasetype")));
        interTaxService.calculateTax();
        return interTaxService;
    }

    public static Map<Long, DynamicObject> getAllTaxEntry(DynamicObjectType dyType, Long taxGroupId) {
        HashMap<Long, DynamicObject> taxRowMap = new HashMap<Long, DynamicObject>();
        DynamicObjectCollection taxgroupColls = InterTaxServiceHelper.queryTaxgroup(taxGroupId);
        for (DynamicObject taxrateEntry : taxgroupColls) {
            DynamicObject taxRow = InterTaxServiceHelper.addTaxRow(dyType, taxrateEntry, false);
            taxRowMap.put(taxRow.getLong("s_taxcategory"), taxRow);
            if (!taxrateEntry.getBoolean("entryentity.taxrateid.offset")) continue;
            InterTaxServiceHelper.addTaxRow(dyType, taxrateEntry, true);
        }
        return taxRowMap;
    }

    private static DynamicObject addTaxRow(DynamicObjectType dyType, DynamicObject taxrateEntry, boolean isSplit) {
        DynamicObject taxRow = new DynamicObject(dyType);
        taxRow.set("s_taxcategory", (Object)taxrateEntry.getLong("entryentity.taxrateid.taxcategoryid"));
        taxRow.set("s_simplecode", (Object)taxrateEntry.getString("entryentity.taxrateid.taxcategoryid.simplecode"));
        taxRow.set("s_isinpricetax", (Object)"1".equals(taxrateEntry.getString("entryentity.taxrateid.taxscope")));
        String entityId = dyType.getName();
        String taxratetype = taxrateEntry.getString("entryentity.taxrateid.taxratetype");
        if ("ar_busbill".equals(entityId) || "ar_finarbill".equals(entityId)) {
            taxRow.set("s_isoutputtax", (Object)"2".equals(taxratetype));
        } else {
            taxRow.set("s_isinputtax", (Object)"1".equals(taxratetype));
        }
        taxRow.set("s_taxrateid", (Object)taxrateEntry.getLong("entryentity.taxrateid.id"));
        BigDecimal taxrate = taxrateEntry.getBigDecimal("entryentity.taxrateid.taxrate");
        taxRow.set("s_taxrate", (Object)(isSplit ? taxrate.negate() : taxrate));
        String taxtime = taxrateEntry.getString("entryentity.taxrateid.taxtime");
        String s_taxtime = "invoice";
        if ("2".equals(taxtime)) {
            s_taxtime = "receipt";
        } else if ("3".equals(taxtime)) {
            s_taxtime = "pay";
        }
        taxRow.set("s_taxtime", (Object)s_taxtime);
        taxRow.set("s_includetail", (Object)taxrateEntry.getBoolean("entryentity.taxrateid.rest"));
        taxRow.set("s_includediscount", (Object)taxrateEntry.getBoolean("entryentity.taxrateid.rebate"));
        taxRow.set("s_includevat", (Object)taxrateEntry.getBoolean("entryentity.taxrateid.tcvat"));
        taxRow.set("s_taxbasetype", (Object)taxrateEntry.getString("entryentity.taxrateid.taxbase"));
        taxRow.set("s_deductionrate", (Object)taxrateEntry.getBigDecimal("entryentity.taxrateid.rebaterate"));
        return taxRow;
    }
}

