/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.intertaximport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.ArapAbstractImport;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.TaxentryImportHelper;

public class ApFinBillTaxentryImport
extends ArapAbstractImport {
    private LinkedHashSet<String> numberList = null;

    @Override
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        super.beforeImportData(data, option, importlogs);
        try {
            QFilter[] filters;
            DynamicObject currency;
            boolean isPeriod = this.isPeriod(data);
            this.checkOrgNew();
            if (this.numberList == null) {
                this.numberList = new LinkedHashSet();
            }
            this.checkText("billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"ApFinBillTaxentryImport_0", (String)"fi-arapcommon", (Object[])new Object[0]), true, 80, null);
            String number = (String)data.get("billno");
            this.checkNumberOnly(number);
            data.remove("billstatus");
            if (isPeriod) {
                String billtypenumber;
                JSONObject billtype = (JSONObject)data.get("billtypeid");
                if (billtype != null && "ApFin_borr_BT_S".equals(billtypenumber = billtype.getString("number"))) {
                    throw new Exception(ResManager.loadKDString((String)"\u501f\u8d37\u9879\u8c03\u6574\uff0c\u4e0d\u80fd\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"ApFinBillTaxentryImport_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                if (this.init.isFinishInit()) {
                    throw new Exception(ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u4e0d\u5141\u8bb8\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"ApFinBillTaxentryImport_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                this.checkDate("bizdate", ResManager.loadKDString((String)"\u5355\u636e\u65e5\u671f", (String)"ApFinBillTaxentryImport_3", (String)"fi-arapcommon", (Object[])new Object[0]), true, null, this.init.getStartDate(), null);
            } else {
                Date currentDate = this.init.getCurrentDate();
                if (ObjectUtils.isEmpty((Object)currentDate)) {
                    currentDate = this.init.getStartDate();
                }
                this.checkDate("bizdate", ResManager.loadKDString((String)"\u5355\u636e\u65e5\u671f", (String)"ApFinBillTaxentryImport_3", (String)"fi-arapcommon", (Object[])new Object[0]), true, currentDate, null, null);
            }
            this.checkDateCompare("duedate", ResManager.loadKDString((String)"\u5230\u671f\u65e5", (String)"ApFinBillTaxentryImport_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            this.checkText("remark", ResManager.loadKDString((String)"\u5907\u6ce8", (String)"ApFinBillTaxentryImport_5", (String)"fi-arapcommon", (Object[])new Object[0]), false, 80, null);
            JSONObject currencyData = (JSONObject)data.get("currency");
            String currencyNumber = (String)currencyData.get((Object)"number");
            if (ObjectUtils.isEmpty((Object)currencyNumber)) {
                currencyNumber = "CNY";
            }
            if ((currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)"id,number,name,amtprecision,priceprecision", (QFilter[])(filters = new QFilter[]{new QFilter("number", "=", (Object)currencyNumber)}))) == null) {
                throw new Exception(ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u201c\u7ed3\u7b97\u5e01\u201d\u3002", (String)"ApFinBillTaxentryImport_6", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            int amtprecision = currency.getInt("amtprecision");
            int priceprecision = currency.getInt("priceprecision");
            this.checkExchangeRate();
            data.put("purmode", "CREDIT");
            String asstacttype = (String)data.get("asstacttype");
            if (asstacttype == null) {
                data.put("asstacttype", "bd_supplier");
            }
            this.checkNull("asstact", ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"ApFinBillTaxentryImport_7", (String)"fi-arapcommon", (Object[])new Object[0]));
            this.checkAsstAct();
            this.checkF7("paycond", ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u4ef6", (String)"ApFinBillTaxentryImport_8", (String)"fi-arapcommon", (Object[])new Object[0]), false, null);
            this.checkF7("settlementtype", ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f", (String)"ApFinBillTaxentryImport_9", (String)"fi-arapcommon", (Object[])new Object[0]), false, this.getDefaultSettleType());
            this.checkF7("purorg", ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7", (String)"ApFinBillTaxentryImport_10", (String)"fi-arapcommon", (Object[])new Object[0]), false, null);
            this.checkF7("purdept", ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4", (String)"ApFinBillTaxentryImport_11", (String)"fi-arapcommon", (Object[])new Object[0]), false, null);
            this.checkF7("purchaser", ResManager.loadKDString((String)"\u91c7\u8d2d\u5458", (String)"ApFinBillTaxentryImport_12", (String)"fi-arapcommon", (Object[])new Object[0]), false, null);
            JSONArray entryList = (JSONArray)data.get("detailentry");
            if (entryList != null) {
                for (int i = 0; i < entryList.size(); ++i) {
                    JSONObject entry = (JSONObject)entryList.get(i);
                    if (!this.isMaterial()) {
                        this.checkEntryNull("expenseitem", ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee", (String)"ApFinBillTaxentryImport_13", (String)"fi-arapcommon", (Object[])new Object[0]), entry, i);
                    } else {
                        this.checkEntryNull("material", ResManager.loadKDString((String)"\u7269\u6599", (String)"ApFinBillTaxentryImport_14", (String)"fi-arapcommon", (Object[])new Object[0]), entry, i);
                        this.checkEntryNull("measureunit", ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"ApFinBillTaxentryImport_15", (String)"fi-arapcommon", (Object[])new Object[0]), entry, i);
                        this.checkEntryF7("measureunit", ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"ApFinBillTaxentryImport_15", (String)"fi-arapcommon", (Object[])new Object[0]), entry, i, false, null);
                    }
                    if (entry.get((Object)"quantity") == null) {
                        entry.put("quantity", (Object)0);
                    }
                    if (entry.get((Object)"price") == null) {
                        entry.put("price", (Object)0);
                    }
                    this.checkEntryEnum("discounttype", ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f", (String)"ApFinBillTaxentryImport_16", (String)"fi-arapcommon", (Object[])new Object[0]), entry, i, false, new String[]{"PERCENT", "PERUNIT", "NULL"}, "NULL");
                    JSONArray taxRowColls = TaxentryImportHelper.checkTaxentry(data, entry, i, "1");
                    this.sumEntryAmt(entry, amtprecision, priceprecision, taxRowColls);
                }
                this.sumHeadAmt();
                JSONArray planEntryList = (JSONArray)data.get("planentity");
                if (entryList != null && planEntryList.size() > 0) {
                    BigDecimal exchanegRate = this.parseBigDecimal(data.get("exchangerate"));
                    BigDecimal sumpricetax = BigDecimal.ZERO;
                    for (int seq = 0; seq < planEntryList.size(); ++seq) {
                        JSONObject row = (JSONObject)planEntryList.get(seq);
                        BigDecimal planRowAmt = this.parseBigDecimal(row.get((Object)"planpricetax"));
                        sumpricetax = sumpricetax.add(planRowAmt);
                        row.put("planpricetaxloc", (Object)planRowAmt.multiply(exchanegRate).toPlainString());
                        row.put("planlockedamt", (Object)"0");
                        row.put("unplanlockamt", (Object)planRowAmt);
                        row.put("plansettledamt", (Object)"0");
                        row.put("plansettledlocamt", (Object)"0");
                        row.put("unplansettleamt", (Object)planRowAmt);
                        row.put("unplansettlelocamt", (Object)planRowAmt.multiply(exchanegRate).toPlainString());
                    }
                    if (sumpricetax.compareTo(this.parseBigDecimal(data.get("pricetaxtotal"))) != 0) {
                        throw new Exception(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u5e94\u4ed8\u91d1\u989d\u5408\u8ba1\u4e0e\u6574\u5355\u5e94\u4ed8\u91d1\u989d\u4e00\u81f4\u624d\u80fd\u4fdd\u5b58\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ApFinBillTaxentryImport_17", (String)"fi-arapcommon", (Object[])new Object[0]));
                    }
                } else {
                    planEntryList = new JSONArray();
                    JSONObject row = new JSONObject();
                    row.put("planduedate", data.get("duedate"));
                    row.put("plansettletype", data.get("settlementtype"));
                    row.put("planpricetax", data.get("pricetaxtotal"));
                    row.put("planpricetaxloc", data.get("pricetaxtotalbase"));
                    row.put("planlockedamt", (Object)"0");
                    row.put("unplanlockamt", data.get("pricetaxtotal"));
                    row.put("plansettledamt", (Object)"0");
                    row.put("plansettledlocamt", (Object)"0");
                    row.put("unplansettleamt", data.get("pricetaxtotal"));
                    row.put("unplansettlelocamt", data.get("pricetaxtotalbase"));
                    planEntryList.add((Object)row);
                    data.put("planentity", planEntryList);
                }
                data.put("isperiod", isPeriod);
            }
            this.numberList.add(number);
        }
        catch (Exception exc) {
            if (exc instanceof KDBizException) {
                importlogs.add(new ImportLogger.ImportLog(exc.getMessage()));
            } else {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                importlogs.add(new ImportLogger.ImportLog(sw.toString()));
                try {
                    pw.close();
                    sw.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }
        return true;
    }

    private boolean isMaterial() {
        String billtypenumber;
        boolean isMaterial = true;
        JSONObject billtype = (JSONObject)this.data.get("billtypeid");
        if (billtype != null && ("ApFin_other_BT_S".equals(billtypenumber = billtype.getString("number")) || "ApFin_purfee_BT_S".equals(billtypenumber) || "ApFin_borr_BT_S".equals(billtypenumber))) {
            isMaterial = false;
        }
        return isMaterial;
    }

    private void checkAsstAct() throws Exception {
        JSONObject value = (JSONObject)this.data.get("asstact");
        if (value == null) {
            return;
        }
        String number = (String)value.get((Object)"number");
        if (!this.checkExist(this.data.get("asstacttype").toString(), number)) {
            throw new Exception(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ApFinBillTaxentryImport_18", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        this.data.put("asstactname", ((DynamicObject)((Map)this.cachedF7.get(this.data.get("asstacttype").toString())).get(number)).get("name"));
    }

    private void checkExchangeRate() throws Exception {
        JSONObject currency = (JSONObject)this.data.get("currency");
        JSONObject baseCurrency = (JSONObject)this.data.get("basecurrency");
        if (currency.get((Object)"number").equals(baseCurrency.get((Object)"number"))) {
            this.data.put("exchangerate", "1");
            return;
        }
        BigDecimal value = this.parseBigDecimal(this.data.get("exchangerate"));
        if (value == null) {
            long currencyId = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("number", "=", currency.get((Object)"number"))}).getLong("id");
            Date bizDate = (Date)this.data.get("bizdate");
            BigDecimal exchangeRate = BaseDataHelper.getExchangeRate(currencyId, this.baseCurrencyId, this.orgId, bizDate);
            this.data.put("exchangerate", exchangeRate.toPlainString());
        }
    }

    private String getDefaultSettleType() {
        QFilter filter = new QFilter("isdefault", "=", (Object)"1");
        DynamicObject[] settleTypes = BusinessDataServiceHelper.load((String)"bd_settlementtype", (String)"number", (QFilter[])new QFilter[]{filter});
        if (settleTypes != null && settleTypes.length > 0) {
            return (String)settleTypes[0].get("number");
        }
        return null;
    }

    private void sumHeadAmt() {
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        BigDecimal pricetaxtotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal unverifyamount = BigDecimal.ZERO;
        BigDecimal unsettleamount = BigDecimal.ZERO;
        BigDecimal unsettleamountBase = BigDecimal.ZERO;
        JSONArray entryList = (JSONArray)this.data.get("detailentry");
        for (int i = 0; i < entryList.size(); ++i) {
            JSONObject row = (JSONObject)entryList.get(i);
            BigDecimal epricetaxtotal = this.parseBigDecimal(row.get((Object)"e_pricetaxtotal"));
            BigDecimal epricetaxtotalBase = this.parseBigDecimal(row.get((Object)"e_pricetaxtotalbase"));
            BigDecimal eamount = this.parseBigDecimal(row.get((Object)"price"));
            BigDecimal eamountBase = this.parseBigDecimal(row.get((Object)"e_amountbase"));
            BigDecimal etax = this.parseBigDecimal(row.get((Object)"e_tax"));
            BigDecimal eunverifyamount = this.parseBigDecimal(row.get((Object)"e_unverifyamount"));
            BigDecimal eunsettleamount = this.parseBigDecimal(row.get((Object)"unsettleamt"));
            BigDecimal eunsettleamountBase = this.parseBigDecimal(row.get((Object)"unsettleamtbase"));
            pricetaxtotal = pricetaxtotal.add(epricetaxtotal);
            pricetaxtotalBase = pricetaxtotalBase.add(epricetaxtotalBase);
            amount = amount.add(eamount);
            amountBase = amountBase.add(eamountBase);
            tax = tax.add(etax);
            unverifyamount = unverifyamount.add(eunverifyamount);
            unsettleamount = unsettleamount.add(eunsettleamount);
            unsettleamountBase = unsettleamountBase.add(eunsettleamountBase);
        }
        this.data.put("pricetaxtotal", pricetaxtotal.toPlainString());
        this.data.put("pricetaxtotalbase", pricetaxtotalBase.toPlainString());
        this.data.put("amount", amount.toPlainString());
        this.data.put("tax", tax.toPlainString());
        this.data.put("amountbase", amountBase.toPlainString());
        this.data.put("unverifyamount", unverifyamount.toPlainString());
        this.data.put("unsettleamount", unsettleamount.toPlainString());
        this.data.put("unsettleamountbase", unsettleamountBase.toPlainString());
    }

    protected void sumEntryAmt(JSONObject row, int amtprecision, int priceprecision, JSONArray taxRowColls) throws Exception {
        BigDecimal exchangeRate = this.getBigDecimal("exchangerate");
        BigDecimal quantity = this.getEntryBigDecimal(row, "quantity");
        row.put("e_uninvoicedqty", (Object)quantity.toPlainString());
        BigDecimal ONE_HUNDRED = new BigDecimal("100");
        BigDecimal discountamount = new BigDecimal(0);
        BigDecimal actunitprice = new BigDecimal(0);
        if ("PERCENT".equals(row.get((Object)"discounttype"))) {
            BigDecimal discountrate = this.getEntryBigDecimal(row, "discountrate").divide(ONE_HUNDRED);
            discountamount = quantity.multiply(this.getEntryBigDecimal(row, "price")).multiply(discountrate);
            row.put("discountamount", (Object)discountamount.setScale(amtprecision, RoundingMode.HALF_DOWN));
            row.put("actprice", (Object)this.getEntryBigDecimal(row, "price").multiply(BigDecimal.ONE.subtract(discountrate)).setScale(priceprecision, RoundingMode.HALF_DOWN));
        } else if ("PERUNIT".equals(row.get((Object)"discounttype"))) {
            BigDecimal discountamt = this.getEntryBigDecimal(row, "discountrate");
            actunitprice = this.getEntryBigDecimal(row, "price").subtract(discountamt);
            row.put("actprice", (Object)actunitprice.toPlainString());
            discountamount = quantity.multiply(discountamt).setScale(amtprecision, RoundingMode.HALF_DOWN);
            row.put("discountamount", (Object)discountamount.toPlainString());
        } else if ("NULL".equals(row.get((Object)"discounttype"))) {
            actunitprice = this.getEntryBigDecimal(row, "price").setScale(priceprecision, RoundingMode.HALF_DOWN);
            row.put("actprice", (Object)this.getEntryBigDecimal(row, "price").toPlainString());
            row.put("actpricetax", (Object)this.getEntryBigDecimal(row, "pricetax").toPlainString());
            row.put("discountrate", (Object)BigDecimal.ZERO);
            row.put("discountamount", (Object)BigDecimal.ZERO);
        }
        row.put("discountlocalamt", (Object)discountamount.multiply(exchangeRate).setScale(this.baseCurrencyPrecision, RoundingMode.HALF_DOWN));
        BigDecimal tax = TaxentryImportHelper.computationTax(taxRowColls, priceprecision, row, actunitprice, discountamount, amtprecision);
        BigDecimal e_amount = actunitprice.multiply(quantity).setScale(amtprecision, RoundingMode.HALF_DOWN);
        row.put("e_amount", (Object)e_amount);
        BigDecimal payAmount = e_amount.add(tax).setScale(amtprecision, RoundingMode.HALF_DOWN);
        BigDecimal payLocAmount = payAmount.multiply(exchangeRate).setScale(this.baseCurrencyPrecision, RoundingMode.HALF_DOWN);
        row.put("e_pricetaxtotal", (Object)payAmount.setScale(this.baseCurrencyPrecision, RoundingMode.HALF_DOWN));
        row.put("e_pricetaxtotalbase", (Object)payLocAmount);
        row.put("e_amountbase", (Object)this.getEntryBigDecimal(row, "e_amount"));
        row.put("e_unverifyamount", (Object)e_amount);
        row.put("unlockamt", (Object)payAmount);
        row.put("unsettleamt", (Object)payAmount);
        row.put("unsettleamtbase", (Object)payLocAmount);
        row.put("unverifyquantity", (Object)quantity.toPlainString());
        row.put("e_tax", (Object)tax.setScale(amtprecision, RoundingMode.HALF_DOWN));
    }

    private void checkNumberOnly(String number) throws Exception {
        switch (this.importtype) {
            case "override": {
                break;
            }
            case "new": {
                if (this.numberList.contains(number)) {
                    throw new Exception(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ApFinBillTaxentryImport_19", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"ap_finapbill", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
                if (obj == null) break;
                throw new Exception(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ApFinBillTaxentryImport_19", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
    }

    protected boolean isPeriod(Map<String, Object> data) {
        if (data.get("isperiod") != null) {
            return (Boolean)data.get("isperiod");
        }
        return true;
    }
}

