/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.invcloud.call;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.business.piaozone.info.QueryInvoiceDetailInfo;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.ActionResponse;
import kd.fi.arapcommon.business.piaozone.kingdee.action.IAction;
import kd.fi.arapcommon.invcloud.call.ICallCloudService;

public abstract class AbstractCallCloudService
implements ICallCloudService {
    protected static final String INVOICE_PAGE_SELECT_INVOICE = "selectInvoice";

    protected void callBackInvCloud(IAction action) {
        String execute = action.execute();
        ActionResponse actionResponse = (ActionResponse)JSON.parseObject((String)execute, ActionResponse.class);
        if (actionResponse == null || !actionResponse.success()) {
            String tipString = actionResponse == null ? ResManager.loadKDString((String)"%s\uff1a\u6267\u884c\u5931\u8d25", (String)"AbstractInvoiceCloud_0", (String)"fi-ap-common", (Object[])new Object[]{action.desc()}) : actionResponse.getDescription();
            throw new KDBizException(tipString);
        }
    }

    protected DynamicObject[] queryInvoices(List<Long> invoiceIds) {
        if (ObjectUtils.isEmpty(invoiceIds)) {
            return null;
        }
        String selectors = "serialno,invoicecode,invoiceno,org,billno,istaxdeduction,org,imageno,changesynstatustime,buyertin";
        return BusinessDataServiceHelper.load((String)"ap_invoice", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
    }

    protected Map<Long, QueryInvoiceDetailInfo> queryInvoiceDetailMap(Map<Long, String> orgForSerialMap) {
        if (ObjectUtils.isEmpty(orgForSerialMap)) {
            return new HashMap<Long, QueryInvoiceDetailInfo>(8);
        }
        HashMap<Long, QueryInvoiceDetailInfo> queryInvoiceDetailInfoMap = new HashMap<Long, QueryInvoiceDetailInfo>(64);
        for (Map.Entry<Long, String> entrySet : orgForSerialMap.entrySet()) {
            Long orgId = entrySet.getKey();
            InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(orgId);
            QueryInvoiceDetailInfo info = new QueryInvoiceDetailInfo();
            String taxRegnums = config.getTaxRegnum();
            info.setTaxNo(taxRegnums);
            info.setSerialNo(entrySet.getValue());
            String firmNames = config.getFirmname();
            info.setCompanyName(firmNames);
            info.setOrgId(orgId);
            info.setBxdKey(null);
            queryInvoiceDetailInfoMap.put(orgId, info);
        }
        return queryInvoiceDetailInfoMap;
    }

    protected String getBillNoCachedInCloud(String entityName, DynamicObject bill) {
        if ("ap_finapbill".equals(entityName) || "ap_payapply".equals(entityName)) {
            DynamicObjectCollection invEntries = bill.getDynamicObjectCollection("inventry");
            for (DynamicObject invEntry : invEntries) {
                if (ObjectUtils.isEmpty((Object)invEntry.getString("i_serialno"))) continue;
                long invPk = invEntry.getLong("invid");
                return "ap_invoice_" + invPk;
            }
        } else if ("ap_replaceinvapply".equals(entityName)) {
            DynamicObjectCollection newInvEntry = bill.getDynamicObjectCollection("newinventry");
            for (DynamicObject newInvRow : newInvEntry) {
                if (ObjectUtils.isEmpty((Object)newInvRow.getString("n_serialno"))) continue;
                long invPk = newInvRow.getLong("n_invid");
                return "ap_invoice_" + invPk;
            }
        } else {
            long id = bill.getLong("id");
            return "ap_invoice_" + id;
        }
        String uid = UUID.randomUUID().toString().replace("-", "");
        return entityName + "_" + uid;
    }

    protected DynamicObject[] getViewInvoiceBill(List<Long> billIds, String entityName) {
        if ("ap_invoice".equals(entityName)) {
            return this.queryInvoices(billIds);
        }
        if ("ap_payapply".equals(entityName)) {
            String selectors = "billno,settleorg,inventry.invid,inventry.i_serialno";
            return BusinessDataServiceHelper.load((String)entityName, (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        }
        if ("ap_replaceinvapply".equals(entityName)) {
            String selectors = "billno,org,oldinventry.o_invid,oldinventry.o_serialno,newinventry.n_invid,newinventry.n_serialno";
            return BusinessDataServiceHelper.load((String)entityName, (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        }
        String selectors = "billno,org,inventry.invid,inventry.i_serialno";
        return BusinessDataServiceHelper.load((String)entityName, (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
    }

    protected Map<Long, List<Long>> getInvoiceForVoucherMap(List<Long> allInvoiceIds) {
        HashMap<Long, List<Long>> invoiceForVoucherMap = new HashMap<Long, List<Long>>(8);
        DataSet invoiceDataSet = QueryServiceHelper.queryDataSet((String)"query_inv_org", (String)"ap_invoice", (String)"id,org,serialno", (QFilter[])new QFilter[]{new QFilter("id", "in", allInvoiceIds)}, (String)"");
        HashSet<Long> orgIds = new HashSet<Long>(8);
        ArrayList<Long> invoiceIds = new ArrayList<Long>(32);
        for (Row row : invoiceDataSet) {
            if (ObjectUtils.isEmpty((Object)row.getString("serialno"))) continue;
            orgIds.add(row.getLong("org"));
            invoiceIds.add(row.getLong("id"));
        }
        if (invoiceIds.isEmpty()) {
            return invoiceForVoucherMap;
        }
        for (Long l : invoiceIds) {
            invoiceForVoucherMap.put(l, new ArrayList(8));
        }
        DataSet dapTrackerDataSet = QueryServiceHelper.queryDataSet((String)"query_inv_voucher", (String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", invoiceIds)}, (String)"");
        for (Row dapTracker : dapTrackerDataSet) {
            Long sourceBillId = dapTracker.getLong("sourcebillid");
            List voucherIds = (List)invoiceForVoucherMap.get(sourceBillId);
            voucherIds.add(dapTracker.getLong("voucherid"));
        }
        QFilter qFilter = new QFilter("org", "in", orgIds);
        qFilter.and(new QFilter("inventry.invid", "in", invoiceIds));
        DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"query_finap", (String)"ap_finapbill", (String)"id,inventry.invid", (QFilter[])new QFilter[]{qFilter}, (String)"");
        HashMap<Long, List> invoiceForFinApMap = new HashMap<Long, List>(8);
        ArrayList<Long> allFinApBillIds = new ArrayList<Long>(32);
        for (Row finAp : finApDataSet) {
            Iterator invId = finAp.getLong("inventry.invid");
            Long l = finAp.getLong("id");
            List finApBillIds = invoiceForFinApMap.getOrDefault(invId, new ArrayList(8));
            finApBillIds.add(l);
            invoiceForFinApMap.put((Long)((Object)invId), finApBillIds);
            allFinApBillIds.add(l);
        }
        if (!invoiceForFinApMap.isEmpty()) {
            DataSet dapTrackerDataSet1 = QueryServiceHelper.queryDataSet((String)"query_finAp_voucher", (String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", allFinApBillIds)}, (String)"");
            HashMap<Long, Long> finApForVoucherMap = new HashMap<Long, Long>(8);
            for (Row row : dapTrackerDataSet1) {
                finApForVoucherMap.put(row.getLong("sourcebillid"), row.getLong("voucherid"));
            }
            if (!finApForVoucherMap.isEmpty()) {
                for (Map.Entry entry : invoiceForFinApMap.entrySet()) {
                    Long invoiceId = (Long)entry.getKey();
                    List finApBillIds = (List)entry.getValue();
                    for (Long finApBillId : finApBillIds) {
                        Long voucherId = (Long)finApForVoucherMap.get(finApBillId);
                        if (voucherId == null || voucherId == 0L) continue;
                        List voucherIds = (List)invoiceForVoucherMap.get(invoiceId);
                        voucherIds.add(voucherId);
                    }
                }
            }
        }
        QFilter filter1 = new QFilter("settleorg", "in", orgIds);
        filter1.and(new QFilter("inventry.invid", "in", invoiceIds));
        DataSet applyDataSet = QueryServiceHelper.queryDataSet((String)"query_apply", (String)"ap_payapply", (String)"id,inventry.invid", (QFilter[])new QFilter[]{filter1}, (String)"");
        HashMap<Long, Long> invoiceForApplyMap = new HashMap<Long, Long>(8);
        for (Row apply : applyDataSet) {
            Long invId = apply.getLong("inventry.invid");
            Long billId = apply.getLong("id");
            invoiceForApplyMap.put(invId, billId);
        }
        if (invoiceForApplyMap.isEmpty()) {
            return invoiceForVoucherMap;
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_apply_voucher", (String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", invoiceForApplyMap.values())}, (String)"");
        HashMap<Long, Long> applyForVoucherMap = new HashMap<Long, Long>(8);
        for (Row dapTrack : dataSet) {
            applyForVoucherMap.put(dapTrack.getLong("sourcebillid"), dapTrack.getLong("voucherid"));
        }
        if (applyForVoucherMap.isEmpty()) {
            return invoiceForVoucherMap;
        }
        for (Map.Entry entrySet : invoiceForApplyMap.entrySet()) {
            Long invoiceId = (Long)entrySet.getKey();
            Long applyId = (Long)entrySet.getValue();
            Long voucherId = (Long)applyForVoucherMap.get(applyId);
            if (voucherId == null || voucherId == 0L) continue;
            List voucherIds = (List)invoiceForVoucherMap.get(invoiceId);
            voucherIds.add(voucherId);
        }
        return invoiceForVoucherMap;
    }

    protected Map<Long, DynamicObject> getVoucherMap(Map<Long, List<Long>> invoiceForVoucherMap) {
        HashSet voucherIds = new HashSet(32);
        for (Map.Entry<Long, List<Long>> entrySet : invoiceForVoucherMap.entrySet()) {
            voucherIds.addAll(entrySet.getValue());
        }
        String selectors = "id,billno,period,bizdate,bookeddate";
        DynamicObject[] vouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", voucherIds)});
        return Arrays.stream(vouchers).collect(Collectors.toMap(v -> v.getLong("id"), Function.identity()));
    }

    protected void updateInvoiceSynStatus(List<DynamicObject> needUpdateSynStatusInvs) {
        if (needUpdateSynStatusInvs.isEmpty()) {
            return;
        }
        Set invoiceIds = needUpdateSynStatusInvs.stream().map(inv -> inv.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"synstatus,changesynstatustime", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        Map invoiceMap = Arrays.stream(invoices).collect(Collectors.toMap(e -> e.getLong("id"), Function.identity()));
        ArrayList<DynamicObject> toSaveInvoices = new ArrayList<DynamicObject>(32);
        for (DynamicObject needUpdateSynStatusInv : needUpdateSynStatusInvs) {
            DynamicObject latestInvoice = (DynamicObject)invoiceMap.get(needUpdateSynStatusInv.getLong("id"));
            if (latestInvoice == null || latestInvoice.getDate("changesynstatustime").compareTo(needUpdateSynStatusInv.getDate("changesynstatustime")) != 0) continue;
            latestInvoice.set("synstatus", (Object)"hassynchro");
            toSaveInvoices.add(latestInvoice);
        }
        if (!toSaveInvoices.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])toSaveInvoices.toArray(new DynamicObject[0]));
        }
    }

    protected Set<String> getBillAllSerialNo(DynamicObject[] bills, String entityName) {
        HashSet<String> serialNos = new HashSet<String>(16);
        for (DynamicObject bill : bills) {
            String[] split;
            if ("ap_invoice".equals(entityName)) {
                String serialNo = bill.getString("serialno");
                String[] split2 = StringUtils.split((String)serialNo, (String)",");
                serialNos.addAll(Arrays.asList(split2));
                continue;
            }
            if ("ap_replaceinvapply".equals(entityName)) {
                Object oldInvRow2;
                DynamicObjectCollection oldInvEntry = bill.getDynamicObjectCollection("oldinventry");
                for (Object oldInvRow2 : oldInvEntry) {
                    String serialNo = oldInvRow2.getString("o_serialno");
                    if (ObjectUtils.isEmpty((Object)serialNo)) continue;
                    split = StringUtils.split((String)serialNo, (String)",");
                    serialNos.addAll(Arrays.asList(split));
                }
                DynamicObjectCollection newInvEntry = bill.getDynamicObjectCollection("newinventry");
                oldInvRow2 = newInvEntry.iterator();
                while (oldInvRow2.hasNext()) {
                    DynamicObject newInvRow = (DynamicObject)oldInvRow2.next();
                    String serialNo = newInvRow.getString("n_serialno");
                    if (ObjectUtils.isEmpty((Object)serialNo)) continue;
                    String[] split3 = StringUtils.split((String)serialNo, (String)",");
                    serialNos.addAll(Arrays.asList(split3));
                }
                continue;
            }
            DynamicObjectCollection invEntries = bill.getDynamicObjectCollection("inventry");
            for (DynamicObject invEntry : invEntries) {
                String iSerialNo = invEntry.getString("i_serialno");
                if (ObjectUtils.isEmpty((Object)iSerialNo)) continue;
                split = StringUtils.split((String)iSerialNo, (String)",");
                serialNos.addAll(Arrays.asList(split));
            }
        }
        return serialNos;
    }
}

