/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.invcloud.call;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.arapcommon.business.piaozone.exception.PZAuthException;
import kd.fi.arapcommon.business.piaozone.info.CompanyInfo;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.business.piaozone.info.InvoiceDetailRetrunVO;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.business.piaozone.info.QueryInvoiceDetailInfo;
import kd.fi.arapcommon.business.piaozone.info.QueryInvoiceDetailParam;
import kd.fi.arapcommon.business.piaozone.info.SaveVoucherRequestParam;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.ActionResponse;
import kd.fi.arapcommon.business.piaozone.kingdee.action.DeleteActionXh;
import kd.fi.arapcommon.business.piaozone.kingdee.action.GenVoucherActionXh;
import kd.fi.arapcommon.business.piaozone.kingdee.action.UpdateActionXh;
import kd.fi.arapcommon.invcloud.call.AbstractCallCloudService;
import kd.fi.arapcommon.util.EmptyUtils;

public class CallXHCloudServiceImpl
extends AbstractCallCloudService {
    protected static final Log logger = LogFactory.getLog(CallXHCloudServiceImpl.class);

    @Override
    public Object updateInvoiceCloud(List<Long> invoiceIds) {
        logger.info("CallXHCloudServiceImpl updateInvoiceCloud begin.");
        Object[] invoices = this.queryInvoices(invoiceIds);
        if (ObjectUtils.isEmpty((Object[])invoices)) {
            return null;
        }
        logger.info("CallXHCloudServiceImpl updateInvoiceCloud invoices length is : " + invoices.length);
        HashMap<Long, InvoiceCloudCfg> cloudCfgMap = new HashMap<Long, InvoiceCloudCfg>(8);
        for (Object invoice : invoices) {
            String serialNo = invoice.getString("serialno");
            if (EmptyUtils.isEmpty(serialNo)) continue;
            long orgId = invoice.getLong("org.id");
            InvoiceCloudCfg config = cloudCfgMap.computeIfAbsent(orgId, v -> KingdeeInvoiceCloudConfig.getConfig(orgId));
            UpdateActionXh updateActionXh = new UpdateActionXh(config, invoice.getPkValue(), invoice.getString("billno"), (DynamicObject)invoice);
            this.callBackInvCloud(updateActionXh);
        }
        return null;
    }

    @Override
    public Object releaseInvoice(List<Long> invoiceIds) {
        logger.info("CallXHCloudServiceImpl releaseInvoice begin.");
        Object[] invoices = this.queryInvoices(invoiceIds);
        if (ObjectUtils.isEmpty((Object[])invoices)) {
            return null;
        }
        for (Object inv : invoices) {
            if (EmptyUtils.isEmpty(inv.getString("serialno"))) continue;
            DeleteActionXh deleteActionXh = new DeleteActionXh(inv.getDynamicObject("org"), inv.getPkValue(), (DynamicObject)inv);
            this.callBackInvCloud(deleteActionXh);
        }
        return null;
    }

    @Override
    public List<InvoiceVO> queryCloudInvoice(Map<Long, String> orgForSerialMap) {
        logger.info("CallXHCloudServiceImpl queryCloudInvoice begin.");
        if (ObjectUtils.isEmpty(orgForSerialMap)) {
            return null;
        }
        logger.info("CallXHCloudServiceImpl queryCloudInvoice orgForSerinalMap is : " + orgForSerialMap);
        Map<Long, QueryInvoiceDetailInfo> queryInvoiceDetailInfoMap = this.queryInvoiceDetailMap(orgForSerialMap);
        ArrayList<InvoiceVO> queryResult = new ArrayList<InvoiceVO>(64);
        for (Map.Entry<Long, QueryInvoiceDetailInfo> entrySet : queryInvoiceDetailInfoMap.entrySet()) {
            QueryInvoiceDetailInfo queryBO = entrySet.getValue();
            QueryInvoiceDetailParam param = new QueryInvoiceDetailParam();
            param.setOrgId(queryBO.getOrgId().toString());
            String taxRegnum = queryBO.getTaxNo();
            String companyName = queryBO.getCompanyName();
            List taxNoList = Arrays.stream(taxRegnum.split("=")).collect(Collectors.toList());
            List companyNameList = Arrays.stream(companyName.split("=")).collect(Collectors.toList());
            int companyInfoCount = Math.min(taxNoList.size(), companyNameList.size());
            ArrayList<CompanyInfo> companyInfos = new ArrayList<CompanyInfo>(companyInfoCount);
            for (int i = 0; i < companyInfoCount; ++i) {
                companyInfos.add(new CompanyInfo((String)taxNoList.get(i), (String)companyNameList.get(i)));
            }
            param.setCompanyInfo(companyInfos);
            param.setSerialNos(Arrays.asList(queryBO.getSerialNo().split(",")));
            logger.info("queryInvoiceDetailByXh\u67e5\u8be2\u53d1\u7968\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)param));
            Map<String, Object> result = this.invokeBizService(param);
            String respJson = JSON.toJSONString(result);
            logger.info("queryInvoiceDetailByXh\u67e5\u8be2\u53d1\u7968\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7684\u8be6\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)param), (Object)respJson);
            InvoiceDetailRetrunVO invoiceDetailReturnVO = (InvoiceDetailRetrunVO)JSON.parseObject((String)respJson, InvoiceDetailRetrunVO.class);
            String errcode = invoiceDetailReturnVO.getErrcode();
            if ("0000".equals(errcode)) {
                logger.info("\u8c03\u7528\u53d1\u7968\u4e91\u67e5\u8be2\u8be6\u7ec6\u4fe1\u606f\u6210\u529f");
                List<InvoiceVO> returnVOData = invoiceDetailReturnVO.getData();
                logger.info("queryInvoiceDetailByXh\u67e5\u8be2\u53d1\u7968\u7684\u8fd4\u56de\u7ed3\u679c" + JSON.toJSONString(returnVOData));
                queryResult.addAll(returnVOData);
                continue;
            }
            logger.error("\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u8fd4\u56de\u6570\u636e\u5f02\u5e38:" + errcode);
            ErrorCode ec = new ErrorCode("query_other_exception", invoiceDetailReturnVO.getDescription());
            throw new PZAuthException(ec);
        }
        return queryResult;
    }

    private Map<String, Object> invokeBizService(QueryInvoiceDetailParam param) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"queryVerify", (Object[])new Object[]{JSON.toJSON((Object)param)});
    }

    @Override
    public Object updateTaxDeduction(List<Long> invoiceIds) {
        return this.updateInvoiceCloud(invoiceIds);
    }

    @Override
    public Map<String, Object> buildViewInvoiceParam(List<Long> billIds, String entityName, List<String> serialNos) {
        logger.info("CallXHCloudServiceImpl buildViewInvoiceParam begin.");
        Object[] bills = this.getViewInvoiceBill(billIds, entityName);
        if (ObjectUtils.isEmpty((Object[])bills)) {
            logger.info("CallXHCloudServiceImpl buildViewInvoiceParam bill is null .");
            return new HashMap<String, Object>(8);
        }
        if (ObjectUtils.isEmpty(serialNos)) {
            serialNos.addAll(this.getBillAllSerialNo((DynamicObject[])bills, entityName));
        }
        Object billOne = bills[0];
        String orgId = billOne.getString("ap_payapply".equals(entityName) ? "settleorg.id" : "org.id");
        String invId = this.getBillNoCachedInCloud(entityName, (DynamicObject)billOne);
        String[] invIdExistLine = invId.split("_");
        logger.info("\u8c03\u7528\u524d\u7aef\u67e5\u770b\u53d1\u7968\u5217\u8868\u754c\u9762>>> serialNosKey:" + invId + ", serialNos:" + serialNos);
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("billId", invIdExistLine[invIdExistLine.length - 1]);
        customParams.put("entityId", entityName);
        customParams.put("serialNos", serialNos);
        customParams.put("billType", entityName);
        customParams.put("orgId", orgId);
        if (!"ap_invoice".equals(entityName)) {
            ArrayList<String> relevanceExpenseIdList = new ArrayList<String>(16);
            for (Object bill : bills) {
                if ("ap_finapbill".equals(entityName) || "ap_payapply".equals(entityName)) {
                    DynamicObjectCollection invEntries = bill.getDynamicObjectCollection("inventry");
                    for (DynamicObject invEntry : invEntries) {
                        if (ObjectUtils.isEmpty((Object)invEntry.getString("i_serialno"))) continue;
                        relevanceExpenseIdList.add(invEntry.getString("invid"));
                    }
                    continue;
                }
                if (!"ap_replaceinvapply".equals(entityName)) continue;
                DynamicObjectCollection oldInvEntry = bill.getDynamicObjectCollection("oldinventry");
                for (DynamicObject oldInvRow : oldInvEntry) {
                    if (ObjectUtils.isEmpty((Object)oldInvRow.getString("o_serialno"))) continue;
                    relevanceExpenseIdList.add(oldInvRow.getString("o_invid"));
                }
                DynamicObjectCollection newInvEntry = bill.getDynamicObjectCollection("newinventry");
                for (DynamicObject newInvRow : newInvEntry) {
                    if (ObjectUtils.isEmpty((Object)newInvRow.getString("n_serialno"))) continue;
                    relevanceExpenseIdList.add(newInvRow.getString("n_invid"));
                }
            }
            if (!relevanceExpenseIdList.isEmpty()) {
                logger.info("\u67e5\u8be2\u53d1\u7968\u5173\u8054\u7684\u5355\u636eID" + relevanceExpenseIdList);
                customParams.put("relevanceExpenseId", relevanceExpenseIdList);
            }
        }
        return customParams;
    }

    @Override
    public void showInvoiceAssistant(AbstractFormPlugin plugin) {
        DynamicObject org;
        logger.info("CallXHCloudServiceImpl showInvoiceAssistant begin.");
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        String entityName = model.getDataEntityType().getName();
        String asstactType = null;
        DynamicObject asstact = null;
        if ("ap_payapply".equals(entityName)) {
            org = (DynamicObject)model.getValue("settleorg");
            asstactType = (String)model.getValue("e_asstacttype", 0);
            asstact = (DynamicObject)model.getValue("e_asstact", 0);
        } else {
            org = (DynamicObject)model.getValue("org");
            if ("ap_finapbill".equals(entityName) || "ap_replaceinvapply".equals(entityName)) {
                asstact = (DynamicObject)model.getValue("asstact");
                asstactType = (String)model.getValue("asstacttype");
            }
        }
        long billId = DB.genLongId((String)"t_ap_invoice");
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("billType", "ap_invoice");
        customParams.put("billNo", "ap_invoice_" + billId);
        customParams.put("billId", billId + "");
        customParams.put("entityId", "ap_invoice");
        customParams.put("viewPage", "ap_invoice");
        customParams.put("orgId", org.getPkValue());
        customParams.put("resource", "4");
        List<Map<String, Object>> companyInfo = this.getTaxNo(org);
        customParams.put("companyInfo", companyInfo);
        if (asstactType != null && asstact != null) {
            HashMap<String, String> salerInfoParams = new HashMap<String, String>(2);
            asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)asstact.getPkValue(), (String)asstactType);
            String name = asstact.getLocaleString("name").getLocaleValue();
            salerInfoParams.put("name", name);
            if (!"bos_user".equals(asstactType)) {
                String taxNo = asstact.getString("tx_register_no");
                salerInfoParams.put("taxNo", taxNo);
            }
            ArrayList<HashMap<String, String>> salerInfo = new ArrayList<HashMap<String, String>>(1);
            salerInfo.add(salerInfoParams);
            customParams.put("salerInfo", salerInfo);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, "selectInvoice_" + billId);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("rim_fpzs_main");
        formShowParameter.setCloseCallBack(closeCallBack);
        plugin.getView().showForm(formShowParameter);
    }

    @Override
    public Object updateCloudInvoicePool(List<Long> invoiceIds) {
        logger.info("CallXHCloudServiceImpl updateCloudInvoicePool begin.");
        if (ObjectUtils.isEmpty(invoiceIds)) {
            return null;
        }
        Map<Long, List<Long>> invoiceForVoucherMap = this.getInvoiceForVoucherMap(invoiceIds);
        logger.info("CallXHCloudServiceImpl updateCloudInvoicePool invoiceForVoucherMap is \uff1a" + invoiceForVoucherMap);
        if (invoiceForVoucherMap.isEmpty()) {
            return null;
        }
        DynamicObject[] invoices = this.queryInvoices(new ArrayList<Long>(invoiceForVoucherMap.keySet()));
        Map<Long, DynamicObject> voucherMap = this.getVoucherMap(invoiceForVoucherMap);
        ArrayList<DynamicObject> needUpdateSynStatusInvs = new ArrayList<DynamicObject>(8);
        for (DynamicObject invoice : invoices) {
            boolean isAllSuccess;
            String buyertIn = invoice.getString("buyertin");
            List<Long> voucherIds = invoiceForVoucherMap.get(invoice.getLong("id"));
            SaveVoucherRequestParam saveParam = new SaveVoucherRequestParam();
            saveParam.setExpenseId(String.valueOf(invoice.getLong("id")));
            ArrayList<SaveVoucherRequestParam.VoucherInfo> vouchArray = new ArrayList<SaveVoucherRequestParam.VoucherInfo>(2);
            if (!ObjectUtils.isEmpty(voucherIds)) {
                for (Long voucherId : voucherIds) {
                    DynamicObject voucher = voucherMap.get(voucherId);
                    if (voucher == null) continue;
                    SaveVoucherRequestParam.VoucherInfo voucherInfo = new SaveVoucherRequestParam.VoucherInfo();
                    voucherInfo.setVouchId(voucher.getString("id"));
                    voucherInfo.setVouchNo(voucher.getString("billno"));
                    voucherInfo.setAccountTime(voucher.getDate("bizdate"));
                    voucherInfo.setAccountDate(voucher.getDate("bookeddate"));
                    vouchArray.add(voucherInfo);
                }
                saveParam.setVouchArray(vouchArray);
            }
            if (!(isAllSuccess = this.updateVoucher(saveParam, buyertIn))) continue;
            needUpdateSynStatusInvs.add(invoice);
        }
        this.updateInvoiceSynStatus(needUpdateSynStatusInvs);
        logger.info("CallXHCloudServiceImpl updateCloudInvoicePool end.");
        return null;
    }

    private boolean updateVoucher(SaveVoucherRequestParam saveParam, String buyertIn) {
        logger.info("CallXHCloudServiceImpl genVoucher NEWparam is " + JSON.toJSONString((Object)saveParam));
        GenVoucherActionXh genVoucherActionXh = new GenVoucherActionXh(buyertIn, saveParam);
        String execute = genVoucherActionXh.execute();
        ActionResponse actionResponse = (ActionResponse)JSON.parseObject((String)execute, ActionResponse.class);
        String errCode = actionResponse.getErrcode();
        if ("0000".equals(errCode)) {
            logger.info("CallXHCloudServiceImpl : updateVoucher is success ! ");
            return true;
        }
        String desc = actionResponse.getDescription();
        logger.info("CallXHCloudServiceImpl : updateVoucher exist error ! error message is : " + desc + "(" + errCode + ")");
        return false;
    }

    private List<Map<String, Object>> getTaxNo(DynamicObject org) {
        InvoiceCloudCfg config;
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        if (KingdeeInvoiceCloudConfig.isGroupPattern()) {
            config = KingdeeInvoiceCloudConfig.getConfig((Long)org.getPkValue());
            String[] taxRegnum = config.getTaxRegnum().split("=");
            String[] firmname = config.getFirmname().split("=");
            int size = Math.min(taxRegnum.length, firmname.length);
            for (int i = 0; i < size; ++i) {
                paramMap.put(taxRegnum[i], firmname[i]);
            }
        }
        if (paramMap.isEmpty()) {
            config = KingdeeInvoiceCloudConfig.getConfig(org);
            paramMap.put(config.getTaxRegnum(), config.getFirmname());
        }
        ArrayList<Map<String, Object>> companyInfo = new ArrayList<Map<String, Object>>(16);
        for (Map.Entry entry : paramMap.entrySet()) {
            HashMap<String, Object> map11 = new HashMap<String, Object>(8);
            map11.put("taxNo", entry.getKey());
            map11.put("name", entry.getValue());
            companyInfo.add(map11);
        }
        return companyInfo;
    }
}

