/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.invoice;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.AsstactHelper;

public class FillIssueInfoHelper {
    public static void fillInfo(boolean isAP, ExtendedDataEntity[] entities) {
        String info = FillIssueInfoHelper.getInfos(!isAP);
        HashMap<String, Set> asstactMap = new HashMap<String, Set>(2);
        for (ExtendedDataEntity entity : entities) {
            DynamicObject inv = entity.getDataEntity();
            FillIssueInfoHelper.fillOrgInfo(inv, FillIssueInfoHelper.getInfos(isAP));
            Set asstactIds = asstactMap.computeIfAbsent(inv.getString("asstacttype"), c -> new HashSet(16));
            if (ObjectUtils.isEmpty((Object)inv.get(info + "bank")) || ObjectUtils.isEmpty((Object)inv.get(info + "acct"))) {
                asstactIds.add(inv.getLong("asstact.id"));
            } else if ((ObjectUtils.isEmpty((Object)inv.get(info + "tin")) || ObjectUtils.isEmpty((Object)inv.get(info + "addr")) || ObjectUtils.isEmpty((Object)inv.get(info + "tel"))) && !"bos_user".equals(inv.get("asstacttype"))) {
                asstactIds.add(inv.getLong("asstact.id"));
            }
            if (!isAP || !ObjectUtils.isEmpty((Object)inv.get("receivablesacct")) || ObjectUtils.isEmpty((Object)inv.getLong("receivablessupp.id"))) continue;
            asstactIds.add(inv.getLong("receivablessupp.id"));
        }
        if (asstactMap.isEmpty()) {
            return;
        }
        HashMap<Long, Map<String, Object>> accbebankMapByAsstactId = new HashMap<Long, Map<String, Object>>(16);
        for (Map.Entry asstactEntry : asstactMap.entrySet()) {
            switch ((String)asstactEntry.getKey()) {
                case "bos_user": {
                    accbebankMapByAsstactId.putAll(AsstactHelper.getErPayeerAccbebankMap((Set)asstactEntry.getValue()));
                    break;
                }
                case "bd_customer": 
                case "bd_supplier": {
                    accbebankMapByAsstactId.putAll(AsstactHelper.getCusOrSupAccbebankMap((String)asstactEntry.getKey(), (Set)asstactEntry.getValue()));
                }
            }
        }
        for (ExtendedDataEntity entity : entities) {
            DynamicObject inv = entity.getDataEntity();
            Map accountBankInfo = (Map)accbebankMapByAsstactId.get(inv.getLong("asstact.id"));
            if (ObjectUtils.isEmpty((Object)accountBankInfo)) continue;
            FillIssueInfoHelper.setValueNotNull(info + "tin", accountBankInfo.get("tx_register_no"), inv);
            FillIssueInfoHelper.setValueNotNull(info + "addr", accountBankInfo.get("bizpartner_address"), inv);
            FillIssueInfoHelper.setValueNotNull(info + "tel", accountBankInfo.get("bizpartner_phone"), inv);
            FillIssueInfoHelper.setValueNotNull(info + "bank", accountBankInfo.get("bebankName"), inv);
            FillIssueInfoHelper.setValueNotNull(info + "acct", accountBankInfo.get("accountStr"), inv);
            if (!isAP || "bos_user".equals(inv.getString("asstacttype"))) continue;
            accountBankInfo = (Map)accbebankMapByAsstactId.get(inv.getLong("receivablessupp.id"));
            FillIssueInfoHelper.setValueNotNull("receivablesacct", accountBankInfo.get("accountStr"), inv);
        }
    }

    public static void fillInfo(DynamicObject inv) {
        boolean isAP = "ap_invoice".equals(inv.getDataEntityType().getExtendName());
        FillIssueInfoHelper.fillOrgInfo(inv, FillIssueInfoHelper.getInfos(isAP));
        FillIssueInfoHelper.fillAsstactInfo(inv, FillIssueInfoHelper.getInfos(!isAP));
    }

    private static String getInfos(boolean isAP) {
        return isAP ? "buyer" : "seller";
    }

    private static void fillOrgInfo(DynamicObject inv, String info) {
        DynamicObject org = inv.getDynamicObject("org");
        FillIssueInfoHelper.setValueNotNull(info + "tin", org.get("ftaxregnum"), inv);
        FillIssueInfoHelper.setValueNotNull(info + "addr", org.getLocaleString("faddress").getLocaleValue(), inv);
        FillIssueInfoHelper.setValueNotNull(info + "tel", org.get("phone"), inv);
        FillIssueInfoHelper.setValueNotNull(info + "bank", org.getLocaleString("depositbank").getLocaleValue(), inv);
        FillIssueInfoHelper.setValueNotNull(info + "acct", org.get("bankaccount"), inv);
    }

    private static void fillAsstactInfo(DynamicObject inv, String info) {
        DynamicObject asstact = inv.getDynamicObject("asstact");
        if (asstact == null) {
            return;
        }
        if ("bos_user".equals(inv.get("asstacttype"))) {
            DynamicObject erPayeeInfo = FillIssueInfoHelper.getErPayeeInfo(asstact.getLong("id"), asstact.getString("name"));
            if (erPayeeInfo != null) {
                FillIssueInfoHelper.setValueNotNull(info + "bank", erPayeeInfo.getDynamicObject("payerbank").getString("name"), inv);
                FillIssueInfoHelper.setValueNotNull(info + "acct", erPayeeInfo.getString("payeraccount"), inv);
            }
        } else {
            asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)asstact.getPkValue(), (String)inv.getString("asstacttype"), (String)"tx_register_no,bizpartner_address,bizpartner_phone, entry_bank, entry_bank.bankaccount, entry_bank.bank, entry_bank.isdefault_bank");
            FillIssueInfoHelper.setValueNotNull(info + "tin", asstact.get("tx_register_no"), inv);
            FillIssueInfoHelper.setValueNotNull(info + "addr", asstact.getLocaleString("bizpartner_address").getLocaleValue_zh_CN(), inv);
            FillIssueInfoHelper.setValueNotNull(info + "tel", asstact.get("bizpartner_phone"), inv);
            FillIssueInfoHelper.setBankInfo(inv, asstact, info);
        }
    }

    private static void setBankInfo(DynamicObject inv, DynamicObject asstact, String info) {
        String acctBank = null;
        String bank = null;
        DynamicObjectCollection bankColls = asstact.getDynamicObjectCollection("entry_bank");
        if (bankColls != null && bankColls.size() > 0) {
            if (bankColls.size() == 1) {
                DynamicObject bankInfo = (DynamicObject)bankColls.get(0);
                acctBank = bankInfo.getString("bankaccount");
                bank = bankInfo.getString("bank.name");
            } else {
                for (int i = 0; i < bankColls.size(); ++i) {
                    DynamicObject bankInfo = (DynamicObject)bankColls.get(i);
                    if (bankInfo.getBoolean("isdefault_bank")) {
                        acctBank = bankInfo.getString("bankaccount");
                        bank = bankInfo.getString("bank.name");
                        break;
                    }
                    if (i != 0) continue;
                    acctBank = bankInfo.getString("bankaccount");
                    bank = bankInfo.getString("bank.name");
                }
            }
        }
        FillIssueInfoHelper.setValueNotNull(info + "bank", bank, inv);
        FillIssueInfoHelper.setValueNotNull(info + "acct", acctBank, inv);
    }

    private static DynamicObject getErPayeeInfo(long userId, String name) {
        DynamicObject dynamicObject = null;
        QFilter uFilter = new QFilter("name", "=", (Object)name);
        uFilter = uFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        uFilter.and(new QFilter("payer", "=", (Object)userId));
        QFilter[] qFilters = new QFilter[]{uFilter};
        String selectFields = "id,name,payer,payeraccount,payeraccount01,payeraccount02,payerbank_id,payerbank.name,payerbank.number";
        String orderBys = "isdefault desc";
        DynamicObject[] defaultAccounts = BusinessDataServiceHelper.load((String)"er_payeer", (String)selectFields, (QFilter[])qFilters, (String)orderBys, (int)1);
        if (defaultAccounts != null && defaultAccounts.length > 0) {
            dynamicObject = defaultAccounts[0];
        }
        return dynamicObject;
    }

    private static void setValueNotNull(String prop, Object value, DynamicObject dynObj) {
        Object v = dynObj.get(prop);
        if (ObjectUtils.isEmpty((Object)v)) {
            dynObj.set(prop, value);
        }
    }
}

