/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.journal;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.journal.convert.JournalConverter;
import kd.fi.arapcommon.journal.enums.BillCheckEnum;
import kd.fi.arapcommon.journal.service.BillNoJournalFactory;
import kd.fi.arapcommon.journal.service.CommonjournalSelectService;
import kd.fi.arapcommon.model.ErrCheckModel;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.ErrCheckVo;

public class JournalCheckEdit
extends AbstractFormPlugin {
    private static boolean isAr = false;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.filterOrgSelect();
    }

    private void filterOrgSelect() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject entity = this.getModel().getDataEntity();
            String app = entity.getString("app");
            Long perId = entity.getLong("curperiod.periodtype.id");
            Date endDate = entity.getDate("curperiod.enddate");
            if (!ObjectUtils.isEmpty((Object)endDate)) {
                DynamicObjectCollection inits = QueryServiceHelper.query((String)(app + "_init"), (String)"org", (QFilter[])new QFilter[]{new QFilter("startperiod.enddate", "<=", (Object)endDate).and("periodtype.id", "=", (Object)perId)});
                Set curPerOrgIds = inits.stream().map(t -> t.getLong("org")).collect(Collectors.toSet());
                QFilter filter = new QFilter("id", "in", curPerOrgIds);
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(filter);
            }
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btnok".equals(key)) {
            this.selAndDoJournals();
        }
    }

    private void selAndDoJournals() {
        IDataModel m = this.getModel();
        DynamicObject checkBill = m.getDataEntity();
        String app = checkBill.getString("app");
        isAr = "ar".equals(app);
        m.deleteEntryData("entry");
        DynamicObjectCollection orgs = checkBill.getDynamicObjectCollection("org");
        Date startDate = checkBill.getDate("startdate");
        Date stopDate = checkBill.getDate("stopdate");
        String formBill = checkBill.getString("formbill");
        if (orgs != null && orgs.size() > 0 && startDate != null && stopDate != null && StringUtils.isNotEmpty(formBill)) {
            HashSet<Long> orgIds = new HashSet<Long>(8);
            for (DynamicObject org : orgs) {
                DynamicObject orgBill = org.getDynamicObject("fbasedataid");
                Long orgId = orgBill.getLong("id");
                orgIds.add(orgId);
            }
            startDate = DateUtils.getDataFormat(startDate, true);
            stopDate = DateUtils.getDataFormat(stopDate, false);
            try {
                if ("all".equals(formBill)) {
                    BillCheckEnum[] enums;
                    for (BillCheckEnum checkEnum : enums = BillCheckEnum.values()) {
                        if (isAr) {
                            if (!checkEnum.isAr()) continue;
                            this.setErrJournals(checkEnum.getValue(), startDate, stopDate, orgIds);
                            continue;
                        }
                        if (checkEnum.isAr()) continue;
                        this.setErrJournals(checkEnum.getValue(), startDate, stopDate, orgIds);
                    }
                } else {
                    this.setErrJournals(formBill, startDate, stopDate, orgIds);
                }
            }
            catch (Exception e) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\u53d1\u751f\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u6392\u67e5\u3002", (String)"JournalCheckEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6210", (String)"JournalCheckEdit_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u5b57\u6bb5", (String)"JournalCheckEdit_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    private void setErrJournals(String key, Date startDate, Date stopDate, Set<Long> orgIds) {
        CommonjournalSelectService SelectService = new BillNoJournalFactory().getJournalByBill(key);
        QFilter filter = SelectService.getFilter(orgIds, startDate, stopDate);
        Set<ErrCheckVo> errorEntry = SelectService.BatchSelectBills(filter, key);
        errorEntry.addAll(SelectService.BatchSelectJournals(orgIds, startDate, stopDate, key));
        if (errorEntry.size() > 0) {
            this.batchCreateEntry(errorEntry);
        }
    }

    private void batchCreateEntry(Set<ErrCheckVo> errorSet) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(ErrCheckModel.ENTRY_BILLNO, new Object[0]);
        vs.addField(ErrCheckModel.ENTRY_BILLID, new Object[0]);
        vs.addField(ErrCheckModel.ENTRY_JOURNALID, new Object[0]);
        vs.addField(ErrCheckModel.ENTRY_SOURCEBILL, new Object[0]);
        vs.addField(ErrCheckModel.ENTRY_CHECKITEM, new Object[0]);
        int fieldsSize = vs.getFields().size();
        for (ErrCheckVo erorVo : errorSet) {
            ArrayList<Object> rowObj = new ArrayList<Object>(fieldsSize);
            rowObj.add(erorVo.getBillno());
            rowObj.add(erorVo.getBillid());
            rowObj.add(erorVo.getJournalid());
            rowObj.add(erorVo.getSourcebill());
            rowObj.add(erorVo.getCheckitem());
            vs.addRow(rowObj.toArray());
        }
        AbstractFormDataModel formDataModel = (AbstractFormDataModel)this.getModel();
        formDataModel.batchCreateNewEntryRow("entry", vs);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        IDataModel m = this.getModel();
        String journalEntity = "ar".equals(m.getValue("app").toString()) ? "ar_journal" : "ap_journal";
        DynamicObjectCollection entryColls = m.getEntryEntity("entry");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        boolean isRepair = this.checkCurperiod();
        if (entryColls == null || entryColls.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u4fee\u590d\u6570\u636e\u3002", (String)"JournalCheckEdit_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        if (!isRepair) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u4fee\u590d\u7ed3\u7b97\u7ec4\u7ec7\u5f53\u524d\u671f\u95f4\u53ca\u4e4b\u540e\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u6761\u4ef6\u9009\u62e9\u4e2d\u7684\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"JournalCheckEdit_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        switch (key) {
            case "repjournalchose": {
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows == null || selectRows.length <= 0) break;
                HashSet<Long> deleJornalSet = new HashSet<Long>(16);
                HashMap<String, List<Long>> rebuildJournalMap = new HashMap<String, List<Long>>(8);
                for (int currtRow : selectRows) {
                    DynamicObject entry = (DynamicObject)entryColls.get(currtRow);
                    this.doJournalByItem(deleJornalSet, rebuildJournalMap, entry);
                }
                if (deleJornalSet.size() > 0) {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)journalEntity), (Object[])deleJornalSet.toArray());
                }
                this.addJournalByBill(rebuildJournalMap);
                this.getModel().deleteEntryRows("entry", selectRows);
                break;
            }
            case "repairjournal": {
                if (entryColls == null || entryColls.size() <= 0) break;
                HashSet<Long> deleJornalSet = new HashSet<Long>(16);
                HashMap<String, List<Long>> rebuildJournalMap = new HashMap<String, List<Long>>(8);
                for (DynamicObject entry : entryColls) {
                    this.doJournalByItem(deleJornalSet, rebuildJournalMap, entry);
                }
                if (deleJornalSet.size() > 0) {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)journalEntity), (Object[])deleJornalSet.toArray());
                }
                this.addJournalByBill(rebuildJournalMap);
                m.deleteEntryData("entry");
            }
        }
    }

    private boolean checkCurperiod() {
        DynamicObject[] inits;
        boolean isReapir = true;
        DynamicObject checkBill = this.getModel().getDataEntity();
        DynamicObjectCollection orgs = checkBill.getDynamicObjectCollection("org");
        Date checkCurDate = checkBill.getDate("curperiod.enddate");
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject org : orgs) {
            DynamicObject orgBill = org.getDynamicObject("fbasedataid");
            Long orgId = orgBill.getLong("id");
            orgIds.add(orgId);
        }
        for (DynamicObject init : inits = BusinessDataServiceHelper.load((String)(checkBill.getString("app") + "_init"), (String)"org,curperiod", (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgIds).and("isfinishinit", "=", (Object)Boolean.TRUE)})) {
            Date curDate = init.getDate("curperiod.enddate");
            if (curDate.compareTo(checkCurDate) <= 0) continue;
            isReapir = false;
            break;
        }
        return isReapir;
    }

    private void addJournalByBill(Map<String, List<Long>> rebuildJournalMap) {
        for (Map.Entry<String, List<Long>> billGroup : rebuildJournalMap.entrySet()) {
            String sourceEntityKey = billGroup.getKey();
            List<Long> sourcebillIds = billGroup.getValue();
            List<List<Long>> splitList = this.split(sourcebillIds, 3000);
            for (int i = 0; i < splitList.size(); ++i) {
                this.doJournals(splitList.get(i), sourceEntityKey);
            }
        }
    }

    private void doJournals(List<Long> sourcebillIds, String sourceEntityKey) {
        JournalService journalService = new JournalService();
        JournalConverter journalConverter = journalService.getConverter(sourceEntityKey);
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])sourcebillIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)sourceEntityKey));
        try (TXHandle tx = TX.requiresNew();){
            try {
                List<DynamicObject> journals = journalConverter.convert(bills);
                journalService.deleteJournals(sourceEntityKey, sourcebillIds.toArray(new Long[0]));
                Map<String, List<DynamicObject>> groupByJournals = journals.stream().collect(Collectors.groupingBy(journal -> journal.getDataEntityType().getName()));
                for (List<DynamicObject> eachTypeJournals : groupByJournals.values()) {
                    SaveServiceHelper.save((DynamicObject[])eachTypeJournals.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u5f02\u5e38\uff0c\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u6392\u67e5\u3002", (String)"JournalCheckEdit_5", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
    }

    public <T> List<List<T>> split(List<T> resList, int count) {
        if (resList == null || count < 1) {
            return null;
        }
        ArrayList<List<T>> ret = new ArrayList<List<T>>();
        int size = resList.size();
        if (size <= count) {
            ret.add(resList);
        } else {
            int pre = size / count;
            int last = size % count;
            for (int i = 0; i < pre; ++i) {
                ArrayList<T> itemList = new ArrayList<T>(10);
                for (int j = 0; j < count; ++j) {
                    itemList.add(resList.get(i * count + j));
                }
                ret.add(itemList);
            }
            if (last > 0) {
                ArrayList<T> itemList = new ArrayList<T>(10);
                for (int i = 0; i < last; ++i) {
                    itemList.add(resList.get(pre * count + i));
                }
                ret.add(itemList);
            }
        }
        return ret;
    }

    private void doJournalByItem(Set<Long> deleJornalSet, Map<String, List<Long>> rebuildJournalMap, DynamicObject entry) {
        String checkItem = entry.getString("checkitem");
        if ("doublejournal".equals(checkItem) || "notbilljournal".equals(checkItem)) {
            deleJornalSet.add(entry.getLong("journalid"));
        }
        if ("journalbill".equals(checkItem)) {
            String sourceBillKey = entry.getString("sourcebill");
            Long billId = entry.getLong("billid");
            List<Long> billSet = rebuildJournalMap.get(sourceBillKey);
            if (billSet == null) {
                billSet = new ArrayList<Long>(16);
                billSet.add(billId);
                rebuildJournalMap.put(sourceBillKey, billSet);
            } else {
                billSet.add(billId);
                rebuildJournalMap.put(sourceBillKey, billSet);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setSourceBill();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List orgIds = (List)formShowParameter.getCustomParam("org");
        if (orgIds != null && orgIds.size() > 0) {
            IDataModel m = this.getModel();
            String appId = formShowParameter.getAppId();
            String initEntity = "ar".equals(appId) ? "ar_init" : "ap_init";
            DynamicObject[] inits = BusinessDataServiceHelper.load((String)initEntity, (String)"org,curperiod", (QFilter[])new QFilter[]{new QFilter("org.id", "in", (Object)orgIds).and("isfinishinit", "=", (Object)Boolean.TRUE)});
            HashSet<Long> curIds = new HashSet<Long>(8);
            ArrayList<DynamicObject> orgs = new ArrayList<DynamicObject>(8);
            for (DynamicObject init : inits) {
                curIds.add(init.getLong("curperiod.id"));
                orgs.add(init.getDynamicObject("org"));
            }
            if (EmptyUtils.isEmpty(curIds) && curIds.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u9700\u5728\u540c\u4e00\u671f\u95f4\u3002", (String)"JournalCheckEdit_6", (String)"fi-arapcommon", (Object[])new Object[0]));
            } else {
                DynamicObjectCollection orgColls = new DynamicObjectCollection(((DynamicObject)orgs.get(0)).getDynamicObjectType(), null, orgs);
                m.setValue("org", (Object)orgColls);
                m.setValue("curperiod", curIds.toArray()[0]);
                if (StringUtils.isNotEmpty("appId")) {
                    m.setValue("app", (Object)appId);
                    this.setSourceBill();
                }
                this.dateArround();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel m = this.getModel();
        m.deleteEntryData("entry");
        switch (key) {
            case "app": {
                m.setValue("formbill", null);
                this.setSourceBill();
                break;
            }
            case "curperiod": {
                m.setValue("org", null);
                m.setValue("startdate", null);
                m.setValue("stopdate", null);
                this.dateArround();
            }
        }
    }

    private void dateArround() {
        DynamicObject entity = this.getModel().getDataEntity();
        Date beginDate = entity.getDate("curperiod.begindate");
        Date endDate = entity.getDate("curperiod.enddate");
        DateEdit startEdit = (DateEdit)this.getControl("startdate");
        startEdit.setMinDate(beginDate);
        startEdit.setMaxDate(endDate);
        DateEdit stopEdit = (DateEdit)this.getControl("stopdate");
        stopEdit.setMinDate(beginDate);
        stopEdit.setMaxDate(endDate);
    }

    private void setSourceBill() {
        BillCheckEnum[] BillCheckEnumArry;
        IDataModel m = this.getModel();
        String app = (String)m.getValue("app");
        isAr = "ar".equals(app);
        ComboEdit item = (ComboEdit)this.getControl("formbill");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (BillCheckEnum billCheckEnum : BillCheckEnumArry = BillCheckEnum.values()) {
            if (billCheckEnum.isAr() != isAr) continue;
            items.add(new ComboItem(new LocaleString(billCheckEnum.getName()), billCheckEnum.getValue()));
        }
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6240\u6709", (String)"JournalCheckEdit_7", (String)"fi-arapcommon", (Object[])new Object[0])), "all"));
        item.setComboItems(items);
    }
}

